<?php $__env->startSection('content'); ?>

        <!-- Content Header (Page header) -->



<section class="content-header">
    <?php if(Session::get('CLIENT_LIST_AJOUTER')): ?>

    <div class="box-tools pull-right">
        <a href="<?php echo e(url('client/ajouter')); ?>" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    <?php endif; ?>

    <h1>
        Gestion des clients
    </h1>

</section>



<!-- Main content -->
<section class="content">
    <?php if(Session::has('msgDeleteOk')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgDeleteOk'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        <?php endif; ?>


        <?php if(Session::has('msgAddSuccess')): ?>
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em><?php echo session('msgAddSuccess'); ?></em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>


    <?php if(Session::has('msgDeleteNotOk')): ?>
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em><?php echo session('msgDeleteNotOk'); ?></em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
            <?php endif; ?>
                <!-- Default box -->
        <div class="box">

            <br>
            <form method="get" action="<?php echo e(route('recherche_client')); ?>">

                <div class="table-responsive">
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" <?php if(isset($mot_a_rechercher)): ?>
                        value="<?php echo e($mot_a_rechercher); ?>"
                    <?php endif; ?>>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
                
            </div><br>
            </form>
           
            <table id="" class="table table-bordered table-striped ">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">Raison sociale</th>
                    <th class="text-center sorting_asc">Contact</th>
                    <th class="text-center sorting_asc">Email</th>
                    <th class="text-center sorting_asc">Téléphone</th>
                    <th class="text-center sorting_asc">Adresse</th>
                    <?php if(Session::get('CLIENT_LIST_MODIFIER')): ?>

                    <th class="text-center sorting_asc">Modifier</th>
                    <?php endif; ?>
                    <?php if(Session::get('CLIENT_LIST_SUPPRIMER')): ?>

                    <th class="text-center sorting_asc">Supprimer</th>
                        <?php endif; ?>
                </tr>
                </thead>

                <tbody>
                <?php foreach( $clients as $client): ?>
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1"><?php echo $client->raisonSociale; ?></td>
                        <td class="text-center sorting_1"><?php echo $client->nomClient; ?> <?php echo $client->prenomClient; ?></td>
                        <td class="text-center sorting_1"><?php echo $client->emailClient; ?></td>
                        <td class="text-center sorting_1"><?php echo $client->telephoneClient; ?></td>
                        <td class="text-center sorting_1"><?php echo $client->adresseClient; ?></td>
                        <?php if(Session::get('CLIENT_LIST_MODIFIER')): ?>

                        <td class="text-center sorting_asc">
                            <a href="<?php echo e(url('client/modifier')); ?>/<?php echo e($client->idClient); ?>" class="glyphicon glyphicon-edit">

                            </a>
                        </td >
                        <?php endif; ?>
                        <?php if(Session::get('CLIENT_LIST_SUPPRIMER')): ?>

                        <td class="text-center sorting_asc">
                            <a href="#DeleteModal<?php echo e($client->idClient); ?>" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                        </td>
                            <?php endif; ?>
                    </tr>

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal<?php echo e($client->idClient); ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce client " <?php echo e($client->raisonSociale); ?> "  ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        <?php echo Form::open(['method' => 'POST', 'action' => ['ClientController@delete',$client->idClient]]); ?>

                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        <?php echo Form::close(); ?>

                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                <?php endforeach; ?>
                </tbody>

            </table>
			<p>Affichage de l'élement <?php echo e(($clients->currentPage()-1)* $clients->perPage()+($clients->total() ? 1:0)); ?> à <?php echo e(($clients->currentPage()-1)*$clients->perPage()+count($clients)); ?>  sur  <?php echo e($clients->total()); ?> éléments</p>
            
            <span class="pull-right"><?php echo e($clients->links()); ?></p>


        </div><!-- /.box -->
</section><!-- /.content -->






<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>