<?php $__env->startSection('content'); ?>

        <!-- Content Header (Page header) -->



<section class="content-header">
    <?php if(Session::get('CLIENT_TRANSPORTEURS_AJOUTER')): ?>

    <div class="box-tools pull-right">
        <a href="<?php echo e(url('transporteur/ajouter')); ?>" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    <?php endif; ?>

    <h1>
        Gestion des transporteurs
    </h1>

</section>



<!-- Main content -->
<section class="content">
    <?php if(Session::has('msgDeleteOk')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgDeleteOk'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

        <?php if(Session::has('msgAddSuccess')): ?>
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em><?php echo session('msgAddSuccess'); ?></em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    <?php if(Session::has('msgDeleteNotOk')): ?>
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgDeleteNotOk'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        <?php endif; ?>
                <!-- Default box -->
        <div class="box">

            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N° transporteur</th>
                    <th class="text-center sorting_asc">Raison sociale</th>
                    <th class="text-center sorting_asc">Nom</th>
                    <th class="text-center sorting_asc">Prénom</th>
                    <th class="text-center sorting_asc">Téléphone</th>
                    <th class="text-center sorting_asc">Véhicule</th>
                    <?php if(Session::get('CLIENT_TRANSPORTEURS_MODIFIER')): ?>

                    <th class="text-center sorting_asc">Modifier</th>
                    <?php endif; ?>
                    <?php if(Session::get('CLIENT_TRANSPORTEURS_SUPPRIMER')): ?>

                    <th class="text-center sorting_asc">Supprimer</th>
                        <?php endif; ?>
                </tr>
                </thead>

                <tbody>
                <?php foreach( $transporteurs as $transporteur): ?>
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1"><?php echo $transporteur->numTransporteur; ?></td>
                        <td class="text-center sorting_1"><?php echo $transporteur->raisonSocial; ?></td>
                        <td class="text-center sorting_1"><?php echo $transporteur->nomTransporteur; ?></td>
                        <td class="text-center sorting_1"><?php echo $transporteur->prenomTransporteur; ?></td>
                        <td class="text-center sorting_1"><?php echo $transporteur->telephoneTransporteur; ?></td>
                        <?php if($transporteur->Emplacement == null): ?>
                        <td class="text-center sorting_1"></td>
                        <?php else: ?>
                            <td class="text-center sorting_1"><?php echo $transporteur->Emplacement->libelle; ?></td>
                        <?php endif; ?>
                        
                        <?php if(Session::get('CLIENT_TRANSPORTEURS_MODIFIER')): ?>

                        <td class="text-center sorting_asc">
                            <a href="<?php echo e(url('transporteur/modifier')); ?>/<?php echo e($transporteur->idTransporteur); ?>" class="glyphicon glyphicon-edit">

                            </a>
                        </td >
                        <?php endif; ?>
                            <?php if(Session::get('CLIENT_TRANSPORTEURS_SUPPRIMER')): ?>

                            <td class="text-center sorting_asc">
                            <a href="#DeleteModal<?php echo e($transporteur->idTransporteur); ?>" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                        </td>
                                <?php endif; ?>
                    </tr>
                    <!--

                    <tr role="row" class="odd">
                        <td class="sorting_1">Gecko</td>
                        <td>Firefox 1.0</td>
                        <td>Win 98+ / OSX.2+</td>
                        <td>1.7</td>
                        <td>A</td>
                        <td>A</td>
                        <td>A</td>
                    </tr>
                    -->



                    <div class="example-modal">
                        <div class="modal" id="DeleteModal<?php echo e($transporteur->idTransporteur); ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce transporteur " <?php echo e($transporteur->nomTransporteur); ?>   <?php echo e($transporteur->prenomTransporteur); ?> "  ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        <?php echo Form::open(['method' => 'POST', 'action' => ['TransporteurController@delete',$transporteur->idTransporteur]]); ?>

                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        <?php echo Form::close(); ?>

                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                <?php endforeach; ?>
                </tbody>

            </table>


        </div><!-- /.box -->
</section><!-- /.content -->






<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>