<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Détail d'un chargement
    </h1>

</section>


<!-- Main content -->
<section class="content">
    <!-- Messages -->

    <?php if(Session::has('msgAdd')): ?>
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgAdd'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if(Session::has('msgExist')): ?>
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgExist'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>


    <!-- fin messages -->

    <!-- Default box -->
    <div class="box" id="MYDIV">
        <div class="box-body">

            <div class="form-group">
                <?php echo Form::open(['method'=>'POST','id' => 'formulaire','action' => ['ChargementController@show',$chargement->idChargement]]); ?>

                <div >
                    <button type="button" id="btn-export"  class="btn btn-flat btn-danger pull-right" onclick="genPDF()">Export PDF</button>
                </div>
                <div class="box-tools pull-right" style="margin-right: 1%">

                    <?php if($chargement->statutChargement == 3 ): ?>
                    <a data-toggle="modal" data-target="#valider_chargement_modal" class="btn btn-block btn-primary" >
                        Valider le chargement
                    </a>

                    <?php endif; ?>
                </div>
                <br>
                <br>

                <div class="col-lg-12 ">
                    <div class="col-lg-3">
                        <label>N° Chargement : </label>
                        <input type="text" class="form-control", id="numChargement" name="numChargement" placeholder="Numéro de chargement"  value="<?php echo e($chargement->numChargement); ?>" readonly>
                    </div>
                    <div class="col-lg-3">
                        <label>Date de chargement : </label>
                        <input type="date" class="form-control" id="dateChargement"  name="dateChargement" value="<?php echo e($chargement->dateChargement); ?>"   readonly>

                    </div>
                    <div class="col-lg-3">
                        <label>Statut : </label>
                        <input type="text" class="form-control" name="statut" value="<?php echo e($chargement->valeur); ?>"   readonly >
                    </div>
                    <?php if(Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0"): ?>
                    <div class="col-lg-3">
                        <label>Nombre total d'unités d'expédition  : </label>
                        <input type="number" class="form-control" id="totalUE"  name="totalUE" value="<?php echo e($chargement->totalUE_chargement); ?>"   readonly >
                    </div>
                    <?php endif; ?>



                </div>
                <br>
                <br>
                <br>
                <br>

                <div class="col-lg-12">
                    <div class="col-lg-3">
                        <label>Transporteur : </label>
                        <input type="text" class="form-control" name="Transporteur" value="<?php echo e($chargement->Transporteur->numTransporteur); ?>--<?php echo e($chargement->Transporteur->nomTransporteur); ?> <?php echo e($chargement->Transporteur->prenomTransporteur); ?>"   readonly >
                    </div>
                    <div class="col-lg-3">
                        <label>Véhicule : </label>
                        <?php if($chargement->Emplacement != null): ?>
                        <input type="text" class="form-control" name="Emplacement"  
                        value="<?php echo e($chargement->Emplacement->libelle); ?>" readonly >
                        <?php else: ?>
                        <input type="text" class="form-control" name="Emplacement"  
                        value="" readonly >

                        <?php endif; ?>

                    </div>

                    <div class="col-lg-3">
                        <label>Nombre total des produits  : </label>
                        <input type="number" class="form-control" id="totalProduits"  name="totalProduits" value="<?php echo e($chargement->totalProduits_chargement); ?>"  required readonly >
                    </div>
                    <div class="col-lg-3">
                        <label>Total poids  : </label>
                        <input type="number" class="form-control" id="totalPoids"  name="totalPoids" value="<?php echo e($chargement->totalPoids_chargement); ?>"  required readonly >
                    </div>

                </div>
                <br>
                <br>

            </div>
            <br>
            <br>
            <h3> Les préparations :</h3>


            <?php foreach($lignes as $ligne): ?>
            <div style="margin-bottom: 2%;margin-top: 2%" >
                <div class="col-lg-3">
                    <label>N° préparation  : </label>
                    <input type="text" class="form-control"  name="numPreparation" value="<?php echo e($ligne->numPreparation); ?>"  required readonly >
                </div>

                <div class="col-lg-3">
                    <label>Statut  : </label>
                    <input type="text" class="form-control"  name="statut" value="<?php echo e($ligne->valeur); ?>"  required readonly >
                </div>
                <?php if($ligne->idCommande): ?>
                <div class="col-lg-3">
                    <label>N° commande  : </label>
                    <input type="text" class="form-control"   value="<?php echo e($ligne->CommandeClient->numCommande); ?>"  required readonly >
                </div>
<?php endif; ?>
                <div class="col-lg-3">
                    <label>Raison sociale  : </label>
                    <input type="text" class="form-control"  value="<?php echo e($ligne->Client->raisonSociale); ?>"  required readonly >
                </div>
                
            </div>
            <br>
            <br>
    
            <div style="margin-bottom: 2%;margin-top: 5%" >
                
                <table id="" class="table table-bordered table-striped display">
                    <thead>
                        <tr role="row">
                            <th class="text-center sorting_asc">N°UE</th>
                            <th class="text-center sorting_asc">Référence</th>
                            <th class="text-center sorting_asc">Désignation</th>
                            <th class="text-center sorting_asc">Code produit</th>
                            <?php if(Session::get('N_LOT')=='1'): ?>
                            <th class="text-center sorting_asc">Numéro de lot</th>
                            <?php endif; ?>
                            <th class="text-center sorting_asc">Emplacement</th>
                            <th class="text-center sorting_asc">Quantité</th>
                            <th class="text-center sorting_asc">Reste à préparer</th>
                            <th class="text-center sorting_asc">Quantité préparée</th>
                            <th class="text-center sorting_asc">Opérateur</th>
                            <th class="text-center sorting_asc">Poids</th>
                            <?php if(Session::get('NUMERO_SERIE')): ?>
                            <th class="text-center sorting_asc">N° de série</th>
                            <?php endif; ?>
                            <th class="text-center sorting_asc">Statut</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($LigneProduits as $LigneProduit): ?>
                        <?php if($ligne->idPreparation == $LigneProduit->idPreparation): ?>

                        <tr role="row">
                            <?php if(Session::get('STOCK_ENTITE') == 1 || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == 1): ?>
                                <td class="text-center sorting_1"><?php echo $LigneProduit->stockProduit->num_ue; ?></td>
                            <?php else: ?>
                            <?php if($LigneProduit->UniteExpedition != null): ?>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->UniteExpedition->SSCC; ?></td>
                            <?php else: ?>
                            <td class="text-center sorting_1"></td>
                            <?php endif; ?>
                            <?php endif; ?>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->Produit->reference; ?></td>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->Produit->designation; ?></td>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->Produit->code_identification; ?></td>
                            <?php if(Session::get('N_LOT')=='1'): ?>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->StockProduit->numero_lot; ?></td>
                            <?php endif; ?>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->StockProduit->Emplacement->libelle; ?></td>
                            <td class="text-center sorting_1"><?php echo (float) $LigneProduit->quantite_a_preparer; ?></td>
                            <td class="text-center sorting_1"><?php echo (float) $LigneProduit->quantite_restante; ?></td>
                            <td class="text-center sorting_1"><?php echo (float) $LigneProduit->quantite_preparer; ?></td>

                            <td class="text-center sorting_1"><?php echo $LigneProduit->User->nom; ?> <?php echo $LigneProduit->User->prenom; ?></td>
                            <td class="text-center sorting_1"><?php echo (float) $LigneProduit->total_poids; ?></td>
                            <?php if(Session::get('NUMERO_SERIE')): ?>
                                <td class="text-center sorting_1">
                                <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="numeroSerie(<?php echo e($LigneProduit); ?>, <?php echo e($LigneProduit->Produit); ?>)"></a>
                            </td>
                            <?php endif; ?>
                            
                            <?php if($LigneProduit->UniteExpedition != null): ?>
                                <?php if($LigneProduit->UniteExpedition->statut == 1): ?>
                                    <td class="text-center sorting_1">Chargée</td>
                                <?php else: ?>
                                    <td class="text-center sorting_1">Non chargée</td>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php if($LigneProduit->statut == 3): ?>
                                    <td class="text-center sorting_1">Chargée</td>
                                <?php else: ?>
                                    <td class="text-center sorting_1">Non chargée</td>
                                <?php endif; ?>
                            <?php endif; ?>

                        </tr>
                        <?php endif; ?>
                        <?php endforeach; ?>
                    </tbody>

                </table>
            

            </div>


            <?php endforeach; ?>


            <div style="float: right">

                <a href="<?php echo e(url('chargement/index')); ?>" class="btn btn-default" data-dismiss="modal">Retour</a>


            </div>

            <div class="hidden">
                <input type="text" name="exportPdf" id="exportPdf" value="0">
                <input type="text" name="preparation[]" id="preparation" value="">
            </div>
            <!---------pdf ------------>
            <?php echo Form::close(); ?>

        </div>
    </div>
    <div class="modal" id="valider_chargement_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                    </div>
                    <div class="modal-body">
                        <p>Voulez-vous vraiment valider le chargement ?</p>
                    </div>

                    <div class="modal-footer">

                        <a href="<?php echo e(url('/chargement/charge')); ?>/<?php echo e($chargement->idChargement); ?>" class="btn btn-flat btn-primary pull-right">
                            Valider
                        </a>
                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>

                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

        <div class="modal fade" id="modal-detail_num_serie">
          <div class="modal-dialog ">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Liste des N° de série </h4>
              </div>
              <div class="modal-body">
                <b id="desi_produit"></b><br>
                <b id="ref_produit"></b><br>
                
              
            
                <main id="tebleau">
                    <br>
                    <table id="example7" class="table table-bordered table-striped" style="text-align: center">
                        <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">N° de série</th>
                            </tr>
                        </thead>
                        <tbody>        
                        </tbody>
                    </table>
                </main>
             
              </div>
              <div class="modal-footer">
               
                <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

    </section><!-- /.content -->
    <script>

        function genPDF() {
            document.getElementById('exportPdf').value = '1';
            document.getElementById('preparation').value = '1';
            document.getElementById("formulaire").submit();
        }


        function numeroSerie(ligneProduit ,  produit){
            $.ajax({
                    url: "<?php echo e(url('chargement/numero_serie')); ?>/"+ligneProduit.idLigneProduit,
                    method : "post",   
                    data: {
                    "_token": "<?php echo e(csrf_token()); ?>"
                    } ,        
                    success: function(data){ 
                        document.getElementById("desi_produit").innerHTML = "Désignation Produit : "+produit.designation;
                        document.getElementById("ref_produit").innerHTML = "Référence Produit : "+produit.reference;

                        var t = $('#example7').DataTable();
                        t.clear().draw();

                        var myModal = $('#modal-detail_num_serie');

                            var vals = Object.keys(data).map(function(key) {
                            t.row.add( [
                                       data[key].num_serie
                                       
                                    ] ).draw( false );
                            }); 
                        
                        myModal.modal({ show: true });                                   
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
        }


    </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>