<?php $__env->startSection('content'); ?>

<section class="content-header" xmlns="http://www.w3.org/1999/html">
    <h1>Détail bon de livraison</h1>
</section>

<!-- Main content -->
<section class="content">
    <!-- Messages -->

    <?php if(Session::has('msgAdd')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAdd'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgExist')): ?>
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgExist'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        <?php endif; ?>

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">

                    <?php echo Form::open(['method'=>'POST','id' => 'formulaire','action' => ['BonLivraisonController@show',$bonLivraison->id_bon_livraison]]); ?>

                    <div >
                        <button type="button" id="btn-export"  class="btn btn-flat btn-danger pull-right" onclick="genPDF()">Export PDF</button>
                    </div>

                    <div >
                        <button type="button" style="margin-right: 1.2%" id="btn-export"  class="btn btn-success pull-right" onclick="genExcel()">Export Excel</button>
                    </div>
                    <?php if($bonLivraison->statut == 1): ?>
                    <div >
                        <a data-toggle="modal" data-target="#bl_annuler" style="margin-right: 1.2%"   class="btn btn-default pull-right" >Annuler</a>
                    </div>
                    <?php endif; ?>
                <div class="form-group">
                    <div class="col-sm-12">
                        <div class="col-sm-4">
                            <label>N° de bon de livraison : </label>
                            <input type="text" class="form-control" name="num_bl"   value="<?php echo e($bonLivraison->num_bl); ?>" readonly>
                        </div>

                        <div class="col-sm-4">
                            <label>N° de préparation : </label>

                            <input type="text" class="form-control" name="num_commande_fournisseur"  required value="<?php echo e($bonLivraison->preparation->numPreparation); ?>" readonly>
                        </div>
                    


                    
                         <?php if(Session::get('STOCK_ENTITE') == "0" && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0"): ?>
                            <div class="col-sm-4">
                            <label>N° Commande client: </label>

                            <input type="text" class="form-control" name="num_commande_fournisseur"  required <?php if($bonLivraison->id_commande != 0): ?> value="<?php echo e($bonLivraison->commandeClient->numCommande); ?>" <?php endif; ?> readonly>
                        </div>
                        <?php endif; ?>
                        <div class="col-sm-4">
                            <label>N°Commande : </label>
                            <input type="text" class="form-control" name="date_creation"
                             <?php if($bonLivraison->id_commande !=0): ?>
                             value="<?php echo e($bonLivraison->commandeClient->numCommande); ?>" 
                             <?php endif; ?>
                             required readonly>
                            
                        </div>
                        
                        <div class="col-sm-4">
                            <label>Date de création : </label>
                            <input type="text" class="form-control" name="date_creation" value="<?php echo e($bonLivraison->date_creation); ?>" required readonly>
                            
                        </div>
                        <div class="col-sm-4">
                            <label>Raison sociale :</label>

                            <input type="text" class="form-control"  name="raison sociale"  
                            <?php if($bonLivraison->preparation->Client != null): ?>
                                 value ="<?php echo e($bonLivraison->preparation->Client->raisonSociale); ?>"
                            <?php endif; ?> required readonly >
                        </div>
                        
                        <div class="col-sm-4">
                            <label>Adresse client :</label>

                            <input type="text" class="form-control"  name="adresse_client"  
                            <?php if($bonLivraison->preparation->Client != null): ?>
                                 value ="<?php echo e($bonLivraison->preparation->Client->adresseClient); ?>"
                            <?php endif; ?> 
                             required readonly >
                        </div>
                        
                        <div class="col-sm-4">
                            <label>Région :</label>

                            <input type="text" class="form-control"  name="adresse_client"  
                            
                            <?php if($bonLivraison->preparation->Client != null): ?>
                                <?php if($bonLivraison->preparation->Client->region == 0 ||$bonLivraison->preparation->Client->region == null ): ?>
                                    value =""
                                    <?php else: ?>
                                    value ="<?php echo e($bonLivraison->preparation->Client->willaya->nom_wilaya); ?>"
                                <?php endif; ?>
                                 
                            <?php endif; ?>
                             
                             readonly >
                        </div>
                   
                        <div class="col-sm-4">
                            <label>Nombre de produit : </label>
                            <input type="text" class="form-control" name="date_creation" value="<?php echo e($bonLivraison->nbr_produit); ?>" required readonly>
                            
                        </div>

                        
                        <?php if(Session::get('STOCK_ENTITE')): ?>
                            <div class="col-sm-12">
                            <label>Entité : </label>
                            <input type="text" class="form-control" name="date_creation" value="<?php echo e($bonLivraison['preparation']['entite->type_entite']); ?> / <?php echo e($bonLivraison['preparation']['entite']['num_entite']); ?> / <?php echo e($bonLivraison['preparation']['entite']['libelle_entite']); ?>" required readonly>
                            <br>
                        </div>
                        <?php endif; ?>
                        

                    </div>


                </div>


                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="table-responsive">
                        <table id="example1" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr role="row">
                                <?php if(Session::get('STOCK_ENTITE') == '1' || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?>
                                    <th class="text-center sorting_asc">N°Document</th>
                                    <th class="text-center sorting_asc">N°UE</th>
                                <?php endif; ?>
                                
                                <th class="text-center sorting_asc">Référence produit</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Code produit</th>
                                <th class="text-center sorting_asc">Emplacement</th>
                                <th class="text-center sorting_asc">Quantité</th>
                                <?php if(Session::get('NUMERO_SERIE')): ?>
                                    <th class="text-center sorting_asc">N° de série</th>
                                <?php endif; ?>
                                <?php if(Session::get('COMPOSE_PACK')=='1'): ?>
                                    <th class="text-center sorting_asc">Produit composé</th>
                                    <th class="text-center sorting_asc">Détail</th>
                                <?php endif; ?>
                            </tr>
                            </thead>

                            <tbody>

                            <?php foreach( $ligneBonLivraison as $ligne): ?>
                                <tr role="row" class="odd">
                                     <?php if(Session::get('STOCK_ENTITE') == '1' || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?>
                                    <td class="text-center sorting_1">

                                        <?php if($ligne->ligneProduit): ?>
                                        <?php if($ligne->ligneProduit->StockProduit): ?>
                                            <?php if(!$ligne->ligneProduit->StockProduit->ligneBonReceptionUe->isEmpty()): ?>
                                            <?php if($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception): ?>
                                            <?php if($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception): ?>
                                        

                                            <?php echo $ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception->num_document; ?>

                                        <?php endif; ?>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        
                                    </td>
                                    <td class="text-center sorting_1"><?php echo $ligne->ligneProduit->stockProduit->num_ue; ?></td>
                                    <?php endif; ?>
                                    <td class="text-center sorting_1"><?php echo $ligne->produit->reference; ?></td>
                                    <td class="text-center sorting_1"><?php echo $ligne->produit->designation; ?></td>
                                    <td class="text-center sorting_1"><?php echo $ligne->produit->code_identification; ?></td>
                                    <td class="text-center sorting_1"><?php echo $ligne->ligneProduit->StockProduit->Emplacement->libelle; ?></td>
                                    <td class="text-center sorting_1">
                                        
                                        <?php echo (float) $ligne->qnt; ?>

                                        
                                    </td>
                                    <?php if(Session::get('NUMERO_SERIE')): ?>
                                <td class="text-center sorting_1">
                                <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="numeroSerie(<?php echo e($ligne->ligneProduit); ?>, <?php echo e($ligne->ligneProduit->Produit); ?>)"></a>
                            </td>
                            <?php endif; ?>
                                    <?php if(Session::get('COMPOSE_PACK')=='1'): ?>
                                    <td class="text-center sorting_1"><?php echo e($ligne->produit->compose_pack); ?></td>
                                    <td class="text-center sorting_1">
                                        <a onclick="get_produit_compose(<?php echo e($ligne->produit); ?>)" class="glyphicon glyphicon-eye-open" style="cursor: pointer;">
                                        </a>
                                    </td>
                                    <?php endif; ?>
                                </tr>

                            <?php endforeach; ?>

                            </tbody>
                        </table>
                    </div>


                    <div class="col-lg-12" >


                        <?php if(Session::get('COMPOSE_PACK')): ?>
                           <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12" style="float: right" >
                            <label> Total quantité(produit composé) : </label>
                            <input type="text" class="form-control col-lg-1" readonly name="total_tva" value="<?php echo number_format($total_qnt_cmp); ?>">
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right; margin-right: 10%" >

                            <label> Total quantité :</label>
                            <input type="text" class="form-control col-lg-1" readonly  value="<?php echo e($total_qnt); ?>">
                            <input type="text" readonly class="hidden" name="total_ttc" value="<?php echo e($total_qnt); ?>">
                        </div>
                    </div>

                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">
                    <a <?php if(Session::get('pageSource')=='preparation'): ?> href="<?php echo e(url('preparation/detail')); ?>/<?php echo e(Session::get('idBL')); ?>" <?php endif; ?> href="<?php echo e(url('livraison/index')); ?>" class="btn btn-default pull-right">Retour</a>
                </div>


                <div class="hidden">
                    <input type="text" name="exportPdf" id="exportPdf" value="0">
                </div>
                <!---------pdf ------------>
                <?php echo Form::close(); ?>

            </div>
        </div><!-- /.box -->

<div class="modal fade" id="modal-detail">
          <div class="modal-dialog ">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="titre_modal"></h4>
              </div>
              <div class="modal-body">
                  <main id="tebleau">
                    <table id="example7" class="table table-bordered table-striped" style="text-align: center">
                        <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">Produit composé</th>
                                <th class="text-center sorting_asc">Quantité</th>   
                            </tr>
                        </thead>
                        <tbody>        
                        </tbody>
                    </table>
                </main>
             
                <div id="liste" style="text-align: center"></div> 
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
<div class="modal fade" id="modal-detail_num_serie">
          <div class="modal-dialog ">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Liste des N° de série </h4>
              </div>
              <div class="modal-body">
                <b id="desi_produit"></b><br>
                <b id="ref_produit"></b><br>
                
              
            
                <main id="tebleau">
                    <br>
                    <table id="example8" class="table table-bordered table-striped" style="text-align: center">
                        <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">N° de série</th>
                            </tr>
                        </thead>
                        <tbody>        
                        </tbody>
                    </table>
                </main>
             
              </div>
              <div class="modal-footer">
               
                <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
<div class="example-modal">
                        <div class="modal" id="bl_annuler">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment annuler cet bon de livraison ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        <?php echo Form::open(['method' => 'GET', 'action' => ['BonLivraisonController@annuler',$bonLivraison->id_bon_livraison]]); ?>

                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        <?php echo Form::close(); ?>

                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>



</section><!-- /.content -->

<script>
    function calcule(id){


        var tva = document.getElementById("tva"+id).value;
        var quantite = document.getElementById("quantite"+id).value;
        var prix_unitaire_ht = document.getElementById("prix_unitaire_ht"+id).value;
        var prix_unitaire_ttc = document.getElementById("prix_unitaire_ttc"+id).value;
        var totale_ht = document.getElementById("totale_ht"+id);
        var totale_ttc = document.getElementById("totale_ttc"+id);

        document.getElementById("prix_unitaire_ttc"+id).value = prix_unitaire_ht * (1+(tva/100));
        document.getElementById("totale_ht"+id).value = prix_unitaire_ht * quantite;
        document.getElementById("totale_ttc"+id).value = prix_unitaire_ttc * quantite;
        document.getElementById("prix_unitaire_ht"+id).value = document.getElementById("prix_unitaire_ttc"+id).value/(1+(tva/100));

    }

    function genPDF() {
        document.getElementById('exportPdf').value = '1';

        document.getElementById("formulaire").submit();
    }
    function genExcel() {
        document.getElementById('exportPdf').value = '-1';

        document.getElementById("formulaire").submit();
    }


    function get_produit_compose(produit){
        $.ajax({
                    url: "<?php echo e(url('livraison/detail/get_list_produit_composer')); ?>/"+produit.id_produit,
                    method : "post",   
                    data: {
                    "_token": "<?php echo e(csrf_token()); ?>"
                    } ,        
                    success: function(data){ 
                        document.getElementById("titre_modal").innerHTML="Détail ["+produit.reference+" - "+produit.designation + "]";
                        var t = $('#example7').DataTable();
                        t.clear().draw();
                        
                        var myModal = $('#modal-detail');
       
                            document.getElementById('liste').hidden =true;

                            var vals = Object.keys(data).map(function(key) {
                            t.row.add( [
                                       '<p>'+data[key].produit_enfant.reference+' - '+data[key].produit_enfant.designation+'</p>',
                                       '<p>'+data[key].quantite+'</p>'
                                       
                                    ] ).draw( false );
                            });
                        
                        myModal.modal({ show: true });                                   
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
      }

      function numeroSerie(ligneProduit ,  produit){
            $.ajax({
                    url: "<?php echo e(url('chargement/numero_serie')); ?>/"+ligneProduit.idLigneProduit,
                    method : "post",   
                    data: {
                    "_token": "<?php echo e(csrf_token()); ?>"
                    } ,        
                    success: function(data){ 
                        document.getElementById("desi_produit").innerHTML = "Désignation Produit : "+produit.designation;
                        document.getElementById("ref_produit").innerHTML = "Référence Produit : "+produit.reference;

                        var t = $('#example8').DataTable();
                        t.clear().draw();

                        var myModal = $('#modal-detail_num_serie');

                            var vals = Object.keys(data).map(function(key) {
                            t.row.add( [
                                       data[key].num_serie
                                       
                                    ] ).draw( false );
                            }); 
                        
                        myModal.modal({ show: true });                                   
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
        }




</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>