<?php $__env->startSection('content'); ?>

<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Ajouter une préparation 
    </h1>

</section>

<!-- Main content -->
<section class="content">
    <!-- Messages -->

    <?php if(Session::has('msgAdd')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAdd'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgAjouter')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAjouter'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgExist')): ?>
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgExist'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        <?php endif; ?>

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV" >
            <div class="box-body" >


                <?php echo Form::open(['method'=>'POST','action' => ['PreparationController@postForm']]); ?>



                <div class="form-group">

                    <div class="col-sm-12">

                        <div class="col-sm-4 ">
                            <label>N° Préparation : </label>
                            <input type="text" class="form-control" name="numPreparation" id="numPreparation" placeholder="N° Préparation" required value="<?php echo e($NumPreparation); ?>" onchange="sessionPreparation(this)" readonly="" >
                        </div>
                        <div class="col-sm-4 ">
                            <label>Date prévue :</label>
                            <input type="date" class="form-control"  name="datePrevue" id="datePrevue" value ="<?php echo e(Session::get('dateP')); ?>" onchange="sessionDate(this)" required>
                        </div>
                        <div class="col-sm-4 ">
                            <label>N° commande :</label>
                            
                            <input list="browsers" class="form-control" name="n_commande" id="n_commande" value ="<?php echo e(Session::get('n_commande')); ?>" onchange="sessionCommadee(this)"  autocomplete="off" />
<datalist id="browsers">
  <?php foreach($commandes as $commande): ?>
      <option value="<?php echo e($commande->numCommande); ?>">
  <?php endforeach; ?>
  
</datalist>


                        </div>

                        
                        
                    </div>



                    <div class="col-lg-12 col-md-12 col-sm-12">
                       

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Transporteur : </label>
                            <select id="idSelecTransporteur" class="form-control selectpicker"  name="transporteur"  onchange="sessionTransporteur(this)" data-live-search="true">
                                <option selected disabled value="" style="background-color: white">Sélectionner le transporteur ...</option>


                                <?php foreach($transporteurs as $transporteur): ?>
                                    <option <?php if(Session::has('Transporteur')): ?>  value="<?php echo e(Session::get('Transporteur')); ?>" selected <?php else: ?> value="<?php echo e($transporteur->idTransporteur); ?>" <?php endif; ?>> <?php echo e($transporteur->numTransporteur); ?>-<?php echo e($transporteur->nomTransporteur); ?> <?php echo e($transporteur->prenomTransporteur); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                         <?php if(Session::get('STOCK_EMPLACEMENT_MOBILE')=='1'): ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Raison sociale :</label>
                            <select id="sociale" class="form-control selectpicker"  name="sociale" required="true" onchange="sessionSociale(this)" data-live-search="true">
                                <option selected disabled value="" style="background-color: white">Sélectionner un raison sociale ...</option>


                                <?php foreach($sociales as $sociale): ?>
                                    <option <?php if(Session::has('sociale')): ?>  value="<?php echo e(Session::get('sociale')); ?>" selected <?php else: ?> value="<?php echo e($sociale->idClient); ?>" <?php endif; ?>> 
                                        <?php echo e($sociale->raisonSociale); ?> / <?php echo e($sociale->adresseClient); ?> 
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php endif; ?>
                       <?php if(Session::get('STOCK_ENTITE')=='1'): ?>
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>Entité : </label>
                            <select  <?php if(count($LigneProduits) >0): ?> readonly <?php endif; ?> id="entite" class="form-control selectpicker" name="entite" required="true" onchange="sessionEntite(this)" data-live-search="true">
                                <option style="background-color: white" selected disabled value="">Sélectionner une entité ...</option>

                                <?php foreach($entites as $entite): ?>
                                    <option <?php if(Session::has('entite')): ?>  value="<?php echo e(Session::get('entite')); ?>" <?php else: ?> value="<?php echo e($entite->num_entite); ?>" <?php endif; ?> <?php if(Session::get('entite') == $entite->num_entite): ?>
                                        selected
                                    <?php endif; ?>>
                                        
                                        <?php echo e($entite->type_entite); ?> / <?php echo e($entite->num_entite); ?> / <?php echo e($entite->libelle_entite); ?>

                                        
                                        
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                         <?php endif; ?>

                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12">

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Opérateur :</label>
                            <select id="idSelecOperateur" class="form-control selectpicker"  name="operateur" data-live-search="true" onchange="sessionOperateur()">
                                <option selected disabled value="" style="background-color: white">Sélectionner l'opérateur ...</option>
                                <?php foreach($operateurs as $operateur): ?>
                                    <option  value="<?php echo e($operateur->id_user); ?>" <?php if(Session::get('Oper') == $operateur->id_user): ?>
                                        selected
                                    <?php endif; ?>>
                                    <?php echo e($operateur->nom); ?> <?php echo e($operateur->prenom); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Total poids : </label>
                            <input type="text" class="form-control"  placeholder="Total poids" name="totalPoids" value="<?php echo e($totalPoids); ?>"  required readonly >
                            <br>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Nombre de produits : </label>
                            <input type="text" class="form-control"  name="nombreProduit" placeholder="Nombre de produits" value="<?php echo e($totalProduits); ?>" required readonly >
                        </div>
                        <?php if(Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0"): ?>
                            
                        
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Nombre d'unité d'expédition : </label>
                            <input type="text" class="form-control"  name="nombreUE" placeholder="Nombre d'unité d'expédition" value="<?php echo e($totalUE); ?>" required readonly >
                        </div>
                        <?php endif; ?>
                        </div>


                 <?php if(Session::get('STOCK_ENTITE')=='0' && Session::get('STOCK_EMPLACEMENT_MOBILE')=='0'): ?>
                    
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <label>
                        <input style=" transform: scale(1.5);"  type="checkbox" id="commande" value=" " name="commande" onchange="setCommande(this),sessionCommande(this)" <?php if(Session::has('commande')): ?> checked <?php endif; ?> >

                        Commande client
                    </label>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 15px">

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>N° commande : </label>
                        <select id="numCommande" class="form-control"  id="numCommande" name="numCommande" placeholder="N° commande" onchange="getClient(this.value)" required disabled  >
                            <option selected disabled value="">Sélectionner une commande ...</option>


                            <?php foreach($commandes as $commande): ?>
                                <option <?php if(Session::has('commande') && Session::get('numCommande')== $commande->numCommande): ?> selected <?php endif; ?> value="<?php echo e($commande->idCommande); ?>" > <?php echo e($commande->numCommande); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>Raison sociale : </label>
                        <input type="text" class="form-control" id="raisonSociale"  name="raisonSociale" placeholder="Raison sociale" <?php if(Session::has('commande')): ?> value="<?php echo e(Session::get('raisonSociale')); ?>"<?php endif; ?> value="" required readonly >
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>Adresse client : </label>
                        <input type="text" class="form-control" id="adresseClient"  name="adresseClient" placeholder="Adresse client "<?php if(Session::has('commande')): ?> value="<?php echo e(Session::get('adresseClient')); ?>" <?php endif; ?> value="" required readonly >
                    </div>

                </div>
                <?php endif; ?>


                <div class="col-lg-12">

                    <div  style="float: right" id="add_produit" 
                    <?php if(Session::get('STOCK_ENTITE')): ?>
                    <?php if(!Session::get('entite')): ?>
                        hidden
                    <?php endif; ?>
                    <?php endif; ?> 
                    >
                        <a href="<?php echo e(url('preparation/produit/ajouter')); ?>"   class="btn btn-block btn-primary" style="margin-bottom: 5%" 
                        
                        >
                            <span class="glyphicon glyphicon-plus" ></span>
                            Ajouter produit
                        </a>
                    </div>

                    <?php if(Session::get('STOCK_ENTITE')=='0' && Session::get('STOCK_EMPLACEMENT_MOBILE')=='0'): ?>                    
                        <div  style="float: right;margin-right: 20px" >
                            <a href="<?php echo e(url('preparation/produit/genererUE')); ?>" data-toggle="modal" class="btn btn-block btn-primary" style="margin-bottom: 5%" >
                                <span class="glyphicon glyphicon-plus" ></span>
                                Générer une UE
                            </a>
                        </div>
                    <?php endif; ?>

                </div>
            
                    <table id="example1" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr role="row" class="odd">
                                <th class="text-center sorting_asc">N° UE</th>
                                <th class="text-center sorting_asc">Référence</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Code produit</th>
                                <?php if(Session::get('N_LOT')=='1'): ?>

                                <th class="text-center sorting_asc">Numéro de lot</th>
                                <?php endif; ?>
                                <th class="text-center sorting_asc">Emplacement</th>
                                <th class="text-center sorting_asc">Quantité</th>
                                <th class="text-center sorting_asc">Opérateur</th>
                                <th class="text-center sorting_asc">Poids</th>
                                
                                    <th class="text-center sorting_asc">Modifier</th>
                                    <th class="text-center sorting_asc">Supprimer</th>
                                
                                
                            </tr>
                            </thead>
                       <tbody>
                            <?php foreach($LigneProduits as $LigneProduit): ?>
                                <tr role="row">
                                    <?php if($LigneProduit->stockProduit != null && (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")): ?>
                                        <td class="text-center sorting_1"><?php echo $LigneProduit->stockProduit->num_ue; ?></td>
                                    <?php else: ?>
                                            <?php if($LigneProduit->UniteExpedition != null): ?>
                                        <td class="text-center sorting_1"><?php echo $LigneProduit->UniteExpedition->SSCC; ?> </td>
                                    <?php else: ?>
                                            <td class="text-center sorting_1"></td>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->Produit->reference; ?></td>
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->Produit->designation; ?></td>
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->Produit->code_identification; ?></td>
                                        <?php if(Session::get('N_LOT')=='1'): ?>

                                        <td class="text-center sorting_1"><?php echo $LigneProduit->StockProduit->numero_lot; ?></td>
                                        <?php endif; ?>
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->StockProduit->Emplacement->libelle; ?></td>
                                    <td class="text-center sorting_1"><?php echo (float) $LigneProduit->quantite_a_preparer; ?></td>
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->User->nom; ?> <?php echo $LigneProduit->User->prenom; ?></td>
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->total_poids; ?></td>
                                    
                                    <td class="text-center sorting_1">
                                        <?php if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?>
                                           
                                            <a style="cursor: pointer;" class="glyphicon glyphicon-edit" onclick="getProduitInfo(<?php echo e($LigneProduit); ?>,<?php echo e($LigneProduit->StockProduit->produit); ?>, <?php echo e($LigneProduit->StockProduit); ?>)">
                                            </a>
                                        <?php else: ?>
                                         <a href="#EditModal<?php echo e($LigneProduit->idLigneProduit); ?>" class="glyphicon glyphicon-edit" data-toggle="modal">
                                            </a>
                                            
                                        <?php endif; ?>
                                        
                                    </td >
                                    <td class="text-center sorting_1">
                                        <a href="#DeleteModal<?php echo e($LigneProduit->idLigneProduit); ?>" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">
                                        </a>
                                    </td>
                                    
                                </tr>

                                <!--

                   <tr role="row" class="odd">
                       <td class="sorting_1">Gecko</td>
                       <td>Firefox 1.0</td>
                       <td>Win 98+ / OSX.2+</td>
                       <td>1.7</td>
                       <td>A</td>
                       <td>A</td>
                       <td>A</td>
                   </tr>
                   -->



                            <?php endforeach; ?>
                        </tbody>

                        </table>
                   
                    </div>

                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">

                    <a <?php if(Session::get('pageSource')=='commande'): ?> href="<?php echo e(url('commande_client/detail')); ?>/<?php echo e(Session::get('idPr')); ?>" <?php endif; ?> href="<?php echo e(url('preparation/index')); ?>" class="btn btn-default pull-right">Annuler</a>
                     <?php if(count($LigneProduits) >0): ?>
                      <button type="submit" class="btn btn-primary pull-right">Valider</button>
                     <?php endif; ?>
                    </div>

                    <?php echo Form::close(); ?>

            </div>

                <?php foreach($LigneProduits as $LigneProduit): ?>


                    <div class="example-modal">
                              <div class="modal" id="DeleteModal<?php echo e($LigneProduit->idLigneProduit); ?>">
                                  <div class="modal-dialog">
                                      <div class="modal-content">
                                          <div class="modal-header">
                                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                  <span aria-hidden="true">&times;</span></button>
                                              <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                          </div>
                                          <div class="modal-body">
                                              <p>Voulez-vous vraiment supprimer ce produit ?</p>
                                          </div>

                                          <div class="modal-footer">
                                              <?php echo Form::open(['method' => 'POST', 'action' => ['PreparationController@deleteProduit',$LigneProduit->idLigneProduit]]); ?>

                                              <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                              <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                              <?php echo Form::close(); ?>

                                          </div>
                                      </div>
                                      <!-- /.modal-content -->
                                  </div>
                                  <!-- /.modal-dialog -->
                              </div>
                              <!-- /.modal -->
                          </div>




                        <div cl1ass="example-modal" >
                            <div class="modal" id="EditModal<?php echo e($LigneProduit->idLigneProduit); ?>">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title" style="font-family:verdana;">Modifier produit</h4>
                                        </div>
                                        <div class="modal-body">
                                            <?php echo Form::open(['method'=>'PUT','action' => ['PreparationController@postEditeLigneProduit',$LigneProduit->idLigneProduit]]); ?>

                                            <div class="col-lg-12">
                                                <div class="col-lg-6">
                                                    <label>N° UE </label>
                                                    <select id="idSelecSSCC" class="form-control" name="sscc" >
                                                        <option value="">Sélectionner un N° UE</option>


                                                        <?php foreach($UEs as $UE): ?>
                                                            <option value="<?php echo e($UE->idUE); ?>" <?php if($UE->idUE == $LigneProduit->idUE): ?> selected <?php endif; ?>> <?php echo e($UE->UniteExpedition->SSCC); ?></option>
                                                        <?php endforeach; ?>

                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group col-lg-6">
                                                    <label>Référence</label>
                                                    <input type="text" class="form-control"  name="refenrence"  value="<?php echo $LigneProduit->Produit->reference; ?>" readonly >
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label>Désignation</label>
                                                    <input type="text" class="form-control"  name="designation"  value="<?php echo $LigneProduit->Produit->designation; ?>" readonly >
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label>Code à barres</label>
                                                    <input type="text" class="form-control"  name="designation"  value="<?php echo $LigneProduit->Produit->code_identification; ?>" readonly >
                                                </div>
                                                <?php if(Session::get('N_LOT')=='1'): ?>

                                                <div class="form-group col-lg-6">
                                                    <label>Numéro de lot</label>
                                                    <input type="text" class="form-control"  name="designation"  value="<?php echo $LigneProduit->StockProduit->numero_lot; ?>" readonly >
                                                </div>
                                                <?php endif; ?>
                                                <div class="form-group col-lg-6">
                                                    <label>Quantité</label>
                                                    <input type="number" step="0.01"min="1" max="" class="form-control"  placeholder="Quantite" name="quantite" value="<?php echo (float) $LigneProduit->quantite_a_preparer; ?>"  required  >
                                                </div>

                                            </div>

                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                            <button type="submit" class="btn btn-primary">Valider</button>
                                        </div>
                                        <?php echo Form::close(); ?>


                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                        </div>

                <?php endforeach; ?>
        </div>

<div class="modal fade" id="modal_modifier">
          <div class="modal-dialog ">
            <form method="post" action="<?php echo e(route('modifier_ligne_produit_preparation')); ?>">
                     <?php echo e(csrf_field()); ?>

            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Modifier produit</h4>
              </div>
              <div class="modal-body">
                <input type="hidden" id="id_stock" name="id_stock">
                <input type="hidden" id="id_ligne_produit" name="id_ligne_produit">
                <input type="hidden" name="importer" value="0">
                <div class="row">
                <div class="col-sm-12">
                    <div class="col-sm-6">
                        <label>Référence produit :</label>
                        <input type="text" class="form-control" readonly id="reference_produit">
                    </div>
                    <div class="col-sm-6">
                        <label>Code a bares produit :</label>
                        <input type="text" class="form-control" readonly id="code_bare_produit">
                    </div>
                    
                 
                    <label>Désignation produit :</label>
                <textarea class="form-control" rows="3" id="designation_produit" readonly style="text-align: center;"></textarea>
                 <div class="col-sm-6">
                        <label>N° UE :</label>
                        <select class="form-control" id="numero_ue" name="numero_ue">
                            
                        </select>
                    </div>
                    <div class="col-sm-6">
                        <label>Quantité a préparer :</label>
                        <input type="number" step="0.01" class="form-control" id="quantite_a_preparer_modal" name="quantite_a_preparer_modal">
                    </div>
               
                 
                    
                </div>
                 
                </div>


              </div>
              <div class="modal-footer">
                <input type="submit" class="btn btn-primary" value="Valider">
                <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                
              </div>
            </div>
            </form>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->




</section><!-- /.content -->
<script>

    function getProduitInfo(ligne , produit, stock){
        
        $.ajax({
                    url: "<?php echo e(url('preparation/get_ue_from_stock')); ?>/"+stock.num_entite+"/"+stock.id_produit,
                    method : "get",   
                    data: {
                    "_token": "<?php echo e(csrf_token()); ?>"
                    } ,        
                    success: function(data){ 
                        //alert(data[0].num_ue);
                    var myModal = $('#modal_modifier');
                    document.getElementById("reference_produit").value = produit.reference;
                    document.getElementById("code_bare_produit").value = produit.code_identification;
                    document.getElementById("designation_produit").value = produit.designation;

                    document.getElementById("id_stock").value = stock.id_stock_produit;
                    document.getElementById("id_ligne_produit").value = ligne.idLigneProduit;

                    document.getElementById("quantite_a_preparer_modal").value = ligne.quantite_a_preparer;
                    $("#numero_ue").empty();
                 
             
                    $("#numero_ue").append("<option selected disabled>Sélectionner un N° UE...</option>");

                  data.forEach(function(d) {
                    if(d.num_ue == stock.num_ue){
                        $("#numero_ue").append("<option selected value="+d.num_ue+">"+d.num_ue+"</option>");
                    }else{
                        $("#numero_ue").append("<option value="+d.num_ue+">"+d.num_ue+"</option>");
                    }
                  });
                    myModal.modal({ show: true }); 
                                  
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
         
      }


    function setCommande(element){

        if(element.checked){
            document.getElementById('numCommande').disabled = false;
            document.getElementById('commande').value = 1;

        }else{
            document.getElementById('numCommande').disabled = true;
            document.getElementById('commande').value = 0;
            document.getElementById('numCommande').value = "";
            document.getElementById("raisonSociale").value ="";
            document.getElementById("adresseClient").value ="";
        }

    }


    function getClient(numCommande){

        var num = document.getElementById("numCommande");
        var test = [];

        $.get("<?php echo e(url('preparation/commande_client?ID=')); ?>"+numCommande, function(res,stat){
            var raisonSociale = document.getElementById("raisonSociale");
            var adresseClient = document.getElementById("adresseClient");


            if (res.length == 0  ) {
                raisonSociale.value = "";
                adresseClient.value = "";
            }
            else
            {
                raisonSociale.value = res.client.raisonSociale;
                adresseClient.value = res.client.adresseClient;
            }

        });
    }
    function sessionPreparation(num)
    {
        var num = document.getElementById("numPreparation").value;
        $.get("<?php echo e(url('preparation/sessionPreparation?ID=')); ?>"+num,function(res,stat){})
    }
    function sessionOperateur(num)
    {
        var num = document.getElementById("idSelecOperateur").value;
        $.get("<?php echo e(url('preparation/sessionOperateur?ID=')); ?>"+num,function(res,stat){})
    }
    function sessionDate(date)
    {
        
        var date = document.getElementById("datePrevue").value;
        $.get("<?php echo e(url('preparation/sessionDate?ID=')); ?>"+date,function(res,stat){})
    }
    function sessionCommadee(date){
        var commande = document.getElementById("n_commande").value;
        $.get("<?php echo e(url('preparation/sessionCommandee?ID=')); ?>"+commande,function(res,stat){})
    }
    function sessionEntite(entite){
        
        var entite = document.getElementById("entite").value;
        //alert(entite);
        
        
        $.ajax({
                    url: "<?php echo e(url('preparation/sessionEntite')); ?>/"+entite,
                    method : "post",   
                    data: {
                    "_token": "<?php echo e(csrf_token()); ?>"
                    } ,        
                    success: function(data){ 
                               document.getElementById("add_produit").hidden = false;                          
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
       
    }
    function sessionTransporteur(idTransporteur)
    {
        
        var idTransporteur = document.getElementById("idSelecTransporteur").value;
        $.get("<?php echo e(url('preparation/sessionTransporteur?ID=')); ?>"+idTransporteur,function(res,stat){})
    }
    function sessionCommande(element)
    {
        var checked = document.getElementById("commande").value;
        $.get("<?php echo e(url('preparation/sessionCommande?ID=')); ?>"+checked,function(res,stat){})

    }
    function sessionSociale(sociale){
       
        var sociale = document.getElementById("sociale").value;

        $.get("<?php echo e(url('preparation/sessionSociale?ID=')); ?>"+sociale,function(res,stat){})
        //document.getElementById("add_produit").hidden = false;
    }

</script>

<?php $__env->stopSection(); ?>









<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>