<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">
    <?php echo Form::open(['method'=>'POST','action' => ['StockProduitController@recherche_lot']]); ?>

    <?php if(Session::get('ADMINISTRATION_STOCK_AJOUTER')): ?>
    <div class="box-tools pull-right">
        <a href="<?php echo e(url('stock_produit_lot/ajouter')); ?>" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>

    <?php endif; ?>
    <div class="box-tools pull-right" style="margin-right: 1%" id="rechercher" hidden="true">
        <input type="submit" class="btn btn-default" value="Rechercher" >
    </div>
     <?php if(isset($emplacementSelected) || isset($produitSelected) || isset($zoneSelected) || isset($entiteSelected)): ?>
        <div class="box-tools pull-right" style="margin-right: 1%">
        <a href="<?php echo e(url('stock_produit_lot/index')); ?>" class="btn btn-default">
         Réinitialiser
        </a>
    </div>
    <?php endif; ?>
    
    <h3>
        Gestion des stocks des produits par N° lot
    </h3>

</br>
<div class="col-lg-12">

<div class="col-md-3">
        <label class="text-center">Filtrer par zone : </label>
        <select  class="form-control selectpicker" data-live-search="true"
        onchange="recherche()" name="zone">
        <option selected disabled style="background-color: white">Choisir la zone ...</option>
        <?php foreach($zones as $zone): ?>
        <option value="<?php echo e($zone->id_zone); ?>" 
            <?php if(isset($zoneSelected) && $zone->id_zone == $zoneSelected->id_zone): ?>
            selected 
            <?php endif; ?> >
            <?php echo e($zone->libelle); ?> </option>
            <?php endforeach; ?>
        </select>

    </div>

    <div class="col-md-3">
        <label class="text-center">Filtrer par emplacement : </label>
        <select  name="emplacement" class="form-control selectpicker" data-live-search="true"
        onchange="recherche()">
        <option selected disabled style="background-color: white">Choisir l'emplacement ...</option>
        <?php foreach($emplacements as $emplacement): ?>
        <option value="<?php echo e($emplacement->id_emplacement); ?>" 
            <?php if(isset($emplacementSelected) && $emplacement->id_emplacement == $emplacementSelected->id_emplacement): ?>
            selected 
            <?php endif; ?> >
            <?php echo e($emplacement->libelle); ?> </option>
            <?php endforeach; ?>
        </select>

    </div>
<?php if(Session::get('STOCK_ENTITE') == '1'): ?> 
<div class="col-md-3">
        <label class="text-center">Filtrer par N° Entité : </label>
        <select name="entite" class="form-control selectpicker" data-live-search="true"
        onchange="recherche()">
        <option selected disabled style="background-color: white">Choisir le n° entité ...</option>
        <?php foreach($entites as $entite): ?>
        <option value="<?php echo e($entite->num_entite); ?>" 
            <?php if(isset($entiteSelected) && $entite->id_entite == $entiteSelected->id_entite): ?>
            selected 
            <?php endif; ?> >
            <?php echo e($entite->num_entite); ?> </option>
            <?php endforeach; ?>
        </select>

    </div>
<?php endif; ?>
    <div class="col-lg-3 col-md-3">
        <label class="text-center">Filtrer par produit : </label>
        <select name="produit" id="idSelectProduit" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="produit" onchange="recherche()">
            <option selected disabled style="background-color: white">Choisir le produit ...</option>
            <?php foreach($produits as $produitIndex): ?>
            <option value="<?php echo e($produitIndex->id_produit); ?>" <?php if(isset($produitSelected) && ($produitIndex->id_produit == $produitSelected->id_produit)): ?> selected <?php endif; ?> ><?php echo e($produitIndex->reference); ?> </option>
            <?php endforeach; ?>
        </select>

    </div>

</div>
<?php echo Form::close(); ?>

</br>
</br>
</br>
</section>
<!-- Main content -->
<section class="content">


    <?php if(Session::has('msgAjouter')): ?>
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgAjouter'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>



    <?php if(Session::has('msgDeleteOk')): ?>
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgDeleteOk'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if(Session::has('msgUpdate')): ?>
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgUpdate'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if(Session::has('msgAddEmplacement')): ?>
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgAddEmplacement'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if(Session::has('msgDeleteNotOk')): ?>
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgDeleteNotOk'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>


    <!-- Default box -->
    <div class="box">
        <div class="table-responsive">
            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr role="row">
                        <?php if(Session::get('STOCK_ENTITE') == '1'): ?> 
                        <th class="text-center sorting_asc">N° Entité</th>
                        <?php endif; ?>
                        <?php if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?> 
                        <th class="text-center sorting_asc">N° UE</th>
                        <?php endif; ?>
                        <th class="text-center sorting_asc">Référence</th>
                        <th class="text-center sorting_asc">Produit</th>
                        <th class="text-center sorting_asc">Emplacement</th>
                        <th class="text-center sorting_asc">N° lot</th>
                        <?php if(Session::get('ADMINISTRATION_STOCK')): ?>
                            <th class="text-center sorting_asc">Quantité <br>physique</th>
                            <th class="text-center sorting_asc">Quantité <br>utilisable</th>
                            <th class="text-center sorting_asc">Quantité <br>réelle</th>
                        <?php endif; ?>
                        
                            <th class="text-center sorting_asc">Détail</th>

                        <?php if(Session::get('ADMINISTRATION_STOCK_MODIFIER')): ?>
                                <th class="text-center sorting_asc">Modifier</th>
                        <?php endif; ?>
                        <?php if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER')): ?>
                                <th class="text-center sorting_asc">Supprimer</th>
                        <?php endif; ?>
                    </tr>
                </thead>

                <tbody>
                    <?php foreach( $stocks as $stock): ?>

                    <tr role="row" class="odd">
                        <?php if(Session::get('STOCK_ENTITE') == '1'): ?> 
                        <td class="text-center sorting_1"><?php echo $stock->num_entite; ?></td>
                        <?php endif; ?>
                        <?php if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?> 
                        <td class="text-center sorting_1"><?php echo $stock->num_ue; ?></td>
                        <?php endif; ?>
                        <td class="text-center sorting_1"><?php echo $stock->produit->reference; ?></td>
                        <td class="text-center sorting_1"><?php echo $stock->produit->designation; ?></td>
                        <td class="text-center sorting_1"><?php echo $stock->emplacement->libelle; ?></td>
                        <td class="text-center sorting_1"><?php echo $stock->numero_lot; ?></td>

                        <?php if(Session::get('ADMINISTRATION_STOCK')): ?>
                            <td class="text-center sorting_1"><?php echo e((float) $stock->quantite); ?></td>
                            <td class="text-center sorting_1"><?php echo e((float) $stock->quantite_utilisable); ?></td>
                            <td class="text-center sorting_1"><?php echo e((float) $stock->quantite_reelle); ?></td>
                        <?php endif; ?>
                        <td class="text-center sorting_1">
                            <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="afficheDetail(<?php echo e($stock->id_stock_produit); ?>)"></a>
                        </td>
                        <?php if(Session::get('ADMINISTRATION_STOCK_MODIFIER')): ?>
                            <td class="text-center sorting_asc">          
                                <a href="<?php echo e(url('stock_produit_lot/modifier')); ?>/<?php echo e($stock->id_stock_produit); ?>" class="glyphicon glyphicon-edit"></a>
                            </td>
                        <?php endif; ?>
                        <?php if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER')): ?>
                            <td class="text-center sorting_asc">
                                <a href="#DeleteModal<?php echo e($stock->id_stock_produit); ?>" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal"></a>    
                            </td>
                        <?php endif; ?>
                    </tr>

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal<?php echo e($stock->id_stock_produit); ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                        </div>
                                        <div class="modal-body">
                                            <p>Voulez vous  supprimer le stock du produit " <?php echo e($stock->produit->designation); ?> " avec la référence " <?php echo e($stock->produit->reference); ?> " ?</p>
                                        </div>

                                        <div class="modal-footer">
                                            <?php echo Form::open(['method' => 'POST', 'action' => ['StockProduitController@delete_lot',$stock->id_stock_produit]]); ?>

                                            <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                            <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                            <?php echo Form::close(); ?>

                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                        </div>
                        <?php endforeach; ?>

                    </tbody>

                </table>
            </div>
        </div><!-- /.box -->
        
        <?php if(isset($emplacementSelected) || isset($produitSelected) || isset($zoneSelected) || isset($entiteSelected)): ?>
             <section class="content">
            <div class="box box-solid text-center" style="width: 40%; float: right;">
                <p style="margin:2%">Total quantité physique : <b><?php echo e((float) $stocks->sum('quantite')); ?></b></p>
                <p style="margin:2%">Total quantité utilisable : <b><?php echo e((float) $stocks->sum('quantite_utilisable')); ?></b></p>
                <p style="margin:2%">Total quantité réelle&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: <b><?php echo e((float) $stocks->sum('quantite_reelle')); ?></b></p>
            </div>
        </section>
        <?php endif; ?>



        
         
        <div class="modal fade" id="modal_detail">
            <div class="modal-dialog modal-lg">
              <div class="modal-content">
                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span></button>
                      <h4 class="modal-title" id="produit_name"></h4>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Emplacement : </label>
                             <input type="text" class="form-control" id="emplacement_modal" value="" readonly >
                            
                        </div>
                        <?php if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">N° UE : </label>
                            <input type="text" class="form-control" id="ue_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Etat Ue : </label>
                            <input type="text" class="form-control" id="etat_ue_modal" value="" readonly >
                        </div>
                        <?php endif; ?>
                        <?php if(Session::get('STOCK_ENTITE') == '1'): ?>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">N° Entité : </label>
                            <input type="text" class="form-control" id="entite_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Type entité : </label>
                            <input type="text" class="form-control" id="type_entite_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Libellé entité : </label>
                            <input type="text" class="form-control" id="libelle_entite_modal" value="" readonly >
                        </div>
                        <?php endif; ?>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date d'entré en stock : </label>
                            <input type="text" class="form-control" id="date_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Inventaire : </label>
                            <input type="text" class="form-control" id="inventaire_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date inventaire : </label>
                            <input type="text" class="form-control" id="date_inventaire_modal" value="" readonly >
                        </div>
                         <?php if(Session::get('DATE_PEREMPTION')=='1'): ?>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date de fabrication : </label>
                            <input type="text" class="form-control" id="date_fabrication" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date de péremption : </label>
                            <input type="text" class="form-control" id="date_peremption" value="" readonly >
                        </div>
                        <?php endif; ?>
                    </div>
                    </div>
                    

                    <div class="modal-footer justify-content-between">
                      <button type="button" class="btn btn-default" data-dismiss="modal">Quitter</button>
                  </div>
              </div>
              <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
      </div>
      <!-- /.modal -->
</div>





  </section><!-- /.content -->


  <script>

    function getProduit(idProduit){

        window.location.href = "<?php echo e(url('stock_produit_lot/produit')); ?>/"+idProduit

    }
    function recherche(){
        document.getElementById("rechercher").hidden =false;
        //document.getElementById("recherche_multipe").submit();
    }
    function getEmplacement(idEmplacement){

        window.location.href = "<?php echo e(url('stock_produit_lot/emplacement')); ?>/"+idEmplacement

    }
    function getZone(idZone){

        window.location.href = "<?php echo e(url('stock_produit_lot/zone')); ?>/"+idZone

    }
    function getEntite(idEntite){
        //alert(idEntite);

        window.location.href = "<?php echo e(url('stock_produit_lot/entite')); ?>/"+idEntite

    }
    function afficheDetail(id_produit){
       $.ajax({
        url: "<?php echo e(url('stock_produit/infos')); ?>/"+id_produit,
        method : "post",   
        data: {
            "_token": "<?php echo e(csrf_token()); ?>"
        } ,        
        success: function(data){ 
            document.getElementById("produit_name").innerHTML = "Détail Produit " +
            "[ "+data.produit.reference +", "+data.produit.designation+" ]";  

            var myModal = $('#modal_detail');
            document.getElementById('emplacement_modal').value = data.emplacement.libelle;
            <?php if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?>
            if(data.ue){
                document.getElementById('ue_modal').value = data.ue.num_ue;
                if(data.ue.etat_ue == 0){
                    document.getElementById('etat_ue_modal').value = "FERMER"; 
                }
                if(data.ue.etat_ue == 1){
                    document.getElementById('etat_ue_modal').value = "OUVERT";             
                } 
            }
            <?php endif; ?>
            <?php if(Session::get('STOCK_ENTITE') == '1'): ?>
            if(data.entite){
                document.getElementById('entite_modal').value =data.entite.num_entite;
                document.getElementById('type_entite_modal').value =data.entite.type_entite;
                document.getElementById('libelle_entite_modal').value =data.entite.libelle_entite;
            }
            <?php endif; ?>
            
            document.getElementById('date_modal').value =data.date_entree;
            if(data.inventaire){
                document.getElementById('inventaire_modal').value =data.inventaire.designationInventaire;
                document.getElementById('date_inventaire_modal').value =data.inventaire.dateFin;
            }
            <?php if(Session::get('DATE_PEREMPTION')=='1'): ?>
                document.getElementById('date_fabrication').value =data.date_fabrication;
                document.getElementById('date_peremption').value =data.date_peremption;
            <?php endif; ?>

            myModal.modal({ show: true });                                  
        },
        error: function(data){
            alert('oops erreur de serveur !!');
        }
    });
   }


</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>