<?php $__env->startSection('content'); ?>

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Modifier un inventaire
    </h1>
</section>


<!-- Main content -->
<section class="content">
<?php if(Session::has('msgAddSuccess')): ?>
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgAddSuccess'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
<?php endif; ?>


<?php if(Session::has('msgAddExist')): ?>
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('msgAddExist'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if(Session::has('erreur')): ?>
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em><?php echo session('erreur'); ?></em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>
            <!-- fin messages -->

    <!-- Default box -->
    <div class="box">
        
            <?php echo Form::open(['method'=>'POST','action' => ['InventaireController@postEdit',$Inventaire->idInventaire]]); ?>

            <div class="form-group">
                <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                    <div class="col-lg-4 col-md-4 col-sm-6">
                        <label>N° inventaire : </label>
                        <input type="text" name="numInventaire" class="form-control" required value="<?php echo e($Inventaire->numInventaire); ?>" readonly>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>Désignation inventaire : </label>
                        <input type="text" name="designation" class="form-control"  required value="<?php echo e($Inventaire->designationInventaire); ?>" >
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>Type d’ inventaire : </label>

                        <?php if($Inventaire->typeInventaire == 0): ?>
                            <input type="text" class="form-control"  value="Inventaire total"  readonly >
                        <?php endif; ?>
                        <?php if($Inventaire->typeInventaire == 1): ?>
                            <input type="text" class="form-control"  value="Inventaire par zone"  readonly >
                        <?php endif; ?>
                        <?php if($Inventaire->typeInventaire == 2): ?>
                            <input type="text" class="form-control"  value="Inventaire par emplacement"  readonly >
                        <?php endif; ?>
                        <?php if($Inventaire->typeInventaire == 3): ?>
                            <input type="text" class="form-control"  value="Inventaire par Entité"  readonly >
                        <?php endif; ?>
                        <?php if($Inventaire->typeInventaire == 4): ?>
                            <input type="text" class="form-control"  value="Inventaire par N°UE"  readonly >
                        <?php endif; ?>

                    </div>
                    
                </div>

                <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>Statut : </label>
                        <select  name="statut"  class="form-control" required="required">
                            <option selected disabled value="">Sélectionner le statut ...</option>
                            <?php foreach($statuts as $statut): ?>
                                <option value="<?php echo e($statut->code); ?>" <?php if($statut->code == $Inventaire->statutInventaire): ?> selected <?php endif; ?>> <?php echo e($statut->valeur); ?> </option>
                            <?php endforeach; ?>
                        </select>
                    </div>


                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>Date début d’inventaire :</label>
                        <input type="date" class="form-control"   required value="<?php echo e($Inventaire->dateDebut); ?>" readonly>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <label>Date fin d’inventaire :</label>
                        <input type="date" class="form-control"   required value="<?php echo e($Inventaire->dateFin); ?>" readonly>
                    </div>

                </div>
                <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                <div class="col-lg-12 col-md-6 col-sm-6">
                        <label>Commentaire : </label>
                        
                        <textarea name="commentaire" class="form-control"><?php echo e($Inventaire->commentaire); ?></textarea>
                    </div>
                </div>

                <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                    

                    <?php if($Inventaire->typeInventaire == 1): ?>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Zone : </label>
                            <input type="text" class="form-control" value="<?php echo e($zone); ?>" readonly>
                        </div>
                    <?php endif; ?>
                    <?php if($Inventaire->typeInventaire == 2): ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Emplacement : </label>
                            <input type="text" class="form-control" value="<?php echo e($emplacement); ?>" readonly>
                        </div>
                    <?php endif; ?>
                    <?php if($Inventaire->typeInventaire == 3): ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Entité : </label>
                            <input type="text" class="form-control" value="<?php echo e($entite->type_entite); ?> / <?php echo e($entite->num_entite); ?> / <?php echo e($entite->libelle_entite); ?>" readonly>
                        </div>
                    <?php endif; ?>
                    <?php if($Inventaire->typeInventaire == 4): ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>N°UE : </label>
                            <input type="text" class="form-control" value="<?php echo e($ue->num_ue); ?>" readonly>
                        </div>
                    <?php endif; ?>

                </div>


                </div>

                <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                    
                    

                     <div style="float: right">
                        <a href="<?php echo e(url('inventaire/index')); ?>" class="btn btn-default" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-primary">Valider</button>
                    </div><br><br><br>
            <?php echo Form::close(); ?>

                <?php if(Session::get('INVENTAIRES_SIMULER_FO')=='1'): ?>
                    <?php if($Inventaire->statutInventaire == 0): ?>
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-ajouter-produit" style="float: right">
                        <span class="glyphicon glyphicon-plus" ></span>
                            Ajouter produit (Simuler Saisie FO)
                        </button>
                    <?php endif; ?>
                <?php endif; ?>
                </div>


        <div class="row">
            <div class="col-sm-12">
                <div class="table-responsive">
           <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                     <?php if(Session::get('STOCK_ENTITE')== "1"): ?>
                            
                                <th class="text-center sorting_asc">Entité</th>
                            
                        <?php endif; ?>
                        <?php if(Session::get('STOCK_EMPLACEMENT_MOBILE')== "1"): ?>
                            
                                <th class="text-center sorting_asc">N°UE</th>
                            
                        <?php endif; ?>
                    <th class="text-center sorting_asc">Référence</th>
                    <th class="text-center sorting_asc">Désignation</th>
                    <th class="text-center sorting_asc">Code produit</th>
                    <?php if(Session::get('N_LOT')=='1'): ?>
                        <th class="text-center sorting_asc">Numéro de lot</th>
                    <?php endif; ?>
                    <th class="text-center sorting_asc">Emplacement</th>
                    <th class="text-center sorting_asc">Quantité estimée</th>
                    <th class="text-center sorting_asc">Quantité comptée</th>
                    <th class="text-center sorting_asc">Ecart</th>
                    <th class="text-center sorting_asc">Opérateur</th>
                    <?php if($Inventaire->statutInventaire == 0): ?>
                        <th class="text-center sorting_asc">Modifier (Simuler Saisie FO)</th>
                    <?php endif; ?>
                    <?php if($Inventaire->statutInventaire == 0): ?>
                        <th class="text-center sorting_asc">Supprimer (Simuler Saisie FO)</th>
                    <?php endif; ?>
                </tr>
                </thead>
                <tbody>
                <?php foreach($LigneInventaire as $LigneProduit): ?>
                    <tr role="row">
                        <?php if(Session::get('STOCK_ENTITE')== "1"): ?>
                               
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->num_entite; ?></td>
                               
                            <?php endif; ?>
                            <?php if(Session::get('STOCK_EMPLACEMENT_MOBILE')== "1"): ?>
                               
                                    <td class="text-center sorting_1"><?php echo $LigneProduit->num_ue; ?></td>
                              
                            <?php endif; ?>
                        <td class="text-center sorting_1"><?php echo $LigneProduit->produit->reference; ?></td>
                        <td class="text-center sorting_1"><?php echo $LigneProduit->produit->designation; ?></td>
                        <td class="text-center sorting_1"><?php echo $LigneProduit->produit->code_identification; ?></td>
                        <?php if(Session::get('N_LOT')=='1'): ?>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->Stock->numero_lot; ?></td>
                        <?php endif; ?>
                        <td class="text-center sorting_1"><?php echo $LigneProduit->Emplacement->libelle; ?></td>
                        <td class="text-center sorting_1"><?php echo (float) $LigneProduit->quantiteEstimee; ?></td>
                        <td class="text-center sorting_1"><?php echo (float) $LigneProduit->quantiteComptee; ?></td>
                        <td class="text-center sorting_1"><?php echo (float) $LigneProduit->ecart; ?></td>
                        <?php if($LigneProduit->User != null): ?>
                            <td class="text-center sorting_1"><?php echo $LigneProduit->User->nom; ?> <?php echo $LigneProduit->User->prenom; ?></td>
                        <?php else: ?>
                            <td class="text-center sorting_1"></td>
                        <?php endif; ?>
                        
                        <?php if($Inventaire->statutInventaire == 0): ?>
                            <td class="text-center sorting_asc">
                                <a style="cursor: pointer;" class="glyphicon glyphicon-edit" onclick="modifier_ligle_produit(<?php echo e($LigneProduit->quantiteEstimee); ?> ,<?php echo e($LigneProduit->quantiteComptee); ?>,<?php echo e($LigneProduit->idLigneInventaire); ?> ,<?php echo e($Inventaire->idInventaire); ?>, <?php echo e($LigneProduit->Produit); ?>)">
                                </a>
                            </td>
                        <?php endif; ?>
                        <?php if($Inventaire->statutInventaire == 0): ?>
                            <td class="text-center sorting_asc">
                                <a onclick="delete_ligne_inventaiee(<?php echo e($LigneProduit->idLigneInventaire); ?>,<?php echo e($Inventaire->idInventaire); ?>)" style="cursor: pointer;" class="open-AddBookDialog glyphicon glyphicon-trash" >
                                </a>
                            </td>
                        <?php endif; ?>

                    </tr>
                <?php endforeach; ?>
                </tbody>

            </table>
        </div>
            </div></div>


        
            
    </div><!-- /.box -->


<div class="modal fade" id="modal-ajouter-produit">
          <div class="modal-dialog">
            <div class="modal-content">
                <form method="post" action="<?php echo e(route('insererInventaire')); ?>">
                     <?php echo e(csrf_field()); ?>

                    <input type="hidden" name="id_inventaire" value="<?php echo e($Inventaire->idInventaire); ?>">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Ajouter produit</h4>
              </div>
              <div class="modal-body">
                 <div class="form-group">
                            <label>Opérateur :</label>
                            <input type="text" id="" class="form-control" disabled value="<?php echo e(Session::get('nom')." ".Session::get('prenom')); ?>" style="text-align: center">
                        </div>
                    <div class="col-sm-12">
                        <div class="col-sm-6">
                            <br> 
                            <label>La zone de stockage :</label>
                            <?php if($Inventaire->typeInventaire == 2): ?>
                            <input type="text" id="zonee" class="form-control" readonly value="<?php echo e($zoneSelected); ?>" style="text-align: center" name="zonee">
                            <?php endif; ?>
                            <?php if($Inventaire->typeInventaire == 1): ?>
                            <input type="text" id="zonee" class="form-control" readonly value="<?php echo e($zone); ?>" style="text-align: center" name="zonee">
                            <?php endif; ?>
                            <?php if($Inventaire->typeInventaire == 0 || $Inventaire->typeInventaire == 3 || $Inventaire->typeInventaire == 4): ?>
                                <select class="form-control" onchange="getEmplacement()" id="zonee" name="zonee" required>
                                <option selected disabled> Sélectionner la zone ...</option>
                                <?php foreach($zones as $zone): ?>
                                    <option value="<?php echo e($zone->id_zone); ?>"><?php echo e($zone->libelle); ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php endif; ?>
                            
                        
                        </div>
                        <div class="col-sm-6">
                            <br>
                            <label>Emplacement :</label>
                            <?php if($Inventaire->typeInventaire == 2): ?>
                                    <input type="text" id="emplacement" class="form-control" readonly value="<?php echo e($emplacement); ?>" style="text-align: center" name="">
                                    <input type="hidden" name="emplacement" value="<?php echo e($Inventaire->idEmplacement); ?>">
                                <?php endif; ?>
                           <?php if($Inventaire->typeInventaire == 1): ?>
                           <select class="form-control"  id="emplacement" name="emplacement" required>
                                <option selected disabled> Sélectionner l'emplacement ...</option>
                                <?php foreach($emplacement_choix as $element): ?>
                                    <option value="<?php echo e($element->id_emplacement); ?>"> <?php echo e($element->libelle); ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php endif; ?>
                            <?php if($Inventaire->typeInventaire == 0 || $Inventaire->typeInventaire == 3 || $Inventaire->typeInventaire == 4): ?>
                             <select class="form-control"  id="emplacement" onchange="" name="emplacement" required>
                                <option selected disabled> Sélectionner l'emplacement ...</option>
                            </select>
                            <?php endif; ?>
                           
                        
                        </div>
                        
                        <?php if(Session::get('STOCK_ENTITE')): ?>
                        <div class="col-sm-6">
                                <br>
                            <label>Entité :</label>
                            <?php if($Inventaire->typeInventaire == 3): ?>
                            <input type="text" id="entite" class="form-control" readonly value="<?php echo e($entiteSelected->num_entite); ?>" style="text-align: center" name="entite">
                            <?php else: ?>
                            <select class="form-control selectpicker" data-live-search="true"  id="entite" onchange="" name="entite" required>
                                <option selected disabled style="background-color: white"> Sélectionner un Entité ...</option>
                                 <?php foreach($entites as $e): ?>
                                    <option value="<?php echo e($e->num_entite); ?>"><?php echo e($e->num_entite); ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php endif; ?>
                            
                        
                        </div>
                        <?php endif; ?>
                        
                        <?php if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')): ?>
                           
                        
                        <div class="col-sm-6">
                                <br>
                            <label>N°UE :</label>
                            <?php if($Inventaire->typeInventaire == 4): ?>
                            <input type="text" id="ue" class="form-control" readonly value="<?php echo e($ueSelected->num_ue); ?>" style="text-align: center" name="ue">
                            <?php else: ?>
                            <select class="form-control selectpicker" data-live-search="true" id="ue" onchange="" name="ue" required>
                                <option selected disabled style="background-color: white"> Sélectionner un N°UE ...</option>
                                <?php foreach($ues as $e): ?>
                                    <option value="<?php echo e($e->num_ue); ?>"><?php echo e($e->num_ue); ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php endif; ?>
                            
                        
                        </div>
                        <?php endif; ?>
                        
                        
                            <label>Produit :</label>
                            <select class="form-control selectpicker" data-live-search="true" id="produit" onchange="selectionneProduit()" name="produit">
                                <option selected disabled style="background-color: white"> Sélectionner le produit ...</option>
                                <?php foreach($produits as $s): ?>
                                     <option value="<?php echo e($s->id_produit); ?>"> <?php echo e($s->reference); ?>

                                 </option>
                                <?php endforeach; ?>

                            </select>
                        
                        <div class="form-group">
                            <label>Quantité comptée :</label>
                            <input type="number" step="0.01" min="0" class="form-control" style="text-align: center"  id="quantiteCompte" name="quantiteCompte" required>
                        </div>                  
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Annuler</button>
                <input type="submit" class="btn btn-primary" value="Valider" />
                
              </div>
          </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

        <div class="modal fade" id="modal-ligne_produit">
          <div class="modal-dialog ">
            <form method="post" action="<?php echo e(route('ligne_produit_modifier')); ?>">
                     <?php echo e(csrf_field()); ?>

                     <input type="hidden" name="id_inventaire" id="id_inventaire">
                     <input type="hidden" name="ligne_produit" id="ligne_produit">
                     <input type="hidden" name="quantite_e" id="quantite_e">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Modifier ligne produit</h4>
              </div>
              <div class="modal-body">
                        <div class="form-group">
                            <label>Opérateur :</label>
                            <input type="text" id="" class="form-control" disabled value="<?php echo e(Session::get('nom')." ".Session::get('prenom')); ?>" style="text-align: center">
                        </div>
                        <div class="form-group">
                            <label>Produit :</label>
                            
                            <textarea id="produit_ligne" row="3" class="form-control" readonly style="text-align: center"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Quantité estimée :</label>
                            <input type="number" step="0.01" id="quantite_E" class="form-control" disabled style="text-align: center">
                        </div>
                    <div class="col-sm-12">
                        <br>
                        <div class="form-group">
                            <label>Quantité comptée :</label>
                            <input type="number" step="0.01" id="quantite_C" required name="quantite_C" class="form-control" style="text-align: center">
                        </div>
                    </div>

              </div>
              
              <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Annuler</button>
               <input type="submit" class="btn btn-primary" value="Valider">
                
              </div>
            </div>
            </form>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

        <div class="example-modal">
                        <div class="modal" id="DeleteModal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer la ligne d'inventaire ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        <form method="post" action="<?php echo e(route('deleteLigne')); ?>">
                                            <?php echo e(csrf_field()); ?>

                                            <input type="hidden" name="id_ligne_produit_delete" id="id_ligne_produit_delete">
                                            <input type="hidden" name="idInventaire" id="idInventaire">
                                            <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                            <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        </form>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>
</section><!-- /.content -->
<script type="text/javascript">
    
    function getEmplacement(){

          var zone = document.getElementById("zonee").value;
          $.ajax({
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},  
                url: "<?php echo e(url('inventaire/getEmplacement')); ?>/"+zone,
                method : "POST",
               
                success: function(data) {
                   if (data == 0) {
                        $('#emplacement').attr('disabled', true);
                        $('#produit').attr('disabled', true);
                        $('#quantiteCompte').attr('disabled', true);
                        alert('oops pas demplacement trouvé pour cette zone! ');
                    }
                    else{
                        $('#emplacement').attr('disabled', false);
                        $("#emplacement").empty();
                         $("#emplacement").append("<option selected disabled>Sélectionner l'emplacement ...</option>");
                        data.forEach(function(d) {
                              $("#emplacement").append("<option value="+d.id_emplacement+">"+d.libelle+"</option>");
                          });
                    }
                },
                error: function(data){
                          alert('oops erreur de serveur! ');
                }

              });
    }

    function getProduitStock(){

          var emplacement = document.getElementById("emplacement").value;
          $.ajax({
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},  
                url: "<?php echo e(url('emplacement/getProduitStock')); ?>/"+emplacement,
                method : "GET",
               
                success: function(data) {
                   if (data == 0) {
                        $('#produit').attr('disabled', true);
                        $('#quantiteCompte').attr('disabled', true);
                        alert('oops pas de produit trouvé dans lemplacement ');
                    }
                    else{
                        $('#produit').attr('disabled', false);
                        $("#produit").empty();
                        $("#produit").append("<option>Sélectionner le produit ...</option>");
                        var vals = Object.keys(data[0]).map(function(key) {
                              $("#produit").append("<option value="+key+">"+data[0][key]+"</option>");
                        });
                    }
                },
                error: function(data){
                    alert('oops erreur de serveur! ');
                }

              });
    }

    function selectionneProduit(){
        $('#quantiteCompte').attr('disabled', false);
    }

    function modifier_ligle_produit(estimee , comptee , id_ligne_inventaire, id_inventaire,objetProduit) {
    //alert(objetProduit) ;      
        var myModal = $('#modal-ligne_produit');
        
        document.getElementById('produit_ligne').value = objetProduit.reference+", "+objetProduit.designation ;
        document.getElementById('id_inventaire').value = id_inventaire;
        document.getElementById('quantite_e').value = estimee;
        document.getElementById('ligne_produit').value = id_ligne_inventaire;
        document.getElementById('quantite_E').value = estimee;
        document.getElementById('quantite_C').value = comptee;
        myModal.modal({ show: true });
    }

    function delete_ligne_inventaiee(id_ligne_produit,id_inventaire){
        var myModal = $('#DeleteModal');
        document.getElementById('id_ligne_produit_delete').value = id_ligne_produit;
        document.getElementById('idInventaire').value = id_inventaire;
        myModal.modal({ show: true });

    }

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>