<?php $__env->startSection('content'); ?>

        <!-- Content Header (Page header) -->



<section class="content-header">

    <h1>
        Ajouter le stock d'un produit
    </h1>

</section>



<!-- Main content -->
<section class="content">
    <!-- Messages -->

    <?php if(Session::has('msgAdd')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAdd'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgAddEmplacement')): ?>
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAddEmplacement'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgAddQuantite')): ?>
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAddQuantite'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgAddExist')): ?>
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAddExist'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>
                <!-- fin messages -->

        <!-- Default box -->
        <div class="box">
            <div class="panel-body">
                <div class="col-sm-12">

                    <?php echo Form::open(['method'=>'POST','action' => ['StockProduitController@postForm']]); ?>



                    <table>
                        <tbody>
                        <?php if(Session::get('STOCK_ENTITE') == '1'): ?>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    N° Entité
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="entite" placeholder="N° entité du stock" required value="<?php echo e(old('entite')); ?>">
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <?php if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1'): ?>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    N° UE
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="ue" placeholder="N° UE du stock" required value="<?php echo e(old('ue')); ?>">
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Référence produit
                                </label>
                                <div class="col-sm-6">
                                    <select class="form-control selectpicker pickProduit" data-selected-text-format="count > 3" data-live-search="true" name="produit" >
                                    
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Zone de stockage
                                </label>
                                <div class="col-sm-6">
                                    <select id="idSelectZone" class="form-control" name="zone" onchange="getEmplacement(this.value)" required="required">
                                        <option selected disabled>Sélectionner la zone de stockage...</option>
                                        <?php foreach($zones as $zone): ?>
                                            <option value="<?php echo e($zone->id_zone); ?>" ><?php echo e($zone->libelle); ?> </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Emplacement du nouveau stock du produit
                                </label>
                                <div class="col-sm-6">
                                    <select id="idSelectEmplacement" class="form-control" name="emplacement" required="required">
                                        <option selected disabled>Sélectionner l'emplacement de ce nouveau stock ...</option>

                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Quantité
                                </label>
                                <div class="col-sm-6">
                                    <input type="number"  step="0.01" class="form-control" name="quantite" placeholder="Quantité du stock" required value="<?php echo e(old('quantite')); ?>">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Date d'entrée de ce stock
                                </label>
                                <div class="col-sm-6">
                                    <input type="date"  class="form-control" name="date" placeholder="Date d'entrée de ce stock" required value="<?php echo e(old('date')); ?>">
                                </div>
                            </td>
                        </tr>

                        </tbody>
                    </table>
                    </br>
                    </br>



                    <input class="btn btn-flat btn-primary pull-right" type="submit" value="Valider">
                    <a href="<?php echo e(url('stock_produit/index')); ?>" class="btn btn-flat btn-danger pull-right">Annuler</a>

                    <?php echo Form::close(); ?>


                </div>
            </div>







        </div><!-- /.box -->
</section><!-- /.content -->





<script>
    function getEmplacement(id_zone){


        //alert(id_zone);

        var nom = document.getElementById("idSelectZone");
        $.get("<?php echo e(url('stock_produit/emplacements?ID=')); ?>"+id_zone, function(res,stat){
            var select1 = document.getElementById("idSelectEmplacement");
            // var nom= document.getElementById("input3");


            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value=''>Sélectionner l'emplacement de ce nouveau stock ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_emplacement+"'> "+res[i].libelle+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }


        });
    }

</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>