<?php $__env->startSection('content'); ?>

<section class="content-header">
    <?php if(Session::get('INVENTAIRES_AJOUTER')): ?>

    <div class="box-tools pull-right">
        <a href=" <?php echo e(url('inventaire/ajouter')); ?>" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
<?php endif; ?>
    <h1>
        Liste des inventaires
    </h1>

</section>

<!-- Main content -->
<section class="content">

    <?php if(Session::has('msgAddSuccess')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAddSuccess'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>


    <?php if(Session::has('msgDelete')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgDelete'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgSupprimer')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgSupprimer'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>


    <?php if(Session::has('msgExist')): ?>
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgExist'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(Session::has('msgAjouter')): ?>
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em><?php echo session('msgAjouter'); ?></em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        <?php endif; ?>
                <!-- Default box -->
        <div class="box">

            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N° inventaire</th>
                    <th class="text-center sorting_asc">Désignation inventaire</th>
                    <th class="text-center sorting_asc">Date début d'inventaire</th>
                    <th class="text-center sorting_asc">Date fin d'inventaire</th>
                    <th class="text-center sorting_asc">Type d'inventaire</th>
                    <th class="text-center sorting_asc">Statut</th>
                    <th class="text-center sorting_asc">Commentaire</th>
                    <?php if(Session::get('INVENTAIRES_MODIFIER')): ?>
                        <th class="text-center sorting_asc">Modifier</th>
                    <?php endif; ?>
                    <?php if(Session::get('INVENTAIRES_DETAIL')): ?>
                        <th class="text-center sorting_asc">Détail</th>
                    <?php endif; ?>
                    <?php if(Session::get('INVENTAIRES_SUPPRIMER')): ?>

                    <th class="text-center sorting_asc">Supprimer</th>
                        <?php endif; ?>
                </tr>
                </thead>

                <tbody>
                <?php foreach($inventaires as $inventaire): ?>
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1"><?php echo $inventaire->numInventaire; ?></td>
                        <td class="text-center sorting_1"><?php echo $inventaire->designationInventaire; ?></td>
                        <td class="text-center sorting_1"><?php echo $inventaire->dateDebut; ?></td>
                        <td class="text-center sorting_1"><?php echo $inventaire->dateFin; ?></td>
                        <?php if($inventaire->typeInventaire == 0): ?>
                        <td class="text-center sorting_1">Inventaire total</td>
                        <?php endif; ?>
                        <?php if($inventaire->typeInventaire == 1): ?>
                        <td class="text-center sorting_1">Inventaire par zone</td>
                        <?php endif; ?>
                        <?php if($inventaire->typeInventaire == 2): ?>
                        <td class="text-center sorting_1">Inventaire par emplacement </td>
                        <?php endif; ?>
                        <?php if($inventaire->typeInventaire == 3): ?>
                        <td class="text-center sorting_1">Inventaire par Entité </td>
                        <?php endif; ?>
                        <?php if($inventaire->typeInventaire == 4): ?>
                        <td class="text-center sorting_1">Inventaire par N°UE </td>
                        <?php endif; ?>
                        <td class="text-center sorting_1"><?php echo $inventaire->valeur; ?></td>
                        <td class="text-center sorting_1"><?php echo $inventaire->commentaire; ?></td>
                        

                           <?php if(Session::get('INVENTAIRES_MODIFIER')): ?>
                                <td class="text-center sorting_asc">
                                     <?php if($inventaire->statutInventaire != 2): ?>
                                        <a href="<?php echo e(url('inventaire/modifier')); ?>/<?php echo e($inventaire->idInventaire); ?>" class="glyphicon glyphicon-edit">

                                        </a>
                                    <?php endif; ?>
                                </td >
                            <?php endif; ?>
                            

                        <?php if(Session::get('INVENTAIRES_DETAIL')): ?>
                        <td class="text-center sorting_1">
                                <a href="<?php echo e(url('inventaire/detail')); ?>/<?php echo e($inventaire->idInventaire); ?>" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                                </a>
                        </td>
                        <?php endif; ?>
                        <?php if(Session::get('INVENTAIRES_SUPPRIMER')): ?>


                        <td class="text-center sorting_asc">
                            <?php if($inventaire->statutInventaire != 2): ?>
                                <a href="#DeleteModal<?php echo e($inventaire->idInventaire); ?>" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                                </a>
                            <?php endif; ?>
                        </td>
                            <?php endif; ?>

                    </tr>
                <?php endforeach; ?>
                </tbody>

            </table>
            <?php foreach($inventaires as $inventaire): ?>

                <div class="example-modal">
                    <div class="modal" id="DeleteModal<?php echo e($inventaire->idInventaire); ?>">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                </div>
                                <div class="modal-body">
                                    <p>Voulez-vous vraiment supprimer cet inventaire ?</p>
                                </div>

                                <div class="modal-footer">
                                    <?php echo Form::open(['method' => 'POST', 'action' => ['InventaireController@delete',$inventaire->idInventaire]]); ?>

                                    <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                    <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                    <?php echo Form::close(); ?>

                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                </div>
            <?php endforeach; ?>

        </div><!-- /.box -->
</section><!-- /.content -->






<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>