@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('ADMINISTRATION_UTILISATEURS_AJOUTER'))
    <div class="box-tools pull-right">
        <a href="{{ url('utilisateur/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    @endif

  <h1>
    Gestion des utilisateurs
  </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDelete'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDelete') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif



        @if(Session::has('msgAdd'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgAdd') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
            @endif
    <!-- Default box -->
    <div class="box">



        <table id="example1" class="table table-bordered table-striped dataTable">
            <thead>
              <tr role="row">
                  <th class="text-center sorting_asc">Nom</th>
                  <th class="text-center sorting_asc">Prénom</th>
                  <th class="text-center sorting_asc">Email</th>
                  <th class="text-center sorting_asc">Identifiant</th>
                  <th class="text-center sorting_asc">Position</th>
                  @if(Session::get('ADMINISTRATION_UTILISATEURS_DETAIL'))
                  <th class="text-center sorting_asc">Détail</th>
                  @endif
                  @if(Session::get('ADMINISTRATION_UTILISATEURS_MODIFIER'))

                  <th class="text-center sorting_asc">Modifier</th>
                  @endif
                  @if(Session::get('ADMINISTRATION_UTILISATEURS_SUPPRIMER'))

                  <th class="text-center sorting_asc">Supprimer</th>
                      @endif
              </tr>
            </thead>

            <tbody>
                @foreach( $users as $user)
                @if ($user->telephone != "0561639605")
                   
                
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{!!$user->nom!!}</td>
                        <td class="text-center sorting_1">{!!$user->prenom!!}</td>
                        <td class="text-center sorting_1">{!!$user->email!!}</td>
                        <td class="text-center sorting_1">{!!$user->login!!}</td>
                        <td class="text-center sorting_1">@if($user->profil == 0) Administrateur @else Opérateur @endif</td>
                        @if(Session::get('ADMINISTRATION_UTILISATEURS_DETAIL'))
                        <td class="text-center sorting_1">
                            <a href="#show{{$user->id_user}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                            </a>
                        </td>
                        @endif
                        @if(Session::get('ADMINISTRATION_UTILISATEURS_MODIFIER'))

                        <td class="text-center sorting_asc">
                            <a href="{{url('utilisateur/modifier')}}/{{$user->id_user}}" class="glyphicon glyphicon-edit">

                            </a>
                        </td >
                        @endif
                        @if(Session::get('ADMINISTRATION_UTILISATEURS_SUPPRIMER'))

                        <td class="text-center sorting_asc">
                            <a href="#DeleteModal{{$user->id_user}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                        </td>
                            @endif
                    </tr>
                <!--

                <tr role="row" class="odd">
                    <td class="sorting_1">Gecko</td>
                    <td>Firefox 1.0</td>
                    <td>Win 98+ / OSX.2+</td>
                    <td>1.7</td>
                    <td>A</td>
                    <td>A</td>
                    <td>A</td>
                </tr>
                -->
                    <div class="example-modal" >
                        <div class="modal" id="show{{$user->id_user}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;">Détail utilisateur</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p><label> Nom : </label>  {!!$user->nom!!}</p>
                                        <p> <label> Prénom : </label> {!!$user->prenom!!}</p>
                                        <p> <label>Identifiant: </label> {!!$user->login!!}</p>
                                        <p> <label> Mot de passe : </label> <input type="password" value="{!!$user->password!!}" readonly style="border: none"> </p>
                                        <p> <label> Téléphone : </label> {!!$user->telephone!!}</p>
                                        <p> <label> Email : </label> {!!$user->email!!}</p>
                                        <p> <label> Position : </label> @if($user->profil == 0) Administrateur @else Opérateur @endif</p>
                                        <p> <label> Profil d'accès : </label> @if($user->profil == 0) {!! $user->profil_acces_backoffice->libelle !!} @else {!! $user->profil_acces_mobile->libelle !!} @endif</p>

                                        <!--<p> <label>Profil : </label> admin</p>-->

                                        <!--   -->
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal">Fermer</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$user->id_user}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer l'utilisateur " {{$user->nom}} {{$user->prenom}} ({{$user->login}}) " ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['UtilisateurController@delete',$user->id_user]]) !!}
                                            <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                            <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>

                    @endif


                @endforeach
            </tbody>

        </table>


    </div><!-- /.box -->
</section><!-- /.content -->



@endsection