﻿@extends('app')
@section('content')

        <!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        Liste des transferts
    </h1>
</section>

<!-- Main content -->
<section class="content">
        <!-- Default box -->
        <div class="box">
            <div class="box-body">
            <br>
            <form method="get" action="{{ route('rechercheTrans') }}">

                
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" @if (isset($mot_a_rechercher))
                        value="{{ $mot_a_rechercher }}"
                    @endif>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
                
            </div><br>
            </form>
            <table id="" class="table table-bordered table-striped">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">Date transfert</th>
                    <th class="text-center sorting_asc">Référence produit</th>
                    <th class="text-center sorting_asc">Désignation produit</th>
                    @if(Session::get('N_LOT') == '1')
                      <th class="text-center sorting_asc">Numéro de lot produit</th>
                    @endif
                    <th class="text-center sorting_asc">Emplacement source</th>
                    <th class="text-center sorting_asc">Quantité transfert</th>
                    <th class="text-center sorting_asc">Emplacement destination</th>
                    @if(Session::get('USE_UE')=='1')
                      <th class="text-center sorting_asc">N° UE</th>
                    @endif
                    <th class="text-center sorting_asc">Statut</th>
                    <th class="text-center sorting_asc">Opérateur</th>
                </tr>
                </thead>

                <tbody>
                        @foreach($transferts as $transfert)
                            <tr role="row" class="odd">
                                <td class="text-center sorting_1">
                                    {{$transfert->date_trans}}
                                </td>
                                @if ($transfert->produitStock != null)
                                    <td class="text-center sorting_1">
                                        {{$transfert->produitStock->produit->reference }}
                                    </td>
                                @else
                                    <td class="text-center sorting_1">
                                    </td>
                                @endif
                                @if ($transfert->produitStock != null)
                                    <td class="text-center sorting_1">
                                        {{$transfert->produitStock->produit->designation }}
                                    </td>
                                @else 
                                    <td class="text-center sorting_1">
                                    </td>
                                @endif

                                @if(Session::get('N_LOT') == '1')
                                    @if ($transfert->produitStock != null)
                                        <td class="text-center sorting_1">{{$transfert->produitStock->numero_lot }}</td>
                                    @else
                                         <td class="text-center sorting_1"></td>
                                    @endif
                                @endif
                           
                                    <td class="text-center sorting_1">
                                        {{$transfert->emplacementSource->libelle}}
                                    </td>
                               
                                

                                 <td class="text-center sorting_1">{{ (float) $transfert->qntTrans }}</td>

                                <td class="text-center sorting_1">
                                  @if ($transfert->idEmplacementDes != 0)
                                    @if ($transfert->emp_mobile_des != null)
                                        {{ $transfert->emplacementDestination->libelle }} / {{ $transfert->emp_mobile_des }}
                                    @else
                                    {{ $transfert->emplacementDestination->libelle }}
                                    @endif
                                  @endif
                                </td>
                                @if(Session::get('USE_UE')=='1')
                                  <td class="text-center sorting_1">{{$transfert->ssccTrans}}</td>
                                @endif
                                
                                @if ($transfert->idEmplacementDes != 0)
                                    <td class="text-center sorting_1">Terminé</td>
                                @else
                                    <td class="text-center sorting_1">En cours</td>
                                @endif
                                <td class="text-center sorting_1">{{ $transfert->operateur->nom }} {{$transfert->operateur->prenom }}</td>
                            </tr>
                        @endforeach           
                </tbody>

            </table>
        
            <p >Affichage de l'élement {{($transferts->currentPage()-1)* $transferts->perPage()+($transferts->total() ? 1:0)}} à {{($transferts->currentPage()-1)*$transferts->perPage()+count($transferts)}}  sur  {{$transferts->total()}} éléments</p>

            <span class="pull-right">{{ $transferts->links() }}</span>
            </div>
        </div><!-- /.box -->
</section><!-- /.content -->
@endsection

