@extends('app')
@section('content')

<!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">
    {!! Form::open(['method'=>'POST','action' => ['StockProduitController@recherche_lot']]) !!}
    @if(Session::get('ADMINISTRATION_STOCK_AJOUTER'))
    <div class="box-tools pull-right">
        <a href="{{ url('stock_produit_lot/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>

    @endif
    <div class="box-tools pull-right" style="margin-right: 1%" id="rechercher" hidden="true">
        <input type="submit" class="btn btn-default" value="Rechercher" >
    </div>
     @if (isset($emplacementSelected) || isset($produitSelected) || isset($zoneSelected) || isset($entiteSelected))
        <div class="box-tools pull-right" style="margin-right: 1%">
        <a href="{{ url('stock_produit_lot/index') }}" class="btn btn-default">
         Réinitialiser
        </a>
    </div>
    @endif
    
    <h3>
        Gestion des stocks des produits par N° lot
    </h3>

</br>
<div class="col-lg-12">

<div class="col-md-3">
        <label class="text-center">Filtrer par zone : </label>
        <select  class="form-control selectpicker" data-live-search="true"
        onchange="recherche()" name="zone">
        <option selected disabled style="background-color: white">Choisir la zone ...</option>
        @foreach($zones as $zone)
        <option value="{{$zone->id_zone}}" 
            @if(isset($zoneSelected) && $zone->id_zone == $zoneSelected->id_zone)
            selected 
            @endif >
            {{$zone->libelle}} </option>
            @endforeach
        </select>

    </div>

    <div class="col-md-3">
        <label class="text-center">Filtrer par emplacement : </label>
        <select  name="emplacement" class="form-control selectpicker" data-live-search="true"
        onchange="recherche()">
        <option selected disabled style="background-color: white">Choisir l'emplacement ...</option>
        @foreach($emplacements as $emplacement)
        <option value="{{$emplacement->id_emplacement}}" 
            @if(isset($emplacementSelected) && $emplacement->id_emplacement == $emplacementSelected->id_emplacement)
            selected 
            @endif >
            {{$emplacement->libelle}} </option>
            @endforeach
        </select>

    </div>
@if (Session::get('STOCK_ENTITE') == '1') 
<div class="col-md-3">
        <label class="text-center">Filtrer par N° Entité : </label>
        <select name="entite" class="form-control selectpicker" data-live-search="true"
        onchange="recherche()">
        <option selected disabled style="background-color: white">Choisir le n° entité ...</option>
        @foreach($entites as $entite)
        <option value="{{$entite->num_entite}}" 
            @if(isset($entiteSelected) && $entite->id_entite == $entiteSelected->id_entite)
            selected 
            @endif >
            {{$entite->num_entite}} </option>
            @endforeach
        </select>

    </div>
@endif
    <div class="col-lg-3 col-md-3">
        <label class="text-center">Filtrer par produit : </label>
        <select name="produit" id="idSelectProduit" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="produit" onchange="recherche()">
            <option selected disabled style="background-color: white">Choisir le produit ...</option>
            @foreach($produits as $produitIndex)
            <option value="{{$produitIndex->id_produit}}" @if(isset($produitSelected) && ($produitIndex->id_produit == $produitSelected->id_produit)) selected @endif >{{$produitIndex->reference}} </option>
            @endforeach
        </select>

    </div>

</div>
{!! Form::close() !!}
</br>
</br>
</br>
</section>
<!-- Main content -->
<section class="content">


    @if(Session::has('msgAjouter'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAjouter') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif



    @if(Session::has('msgDeleteOk'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgDeleteOk') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgUpdate'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgUpdate') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgAddEmplacement'))
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAddEmplacement') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgDeleteNotOk'))
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgDeleteNotOk') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif


    <!-- Default box -->
    <div class="box">
        <div class="table-responsive">
            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr role="row">
                        @if (Session::get('STOCK_ENTITE') == '1') 
                        <th class="text-center sorting_asc">N° Entité</th>
                        @endif
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') 
                        <th class="text-center sorting_asc">N° UE</th>
                        @endif
                        <th class="text-center sorting_asc">Référence</th>
                        <th class="text-center sorting_asc">Produit</th>
                        <th class="text-center sorting_asc">Emplacement</th>
                        <th class="text-center sorting_asc">N° lot</th>
                        @if(Session::get('ADMINISTRATION_STOCK'))
                            <th class="text-center sorting_asc">Quantité <br>physique</th>
                            <th class="text-center sorting_asc">Quantité <br>utilisable</th>
                            <th class="text-center sorting_asc">Quantité <br>réelle</th>
                        @endif
                        
                            <th class="text-center sorting_asc">Détail</th>

                        @if(Session::get('ADMINISTRATION_STOCK_MODIFIER'))
                                <th class="text-center sorting_asc">Modifier</th>
                        @endif
                        @if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER'))
                                <th class="text-center sorting_asc">Supprimer</th>
                        @endif
                    </tr>
                </thead>

                <tbody>
                    @foreach( $stocks as $stock)

                    <tr role="row" class="odd">
                        @if (Session::get('STOCK_ENTITE') == '1') 
                        <td class="text-center sorting_1">{!!$stock->num_entite!!}</td>
                        @endif
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') 
                        <td class="text-center sorting_1">{!!$stock->num_ue!!}</td>
                        @endif
                        <td class="text-center sorting_1">{!!$stock->produit->reference!!}</td>
                        <td class="text-center sorting_1">{!!$stock->produit->designation!!}</td>
                        <td class="text-center sorting_1">{!!$stock->emplacement->libelle!!}</td>
                        <td class="text-center sorting_1">{!!$stock->numero_lot!!}</td>

                        @if(Session::get('ADMINISTRATION_STOCK'))
                            <td class="text-center sorting_1">{{ (float) $stock->quantite }}</td>
                            <td class="text-center sorting_1">{{ (float) $stock->quantite_utilisable }}</td>
                            <td class="text-center sorting_1">{{ (float) $stock->quantite_reelle }}</td>
                        @endif
                        <td class="text-center sorting_1">
                            <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="afficheDetail({{ $stock->id_stock_produit }})"></a>
                        </td>
                        @if(Session::get('ADMINISTRATION_STOCK_MODIFIER'))
                            <td class="text-center sorting_asc">          
                                <a href="{{url('stock_produit_lot/modifier')}}/{{$stock->id_stock_produit}}" class="glyphicon glyphicon-edit"></a>
                            </td>
                        @endif
                        @if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER'))
                            <td class="text-center sorting_asc">
                                <a href="#DeleteModal{{$stock->id_stock_produit}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal"></a>    
                            </td>
                        @endif
                    </tr>

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$stock->id_stock_produit}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                        </div>
                                        <div class="modal-body">
                                            <p>Voulez vous  supprimer le stock du produit " {{$stock->produit->designation}} " avec la référence " {{$stock->produit->reference}} " ?</p>
                                        </div>

                                        <div class="modal-footer">
                                            {!! Form::open(['method' => 'POST', 'action' => ['StockProduitController@delete_lot',$stock->id_stock_produit]]) !!}
                                            <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                            <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                        </div>
                        @endforeach

                    </tbody>

                </table>
            </div>
        </div><!-- /.box -->
        
        @if (isset($emplacementSelected) || isset($produitSelected) || isset($zoneSelected) || isset($entiteSelected))
             <section class="content">
            <div class="box box-solid text-center" style="width: 40%; float: right;">
                <p style="margin:2%">Total quantité physique : <b>{{ (float) $stocks->sum('quantite') }}</b></p>
                <p style="margin:2%">Total quantité utilisable : <b>{{ (float) $stocks->sum('quantite_utilisable') }}</b></p>
                <p style="margin:2%">Total quantité réelle&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: <b>{{ (float) $stocks->sum('quantite_reelle') }}</b></p>
            </div>
        </section>
        @endif



        
         
        <div class="modal fade" id="modal_detail">
            <div class="modal-dialog modal-lg">
              <div class="modal-content">
                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span></button>
                      <h4 class="modal-title" id="produit_name"></h4>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Emplacement : </label>
                             <input type="text" class="form-control" id="emplacement_modal" value="" readonly >
                            
                        </div>
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">N° UE : </label>
                            <input type="text" class="form-control" id="ue_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Etat Ue : </label>
                            <input type="text" class="form-control" id="etat_ue_modal" value="" readonly >
                        </div>
                        @endif
                        @if (Session::get('STOCK_ENTITE') == '1')
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">N° Entité : </label>
                            <input type="text" class="form-control" id="entite_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Type entité : </label>
                            <input type="text" class="form-control" id="type_entite_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Libellé entité : </label>
                            <input type="text" class="form-control" id="libelle_entite_modal" value="" readonly >
                        </div>
                        @endif
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date d'entré en stock : </label>
                            <input type="text" class="form-control" id="date_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Inventaire : </label>
                            <input type="text" class="form-control" id="inventaire_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date inventaire : </label>
                            <input type="text" class="form-control" id="date_inventaire_modal" value="" readonly >
                        </div>
                         @if(Session::get('DATE_PEREMPTION')=='1')
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date de fabrication : </label>
                            <input type="text" class="form-control" id="date_fabrication" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date de péremption : </label>
                            <input type="text" class="form-control" id="date_peremption" value="" readonly >
                        </div>
                        @endif
                    </div>
                    </div>
                    

                    <div class="modal-footer justify-content-between">
                      <button type="button" class="btn btn-default" data-dismiss="modal">Quitter</button>
                  </div>
              </div>
              <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
      </div>
      <!-- /.modal -->
</div>





  </section><!-- /.content -->


  <script>

    function getProduit(idProduit){

        window.location.href = "{{url('stock_produit_lot/produit')}}/"+idProduit

    }
    function recherche(){
        document.getElementById("rechercher").hidden =false;
        //document.getElementById("recherche_multipe").submit();
    }
    function getEmplacement(idEmplacement){

        window.location.href = "{{url('stock_produit_lot/emplacement')}}/"+idEmplacement

    }
    function getZone(idZone){

        window.location.href = "{{url('stock_produit_lot/zone')}}/"+idZone

    }
    function getEntite(idEntite){
        //alert(idEntite);

        window.location.href = "{{url('stock_produit_lot/entite')}}/"+idEntite

    }
    function afficheDetail(id_produit){
       $.ajax({
        url: "{{url('stock_produit/infos')}}/"+id_produit,
        method : "post",   
        data: {
            "_token": "{{ csrf_token() }}"
        } ,        
        success: function(data){ 
            document.getElementById("produit_name").innerHTML = "Détail Produit " +
            "[ "+data.produit.reference +", "+data.produit.designation+" ]";  

            var myModal = $('#modal_detail');
            document.getElementById('emplacement_modal').value = data.emplacement.libelle;
            @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
            if(data.ue){
                document.getElementById('ue_modal').value = data.ue.num_ue;
                if(data.ue.etat_ue == 0){
                    document.getElementById('etat_ue_modal').value = "FERMER"; 
                }
                if(data.ue.etat_ue == 1){
                    document.getElementById('etat_ue_modal').value = "OUVERT";             
                } 
            }
            @endif
            @if (Session::get('STOCK_ENTITE') == '1')
            if(data.entite){
                document.getElementById('entite_modal').value =data.entite.num_entite;
                document.getElementById('type_entite_modal').value =data.entite.type_entite;
                document.getElementById('libelle_entite_modal').value =data.entite.libelle_entite;
            }
            @endif
            
            document.getElementById('date_modal').value =data.date_entree;
            if(data.inventaire){
                document.getElementById('inventaire_modal').value =data.inventaire.designationInventaire;
                document.getElementById('date_inventaire_modal').value =data.inventaire.dateFin;
            }
            @if(Session::get('DATE_PEREMPTION')=='1')
                document.getElementById('date_fabrication').value =data.date_fabrication;
                document.getElementById('date_peremption').value =data.date_peremption;
            @endif

            myModal.modal({ show: true });                                  
        },
        error: function(data){
            alert('oops erreur de serveur !!');
        }
    });
   }


</script>

@endsection