@extends('app')
@section('content')

<section class="content-header">

    <h1>
        Ajouter le stock d'un produit
    </h1>

</section>



<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgAddEmplacement'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddEmplacement') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgAddQuantite'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddQuantite') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgAddExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif
                <!-- fin messages -->

        <!-- Default box -->
        <div class="box">
            <div class="panel-body">
                <div class="col-sm-12">

                    {!! Form::open(['method'=>'POST','action' => ['StockProduitController@postForm_lot']]) !!}


                    <table>
                        <tbody>
                            @if (Session::get('STOCK_ENTITE') == '1')
                            <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    N° Entité
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="entite" placeholder="N° entité du stock" required value="{{old('entite')}}">
                                </div>
                            </td>
                        </tr>
                        @endif
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    N° UE
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="ue" placeholder="N° UE du stock" required value="{{old('ue')}}">
                                </div>
                            </td>
                        </tr>
                        @endif
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Référence
                                </label>
                                <div class="col-sm-6">
                                    <select class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="produit" >
                                        <option selected disabled style="background-color: white">Sélectionner le produit...</option>
                                        @foreach($produits as $produit)
                                            <option  value="{{$produit->id_produit}}" >{{$produit->reference}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Zone de stockage
                                </label>
                                <div class="col-sm-6">
                                    <select id="idSelectZone" class="form-control" name="zone" onchange="getEmplacement(this.value)" required="required">
                                        <option selected disabled>Sélectionner la zone de stockage...</option>
                                        @foreach($zones as $zone)
                                            <option value="{{$zone->id_zone}}" >{{$zone->libelle}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Emplacement du nouveau stock du produit
                                </label>
                                <div class="col-sm-6">
                                    <select id="idSelectEmplacement" class="form-control" name="emplacement" required="required">
                                        <option selected disabled>Sélectionner l'emplacement de ce nouveau stock ...</option>

                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Quantité
                                </label>
                                <div class="col-sm-6">
                                    <input type="number"  step="0.01" class="form-control" name="quantite" placeholder="Quantité du stock" required value="{{old('quantite')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Date d'entrée de ce stock
                                </label>
                                <div class="col-sm-6">
                                    <input type="date"  class="form-control" name="date" placeholder="Date d'entrée de ce stock" required value="{{old('date')}}">
                                </div>
                            </td>
                        </tr>
                        

                            <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Numéro de Lot
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="numeroLot" placeholder="Numéro de Lot" required value="{{old('numeroLot')}}">
                                </div>
                            </td>
                        </tr>
                            
                        @if(Session::get('DATE_PEREMPTION')=='1')

                            <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Date de fabrication
                                </label>
                                <div class="col-sm-6">
                                    <input type="date"  class="form-control" name="dateFabrication" placeholder="Date de fabrication" required value="{{old('dateFabrication')}}">
                                </div>
                            </td>
                        </tr>

                            <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Date de péremption
                                </label>
                                <div class="col-sm-6">
                                    <input type="date"  class="form-control" name="datePeremption" placeholder="Date de péremption" required value="{{old('datePeremption')}}">
                                </div>
                            </td>
                        </tr>
                            @endif


                        </tbody>
                    </table>
                    </br>
                    </br>



                    <input class="btn btn-flat btn-primary pull-right" type="submit" value="Valider">
                    <a href="{{url('stock_produit_lot/index')}}" class="btn btn-flat btn-danger pull-right">Annuler</a>

                    {!! Form::close() !!}

                </div>
            </div>







        </div><!-- /.box -->
</section><!-- /.content -->





<script>
    function getEmplacement(id_zone){


        //alert(id_zone);

        var nom = document.getElementById("idSelectZone");
        $.get("{{url('stock_produit/emplacements?ID=')}}"+id_zone, function(res,stat){
            var select1 = document.getElementById("idSelectEmplacement");
            // var nom= document.getElementById("input3");


            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value=''>Sélectionner l'emplacement de ce nouveau stock ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_emplacement+"'> "+res[i].libelle+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }


        });
    }

</script>



@endsection