@extends('app')
@section('content')

<!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">
    
     <div class="forme-inline">   
    @if(Session::get('ADMINISTRATION_STOCK_AJOUTER'))
    @if(Session::get('N_LOT') == '0')
    <div class="box-tools pull-right">
        <a href="{{ url('stock_produit/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>

    @endif
    @endif
        @if(Session::get('ADMINISTRATION_STOCK_EXPORTER'))
    {!! Form::open(['method' => 'POST', 'action' => ['StockProduitController@exportUeStock']]) !!}
    <div class="box-tools pull-right form-inline" style="margin-right: 1%">
 @if (isset($ueSelected))
        <input type="hidden" name="ueExport" value="{{ $ueSelected->num_ue}}">
        @endif
        <button type="submit" class="btn btn-block btn-success" 
@if (!isset($ueSelected))    
        disabled
        @endif
        >
            <span class="glyphicon glyphicon-export" aria-hidden="false"> </span>Export Fiche du stock
             </button>   
        
    </div>
    
{!! Form::close() !!}
     {!! Form::open(['method' => 'POST', 'action' => ['StockProduitController@exportStock']]) !!}
    <div class="box-tools pull-right form-inline" style="margin-right: 1%">
        
        <input type="hidden" name="emplacementExport" 
        @if (isset($emplacementSelected))
            value="{{ $emplacementSelected->id_emplacement}}"
        @else
        value=""
        @endif>

        <input type="hidden" name="entiteExport" 
        @if (isset($entiteSelected))
            value="{{ $entiteSelected->num_entite}}"
        @else
        value=""
        @endif>

        <input type="hidden" name="produitExport" 
        @if (isset($produitSelected))
            value="{{ $produitSelected->id_produit}}"
        @else
        value=""
        @endif>

        <input type="hidden" name="zoneExport" 
        @if (isset($zoneSelected))
            value="{{ $zoneSelected->id_zone}}"
        @else
        value=""
        @endif>

        <input type="hidden" name="ueExport" 
        @if (isset($ueSelected))
            value="{{ $ueSelected->num_ue}}"
        @else
        value=""
        @endif>
        
        <button type="submit" class="btn btn-block btn-success">
            <span class="glyphicon glyphicon-export" aria-hidden="false"> </span> Export
             </button>   
        
    </div>
    
{!! Form::close() !!}
        @endif



{!! Form::open(['method'=>'GET','action' => ['StockProduitController@recherche']]) !!}
    
    <div class="box-tools pull-right" style="margin-right: 1%;" id="rechercher">
        <input type="submit" class="btn btn-default" value="Rechercher" >
    </div>
     @if (isset($emplacementSelected) || isset($produitSelected) || isset($zoneSelected) || isset($entiteSelected)|| isset($ueSelected) || isset($designation_produit))
        <div class="box-tools pull-right" style="margin-right: 1%">
        <a href="{{ url('stock_produit/index') }}" class="btn btn-default">
         Réinitialiser
        </a>
    </div>
    @endif
    
   

    
    
    <h3>
        Gestion des stocks des produits
    </h3>

</br>
 <div class="row">


<div class="col-md-12">
    @if(Session::has('msgAjouter'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAjouter') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif



    @if(Session::has('msgDeleteOk'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgDeleteOk') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgUpdate'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgUpdate') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgAddEmplacement'))
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAddEmplacement') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgDeleteNotOk'))
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgDeleteNotOk') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif
        @if(Session::get('ADMINISTRATION_STOCK_FILTRER_PAR_ZONE'))
<div class="col-md-3">
        <label class="text-center">Filtrer par zone : </label>
        <select id="idSelectZone" class="form-control selectpicker pickZone" data-live-search="true"
         name="zone">
        @if (isset($zoneSelected))
                <option value="{{ $zoneSelected->id_zone }}">{{ $zoneSelected->libelle }}</option>
            @endif
        </select>

    </div>
        @endif

        @if(Session::get('ADMINISTRATION_STOCK_FILTRER_PAR_EMPLACEMENT'))
    <div class="col-md-3">
        <label class="text-center">Filtrer par emplacement : </label>
        <select name="emplacement" id="idSelectEmpl" class="form-control selectpicker pickEmp" data-live-search="true"
        >
        @if (isset($emplacementSelected))
                <option value="{{ $emplacementSelected->id_emplacement }}">{{ $emplacementSelected->libelle }}</option>
            @endif
        
        </select>

    </div>
        @endif

        @if(Session::get('ADMINISTRATION_STOCK_FILTRER_PAR_ENTITE'))

            @if (Session::get('STOCK_ENTITE') == '1')
<div class="col-md-3">
        <label class="text-center">Filtrer par N° Entité : </label>
        <select name="entite" id="idSelectEnite" class="form-control selectpicker pickEntite" data-live-search="true"
        >
        @if (isset($entiteSelected))
                <option value="{{ $entiteSelected->num_entite }}">{{ $entiteSelected->num_entite }}</option>
            @endif
        
        </select>

    </div>
    @endif
        @endif

        @if(Session::get('ADMINISTRATION_STOCK_FILTRER_PAR_UE'))
    
    <div class="col-md-3">
        <label class="text-center">Filtrer par N° UE : </label>
        <select name="ue" id="idSelectUe" class="form-control selectpicker pickUE" data-selected-text-format="count > 3" data-live-search="true" name="ue" >
           @if (isset($ueSelected))
                <option value="{{ $ueSelected->num_ue }}">{{ $ueSelected->num_ue }}</option>
            @endif
            
        </select>

    </div>
            @endif
  
</div>

   
<div class="col-md-12">
   <br>

    @if(Session::get('ADMINISTRATION_STOCK_FILTRER_PAR_REFERENCE'))
<div class="col-md-3">
        <label class="text-center">Filtrer par référence produit : </label>
        <select name="produit" id="idSelectProduit"  class="form-control selectpicker pickProduit" data-selected-text-format="count > 3" data-live-search="true" name="produit" >
            @if (isset($produitSelected))
                <option value="{{ $produitSelected->id_produit }}">{{ $produitSelected->reference }}</option>
            @endif
        </select>

    </div>
    @endif

    @if(Session::get('ADMINISTRATION_STOCK_FILTRER_PAR_DESIGNATION'))
    <div class="col-md-9">
        <label class="text-center">Filtrer par désignation produit : </label>
        <input type="text" name="designation_produit" placeholder="Désignation produit"  class="form-control"   @if (isset($designation_produit))
            value="{{$designation_produit }}"
        @endif
         >
    </div>
        @endif
    </div>
</div>


{!! Form::close() !!}

</div>


</section>
<!-- Main content -->
<section class="content">


    


    <!-- Default box -->
    @if(Session::get('N_LOT')=='1')
    
    <div class="box">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr role="row">
                        @if (Session::get('STOCK_ENTITE') == '1')
                            <th class="text-center sorting_asc">N° Entité</th>
                        @endif
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') 
                            <th class="text-center sorting_asc">N° UE</th>
                        @endif
                        <th class="text-center sorting_asc">Référence</th>
                        <th class="text-center sorting_asc">Produit</th>
                        <th class="text-center sorting_asc">Emplacement</th>
                        @if(Session::get('ADMINISTRATION_STOCK'))
                            <th class="text-center sorting_asc">Quantité <br>physique</th>
                            <th class="text-center sorting_asc">Quantité <br>utilisable</th>
                            <th class="text-center sorting_asc">Quantité <br>réelle</th>
                        @endif
                        
                            <th class="text-center sorting_asc">Détail</th>

                        @if(Session::get('ADMINISTRATION_STOCK_MODIFIER'))
                            @if(Session::get('N_LOT') == '0')
                                <th class="text-center sorting_asc">Modifier</th>
                            @endif
                        @endif
                        @if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER'))
                            @if(Session::get('N_LOT') == '0')
                                <th class="text-center sorting_asc">Supprimer</th>
                            @endif
                        @endif
                    </tr>
                </thead>

                <tbody>
                    @foreach( $stocks as $s)
                    @php
                    $numItems = count($s);
                    $i=0;
                    @endphp
                    @foreach ($s as $k=> $stock)
                    @if(++$i === $numItems)
                    <tr role="row" class="odd">
                        @if (Session::get('STOCK_ENTITE') == '1')
                            <td class="text-center sorting_1">{!!$stock->num_entite!!}</td>
                        @endif
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') 
                            <td class="text-center sorting_1">{!!$stock->num_ue!!}</td>
                        @endif
                        <td class="text-center sorting_1">{!!$stock->produit->reference!!}</td>
                        <td class="text-center sorting_1">{!!$stock->produit->designation!!}</td>
                        <td class="text-center sorting_1">{!!$stock->emplacement->libelle!!}</td>

                        @if(Session::get('ADMINISTRATION_STOCK'))
                            <td class="text-center sorting_1">
                                {{ (float) $quantiteCollect->get($stock->id_produit."-".$stock->id_emplacement) }}
                            </td>
                            <td class="text-center sorting_1">
                                {{ (float) $quantiteUtilisableCollect->get($stock->id_produit."-".$stock->id_emplacement) }}
                            </td>
                            <td class="text-center sorting_1">
                                {{(float)  $quantiteReelleCollect->get($stock->id_produit."-".$stock->id_emplacement) }}
                            </td>
                        @endif

                        
                        @if ($numItems == 1)
                                <td class="text-center sorting_1">
                                    <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="afficheDetail({{ $stock->id_stock_produit }})"></a>
                                </td>
                            @if(Session::get('ADMINISTRATION_STOCK_MODIFIER'))
                                 @if(Session::get('N_LOT') == '0')
                                <td class="text-center sorting_asc">
                                   
                                    <a href="{{url('stock_produit/modifier')}}/{{$stock->id_stock_produit}}" class="glyphicon glyphicon-edit"></a>
                                    
                                </td>
                                @endif
                                
                            @endif
                            @if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER'))
                            @if(Session::get('N_LOT') == '0')
                                <td class="text-center sorting_asc">
                                    
                                    <a href="#DeleteModal{{$stock->id_stock_produit}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal"></a>
                                    
                                </td>
                                @endif
                                
                            @endif
                            @else
                            <td class="text-center sorting_1"></td>
                            @if(Session::get('N_LOT') == '0')
                            @if(Session::get('ADMINISTRATION_STOCK_MODIFIER'))
                            <td class="text-center sorting_1"></td>
                            @endif
                            @if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER'))
                            <td class="text-center sorting_1"></td>
                            @endif

                            @endif

                        @endif
                        
                    </tr>

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$stock->id_stock_produit}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                        </div>
                                        <div class="modal-body">
                                            <p>Voulez vous  supprimer le stock du produit " {{$stock->produit->designation}} " avec la référence " {{$stock->produit->reference}} " ?</p>
                                        </div>

                                        <div class="modal-footer">
                                            {!! Form::open(['method' => 'POST', 'action' => ['StockProduitController@delete',$stock->id_stock_produit]]) !!}
                                            <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                            <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                        </div>

                        @endif
                        @endforeach
                        @endforeach

                    </tbody>

                </table>
                
                    <span class="pull-right">{{ $stocks->links() }}</span>
               
            </div>
        </div><!-- /.box -->

        @if (isset($emplacementSelected) || isset($produitSelected) || isset($zoneSelected) || isset($entiteSelected) || isset($ueSelected) )
             <section class="content">
            <div class="box box-solid text-center" style="width: 40%; float: right;">
                <p style="margin:2%">Total quantité physique : <b>{{ $quantiteCollect->sum() }}</b></p>
                <p style="margin:2%">Total quantité utilisable : <b>{{ $quantiteUtilisableCollect->sum() }}</b></p>
                <p style="margin:2%">Total quantité réelle&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: <b>{{ $quantiteReelleCollect->sum() }}</b></p>
            </div>
        </section>
        @endif
        @else

            <div class="box">
        <div class="table-responsive">
            <table id="" class="table table-bordered table-striped">
                <thead>
                    <tr role="row">
                        @if (Session::get('STOCK_ENTITE') == '1')
                        <th class="text-center sorting_asc">N° Entité</th>
                        @endif
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                        <th class="text-center sorting_asc">N° UE</th>
                        @endif
                        <th class="text-center sorting_asc">Référence</th>
                        <th class="text-center sorting_asc">Produit</th>
                        <th class="text-center sorting_asc">Emplacement</th>
                        @if(Session::get('ADMINISTRATION_STOCK'))
                            <th class="text-center sorting_asc">Quantité <br>physique</th>
                            <th class="text-center sorting_asc">Quantité <br>utilisable</th>
                            <th class="text-center sorting_asc">Quantité <br>réelle</th>
                        @endif
                        
                            <th class="text-center sorting_asc">Détail</th>

                        @if(Session::get('ADMINISTRATION_STOCK_MODIFIER'))
                                <th class="text-center sorting_asc">Modifier</th>
                        @endif
                        @if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER'))
                                <th class="text-center sorting_asc">Supprimer</th>
                        @endif
                    </tr>
                </thead>

                <tbody>
                    @foreach( $stocks as $stock)
                    
                    <tr role="row" class="odd">
                        @if (Session::get('STOCK_ENTITE') == '1')
                        <td class="text-center sorting_1">{!!$stock->num_entite!!}</td>
                        @endif
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                        <td class="text-center sorting_1">{!!$stock->num_ue!!}</td>
                        @endif
                        <td class="text-center sorting_1">{!!$stock->produit->reference!!}</td>
                        <td class="text-center sorting_1">{!!$stock->produit->designation!!}</td>
                        <td class="text-center sorting_1">{!!$stock->emplacement->libelle!!}</td>

                        @if(Session::get('ADMINISTRATION_STOCK'))
                            <td class="text-center sorting_1">
                                {{ (float) $stock->quantite }}
                            </td>
                            <td class="text-center sorting_1">
                                {{ (float) $stock->quantite_utilisable }}
                            </td>
                            <td class="text-center sorting_1">
                                {{ (float) $stock->quantite_reelle }}
                            </td>
                        @endif
                            <td class="text-center sorting_1">
                                <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="afficheDetail({{ $stock->id_stock_produit }})"></a>
                            </td>
                            @if(Session::get('ADMINISTRATION_STOCK_MODIFIER'))
                                <td class="text-center sorting_asc">
                                    <a href="{{url('stock_produit/modifier')}}/{{$stock->id_stock_produit}}" class="glyphicon glyphicon-edit"></a>
                                </td>
                            @endif

                            @if(Session::get('ADMINISTRATION_STOCK_SUPPRIMER'))
                                <td class="text-center sorting_asc">
                                    <a href="#DeleteModal{{$stock->id_stock_produit}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal"></a>  
                                </td>
                            @endif
                        
                    </tr>

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$stock->id_stock_produit}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                        </div>
                                        <div class="modal-body">
                                            <p>Voulez vous  supprimer le stock du produit " {{$stock->produit->designation}} " avec la référence " {{$stock->produit->reference}} " ?</p>
                                        </div>

                                        <div class="modal-footer">
                                            {!! Form::open(['method' => 'POST', 'action' => ['StockProduitController@delete',$stock->id_stock_produit]]) !!}
                                            <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                            <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                        </div>


                        @endforeach

                    </tbody>

                </table>

               
                <p >Affichage de l'élement {{($stocks->currentPage()-1)* $stocks->perPage()+($stocks->total() ? 1:0)}} à {{($stocks->currentPage()-1)*$stocks->perPage()+count($stocks)}}  sur  {{$stocks->total()}} éléments</p>
                    <span class="pull-right">{{ $stocks->links() }}</span>
                    
                
            </div>
        </div><!-- /.box -->

        @if (isset($emplacementSelected) || isset($produitSelected) || isset($zoneSelected) || isset($entiteSelected) || isset($ueSelected))
             <section class="content">
            <div class="box box-solid text-center" style="width: 40%; float: right;">
                <p style="margin:2%">Total quantité physique : <b>{{ (float) $stocks->sum('quantite') }}</b></p>
                <p style="margin:2%">Total quantité utilisable : <b>{{ (float) $stocks->sum('quantite_utilisable') }}</b></p>
                <p style="margin:2%">Total quantité réelle&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: <b>{{ (float) $stocks->sum('quantite_reelle') }}</b></p>
            </div>
        </section>
        @endif

        @endif



        
         
        <div class="modal fade" id="modal_detail">
            <div class="modal-dialog modal-lg">
              <div class="modal-content">
                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span></button>
                      <h4 class="modal-title" id="produit_name"></h4>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                    <div class="col-lg-12 col-md-12">

         
          <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
              <li class="active"><a href="#tab_1" data-toggle="tab" aria-expanded="true">Détail</a></li>
              <li class=""><a href="#tab_2" data-toggle="tab" aria-expanded="false">Stock en préparation</a></li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane active" id="tab_1">
                <div class="row">
                <div class="col-md-12">

                 <div class="col-lg-4 col-md-4">
                            <label class="text-center">Emplacement : </label>
                             <input type="text" class="form-control" id="emplacement_modal" value="" readonly >
                            
                        </div>
                        @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">N° UE : </label>
                            <input type="text" class="form-control" id="ue_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Etat UE : </label>
                            <input type="text" class="form-control" id="etat_ue_modal" value="" readonly >
                        </div>
                        @endif
                        @if (Session::get('STOCK_ENTITE') == '1')
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">N° Entité : </label>
                            <input type="text" class="form-control" id="entite_modal" value="" readonly >
                        </div>

                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Type entité : </label>
                            <input type="text" class="form-control" id="type_entite_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Libellé entité : </label>
                            <input type="text" class="form-control" id="libelle_entite_modal" value="" readonly >
                        </div>
                        @endif
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date d'entré en stock : </label>
                            <input type="text" class="form-control" id="date_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Inventaire : </label>
                            <input type="text" class="form-control" id="inventaire_modal" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date inventaire : </label>
                            <input type="text" class="form-control" id="date_inventaire_modal" value="" readonly >
                        </div>
                         @if(Session::get('DATE_PEREMPTION')=='1')
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date de fabrication : </label>
                            <input type="text" class="form-control" id="date_fabrication" value="" readonly >
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <label class="text-center">Date de péremption : </label>
                            <input type="text" class="form-control" id="date_peremption" value="" readonly >
                        </div>
                        @endif
              </div>
              </div>
          </div>
              <!-- /.tab-pane -->
            <div class="tab-pane" id="tab_2">
                <table id="example7" class="table table-bordered table-striped" style="text-align: center">
                        <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">N° Préparation</th>   
                            </tr>
                        </thead>
                        <tbody>        
                        </tbody>
                    </table>
            </div>
            <!-- /.tab-content -->
          </div>
          <!-- nav-tabs-custom -->
        </div>
        <!-- /.col -->

      

                    </div>


                    <div class="modal-footer justify-content-between">
                      <button type="button" class="btn btn-default" data-dismiss="modal">Quitter</button>
                  </div>
              </div>
              <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
      </div>
      <!-- /.modal -->
</div>





  </section><!-- /.content -->


  <script>

    function getProduit(idProduit){

        window.location.href = "{{url('stock_produit/indexWithIdProduit')}}/"+idProduit

    }
    function getEmplacement(idEmplacement){

        window.location.href = "{{url('stock_produit/indexWithIdEmplacement')}}/"+idEmplacement

    }
    function getZone(idZone){

        window.location.href = "{{url('stock_produit/indexWithIdZone')}}/"+idZone

    }
    function recherche(){
        document.getElementById("rechercher").hidden =false;
        //document.getElementById("recherche_multipe").submit();
    }
    function getEntite(idEntite){
        //alert(idEntite);

        window.location.href = "{{url('stock_produit/indexWithIdEntite')}}/"+idEntite

    }
    function afficheDetail(id_produit){
       $.ajax({
        url: "{{url('stock_produit/infos')}}/"+id_produit,
        method : "post",   
        data: {
            "_token": "{{ csrf_token() }}"
        } ,        
        success: function(data){ 
            var t = $('#example7').DataTable();
            t.clear().draw();
            /*var vals = Object.keys(data).map(function(key) {
                            t.row.add( [
                                       '<b>'+data.ligneProduitt[key]+'</b>'
                                    ] ).draw( false );
                            });*/
var vals = Object.keys(data.ligne_produit).map(function(key) {
    //alert(data.ligne_produit[key].preparation.livraison);
    if(data.ligne_produit[key].preparation.livraison == null && data.ligne_produit[key].preparation.statutPreparation != 4){
        var id = data.ligne_produit[key].preparation.idPreparation;
        var url = "{{ url('preparation/detail')}}/"+id;

       t.row.add( [
                                       '<a href="'+url+'">'+data.ligne_produit[key].preparation.numPreparation+'</a>'
                                    ] ).draw( false ); 
    }
                            
                            });

            document.getElementById("produit_name").innerHTML = "Détail Produit " +
            "[ "+data.produit.reference +", "+data.produit.designation+" ]";  

            var myModal = $('#modal_detail');
            document.getElementById('emplacement_modal').value = data.emplacement.libelle;
            @if(Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')=='1')
            if(data.ue){
                document.getElementById('ue_modal').value = data.ue.num_ue;
                if(data.ue.etat_ue == 0){
                    document.getElementById('etat_ue_modal').value = "FERMER"; 
                }
                if(data.ue.etat_ue == 1){
                    document.getElementById('etat_ue_modal').value = "OUVERT";             
                }
                
            }else{
                document.getElementById('ue_modal').value = "";
                document.getElementById('etat_ue_modal').value = ""; 
            }
            @endif
            @if(Session::get('STOCK_ENTITE')=='1')
            if(data.entite){
                document.getElementById('entite_modal').value =data.entite.num_entite;
                document.getElementById('type_entite_modal').value =data.entite.type_entite;
                document.getElementById('libelle_entite_modal').value =data.entite.libelle_entite;
            }else{
                document.getElementById('entite_modal').value ="";
                document.getElementById('type_entite_modal').value ="";
                document.getElementById('libelle_entite_modal').value ="";
            }
            @endif
            document.getElementById('date_modal').value =data.date_entree;
            if(data.inventaire){
                document.getElementById('inventaire_modal').value =data.inventaire.designationInventaire;
                document.getElementById('date_inventaire_modal').value =data.inventaire.dateFin;
            }else{
                document.getElementById('inventaire_modal').value ="";
                document.getElementById('date_inventaire_modal').value ="";
            }

            @if(Session::get('DATE_PEREMPTION')=='1')
                document.getElementById('date_fabrication').value =data.date_fabrication;
                document.getElementById('date_peremption').value =data.date_peremption;
            @endif

            myModal.modal({ show: true });                                  
        },
        error: function(data){
            alert('oops erreur de serveur !!');
        }
    });
   }


</script>

@endsection