@extends('app')
@section('content')

<section class="content-header">
    @if(Session::get('ADMINISTRATION_PRODUITS_AJOUTER'))

    <div class="box-tools pull-right">
        <a href="{{ url('produit/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    @endif
        <div class="box-tools pull-right" style="margin-right: 1%">
            @if(Session::get('ADMINISTRATION_PRODUITS_IMPORTER'))
            <a href="#importer" class="btn btn-block btn-success" data-toggle="modal">
                <span class="glyphicon glyphicon-download-alt" aria-hidden="false"></span>
                Importer
            </a>
                @endif
        </div>
        <div class="box-tools pull-right" style="margin-right: 1%">
            @if(Session::get('ADMINISTRATION_PRODUITS_EXPORTER'))
        <a class="btn btn-block btn-success" href="{{ route('exportProduit') }}">
            <span class="glyphicon glyphicon-export" aria-hidden="false"></span>
                Export
        </a>
                @endif
    </div>
    <h1>
        Gestion des produits
    </h1>

</section>



<!-- Main content -->
<section class="content">


        @if(Session::has('msg'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msg') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif

    @if(Session::has('msgDeleteOk'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDeleteOk') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

        @if(Session::has('msgDeleteNotOk'))
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgDeleteNotOk') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
            @endif


            @if($errors->any())
                <div class="box box-warning box-solid">
                    <div class="box-header with-border">
                        <div class="box-title">
                            <span> <i class="fa fa-check"></i></span>
                            <em>{!! $errors->first() !!}</em>
                        </div>
                        <div class="box-tools pull-right">
                            <button class="btn btn-box-tool" data-widget="remove">
                                <i class="fa fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
        @endif

                    <!-- Default box -->
        <div class="box">


            <div class="example-modal">
                <div class="modal" id="importer">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h3 class="modal-title" style="font-family:verdana;">Importer les produits </h3>
                            </div>
                            <div class="modal-body">
                                <p>Importer les produits depuis un fichier xls ou xlsx. Télécharger le modèle et ouvrir Excel  pour voir le format avec tous les champs acceptés.
                                </p>
                                {!! Form::open(['method'=>'POST','action' => ['ProduitController@downloadModele']]) !!}
                                <div class="col-sm-7">
                                    <label class="control-label">Télécharger le fichier modèle                   </label>

                                </div>


                                <input id="btnDwnld" class="btn btn-success col-sm-4" type="submit"  value="Télécharger le modèle "  name="dwnld">
                                <br>
                                <br>
                                {!! Form::close() !!}
                                {!! Form::open(['url'=>'produit/upload', 'files' => true,'enctype'=>'multipart/form-data']) !!}
                                <div class="col-sm-7">
                                    <input type="file" id="file" name="file"  class="form-control" onchange="verifInput(this.id, 'btnSubmit');" accept=".xls,.xlsx,.csv" required>
                                </div>
                                <input id="btnSubmit" class="btn btn-success col-sm-4" type="submit" value="Importer le fichier" disabled="disabled" name="submit" onClick="toggle_visibility('tips');">

                                {!! Form::close() !!}



                                <div class="modal-footer">



                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                </div>





                <br>
                
                <form method="get" action="{{ route('recherche') }}">

                <div class="table-responsive">
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" @if (isset($mot_a_rechercher))
                        value="{{ $mot_a_rechercher }}"
                    @endif>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
                
            </div><br>
            </form>

            <table id="" class="table table-bordered table-striped ">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">Désignation</th>
                    <th class="text-center sorting_asc">Catégorie</th>
                    <th class="text-center sorting_asc">Code produit</th>
                    <th class="text-center sorting_asc">Référence</th>
                    <th class="text-center sorting_asc">TVA</th>
                    <th class="text-center sorting_asc">Mesure</th>
                    <th class="text-center sorting_asc">Poids (kg)</th>
                    <th class="text-center sorting_asc">Volume (m³)</th>
                    @if(Session::get('COMPOSE_PACK'))
                        <th class="text-center sorting_asc">Produit composé (pack)</th>
                    @endif
                    
                    <th class="text-center sorting_asc">Statut</th>
                    @if(Session::get('ADMINISTRATION_PRODUITS_MODIFIER'))

                    <th class="text-center sorting_asc">Modifier</th>
                    @endif
                    @if(Session::get('ADMINISTRATION_PRODUITS_SUPPRIMER'))

                    <th class="text-center sorting_asc">Supprimer</th>
                        @endif
                </tr>
                </thead>

                <tbody>
                @foreach( $produits as $produit)
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{!!$produit->designation!!}</td>
                        <td class="text-center sorting_1">{!!$produit->catigorie->libelle!!}</td>
                        <td class="text-center sorting_1">{!!$produit->code_identification!!}</td>
                        <td class="text-center sorting_1">{!!$produit->reference!!}</td>
                        <td class="text-center sorting_1">{!!$produit->tva!!}</td>
                        <td class="text-center sorting_1">{!!$produit->uniteMesure->libelle!!}</td>
                        <td class="text-center sorting_1">{!!$produit->poids!!}</td>
                        <td class="text-center sorting_1">{!!$produit->volume!!}</td>
                        @if(Session::get('COMPOSE_PACK'))
                            <td class="text-center sorting_1">{!!$produit->compose_pack!!}</td>
                        @endif
                        <td class="text-center sorting_1">{!!$produit->statut!!}</td>
                        @if(Session::get('ADMINISTRATION_PRODUITS_MODIFIER'))

                        <td class="text-center sorting_asc">
                            <a href="{{url('produit/modifier')}}/{{$produit->id_produit}}" class="glyphicon glyphicon-edit">

                            </a>
                        </td >
                        @endif
                        @if(Session::get('ADMINISTRATION_PRODUITS_SUPPRIMER'))

                        <td class="text-center sorting_asc">
                            <a href="#DeleteModal{{$produit->id_produit}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                        </td>
                            @endif
                    </tr>
                    <!--

                    <tr role="row" class="odd">
                        <td class="sorting_1">Gecko</td>
                        <td>Firefox 1.0</td>
                        <td>Win 98+ / OSX.2+</td>
                        <td>1.7</td>
                        <td>A</td>
                        <td>A</td>
                        <td>A</td>
                    </tr>
                    -->
                    <div class="example-modal" >
                        <div class="modal" id="show{{$produit->id_produit}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;">Détail du produit</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p><label> Désignation : </label>  {!!$produit->designation!!}</p>
                                        <p> <label> Catégorie : </label> {!!$produit->categorie!!}</p>
                                        <p> <label> Code produit : </label> {!!$produit->code_identificatuion!!}</p>
                                        <p> <label> Référence : </label> {!!$produit->reference!!}</p>
                                        <p> <label> prix TTC : </label> {!!$produit->prix_ttc!!}</p>
                                        <p> <label> Statut : </label> {!!$produit->statut!!}</p>
                                        <!--<p> <label>Profil : </label> admin</p>-->



                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal">Fermer</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$produit->id_produit}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce produit " {{$produit->designation}} " ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['ProduitController@delete',$produit->id_produit]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                @endforeach
                </tbody>

            </table>
            <p >Affichage de l'élement {{($produits->currentPage()-1)* $produits->perPage()+($produits->total() ? 1:0)}} à {{($produits->currentPage()-1)*$produits->perPage()+count($produits)}}  sur  {{$produits->total()}} éléments</p>
            <span class="pull-right">{{ $produits->links() }}</span>
            </div>

        </div><!-- /.box -->

        <div hidden="true">
         <table id="headerTable">
   
        <tr>
            <td>Désignation*</td>
            <td>Catégorie*</td>
            <td>Code à barres*</td>
            <td>Référence*</td>
            <td>TVA</td>
            <td>Mesure</td>
            <td>Poids (Kg)</td>
            <td>Volume (m3)</td>
            
            @if (Session::get('NUMERO_SERIE'))
                <td>N° de série</td>
            @endif
        </tr>
    
    
        @foreach ($produits as $element)
            <tr>
                <td>{{ $element->designation }}</td>
                <td>{{ $element->catigorie->libelle }}</td>
                <td>"{{ $element->code_identification }}"</td>
                <td>{{ $element->reference }}</td>
                <td>{{ $element->tva }}</td>
                <td>{{ $element->code_mesure }}</td>
                <td>{{ $element->poids }}</td>
                <td>{{ $element->volume }}</td>
                @if (Session::get('NUMERO_SERIE'))
                    @if ($element->num_serie == 1)
                       <td>OUI</td>
                    @else
                        <td>NON</td>
                    @endif
                @endif
            </tr>
        @endforeach
   
</table>
</div>



</section><!-- /.content -->

<script>

    function doit(type, fn, dl) {


         //alert(fn);
        var elt = document.getElementById('headerTable');
       

        //console.log(workbook);
        var wb = XLSX.utils.table_to_book(elt, {sheet:"Feuil1"});

        //wb.addSheetFromArray('A');
       //console.log(wb["A2"].v);
        return dl ?
            XLSX.write(wb, {bookType:type, bookSST:true, type: 'binary'}) :
            XLSX.writeFile(wb, fn || ('Les produits.' + (type || 'csv')));
    }

    function verifInput(id, idSubmit) {

        if(document.getElementById(id).value != ""){
            document.getElementById(idSubmit).disabled = false;
        }
    }


    function toggle_visibility(id)
    {
        var e = document.getElementById(id);
        if(e.style.display == 'block')
            e.style.display = 'none';
        else
            e.style.display = 'block';
    }

</script>


@endsection
<!--<script>

    window.onload = function get(){
    alert('tttttt');
     //   var designation = document.getElementById('numChargement').value;
      //  if()
        $.get("",function(res,stat){
            var cat = document.getElementById('t').value =res;
        })



    }
</script>-->
