@extends('app')
@section('content')

        <!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        Liste des productions
    </h1>
</section>

<!-- Main content -->
<section class="content">
        <!-- Default box -->
        <div class="box">
            <table id="example5" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">Date production</th>
                    <th class="text-center sorting_asc">Désignation MP</th>
                    <th class="text-center sorting_asc">Quantité MP</th>
                    <th class="text-center sorting_asc">Désignation PF</th>
                    <th class="text-center sorting_asc">Quantité PF</th>
                    <th class="text-center sorting_asc">Statut</th>
                    <th class="text-center sorting_asc">Détail</th>
                </tr>
                </thead>

                <tbody>
                        @foreach($productions as $production)
                            <tr role="row" class="odd">
                                <td class="text-center sorting_1">{{$production->date1}}</td>
                                <td class="text-center sorting_1">{{$production->designation_mp}}</td>
                                <td class="text-center sorting_1">{{$production->quantite_mp}}</td>
                                <td class="text-center sorting_1">{{$production->designation_pf}}</td>
                                <td class="text-center sorting_1">{{$production->quantite_pf}}</td>
                                @if ($production->status)
                                    <td class="text-center sorting_1">Terminé</td>
                                @else
                                    <td class="text-center sorting_1">En production</td>
                                @endif
                                <td class="text-center sorting_1">
                                  @if ($production->operateur2 == 0)
                                     <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="afficheDetail({{$production }},'{{$production->emplacement_mp}}','{{$production->emplacement_pf}}','{{$production->operateurMP->nom}} {{$production->operateurMP->prenom}}','Non identifié')">
                                    </a>
                                  @else
                                    <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="afficheDetail({{$production }},'{{$production->emplacement_mp}}','{{$production->emplacement_pf}}','{{$production->operateurMP->nom}} {{$production->operateurMP->prenom}}','{{$production->operateurPF->nom}} {{$production->operateurPF->prenom}}')">
                                    </a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach           
                </tbody>
            </table>
        </div><!-- /.box -->
<div class="modal fade" id="modal">
        <div class="modal-dialog ">
          <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Détail Production</h4>
              </div>
            <div class="modal-body">
                <div class="col-md-12">
                  <div class="col-md-6">
                    <div class="form-group">
                        <label>Date production</label>
                        <input type="text" id="numeroProduction" class="form-control" disabled>
                    </div>

                    <div class="form-group" id="sscc_group">
                        <label>SSCC</label>
                        <input type="text" id="sscc" class="form-control" disabled>
                    </div>
                    
                  </div>

                  <div class="col-md-6">
                    <div class="form-group">
                        <label>Statut</label>
                        <input type="text" id="statutProduit" class="form-control" disabled style="text-align: center">
                    </div>
                  </div>
                </div>
                <br><br><br>
               <div class="col-md-12">

                    <div class="col-md-6"><br>
            
            <div class="card-body">
                    <div class="form-group">
                <label>Opérateur MP</label>
                <input type="text" id="operateurMP" class="form-control" disabled>
              </div>
              <div class="form-group">
                <label>Emplacement MP</label>
                <input type="text" id="empMP" class="form-control" disabled>
              </div>

              <div class="form-group">
                <label>Désignation MP</label>
                <input type="text" id="desiMP" class="form-control" disabled>
              </div>
              <div class="form-group">
                <label>Quantité MP</label>
                <input type="text" id="QuantiteMP" class="form-control" disabled>
              </div>

              <div class="form-group">
                <label>Date MP</label>
                <input type="text" id="dateMP" class="form-control" disabled>
              </div>
            </div>
            <!-- /.card-body -->
         
          <!-- /.card -->
        </div>
        <div class="col-md-6"><br>
         
            <div class="card-body">
               <div class="form-group">
                <label>Opérateur PF</label>
                <input type="text" id="operateurPF" class="form-control" disabled >
              </div>
              <div class="form-group">
                <label>Emplacement PF</label>
                <input type="text" id="empPF" class="form-control" disabled >
              </div>

              <div class="form-group">
                <label>Désignation PE</label>
                <input type="text" id="desiPF" class="form-control" disabled >
              </div>
              <div class="form-group">
                <label>Quantité PF</label>
                <input type="text" id="QuantitePF" class="form-control" disabled >
              </div>

              <div class="form-group">
                <label>Date PF</label>
                <input type="text" id="datePE" class="form-control" disabled >
              </div>

            </div>
            <!-- /.card-body -->
        
          <!-- /.card -->
        </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Quitter</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <!-- /.modal -->


</section><!-- /.content -->


<script>
    function afficheDetail(ligneProduction,empMP,empPF,op1,op2){
      //alert(ligneProduction.status);

        var myModal = $('#modal');

        document.getElementById('numeroProduction').value = ligneProduction.date1;
        document.getElementById('operateurMP').value = op1;
        document.getElementById('empMP').value = empMP;
        document.getElementById('desiMP').value = ligneProduction.designation_mp;
        document.getElementById('QuantiteMP').value = ligneProduction.quantite_mp;
        document.getElementById('dateMP').value = ligneProduction.date1;
        document.getElementById('operateurPF').value = op2;
        document.getElementById('empPF').value = empPF;
        document.getElementById('desiPF').value = ligneProduction.designation_pf;
        document.getElementById('QuantitePF').value = ligneProduction.quantite_pf;
        document.getElementById('datePE').value = ligneProduction.date2;
        if(ligneProduction.status == 1)
            document.getElementById('statutProduit').value = 'Terminé';
        else
            document.getElementById('statutProduit').value = 'En production';
        if(ligneProduction.sscc){
          document.getElementById('sscc_group').style.display = "inline";
          document.getElementById('sscc').value = ligneProduction.sscc;
        }
        else{
          document.getElementById('sscc_group').style.display = "none";
        }
        myModal.modal({ show: true }); 
    }
</script>



@endsection

