@extends('app')
@section('content')


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Modifier une préparation
    </h1>


</section>

<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

        @if(Session::has('msgAjouter'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAjouter') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV" >
            <div class="box-body" >


                {!! Form::open(['method'=>'POST','action' => ['PreparationController@postEdit',$preparation->idPreparation]]) !!}


                <div class="form-group">

                    <div class="col-lg-12 ">

                        <div class="col-lg-4 ">
                            <label>N° Préparation : </label>
                            <input type="text" class="form-control" name="numPreparation" id="numPreparation" placeholder="N° Préparation" required @if(Session::has('numP')) value="{{Session::get('numP')}}" @endif value="{{$preparation->numPreparation}}" onchange="sessionPreparation(this)" readonly>
                        </div>
                        <div class="col-lg-4">
                            <label>Date prévue :</label>
                            <input type="date" class="form-control"  name="datePrevue" id="datePrevue" @if(Session::has('dateP')) value ="{{Session::get('dateP')}}" @endif value="{{$preparation->datePrevue}}" onchange="sessionDate(this)" required>
                        </div>
                        <div class="col-lg-4">
                        <label>N° Commande : </label>
                        <input list="browsers" class="form-control" name="n_commande" id="n_commande" 
                        @if($preparation->CommandeClient != null)
                        value="{!!$preparation->CommandeClient->numCommande!!}"
                            
                        @endif
                         autocomplete="off" />
<datalist id="browsers">
  @foreach ($commandes as $commande)
      <option value="{{ $commande->numCommande }}">
  @endforeach
  
</datalist>
                    </div>
                    </div>



                    <div class="col-md-12">
                       

                        <div class="col-md-4">
                            <label>Transporteur : </label>
                            <select id="idSelecTransporteur" class="form-control selectpicker"  name="transporteur"  onchange="sessionTransporteur(this)" data-live-search="true">
                                <option selected disabled value="" style="background-color: white">Sélectionner le transporteur ...</option>
                                @if(Session::has('Transporteur'))
                                @foreach($transporteurs as $transporteur)
                                    <option   value="{{$transporteur->idTransporteur}}" @if(Session::get('Transporteur')==$transporteur->idTransporteur)) value="{{Session::get('Transporteur')}}" selected @endif> {{$transporteur->numTransporteur}}-{{$transporteur->nomTransporteur}} {{$transporteur->prenomTransporteur}}</option>
                                @endforeach
                                @else
                                    @foreach($transporteurs as $transporteur)
                                        <option   value="{{$transporteur->idTransporteur}}"@if($preparation->idTransporteur==$transporteur->idTransporteur) value="{{$preparation->idTransporteur}}" selected @endif> {{$transporteur->numTransporteur}}-{{$transporteur->nomTransporteur}} {{$transporteur->prenomTransporteur}}</option>
                                    @endforeach
                                @endif

                            </select>
                        </div>
                        @if(Session::get('STOCK_EMPLACEMENT_MOBILE')=='1')
                        
                        <div class="col-md-4">
                            <label>Raison sociale :</label>
                            <input type="text" class="form-control"   
                            @if ($preparation->Client != null)
                                value="{{ $preparation->Client->raisonSociale }}" 
                            @endif
                            
                            readonly>
                            <input type="hidden" name="sociale"  value="{{ $preparation->adresse_livraison }}" >
                        </div>
                        @endif
                       
                         <div class="col-md-4">
                            <label>Total poids : </label>
                            <input type="text" class="form-control"  placeholder="Total poids" name="totalPoids" value="{{$totalPoids}}"  required readonly >
                            
                        </div>

                        </div>
                    <div class="col-md-12">
@if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                        <div class="col-md-4">
                            <label>Nombre d'unité d'expédition : </label>
                            <input type="text" class="form-control"  name="nombreUE" placeholder="Nombre d'unité d'expédition" value="{{$totalUE}}" required readonly >
                        </div>
@endif

                        

                        <div class="col-md-4">
                            <label>Nombre de produits : </label>
                            <input type="text" class="form-control"  name="nombreProduit" placeholder="Nombre de produits" value="{{$totalProduits}}" required readonly >
                        </div>
                        @if(Session::get('STOCK_ENTITE')=='1' )
                        <div class="col-md-8">
                            <label>Entité : </label>
                            <input type="text" class="form-control"  
                            @if ($preparation->entite != null)
                            value="{{ $preparation->entite->type_entite }} / {{  $preparation->entite->num_entite }} / {{  $preparation->entite->libelle_entite }}" 
                            @endif
                            readonly>
                        </div>
                         @endif
                    </div>
                   

                    @if($preparation->idCommande != 0 && Session::get('STOCK_ENTITE') != 1)
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="col-lg-4 col-md-6 col-sm-6">
                                <label>N° commande : </label>
                                <input type="text" class="form-control" value="{{$preparation->CommandeClient->numCommande}}" readonly>
                            </div>
                            <div class="col-lg-4 col-md-6 col-sm-6">
                                <label>Raison sociale : </label>
                                <input type="text" class="form-control" value="{{$preparation->CommandeClient->Client->raisonSociale}}" readonly>
                            </div>

                            <div class="col-lg-4 col-md-6 col-sm-6">
                                <label>Adresse client : </label>
                                <input type="text" class="form-control" value="{{$preparation->CommandeClient->Client->adresseClient}}" readonly>
                            </div>
                        </div>
                    @endif


                    <div class="col-lg-12">

                        <div  style="float: right" >
                            <a href="{{url('preparation/modifier/produit/ajouter')}}"  class="btn btn-block btn-primary" style="margin-bottom: 5%;margin-top: 5%" >
                                <span class="glyphicon glyphicon-plus" ></span>
                                Ajouter produit
                            </a>
                        </div>
                        @if(Session::get('STOCK_ENTITE')=='0' || Session::get('AVEC_UE_RECEPTION')=='0')
                        <div  style="float: right;margin-right: 20px" >
                            <a href="{{url('preparation/modifier/produit/genererUE')}}" data-toggle="modal" class="btn btn-block btn-primary" style="margin-bottom: 5%;margin-top: 5%" >
                                <span class="glyphicon glyphicon-plus" ></span>
                                Générer une UE
                            </a>
                        </div>
                        @endif

                    </div>

                    <table id="example1" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr role="row">
                            <th class="text-center sorting_asc">N° UE</th>
                            <th class="text-center sorting_asc">Référence</th>
                            <th class="text-center sorting_asc">Désignation</th>
                            <th class="text-center sorting_asc">Code produit</th>
                            @if(Session::get('N_LOT')=='1')

                            <th class="text-center sorting_asc">Numéro de lot</th>
                            @endif
                            <th class="text-center sorting_asc">Emplacement</th>
                            <th class="text-center sorting_asc">Quantité</th>
                            <th class="text-center sorting_asc">Opérateur</th>
                            <th class="text-center sorting_asc">Poids</th>
                            <th class="text-center sorting_asc">Modifier</th>
                            <th class="text-center sorting_asc">Supprimer</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($LigneProduits as $LigneProduit)
                            <tr role="row">
                                @if($LigneProduit->stockProduit != null)
                                        <td class="text-center sorting_1">{!!$LigneProduit->stockProduit->num_ue !!}</td>
                                    @else
                                            <td class="text-center sorting_1"></td>
                                    @endif
                                <td class="text-center sorting_1">{!!$LigneProduit->Produit->reference!!}</td>
                                <td class="text-center sorting_1">{!!$LigneProduit->Produit->designation!!}</td>
                                <td class="text-center sorting_1">{!!$LigneProduit->Produit->code_identification!!}</td>
                                    @if(Session::get('N_LOT')=='1')

                                    <td class="text-center sorting_1">{!!$LigneProduit->StockProduit->numero_lot!!}</td>
                                    @endif
                                <td class="text-center sorting_1">{!!$LigneProduit->StockProduit->Emplacement->libelle!!}</td>
                                <td class="text-center sorting_1">{!! (float)$LigneProduit->quantite_a_preparer!!}</td>
                                <td class="text-center sorting_1">{!!$LigneProduit->User->nom!!} {!!$LigneProduit->User->prenom!!}</td>
                                <td class="text-center sorting_1">{!!$LigneProduit->total_poids!!}</td>
                                <td class="text-center sorting_1">
                                    @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                                           
                                            <a style="cursor: pointer;" class="glyphicon glyphicon-edit" onclick="getProduitInfo({{ $LigneProduit }},{{ $LigneProduit->StockProduit->produit }}, {{ $LigneProduit->StockProduit }})">
                                            </a>
                                        @else
                                    <a href="#EditModal{{$LigneProduit->idLigneProduit}}" class="glyphicon glyphicon-edit" data-toggle="modal">

                                    </a>
                                    @endif
                                </td >
                                <td class="text-center sorting_1">
                                    <a href="#DeleteModal{{$LigneProduit->idLigneProduit}}" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>

                    </table>

                </div>
                <div class="modal-footer" >
                    <button type="submit" class="btn btn-primary">Valider</button>
                    <a href="{{url('preparation/index')}}" class="btn btn-default pull-right">Annuler</a>

                    {!! Form::close() !!}



                        </div>

                @foreach($LigneProduits as $LigneProduit)

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$LigneProduit->idLigneProduit}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce produit ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['PreparationController@deleteProduit',$LigneProduit->idLigneProduit]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                    <div cl1ass="example-modal" >
                        <div class="modal" id="EditModal{{$LigneProduit->idLigneProduit}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;">Modifier produit</h4>
                                    </div>
                                    <div class="modal-body">
                                        {!! Form::open(['method'=>'PUT','action' => ['PreparationController@postEditeLigneProduit',$LigneProduit->idLigneProduit]]) !!}
                                        <div class="col-lg-12">
                                            <div class="col-lg-6">
                                                <label>N°UE </label>
                                                <select id="idSelecSSCC" class="form-control selectpicker" name="sscc" data-live-search="true" >
                                                    <option value="" 
style="background-color: white" >Sélectionner le N°UE</option>
                                                    @foreach($UEs as $UE)
                                                        <option value="{{$UE->idUE}}" @if($UE->idUE == $LigneProduit->idUE) selected @endif> {{$UE->UniteExpedition->SSCC}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="form-group col-lg-6">
                                                <label>Référence</label>
                                                <input type="text" class="form-control"  name="refenrence"  value="{!!$LigneProduit->Produit->reference!!}" readonly >
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label>Désignation</label>
                                                <input type="text" class="form-control"  name="designation"  value="{!!$LigneProduit->Produit->designation!!}" readonly >
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label>Code à barres</label>
                                                <input type="text" class="form-control"  name="designation"  value="{!!$LigneProduit->Produit->code_identification!!}" readonly >
                                            </div>
                                            @if(Session::get('N_LOT')=='1')

                                            <div class="form-group col-lg-6">
                                                <label>Numéro de lot</label>
                                                <input type="text" class="form-control"  name="designation"  value="{!!$LigneProduit->StockProduit->numero_lot!!}" readonly >
                                            </div>
                                            @endif
                                            <div class="form-group col-lg-6">
                                                <label>Quantité</label>
                                                <input type="number" step="0.01" min="1" max="" class="form-control"  placeholder="Quantite" name="quantite" value="{!!(float) $LigneProduit->quantite_a_preparer!!}"  required  >
                                            </div>

                                        </div>

                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                            <button type="submit" class="btn btn-primary">Valider</button>
                                        </div>
                                        {!! Form::close() !!}

                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                        </div>

                        @endforeach







                    </div>
            </div>

<div class="modal fade" id="modal_modifier">
          <div class="modal-dialog ">
            <form method="post" action="{{ route('modifier_ligne_produit_preparation') }}">
                     {{ csrf_field() }}
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Modifier produit</h4>
              </div>
              <div class="modal-body">
                <input type="hidden" id="id_stock" name="id_stock">
                <input type="hidden" id="id_ligne_produit" name="id_ligne_produit">
                <input type="hidden" name="importer" value="1">
                <div class="row">
                <div class="col-sm-12">
                    <div class="col-sm-6">
                        <label>Référence produit :</label>
                        <input type="text" class="form-control" readonly id="reference_produit" name="referencee">
                    </div>
                    <div class="col-sm-6">
                        <label>Code a bares produit :</label>
                        <input type="text" class="form-control" readonly id="code_bare_produit">
                    </div>
                    
                 
                    <label>Désignation produit :</label>
                <textarea class="form-control" rows="3" id="designation_produit" readonly style="text-align: center;"></textarea>
                 <div class="col-sm-6">
                        <label>N° UE :</label>
                        <select class="form-control" id="numero_ue" name="numero_ue">
                            
                        </select>
                    </div>
                    <div class="col-sm-6">
                        <label>Quantité a préparer :</label>
                        <input type="number" step="0.01" class="form-control" id="quantite_a_preparer_modal" name="quantite_a_preparer_modal">
                    </div>
               
                 
                    
                </div>
                 
                </div>


              </div>
              <div class="modal-footer">
                <input type="submit" class="btn btn-primary" value="Valider">
                <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                
              </div>
            </div>
            </form>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->


</section><!-- /.content -->
<script>
    function getProduitInfo(ligne , produit, stock){
        
        $.ajax({
                    url: "{{url('preparation/get_ue_from_stock')}}/"+stock.num_entite+"/"+stock.id_produit,
                    method : "get",   
                    data: {
                    "_token": "{{ csrf_token() }}"
                    } ,        
                    success: function(data){ 
                        //alert(data[0].num_ue);
                    var myModal = $('#modal_modifier');
                    document.getElementById("reference_produit").value = produit.reference;
                    document.getElementById("code_bare_produit").value = produit.code_identification;
                    document.getElementById("designation_produit").value = produit.designation;

                    document.getElementById("id_stock").value = stock.id_stock_produit;
                    document.getElementById("id_ligne_produit").value = ligne.idLigneProduit;

                    document.getElementById("quantite_a_preparer_modal").value = ligne.quantite_a_preparer;
                    $("#numero_ue").empty();
                 
             
                    $("#numero_ue").append("<option selected disabled>Sélectionner un N° UE...</option>");

                  data.forEach(function(d) {
                    if(d.num_ue == stock.num_ue){
                        $("#numero_ue").append("<option selected value="+d.num_ue+">"+d.num_ue+"</option>");
                    }else{
                        $("#numero_ue").append("<option value="+d.num_ue+">"+d.num_ue+"</option>");
                    }
                  });
                    myModal.modal({ show: true }); 
                                  
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
         
      }

    function setCommande(element){

        if(element.checked){
            document.getElementById('numCommande').disabled = false;

        }else{
            document.getElementById('numCommande').disabled = true;
            document.getElementById('numCommande').value = "";
            document.getElementById("raisonSociale").value ="";
            document.getElementById("adresseClient").value ="";
        }

    }


    function getClient(numCommande){

        var num = document.getElementById("numCommande");
        var test = [];
        $.get("{{url('preparation/commande_client?ID=')}}"+numCommande, function(res,stat){
            var raisonSociale = document.getElementById("raisonSociale");
            var adresseClient = document.getElementById("adresseClient");


            if (res.length == 0  ) {
                raisonSociale.value = "";
                adresseClient.value = "";
            }
            else
            {
                raisonSociale.value = res[0].raisonSociale;
                adresseClient.value = res[0].adresseClient;
            }

        });
    }
    function sessionPreparation(num)
    {
        var num = document.getElementById("numPreparation").value;
        $.get("{{url('preparation/sessionPreparation?ID=')}}"+num,function(res,stat){})
    }
    function sessionDate(date)
    {
        var date = document.getElementById("datePrevue").value;
        $.get("{{url('preparation/sessionDate?ID=')}}"+date,function(res,stat){})
    }
    function sessionTransporteur(idTransporteur)
    {
        var idTransporteur = document.getElementById("idSelecTransporteur").value;
        $.get("{{url('preparation/sessionTransporteur?ID=')}}"+idTransporteur,function(res,stat){})
    }
    function sessionCommande(element)
    {
        if(element.checked){
            var checked = document.getElementById("commande").value;
            checked = "checked";
            $.get("{{url('preparation/sessionCommande?ID=')}}"+checked,function(res,stat){})

        }
        else {
            var checked = document.getElementById("commande").value;
            checked = "";
            $.get("{{url('preparation/sessionCommande?ID=')}}"+checked,function(res,stat){})
        }

    }

</script>

@endsection








