@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('CLIENT_PREPARATION_AJOUTER'))

    <div class="box-tools pull-right">
        <a href=" {{url('preparation/ajouter')}}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    @endif
    @if ( Session::get('STOCK_ENTITE')=="1" || Session::get('STOCK_EMPLACEMENT_MOBILE')=="1")
        
    
    <div class="box-tools pull-right" style="margin-right: 1%">
        <a href="#importer" class="btn btn-block btn-success" data-toggle="modal">
            <span class="glyphicon glyphicon-download-alt" aria-hidden="false"></span>
            Importer
        </a>
    </div>
    @endif


    <h1>
        Liste des préparations
    </h1>

</section>



<!-- Main content -->

<section class="content">

    @if($errors->any())
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! $errors->first() !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif
    
    @if(Session::has('msgDelete'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDelete') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgSupprimer'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgSupprimer') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif


        @if(Session::has('msgExist'))
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgExist') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif

       @if(Session::has('msgAjouterErreur'))
    <div class="box box-danger box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                    Échec de l'importation.<br>
                <em>
                    @if (session('msgAjouterErreur')[0]->count() != 0)
                    <ul>
                        @foreach (session('msgAjouterErreur')[0] as $key =>$warning)
                        <li>
                        Ligne {{ $key }} : {{ $warning }}.
                        </li>
                        @endforeach
                    </ul>
                    @endif

                    @if (session('msgAjouterErreur')[1]->count() != 0)
                    <ul>
                        @foreach (session('msgAjouterErreur')[1] as $key => $erreur)
                        <li>
                            Ligne {{ $key }} : {{ $erreur }}.
                        </li>
                        @endforeach
                    </ul>
                    @endif
                </em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

   @if(Session::has('msgAjouterAnnuler'))
    <div class="box box-danger box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                    Échec de l'importation.<br>
                <em>
                    <ul>
                        @foreach (session('msgAjouterAnnuler')[0] as $key => $erreur)
                        <li>
                            Ligne {{ $key }} : {{ $erreur }}.
                        </li>
                        @endforeach
                    </ul>
                    
                </em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgAjouter'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAjouter') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
        {!! Form::open(['method' => 'GET', 'action' => ['PreparationController@filtre']]) !!}
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-4">
                        <label class="text-center">Filtrer par mode d'affichage : </label>
                        <select name="mode_affichage" id="mode_affichage"  class="form-control" >
                            <option value="0" disabled>Choisir un mode d'affichage</option>
                            <option value="1"
                                @if(isset($mode_affichage))
                                    @if($mode_affichage == 1)
                                        selected
                                    @endif
                                @else
                                    selected
                                @endif>
                                Les préparations qui n'ont pas été livrées
                            </option>
                            <option value="2"
                            @if(isset($mode_affichage))
                                @if($mode_affichage == 2)
                                    selected
                                @endif
                            @endif>
                                Toutes les préparations
                            </option>  
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="text-center">Filtrer par région du client : </label>
                        <select name="region_client" id="region_client" class="form-control selectpicker" data-live-search="true">
                            <option value="0" selected >Choisir une région</option>
                            @foreach($regions as $value)
                                <option value="{{$value['id_wilaya']}}"
                                    @if(isset($region_client))
                                        @if($region_client == $value['id_wilaya'])
                                            selected
                                        @endif
                                    @endif>
                                    {{$value['nom_wilaya']}}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <br>
                <div class="col-md-12">
                    @if(isset($region_client) || isset($mode_affichage))
                        <div class="box-tools pull-right" style="margin-right: 1%;" id="rechercher">
                            <input type="button" class="btn btn-default" value="Réinitialiser" onclick="window.location.href = '{{ route('index_preparation') }}';">
                        </div>
                    @endif
                    <div class="box-tools pull-right" style="margin-right: 1%;" id="rechercher">
                        <input type="submit" class="btn btn-default" value="Filtrer" >
                    </div>
                </div>
            </div>
        {!! Form::close() !!}
        <br>
                <!-- Default box -->
        <div class="box">
            
            <br>

            <form method="get" action="{{ route('recherche_preparation') }}">

                <div class="table-responsive">
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" @if (isset($mot_a_rechercher))
                        value="{{ $mot_a_rechercher }}"
                    @endif>

                    <input type="hidden" name="mode_affichage" class="form-control" 
                    @if (isset($mode_affichage))
                        value="{{ $mode_affichage }}"
                    @endif>

                    <input type="hidden" name="region_client" class="form-control" 
                    @if (isset($region_client))
                        value="{{ $region_client }}"
                    @endif>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
                
            </div><br>
            </form>
           
            <table class="table table-bordered table-striped">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N° préparation</th>
                    <th class="text-center sorting_asc">N° commande</th>
                    <th class="text-center sorting_asc">N° de bon de livraison</th>
                    <th class="ptext-center sorting_asc">Raison sociale</th>
                    <th class="text-center sorting_asc">N° transporteur</th>
                    <th class="text-center sorting_asc">Date prévue</th>
                    @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                    <th class="text-center sorting_asc">Nombre d'UE</th>
                    @endif
                    <th class="text-center sorting_asc">Statut</th>
                    @if(Session::get('CLIENT_PREPARATION_MODIFIER'))

                    <th class="text-center sorting_asc">Modifier</th>
                    @endif
                    @if(Session::get('CLIENT_PREPARATION_DETAIL'))
                    <th class="text-center sorting_asc">Détail</th>
                    @endif
                    @if(Session::get('CLIENT_PREPARATION_SUPPRIMER'))

                    <th class="text-center sorting_asc">Supprimer</th>
                        @endif
                </tr>
                </thead>

                <tbody>
                @foreach($preparations as $preparation)
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{!!$preparation->numPreparation!!}</td>
                        @if($preparation->CommandeClient != null)
                        <td class="text-center sorting_1">{!!$preparation->CommandeClient->numCommande!!}</td>
                        @else
                             <td class="text-center sorting_1"> </td>
                        @endif

                        <td class="text-center sorting_1">
                            <a href="{{url('./livraison/detail/')}}/{{ $preparation['livraison']['id_bon_livraison'] }}" target="_blank">{{ $preparation['livraison']['num_bl'] }}</a>

                            
                        </td>
                            @if ($preparation->Client != null)
                               <td class="text-center sorting_1">{{ $preparation->Client->raisonSociale }}</td>
                            @else
                                <td class="text-center sorting_1"> </td>
                            @endif
                            
                        


                        @if($preparation->idTransporteur !=null)
                        <td class="text-center sorting_1">{!!$preparation->Transporteur->numTransporteur!!}</td>
                        @else
                            <td class="text-center sorting_1"> </td>
                        @endif
                        <td class="text-center sorting_1">{!!$preparation->datePrevue!!}</td>
                        @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                        <td class="text-center sorting_1">{!!$preparation->nombreUE!!}</td>
                        @endif

                        <td class="text-center sorting_1">{!!$preparation->valeur!!}</td>
                        @if(Session::get('CLIENT_PREPARATION_MODIFIER'))

                        <td class="text-center sorting_asc">
                            @if($preparation->valeur!='Préparée' && $preparation->valeur!='Annulée')

                            <a href="{{url('preparation/modifier')}}/{{$preparation->idPreparation}}" class="glyphicon glyphicon-edit">

                            </a>
                            @endif

                        </td >
                        @endif
                        @if(Session::get('CLIENT_PREPARATION_DETAIL'))
                        <td class="text-center sorting_1">
                            <a href="{{url('preparation/detail')}}/{{$preparation->idPreparation}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                            </a>
                        </td>
                        @endif
                        @if(Session::get('CLIENT_PREPARATION_SUPPRIMER'))

                        <td class="text-center sorting_asc">
                            @if($preparation->valeur!='Préparée')

                            <a href="#DeleteModal{{$preparation->idPreparation}}" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                            @endif
                        </td>
                            @endif
                    </tr>
                @endforeach
                </tbody>
            </table>

            <p>Affichage de l'élement {{($preparations->currentPage()-1)* $preparations->perPage()+($preparations->total() ? 1:0)}} à {{($preparations->currentPage()-1)*$preparations->perPage()+count($preparations)}}  sur  {{$preparations->total()}} éléments</p>
            
            <span class="pull-right">{{ $preparations->links() }}</span>

                @foreach($preparations as $preparation)

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$preparation->idPreparation}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer cette préparation ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['PreparationController@delete',$preparation->idPreparation]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>
                    @endforeach
        </div><!-- /.box -->
</section><!-- /.content -->
<div class="example-modal">
        <div class="modal" id="importer">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h3 class="modal-title" style="font-family:verdana;">Importer les préparations </h3>
                        </div>
                        <div class="modal-body">
                            <p>Importer les préparations par UE depuis un fichier xls ou xlsx. Télécharger le modèle et ouvrir Excel  pour voir le format avec tous les champs acceptés.
                            </p>

                            {!! Form::open(['method'=>'POST','action' => ['PreparationController@downloadModele']]) !!}
                            <div class="col-sm-7">
                                <label class="control-label">Télécharger le fichier modèle</label>

                            </div>


                            <input id="btnDwnld" class="btn btn-success col-sm-4" type="submit"  value="Télécharger le modèle "  name="dwnld">
                            <br>
                            <br>
                            {!! Form::close() !!}
                            @if (Session::get('STOCK_ENTITE') == '1')

                            {!! Form::open(['url'=>'preparation/upload', 'files' => true,'enctype'=>'multipart/form-data']) !!}
                            <div class="col-sm-7">
                                <input type="file" id="file" name="file"  class="form-control" onchange="verifInput(this.id, 'btnSubmit');" accept=".xls,.xlsx,.csv" required>
                            </div>
                            <input id="btnSubmit" class="btn btn-success col-sm-4" type="submit" value="Importer le fichier" disabled="disabled" name="submit" onClick="toggle_visibility('tips');">

                            {!! Form::close() !!}
                            @else
                                {!! Form::open(['url'=>'preparation/upload_ue', 'files' => true,'enctype'=>'multipart/form-data']) !!}
                            <div class="col-sm-7">
                                <input type="file" id="file" name="file"  class="form-control" onchange="verifInput(this.id, 'btnSubmit');" accept=".xls,.xlsx,.csv" required>
                            </div>
                            <input id="btnSubmit" class="btn btn-success col-sm-4" type="submit" value="Importer le fichier" disabled="disabled" name="submit" onClick="toggle_visibility('tips');">

                            {!! Form::close() !!}
                            @endif



                            <div class="modal-footer">



                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>
        </div>

<script type="text/javascript">
            function verifInput(id, idSubmit) {
                if(document.getElementById(id).value != ""){
                    document.getElementById(idSubmit).disabled = false;
                }
            }
        </script>



@endsection