@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Générer une unité d'expédition
    </h1>

</section>


<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'POST','action' => ['PreparationController@postFormUE']]) !!}
                <div class="form-group">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>N° UE : </label>
                            <input type="text" class="form-control" id="sscc" name="sscc" placeholder="SSCC"  value="{{$SSCC}}" required readonly >
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Nombre de produits : </label>
                            <input type="number" class="form-control" id="nombreProduit"  name="nombreProduit" placeholder="Nombre de produits" value="0" required readonly >
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Poids des produits : </label>
                            <input type="number" class="form-control" id="poidsProduit"  name="poidsProduit" placeholder="Poids des produits" value="0" required readonly >
                        </div>

                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12"style="margin-top: 15px">
                        <div class="table-responsive">
                            <table id="example1" class="table table-bordered table-striped dataTable">
                                <thead>
                                <tr role="row">

                                    <th class="text-center sorting_asc">Sélectionner</th>
                                    <th class="text-center sorting_asc">Référence</th>
                                    <th class="text-center sorting_asc">Désignation</th>
                                    <th class="text-center sorting_asc">Code produit</th>
                                    @if(Session::get('N_LOT')=='1')

                                    <th class="text-center sorting_asc">Numéro de lot</th>
                                    @endif
                                    <th class="text-center sorting_asc">Emplacement</th>
                                    <th class="text-center sorting_asc">Quantité</th>
                                    <th class="text-center sorting_asc">Opérateur</th>
                                    <th class="text-center sorting_asc">Poids</th>

                                </tr>
                                </thead>

                                <tbody>
                                @foreach($LigneProduits as $LigneProduit)
                                    <tr role="row" class="odd">
                                        <td class="text-center sorting_1"><label>
                                                <input style=" transform: scale(1.5);"  type="checkbox" id="select{{$LigneProduit->idLigneProduit}}" name="select{{$LigneProduit->idLigneProduit}}"  value="selected" onchange="nbrProduit(this,{{$LigneProduit->idLigneProduit}}),totalPoids(this,{!!$LigneProduit->total_poids!!})">
                                            </label> </td>
                                        <td class="text-center sorting_1">{!!$LigneProduit->Produit->reference!!}</td>
                                        <td class="text-center sorting_1">{!!$LigneProduit->Produit->designation!!}</td>
                                        <td class="text-center sorting_1">{!!$LigneProduit->Produit->code_identification!!}</td>
                                        @if(Session::get('N_LOT')=='1')

                                        <td class="text-center sorting_1">{!!$LigneProduit->StockProduit->numero_lot!!}</td>
                                        @endif
                                        <td class="text-center sorting_1">{!!$LigneProduit->StockProduit->Emplacement->libelle!!}</td>
                                        <td class="text-center sorting_1">{!! (float) $LigneProduit->quantite_a_preparer!!}</td>
                                        <td class="text-center sorting_1">{!!$LigneProduit->User->nom!!} {!!$LigneProduit->User->prenom!!}</td>
                                        <td class="text-center sorting_1">{!!$LigneProduit->total_poids!!}</td>

                                @endforeach

                                </tbody>



                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Valider</button>
                        <a href="{{url('preparation/ajouter')}}" class="btn btn-default pull-right">Annuler</a>
                    </div>
                </div>

            </div>
        </div>
</section><!-- /.content -->
<script>

    function setSelect(element,idStock){

        if(element.checked){
            document.getElementById('quantite'+idStock).disabled = false;
        }else{
            document.getElementById('quantite'+idStock).disabled = true;
            document.getElementById('quantite'+idStock).value = "";

        }

    }

    function nbrProduit(element,nbr)
    {
        if(element.checked) {
            var nombreProduit = (document.getElementById('nombreProduit'));

            var n = nombreProduit.value;

            var nb = parseInt(n);
            nb += 1;
            document.getElementById('nombreProduit').value = nb;
        }
        else{
            var nombreProduit = (document.getElementById('nombreProduit'));

            var n = nombreProduit.value;

            var nb = parseInt(n);
            nb -= 1;
            document.getElementById('nombreProduit').value = nb;
        }

    }
    function totalPoids(element,poids)
    {
        if(element.checked) {
            var poidsProduit = (document.getElementById('poidsProduit'));

            var n = poidsProduit.value;

            var nb = parseFloat(n);
            nb = nb+poids;
            document.getElementById('poidsProduit').value = nb;
        }
        else{
            var poidsProduit = (document.getElementById('poidsProduit'));

            var n = poidsProduit.value;

            var nb = parseFloat(n);
            nb = nb-poids;
            document.getElementById('poidsProduit').value = nb;
        }
    }

</script>











@endsection