@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Ajouter des produits
    </h1>

</section>

<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif
    @if($errors->any())
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! $errors->first() !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
       

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'POST','action' => ['PreparationController@postFormProduit']]) !!}
                <div class="form-group">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Opérateur : </label>
                            <select id="idSelecOperateur" class="form-control selectpicker"  name="operateur" required="required" data-live-search="true">
                                <option selected disabled value="" style="background-color: white">Sélectionner l'opérateur ...</option>
                                @foreach($operateurs as $operateur)
                                    <option value="{{$operateur->id_user}}" @if (Session::get('Oper') == $operateur->id_user)
                                        selected
                                    @endif> {{$operateur->nom}} {{$operateur->prenom}}</option>
                                @endforeach
                            </select>
                        </div>
    

                      </div>

                <div class="col-lg-12 col-md-12 col-sm-12"style="margin-top: 15px">
                    <div class="table-responsive">
                        <table id="example7" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">Sélectionner </th>
                                <th class="text-center sorting_asc">Référence</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Code produit</th>
                                @if(Session::get('N_LOT')=='1')

                                <th class="text-center sorting_asc">Numéro de lot</th>
                                @endif
                                @if (Session::get('STOCK_EMPLACEMENT_MOBILE') != '1')
                                    <th class="text-center sorting_asc">Emplacement</th>
                                    @if(Session::has('numCommande'))
                                        <th class="text-center sorting_asc">Quantité commandée</th>
                                    @endif
                                @endif

                                <th class="text-center sorting_asc">Quantité Stock</th>

                                @if(Session::get('ADMINISTRATION_STOCK'))
                                    <th class="text-center sorting_asc">Quantité</th>      
                                @endif
                                
                                

                            </tr>
                            </thead>
                            @if ($alerte != null)
                                <div class="alert alert-warning alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                    <h4><i class="icon fa fa-warning"></i> Alert!</h4>
                                    <b>{{ $alerte }}</b>
                                  </div>
                            
                            @endif

                            <tbody>
                                
                            @foreach($stockproduits as $stockproduit)
                                @if(Session::has('numCommande'))

                                <?php $ligneCommande=DB::table('ligne_commande_produit')->where('idCommande','=',$idCommande->idCommande)
                                                    ->where('idProduit','=',$stockproduit->id_produit)
                                                    ->first()?>
                                @endif
                                
                                <tr role="row" class="odd">
                                    <td class="text-center sorting_1"><label>
                                        @if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")
                                        
                                            <input style=" transform: scale(1.5);"  type="checkbox" id="select" name="select[]" onchange="setSelect(this,{{$stockproduit[0]->id_stock_produit}})" value="{{$stockproduit[0]['produit']['id_produit']}}">
                                            @else
                                              <input style=" transform: scale(1.5);"  type="checkbox" id="select" name="select{{$stockproduit->id_stock_produit}}" onchange="setSelect(this,{{$stockproduit->id_stock_produit}})" value="selected">
                                              @endif
                                        </label> 
                                    </td>
                                    @if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")
                                    <td class="text-center sorting_1">{!!$stockproduit[0]['Produit']['reference']!!}</td>
                                    @else
                                    <td class="text-center sorting_1">{!!$stockproduit['Produit']['reference']!!}</td>
                                    @endif
                                    @if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")
                                    <td class="text-center sorting_1">{!!$stockproduit[0]['Produit']['designation']!!}</td>
                                    @else
                                    <td class="text-center sorting_1">{!!$stockproduit['Produit']['designation']!!}</td>
                                    @endif
                                    @if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")
                                    <td class="text-center sorting_1">{!!$stockproduit[0]['Produit']['code_identification']!!}</td>
                                    @else
                                    <td class="text-center sorting_1">{!!$stockproduit['Produit']['code_identification']!!}</td>
                                    @endif
                                    @if(Session::get('N_LOT')=='1')
                                    @if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")
                                    <td class="text-center sorting_1">{!!$stockproduit[0]->numero_lot!!}</td>
                                    @else
                                    <td class="text-center sorting_1">{!!$stockproduit->numero_lot!!}</td>
                                    @endif

                                    @endif
                                    @if (Session::get('STOCK_EMPLACEMENT_MOBILE') != '1' &&  Session::get('STOCK_ENTITE') != '1')
                                    <td class="text-center sorting_1">{!!$stockproduit->Emplacement->libelle!!}
                                    </td>
                                    @if(Session::has('numCommande'))
                                    <td class="text-center sorting_1">{!! (float)$ligneCommande->quantiteCommande!!}</td>
                                    @endif
                                    @endif
                                    

                                    @if(Session::get('ADMINISTRATION_STOCK'))
                                    @if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")
                                    @if ($stockproduit->count() == 1)
                                        <td class="text-center sorting_1">
                                            {!!(float) $stockproduit[0]->quantite_utilisable!!}
                                        </td>
                                    @else
                                    @php
                                        $quantiteCount = 0;
                                        foreach ($stockproduit as $element){
                                            $quantiteCount += $element->quantite_utilisable;
                                        }
                                    @endphp
                                    <td class="text-center sorting_1">
                                            {!!(float) $quantiteCount!!}
                                        </td>
                                    @endif
                                    @else
                                    <td class="text-center sorting_1">{!!(float)$stockproduit->quantite_utilisable!!}</td>
                                    @endif
                                    @endif
                                    
                                   @if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1")
                                    <td class="text-center sorting_1"> <input  type="number" step="0.01" min="0.01" class="form-control"  placeholder="Quantite" id="quantite{{$stockproduit[0]->id_stock_produit}}" name="quantite[]" value=""  required disabled ></td>
                                    @else
                                    <td class="text-center sorting_1"> <input  type="number" step="0.01" min="0.01" max="{!!$stockproduit->quantite_utilisable!!}" class="form-control"  placeholder="Quantite" id="quantite{{$stockproduit->id_stock_produit}}" name="quantite{{$stockproduit->id_stock_produit}}" value=""  required disabled ></td>
                                    @endif
                                    

                                </tr>
                            @endforeach

                            </tbody>
                            

                        </table>
                    </div>
                </div>
                <div class="modal-footer">

                    <input @if ($stockproduits->isEmpty())
                        type="hidden"  
                        @else
                          type="submit"  
                    @endif  class="btn btn-primary"  value="Valider">
                   <a href="{{url('preparation/ajouter')}}" class="btn btn-default pull-right">Annuler</a>
                </div>
            </div>
</div>
        </div>
</section><!-- /.content -->
<script>

    function setSelect(element,idStock){

        if(element.checked){
            document.getElementById('quantite'+idStock).disabled = false;
        }else{
            document.getElementById('quantite'+idStock).disabled = true;
            document.getElementById('quantite'+idStock).value = "";

        }


        var qnt =  document.getElementById('quantite'+idStock);
        qnt.oninvalid = function (e) {
            e.target.setCustomValidity("");
            if (!e.target.validity.valid) {
                if (e.target.value.length == 0) {
                    e.target.setCustomValidity("Ce champ est obligatoire");
                } else {
                    e.target.setCustomValidity("Cette valeur n'est pas valide.");
                }
            }
        };

    }





</script>











@endsection