@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Détail d'un inventaire
    </h1>

</section>

<section class="content">
@if(Session::has('msgAddSuccess'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAddSuccess') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
@endif

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                <div class="form-group" style="margin-bottom: 20%">
                    {!! Form::open(['method'=>'POST','id' => 'formulaire','action' => ['InventaireController@show',$Inventaire->idInventaire]]) !!}
                    <div >
                        <button type="button" id="btn-export"  class="btn btn-flat btn-danger pull-right" onclick="genPDF()">Export PDF</button>
                    </div>
                    <div >
                        <button type="button" id="btn-export"  style="margin-right:  1%" class="btn btn-flat btn-danger pull-right" onclick="genPDF1()">Export PDF (produit)</button>
                    </div>
                    @if ($Inventaire->statutInventaire == 1)
                        <a data-toggle="modal" data-target="#cloturer_modal" class="btn btn-primary" style="float: right;margin-right: 0.5%;">
                            Clôturer
                        </a>
                    @endif
                    <br>
                    <br>
                    <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° inventaire : </label>
                            <input type="text" class="form-control" required value="{{$Inventaire->numInventaire}}" readonly>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Désignation inventaire : </label>
                            <input type="text" class="form-control"  required value="{{$Inventaire->designationInventaire}}" readonly>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Type d’ inventaire : </label>
                            @if($Inventaire->typeInventaire == 0)
                            <input type="text" class="form-control"  value="Inventaire total"  readonly >
                            @endif
                            @if($Inventaire->typeInventaire == 1)
                            <input type="text" class="form-control"  value="Inventaire par zone"  readonly >
                            @endif
                            @if($Inventaire->typeInventaire == 2)
                            <input type="text" class="form-control"  value="Inventaire par emplacement"  readonly >
                            @endif
                            @if($Inventaire->typeInventaire == 3)
                            <input type="text" class="form-control"  value="Inventaire par Entité"  readonly >
                            @endif
                            @if($Inventaire->typeInventaire == 4)
                            <input type="text" class="form-control"  value="Inventaire par N°UE"  readonly >
                            @endif
                        </div>
                        
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Statut : </label>
                            <input type="text" class="form-control" value="{{$Inventaire->valeur}}" readonly>
                        </div>
                       
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Date début d’inventaire :</label>
                            <input type="text" class="form-control"   required value="{{$Inventaire->dateDebut}}" readonly>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Date fin d’inventaire :</label>
                            <input type="text" class="form-control"   required value="{{$Inventaire->dateFin}}" readonly>
                        </div>
                         </div>
                          <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                         <div class="col-lg-12 col-md-8 col-sm-8">
                            <label>Commentaire : </label>
                            <textarea type="text" row ="3" class="form-control"  readonly> {{$Inventaire->commentaire}}</textarea>

                        </div>
                    </div>

                    

                    <div class="col-lg-12 col-md-12 col-sm-12" style="margin-bottom: 20px">
                        

                        @if($Inventaire->typeInventaire == 1)

                                <div class="col-lg-4 col-md-6 col-sm-6">
                                    <label>Zone : </label>
                                    <input type="text" class="form-control" value="{{$zone}}" readonly>
                                </div>
                                @endif
                                @if($Inventaire->typeInventaire == 2)
                                <div class="col-lg-4 col-md-6 col-sm-6">
                                    <label>Emplacement : </label>
                                    <input type="text" class="form-control" value="{{$emplacement}}" readonly>
                                </div>
                        @endif
                        @if($Inventaire->typeInventaire == 3)
                                <div class="col-lg-4 col-md-6 col-sm-6">
                                    <label>Entité : </label>
                                    <input type="text" class="form-control" value="{{$entite->type_entite}} / {{$entite->num_entite}} / {{$entite->libelle_entite}}" readonly>
                                </div>
                        @endif
                        @if($Inventaire->typeInventaire == 4)
                                <div class="col-lg-4 col-md-6 col-sm-6">
                                    <label>N°UE : </label>
                                    <input type="text" class="form-control" value="{{$ue->num_ue}}" readonly>
                                </div>
                        @endif

                    </div>

                   

                </div>

<div class="row">
            <div class="col-sm-12">
                <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped dataTable">
                    <thead>
                    <tr role="row">
                        @if (Session::get('STOCK_ENTITE')== "1")
                            
                                <th class="text-center sorting_asc">Entité</th>
                            
                        @endif
                        @if (Session::get('STOCK_EMPLACEMENT_MOBILE')== "1")
                            
                                <th class="text-center sorting_asc">N°UE</th>
                            
                        @endif
                        <th class="text-center sorting_asc">Référence</th>
                        <th class="text-center sorting_asc">Désignation</th>
                        <th class="text-center sorting_asc">Code produit</th>
                        @if(Session::get('N_LOT')=='1')
                            <th class="text-center sorting_asc">Numéro de lot</th>
                        @endif
                        <th class="text-center sorting_asc">Emplacement</th>
                        <th class="text-center sorting_asc">Quantité estimée</th>
                        <th class="text-center sorting_asc">Quantité comptée</th>
                        <th class="text-center sorting_asc">Ecart</th>
                        <th class="text-center sorting_asc">Opérateur</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($LigneInventaire as $LigneProduit)
                        <tr role="row">
                            @if (Session::get('STOCK_ENTITE')== "1")
                               
                                    <td class="text-center sorting_1">{!!$LigneProduit->num_entite!!}</td>
                               
                            @endif
                            @if (Session::get('STOCK_EMPLACEMENT_MOBILE')== "1")
                               
                                    <td class="text-center sorting_1">{!!$LigneProduit->num_ue!!}</td>
                              
                            @endif
                            
                            
                            <td class="text-center sorting_1">{!!$LigneProduit->produit->reference!!}</td>
                            <td class="text-center sorting_1">{!!$LigneProduit->produit->designation!!}</td>
                            <td class="text-center sorting_1">{!!$LigneProduit->produit->code_identification!!}</td>
                            @if(Session::get('N_LOT')=='1')
                                <td class="text-center sorting_1">{!!$LigneProduit->Stock->numero_lot!!}</td>
                            @endif
                            <td class="text-center sorting_1">{!!$LigneProduit->Emplacement->libelle!!}</td>
                            <td class="text-center sorting_1">{!! (float) $LigneProduit->quantiteEstimee!!}</td>
                            <td class="text-center sorting_1">{!! (float) $LigneProduit->quantiteComptee!!}</td>
                            <td class="text-center sorting_1">{!! (float) $LigneProduit->ecart!!}</td>
                            @if ($LigneProduit->User != null)
                                <td class="text-center sorting_1">{!!$LigneProduit->User->nom!!} {!!$LigneProduit->User->prenom!!}</td>
                            @else
                                <td class="text-center sorting_1"></td>
                            @endif
                            

                        </tr>
                    @endforeach
                    </tbody>

                </table></div></div></div>



                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">
                    <a href="{{url('inventaire/index')}}" class="btn btn-default pull-right" data-dismiss="modal">Retour</a>
                </div>
            </div>
       <!-- /.box -->


    <div class="hidden">
        <input type="text" name="exportPdf" id="exportPdf" value="0">
    </div>
        
       </div>
       
        
    {!! Form::close() !!}

    <div class="modal" id="cloturer_modal">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                </div>
                                <div class="modal-body">
                                    <p>Voulez-vous vraiment clôturer cet inventaire ?</p>
                                </div>

                                <div class="modal-footer">

                                    <a href="{{ route('cloture',$Inventaire->idInventaire) }}" class="btn btn-flat btn-primary pull-right">
                                        Valider
                                    </a>
                                    <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>

                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
</section><!-- /.content -->

<script>
function genPDF() {
document.getElementById('exportPdf').value = '1';

document.getElementById("formulaire").submit();
}

function genPDF1() {
document.getElementById('exportPdf').value = '2';

document.getElementById("formulaire").submit();
}

</script>




@endsection
