@extends('app')
@section('content')

<section class="content-header">

    <h1>
        Ajouter un inventaire
    </h1>

</section>



<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAddSuccess'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddSuccess') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif


    @if(Session::has('msgAddExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
                <!-- fin messages -->

        <!-- Default box -->
        <div class="box">
            <div class="panel-body">
                <div class="col-sm-12">

                    {!! Form::open(['method'=>'POST','action' => ['InventaireController@postForm']]) !!}
                    <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="col-lg-4 col-md-4 col-sm-6">
                    <label class="col-sm-8 control-label" style="margin-top: 10px">
                        N° inventaire
                    </label>
                    </div>
                    <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                        <input type="text"  class="form-control" name="numInventaire" placeholder="Numéro d'inventaire" required readonly value="{{$NumInventaire}}">
                    </div>
                        </div>
                    <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="col-lg-4 col-md-4 col-sm-6">
                    <label class="col-sm-8 control-label"  style="margin-top: 10px">
                        Désignation  inventaire
                    </label>
                    </div>
                    <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                            <input type="text"  class="form-control" name="designation" placeholder="Désignation inventaire" required value="{{old('designation')}}">
                    </div>
                        </div>

                    <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="col-lg-4 col-md-4 col-sm-6">
                    <label class="col-sm-8 control-label"  style="margin-top: 10px">
                        Date début d’inventaire
                    </label>
                    </div>
                    <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                        <input type="date"  class="form-control" name="dateDebut"  required @if(old('dateDebut')) value="{{old('dateDebut')}}" @else value="{{$dateToday}}" @endif   >
                    </div>
                        </div>
                    <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="col-lg-4 col-md-4 col-sm-6">
                    <label class="col-sm-8 control-label"  style="margin-top: 10px">
                        Type d’ inventaire
                    </label>
                    </div>
                    <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                        <select id="idSelectType"   name="idSelectType"  class="form-control" required="required" onchange="affichage()">
                            <option selected disabled value="">Sélectionner le type d'inventaire ...</option>
                            <option  value="0">Inventaire total</option>
                            <option  value="1">Inventaire par zone</option>
                            <option  value="2">Inventaire par emplacement</option>
                            <!--<option  value="3">Inventaire par Entité</option>-->
                            <option  value="4">Inventaire par N°UE</option>
                        </select>
                    </div>
                        </div>
                    <div class="col-lg-12 col-md-12 col-sm-12">
                      <div id="zone" class="hidden">
                    <div class="col-lg-4 col-md-4 col-sm-6">
                    <label class="col-sm-8 control-label"  style="margin-top: 10px">
                       Zone
                    </label>
                    </div>
                    <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                        <select id="idSelectZone"   name="idSelectZone"  class="form-control"  >
                            <option selected disabled value="">Sélectionner une zone ...</option>
                            @foreach($zones as $zone)
                                <option value="{{$zone->id_zone}}" > {{$zone->libelle}} </option>
                            @endforeach
                        </select>
                    </div>
                      </div>
                        </div>
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div id="emplacement" class="hidden">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label class="col-sm-8 control-label"  style="margin-top: 10px">
                                Emplacement
                            </label>
                        </div>
                        <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                            <select id="idSelectEmplacement"   name="idSelectEmplacement"  class="form-control" >
                                <option selected disabled value="">Sélectionner un emplacement ...</option>
                                @foreach($emplacements as $emplacement)
                                    <option value="{{$emplacement->id_emplacement}}" > {{$emplacement->libelle}} </option>
                                @endforeach
                            </select>
                        </div>
                        </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12">
                        <div id="entite" class="hidden">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label class="col-sm-8 control-label"  style="margin-top: 10px">
                                Entité
                            </label>
                        </div>
                        <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                            <select id="numero_entite"   name="numero_entite"  class="form-control selectpicker" data-live-search="true" >
                                <option selected disabled value="" style="background-color: white">Sélectionner un Entité ...</option>
                                @foreach($entites as $entite)
                                    <option value="{{$entite->num_entite}}" > {{$entite->num_entite}} </option>
                                @endforeach
                            </select>
                        </div>
                        </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12">
                        <div id="ue" class="hidden">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label class="col-sm-8 control-label"  style="margin-top: 10px">
                                N°UE
                            </label>
                        </div>
                        <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                            <select id="idSelectUe"   name="numero_ue"  class="form-control selectpicker pickUE" data-live-search="true" >
                                <option selected disabled value="" style="background-color: white">Sélectionner un N°UE ...</option>
                                
                            </select>
                        </div>
                        </div>
                        </div>

                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label class="col-sm-8 control-label"  style="margin-top: 10px">
                                Statut
                            </label>
                        </div>
                        <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                                <input type="text"  class="form-control" name="statut"   value="En cours" readonly>
                        </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label class="col-sm-8 control-label"  style="margin-top: 10px">
                                Commentaire
                            </label>
                        </div>

                        <div class="col-lg-6 col-md-4 col-sm-6" style="margin-top: 10px">
                            <input class="form-control" name="commentaire"  placeholder="Commentaire"  value="{{old('commentaire')}}">
                        </div>

                    </div>

                    </br>
                    </br>



                        <input class="btn btn-flat btn-primary pull-right" type="submit" value="Valider" style="margin-top: 15px">
                        <a href="{{url('inventaire/index')}}" class="btn btn-flat btn-danger pull-right" style="margin-top: 15px">Annuler</a>


                    {!! Form::close() !!}

                </div>
            </div>
        </div><!-- /.box -->
</section><!-- /.content -->


<script>


    function affichage(){
        var select=document.getElementById('idSelectType').value ;
        if(select == 0)
        {
            document.getElementById('emplacement').className = "hidden";
            document.getElementById('idSelectEmplacement').required=false;
            document.getElementById('zone').className = "hidden";
            document.getElementById('idSelectZone').required=false;

            document.getElementById('entite').className = "hidden";
            document.getElementById('numero_entite').required=false;
            document.getElementById('ue').className = "hidden";
            document.getElementById('idSelectUe').required=false;
        }
        if(select == 1)
        {
            document.getElementById('zone').className = "";
            document.getElementById('idSelectZone').required="required";
            document.getElementById('emplacement').className = "hidden";
            document.getElementById('idSelectEmplacement').required=false;

            document.getElementById('entite').className = "hidden";
            document.getElementById('numero_entite').required=false;
            document.getElementById('ue').className = "hidden";
            document.getElementById('idSelectUe').required=false;
        }
        if(select == 2)
        {
            document.getElementById('emplacement').className = "";
            document.getElementById('idSelectEmplacement').required="required";
            document.getElementById('zone').className = "hidden";
            document.getElementById('idSelectZone').required=false;

            document.getElementById('entite').className = "hidden";
            document.getElementById('numero_entite').required=false;
            document.getElementById('ue').className = "hidden";
            document.getElementById('idSelectUe').required=false;

        }
        if(select == 3)
        {
            document.getElementById('emplacement').className = "hidden";
            document.getElementById('idSelectEmplacement').required=false;
            document.getElementById('zone').className = "hidden";
            document.getElementById('idSelectZone').required=false;

            document.getElementById('entite').className = "";
            document.getElementById('numero_entite').required="required";
            document.getElementById('ue').className = "hidden";
            document.getElementById('idSelectUe').required=false;

        }
        if(select == 4)
        {
            document.getElementById('emplacement').className = "hidden";
            document.getElementById('idSelectEmplacement').required=false;
            document.getElementById('zone').className = "hidden";
            document.getElementById('idSelectZone').required=false;

            document.getElementById('entite').className = "hidden";
            document.getElementById('numero_entite').required=false;
            document.getElementById('ue').className = "";
            document.getElementById('idSelectUe').required="required";


        }


    }




</script>



@endsection