@extends('app')
@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">


        @if(session()->has('msg'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em> {!! session()->get('msg') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif

        @if(Session::has('flash_message'))
            <div class="alerte alert_success">
                {{Session::get('flash_message')}}
            </div>
        @endif
        <h1>
            Historique des actions
        </h1>

        <!--
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
          <li><a href="#">Examples</a></li>
          <li class="active">Blank page</li>
        </ol>
        -->
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Default box -->
        <div class="box">
            <div class="box-body">


<form method="get" action="{{ route('rechercheHisto') }}">

                
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" @if (isset($mot_a_rechercher))
                        value="{{ $mot_a_rechercher }}"
                    @endif>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
                
            </div><br>
            </form>
                <table id="" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                        <th class="text-center">Action</th>
                        <th class="text-center">Table</th>
                        <th class="text-center">Description</th>
                        <th class="text-center">Utilisateur</th>
                        <th class="text-center">Date</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($HistoriqueActions as $HistoriqueAction)
                            <tr>
                                <td class="text-center">{{$HistoriqueAction->type_action}}</td>
                                <td class="text-center">{{$HistoriqueAction->nom_table}}</td>
                                <td class="text-center">{{$HistoriqueAction->description}}</td>
                                <td class="text-center">{{$HistoriqueAction->nom_user}}</td>
                                <td class="text-center">{{$HistoriqueAction->date}}</td>

                            </tr>


                    @endforeach

                    </tbody>
                </table>
                <p >Affichage de l'élement {{($HistoriqueActions->currentPage()-1)* $HistoriqueActions->perPage()+($HistoriqueActions->total() ? 1:0)}} à {{($HistoriqueActions->currentPage()-1)*$HistoriqueActions->perPage()+count($HistoriqueActions)}}  sur  {{$HistoriqueActions->total()}} éléments</p>
            <span class="pull-right">{{ $HistoriqueActions->links() }}</span>



            </div><!-- /.box-body -->
        </div><!-- /.box -->
    </section><!-- /.content -->
    <script>


    </script>


@endsection