@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('FOURNISSEURS_LISTE_AJOUTER'))

    <div class="box-tools pull-right">
        <a href="{{ url('fournisseur/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    @endif

    <h1>
        Gestion des fournisseurs
    </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDeleteOk'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDeleteOk') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif


        @if(Session::has('msgAddSuccess'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgAddSuccess') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif


    @if(Session::has('msgDeleteNotOk'))
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgDeleteNotOk') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
            @endif
                <!-- Default box -->
        <div class="box">

            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">Société</th>
                    <th class="text-center sorting_asc">Contact</th>
                    <th class="text-center sorting_asc">Email</th>
                    <th class="text-center sorting_asc">page d'accueil</th>
                    @if(Session::get('FOURNISSEURS_LISTE_DETAIL'))
                    <th class="text-center sorting_asc">Détail</th>
                    @endif
                    @if(Session::get('FOURNISSEURS_LISTE_MODIFIER'))

                    <th class="text-center sorting_asc">Modifier</th>
                    @endif
                    @if(Session::get('FOURNISSEURS_LISTE_SUPPRIMER'))

                    <th class="text-center sorting_asc">Supprimer</th>
                        @endif
                </tr>
                </thead>

                <tbody>
                @foreach( $fournisseurs as $fournisseur)
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{!!$fournisseur->societe!!}</td>
                        <td class="text-center sorting_1">{!!$fournisseur->contact!!}</td>
                        <td class="text-center sorting_1">{!!$fournisseur->email!!}</td>
                        <td class="text-center sorting_1">{!!$fournisseur->page_accueil!!}</td>
                        @if(Session::get('FOURNISSEURS_LISTE_DETAIL'))
                        <td class="text-center sorting_1">
                            <a href="#show{{$fournisseur->id_fournisseur}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                            </a>
                        </td>
                        @endif
                        @if(Session::get('FOURNISSEURS_LISTE_MODIFIER'))

                        <td class="text-center sorting_asc">
                            <a href="{{url('fournisseur/modifier')}}/{{$fournisseur->id_fournisseur}}" class="glyphicon glyphicon-edit">

                            </a>
                        </td >
                        @endif
                        @if(Session::get('FOURNISSEURS_LISTE_SUPPRIMER'))

                        <td class="text-center sorting_asc">
                            <a href="#DeleteModal{{$fournisseur->id_fournisseur}}" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                        </td>
                            @endif
                    </tr>
                    <!--

                    <tr role="row" class="odd">
                        <td class="sorting_1">Gecko</td>
                        <td>Firefox 1.0</td>
                        <td>Win 98+ / OSX.2+</td>
                        <td>1.7</td>
                        <td>A</td>
                        <td>A</td>
                        <td>A</td>
                    </tr>
                    -->
                    <div class="example-modal" >
                        <div class="modal" id="show{{$fournisseur->id_fournisseur}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;">Détail du fournisseur</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p><label>Société : </label>  {!!$fournisseur->societe!!}</p>
                                        <p> <label>Contact : </label> {!!$fournisseur->contact!!}</p>
                                        <p> <label>Fonction: </label> {!!$fournisseur->fonction!!}</p>
                                        <p> <label>Adresse : </label> {!!$fournisseur->adresse_complet!!}</p>
                                        <p> <label>Téléphone : </label> {!!$fournisseur->telephone!!}</p>
                                        <p> <label>Fax : </label> {!!$fournisseur->fax!!}</p>
                                        <p> <label>Email : </label> {!!$fournisseur->email!!}</p>
                                        <p> <label>Page d'accueil : </label> {!!$fournisseur->page_accueil!!}</p>
                                        <!--<p> <label>Profil : </label> admin</p>-->

                                        <!--   -->
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal">Fermer</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$fournisseur->id_fournisseur}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce fournisseur " {{$fournisseur->contact}} " de la société " {{$fournisseur->societe}} " ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['FournisseurController@delete',$fournisseur->id_fournisseur]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                @endforeach
                </tbody>

            </table>


        </div><!-- /.box -->
</section><!-- /.content -->






@endsection