@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">

    <h1>
        Ajouter un fournisseur
    </h1>

    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>



<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAddSuccess'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddSuccess') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif


    @if(Session::has('msgAddExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
                <!-- fin messages -->

        <!-- Default box -->
        <div class="box">
            <div class="panel-body">
                <div class="col-sm-12">

                    {!! Form::open(['method'=>'POST','action' => ['FournisseurController@postForm']]) !!}


                    <table>
                        <tbody>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Société
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="societe" placeholder="Société" required value="{{old('societe')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Contact
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="contact" placeholder="Contact" required value="{{old('contact')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Fonction
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="fonction" placeholder="Fonction" required value="{{old('fonction')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Adresse
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="adresse" placeholder="Adresse" required value="{{old('adresse')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Wilaya
                                </label>
                                <div class="col-sm-6">
                                    <select id="idSelectWilaya" class="form-control "  name="wilaya" onchange="getCommune(this.value)" required="required">
                                        <option selected disabled value="" style="background-color: white">Sélectionner la wilaya ...</option>
                                        @foreach($wilayas as $wilaya)
                                            <option value="{{$wilaya->id_wilaya}}" >@if($wilaya->id_wilaya < 10 ) 0{{$wilaya->id_wilaya}} @else {{$wilaya->id_wilaya}} @endif - {{$wilaya->nom_wilaya}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Commune
                                </label>
                                <div class="col-sm-6">
                                    <select id="idSelectCommune" class="form-control " name="commune" required="required">
                                        <option selected disabled value="" style="background-color: white">Sélectionner la commune ...</option>
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Téléphone
                                </label>
                                <div class="col-sm-6">
                                    <input type="number"  class="form-control" name="telephone" placeholder="Téléphone" required value="{{old('telephone')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Fax
                                </label>
                                <div class="col-sm-6">
                                    <input type="number"  class="form-control" name="fax" placeholder="Fax"  value="{{old('fax')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Email
                                </label>
                                <div class="col-sm-6">
                                    <input type="email" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" title="exemple@email.com"   class="form-control" name="email" placeholder="Email" required value="{{old('email')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Page d'accueil
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="page_accueil" placeholder="Page d'accueil"  value="{{old('page_accueil')}}">
                                </div>
                            </td>
                        </tr>

                        </tbody>
                    </table>
                    </br>
                    </br>



                    <input class="btn btn-flat btn-primary pull-right" type="submit" value="Valider">
                    <a href="{{url('fournisseur/index')}}" class="btn btn-flat btn-danger pull-right">Annuler</a>

                    {!! Form::close() !!}

                </div>
            </div>
        </div><!-- /.box -->
</section><!-- /.content -->


<script>
    function getCommune(id_wilaya){

        var nom = document.getElementById("idSelectWilaya");
        $.get("{{url('fournisseur/communes?ID=')}}"+id_wilaya, function(res,stat){
            var select1 = document.getElementById("idSelectCommune");
            // var nom= document.getElementById("input3");


            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value=''>Sélectionner la commune ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_commune+"'> "+res[i].nom_commune+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }


        });
    }

</script>



@endsection