@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">

    <h1>
        Ajouter un nounvel emplacement de stockage
    </h1>

    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>






<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgLib'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgLib') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box">
            <div class="panel-body">
                <div class="col-sm-12">

                    {!! Form::open(['method'=>'POST','action' => ['EmplacementController@postForm']]) !!}


                    <table>
                        <tbody>
                            <tr style="height:50px">
                                <td class="col-sm-4">
                                    <label class="col-sm-4 control-label">
                                        Libellé de l'emplacement
                                    </label>
                                    <div class="col-sm-6">
                                        <input type="text"  class="form-control" name="libelle" placeholder="" required value="{{old('libelle')}}">
                                    </div>
                                </td>
                            </tr>
                            <tr style="height:50px">
                                <td class="col-sm-4">
                                    <label class="col-sm-4 control-label">
                                        Code à barres de l'emplacement
                                    </label>
                                    <div class="col-sm-6">
                                        <input type="text"  class="form-control" name="code" placeholder="" required value="{{old('code')}}">
                                    </div>
                                </td>
                            </tr>
                            <tr style="height:50px">
                                <td class="col-sm-4">
                                    <label class="col-sm-4 control-label">
                                        Remarque
                                    </label>
                                    <div class="col-sm-6">
                                        <input type="text"  class="form-control" name="description" placeholder="" value="{{old('description')}}">
                                    </div>
                                </td>
                            </tr>

                            <tr style="height:50px">
                                <td class="col-sm-4">
                                    <label class="col-sm-4 control-label">
                                        La zone de l'emplacement
                                    </label>
                                    <div class="col-sm-6">
                                        <select class="form-control" name="zone" required="required">
                                            <option selected disabled value="" style="background-color: white">Sélectionner la zone de l'emplacement...</option>
                                            @foreach($zones as $zone)
                                                <option value="{{$zone->id_zone}}" >{{$zone->libelle}} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </td>
                            </tr>


                            <tr style="height:50px">
                                <td class="col-sm-4">
                                    <label class="col-sm-4 control-label">
                                        Volume max (m³)
                                    </label>
                                    <div class="col-sm-6">
                                        <input type="number" step="0.01"  class="form-control" name="volumeMax" placeholder="" value="{{old('volumeMax')}}" required>
                                    </div>
                                </td>
                            </tr>
                            @if(Session::get('CHARGEMENT')=='1')

                                <tr style="height:50px">
                                <td class="col-sm-4">
                                    <label class="col-sm-4 control-label">Véhicule :</label>
                                    <div class="col-sm-6">
                                        <label>NON </label>
                                        <input type="radio" name="vehicule"   value="NON"   checked="checked" />
                                        <label>OUI </label>
                                        <input type="radio" name="vehicule"  value="OUI"  />
                                    </div>
                                </td>

                            </tr>
                                @endif





                        </tbody>
                    </table>
                    </br>
                    </br>


                    <input class="btn btn-flat btn-primary pull-right" type="submit" value="Valider">
                    <a href="{{url('emplacement/index')}}" class="btn btn-flat btn-danger pull-right">Annuler</a>


                    {!! Form::close() !!}

                </div>
            </div>









        </div><!-- /.box -->
</section><!-- /.content -->



@endsection