@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('CONFIGURATION_FRONT_OFFICE_AJOUTER'))

    <div class="box-tools pull-right">
        <a href="{{url('profil/mobile/ajouter')}}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    @endif

    <h1>
        Gestion des profils front office
    </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDeleteOk'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDeleteOk') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif


        @if(Session::has('msgAddSuccess'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgAddSuccess') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif


    @if(Session::has('msgDeleteNotOk'))
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgDeleteNotOk') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
            @endif
                <!-- Default box -->
        <div class="box">

            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N°</th>
                    <th class="text-center sorting_asc">Libellé</th>
                    @if(Session::get('CONFIGURATION_FRONT_OFFICE_DETAIL'))
                    <th class="text-center sorting_asc">Détail</th>
                    @endif
                    @if(Session::get('CONFIGURATION_FRONT_OFFICE_MODIFIER'))

                    <th class="text-center sorting_asc">Modifier</th>
                    @endif
                    @if(Session::get('CONFIGURATION_FRONT_OFFICE_SUPPRIMER'))

                    <th class="text-center sorting_asc">Supprimer</th>
                        @endif
                </tr>
                </thead>

                <tbody>

                @foreach($profiles as $profile)

                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{{$profile->id}}</td>
                        <td class="text-center sorting_1">	{{$profile->libelle}}</td>
                        @if(Session::get('CONFIGURATION_FRONT_OFFICE_DETAIL'))
                        <td class="text-center sorting_1">
                            <a href="#detail{!!$profile->id!!}" data-toggle="modal" class="use-address delete" >
                                <i class="fa fa-info-circle" id="datail" style="font-size: 1.5em; color: #1A82C3"></i>
                            </a>
                        </td>
                        @endif
                        @if(Session::get('CONFIGURATION_FRONT_OFFICE_MODIFIER'))

                        <td class="text-center sorting_asc">
                            @if($profile->default_profil != 1)

                            <a href="{{url('profil/mobile/modifier/'.$profile->id)}}" data-toggle="modal" class="use-address delete" >
                                <i class="fa fa-pencil-square-o" style="color:#26B99A ;font-size: 1.5em; align-content: center"></i>
                            </a>
                            @endif

                        </td >
                        @endif
                        @if(Session::get('CONFIGURATION_FRONT_OFFICE_SUPPRIMER'))

                        <td class="text-center sorting_asc">
                            @if($profile->default_profil != 1)
                                <a href="#DeleteModal{!!$profile->id!!}" data-toggle="modal" class="use-address delete" >
                                    <i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>
                                </a>
                            @endif
                        </td>
                            @endif
                    </tr>
                    <!--

                    <tr role="row" class="odd">
                        <td class="sorting_1">Gecko</td>
                        <td>Firefox 1.0</td>
                        <td>Win 98+ / OSX.2+</td>
                        <td>1.7</td>
                        <td>A</td>
                        <td>A</td>
                        <td>A</td>
                    </tr>
                    -->
                    @if(Session::get('CONFIGURATION_FRONT_OFFICE_SUPPRIMER'))
                            <!-- Delete Modal -->
                    <div class="modal fade" id="DeleteModal{!!$profile->id!!}">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h3 class="modal-title">Confirmation</h3>
                                </div>
                                <div class="modal-body">
                                    <div ><b id="name">Voulez-vous vraiment supprimer de ce profil ?</b></div>
                                </div>
                                <div class="modal-footer" id="modal-footer-delete">

                                    {!! Form::open(['method'=>'POST','action' => ['GestionProfilMobileController@supprimer',$profile->id]]) !!}
                                    <div>
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                        <button type="submit" class="btn btn-primary">Valider</button>
                                    </div>
                                    {!! Form::close() !!}
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    @endif

                            <!-- Delete Modal -->
                    <div class="modal fade" id="detail{!!$profile->id!!}">
                        <div class="modal-dialog modal-sm">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h3 class="modal-title">Détail</h3>
                                </div>
                                <div class="modal-body col-lg-offset-1 col-md-offset-1 col-sm-offset-1 col-xs-offset-1">
                                    @foreach($profile->DroitAccesMobile as $droit)
                                        <?php
                                        switch ($droit->action){
                                        case "RECEPTION": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Réception'); break;
                                        case "PREPARATION": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Préparation'); break;
                                        case "CHARGEMENT": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Chargement'); break;
                                        case "INVENTAIRE": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Inventaire'); break;
                                        case "ENTREPOT": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Entrepôt'); break;
                                        case "ENTREPOT_PRODUITS": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Produits'); break;
                                        case "ENTREPOT_EMPLACEMENTS": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Emplacements'); break;
                                        case "ENTREPOT_TRANSFERT": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Transfert'); break;
                                        case "SYNCHRONISATION": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Synchronisation'); break;
                                        case "ENTREPOT_PRODUCTION": if($droit->droit == 1) echo('<i class="fa fa-check" style="color:#00A000 ;font-size: 1.5em; align-content: center"></i>'); else echo ('<i class="fa fa-times" style="color:#ff2918 ;font-size: 1.5em; align-content: center"></i>'); echo (' Production'); break;
                                        }
                                        ?>
                                        <br>
                                    @endforeach
                                </div>
                                <div class="modal-footer" id="modal-footer-delete">

                                    <div>
                                        <button type="submit" class="btn btn-primary" data-dismiss="modal">Fermer</button>
                                    </div>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->



                @endforeach
                </tbody>

            </table>


        </div><!-- /.box -->
</section><!-- /.content -->






@endsection