@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('FOURNISSEURS_COMMANDES_AJOUTER'))

    <div class="box-tools pull-right">
        <a href="{{ url('commande_fournisseur/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
@endif
    <h1>
        Gestion des commandes fournisseur
    </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDelete'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDelete') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgSupprimer'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgSupprimer') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

        @if(Session::has('msgAjouter'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAjouter') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
                <!-- Default box -->
        <div class="box">

            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N° Commande</th>
                    <th class="text-center sorting_asc">Date commande</th>
                    <th class="text-center sorting_asc">Fournisseur</th>
                    <th class="text-center sorting_asc">Total HT</th>
                    <th class="text-center sorting_asc">Total TTC</th>
                    <th class="text-center sorting_asc">Etat de la commande</th>
                    @if(Session::get('FOURNISSEURS_COMMANDES_DETAIL'))
                    <th class="text-center sorting_asc">Détail</th>
                    @endif
                    @if(Session::get('FOURNISSEURS_COMMANDES_MODIFIER'))

                    <th class="text-center sorting_asc">Modifier</th>
                    @endif
                    @if(Session::get('FOURNISSEURS_COMMANDES_SUPPRIMER'))

                    <th class="text-center sorting_asc">Annuler</th>
                        @endif
                </tr>
                </thead>

                <tbody>
                @foreach( $commandes_fournisseurs as $commande_fournisseur)
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{!!$commande_fournisseur->num_commande_fournisseur!!}</td>
                        <td class="text-center sorting_1">{!!$commande_fournisseur->date_creation!!}</td>
                        <td class="text-center sorting_1">{!!$commande_fournisseur->fournisseur->societe!!}</td>
                        <td class="text-center sorting_1">{!!number_format($commande_fournisseur->total_prix_ht,2)!!}</td>
                        <td class="text-center sorting_1">{!!number_format($commande_fournisseur->total_prix_ttc,2)!!}</td>
                        <td class="text-center sorting_1">{!!$commande_fournisseur->etat!!}</td>
                        @if(Session::get('FOURNISSEURS_COMMANDES_DETAIL'))
                        <td class="text-center sorting_1">
                            <a href="{{url('commande_fournisseur/detail')}}/{{$commande_fournisseur->id_commande_fournisseur}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                            </a>
                        </td>
                        @endif
                        @if(Session::get('FOURNISSEURS_COMMANDES_MODIFIER'))

                        <td class="text-center sorting_asc">
                            @if($commande_fournisseur->etat!="Réceptionnée")

                            <a href="{{url('commande_fournisseur/modifier')}}/{{$commande_fournisseur->id_commande_fournisseur}}" class="glyphicon glyphicon-edit">

                            </a>
                            @endif
                        </td >

                        @endif
                        @if(Session::get('FOURNISSEURS_COMMANDES_SUPPRIMER'))

                        <td class="text-center sorting_asc">
                            @if($commande_fournisseur->etat!="Réceptionnée")

                            <a href="#DeleteModal{{$commande_fournisseur->id_commande_fournisseur}}" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                            @endif

                        </td>
                            @endif
                    </tr>

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$commande_fournisseur->id_commande_fournisseur}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer cette commande fournisseur ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['CommandeFournisseurController@delete',$commande_fournisseur->id_commande_fournisseur]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                @endforeach
                </tbody>

            </table>


        </div><!-- /.box -->
</section><!-- /.content -->






@endsection