@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Détail de la commande fournisseur
    </h1>

</section>






<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                <div class="form-group">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° Commande fournisseur : </label>
                            <input type="text" class="form-control" name="num_commande_fournisseur" placeholder="Société" required value="{{$commande_fournisseur->num_commande_fournisseur}}" readonly>
                        </div>
                    </div>


                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Fournisseur : </label>
                            <select id="idSelecFournisseur" class="form-control" onchange="getFournisseur(this.value)" name="fournisseur" required="required" readonly>
                                <option selected disabled value="">Sélectionner le fournisseur ...</option>
                                @foreach($fournisseurs as $fournisseur)
                                    <option value="{{$fournisseur->id_fournisseur}}" @if($fournisseur->id_fournisseur == $commande_fournisseur->fournisseur->id_fournisseur) selected @endif> {{$fournisseur->societe}} </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Contact fournisseur :</label>
                            <input type="text" class="form-control" id="contact_Fournisseur" name="contact_Fournisseur" placeholder="Contact fournisseur" value ="{{$commande_fournisseur->fournisseur->contact}}" required readonly >
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Adresse : </label>
                            <input type="text" class="form-control" id="adresse_Fournisseur" name="adresse_Fournisseur" placeholder="Adresse" value="{{$commande_fournisseur->fournisseur->adresse_complet}}" required readonly >
                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Date de création : </label>
                            <input type="date" class="form-control" name="date_creation" value="{{$commande_fournisseur->date_creation}}" required readonly>

                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Statut : </label>
                            <select id="idSelecStatut" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="statut" required="required" readonly>
                                @foreach($statuts as $statut)
                                    <option value="{{$statut->valeur}}" @if($statut->valeur == $commande_fournisseur->etat) selected @endif > {{$statut->valeur}} </option>
                                @endforeach
                            </select>
                            <br>

                        </div>

                    </div>

                </div>


                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="table-responsive">
                        <table id="example1" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">Référence produit</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Quantité</th>
                                <th class="text-center sorting_asc">TVA (%)</th>
                                <th class="text-center sorting_asc">Prix Unitaire H.T</th>
                                <th class="text-center sorting_asc">Prix Unitaire T.T.C</th>
                                <th class="text-center sorting_asc">Quantité réceptionnée</th>
                                <th class="text-center sorting_asc">Reste à recevoir</th>
                                <th class="text-center sorting_asc">Totale H.T</th>
                                <th class="text-center sorting_asc">Totale T.T.C</th>

                            </tr>
                            </thead>

                            <tbody>


                            <?php

                            $total_ht = 0;
                            $total_ttc = 0;

                            ?>

                            @foreach( $lignescommande as $ligne)
                                <tr role="row" class="odd">
                                    <td class="text-center sorting_1">{!!$ligne->produit->reference!!}</td>
                                    <td class="text-center sorting_1">{!!$ligne->produit->designation!!}</td>
                                    <td class="text-center sorting_1">{!!(float)$ligne->quantite_commander!!}</td>
                                    <td class="text-center sorting_1">{!!(float)$ligne->tva!!}</td>
                                    <td class="text-center sorting_1">{!!number_format($ligne->prix_ht,2)!!}</td>
                                    <td class="text-center sorting_1">{!!number_format($ligne->prix_ttc,2)!!}</td>
                                    <td class="text-center sorting_1">{!!(float)$ligne->quantite_receptionner!!}</td>
                                    <td class="text-center sorting_1">{!!(float)($ligne->quantite_commander - $ligne->quantite_receptionner)!!}</td>
                                    <td class="text-center sorting_1">{!!number_format($ligne->total_prix_ht,2)!!}</td>
                                    <td class="text-center sorting_1">{!!number_format($ligne->total_prix_ttc,2)!!}</td>

                                </tr>

                                <?php

                                $total_ttc +=  $ligne->total_prix_ttc;
                                $total_ht +=   $ligne->total_prix_ht;

                                ?>
                            @endforeach

                            </tbody>
                        </table>
                    </div>


                    <div class="col-lg-12" >

                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >

                            <label> Total TTC </label>
                            <input type="text" class="form-control col-lg-1" readonly  value="{!!number_format($total_ttc,2)!!}">
                            <input type="text" readonly class="hidden" name="total_ttc" value="{!!$total_ttc!!}">
                        </div>

                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >
                            <label> TVA </label>
                            <input type="text" class="form-control col-lg-1" readonly name="total_tva" value="{!!number_format(($total_ttc-$total_ht),2)!!}">
                        </div>
                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >
                            <label> Total HT </label>
                            <input type="text" class="form-control col-lg-1" readonly value="{!!number_format($total_ht,2)!!}">
                            <input type="text" class="hidden" readonly name="total_ht" value="{!!$total_ht!!}">

                        </div>
                    </div>

                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">
                    <a href="{{url('commande_fournisseur/index')}}" class="btn btn-default pull-right" data-dismiss="modal">Retour</a>
                </div>
            </div>
        </div><!-- /.box -->


        <!--  POPUP pour ajout produit  -->
        <div cl1ass="example-modal" >
            <div class="modal" id="ajouterLigneCommandeFournisseur">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" style="font-family:verdana;">Ajout produit</h4>
                        </div>
                        <div class="modal-body">
                            <div class="col-lg-12">
                                <div class="col-lg-6">
                                    <label>Produit </label>
                                    <select id="idSelecReference" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="produit" required="required">
                                        <option value="">Sélectionner le produit</option>
                                        @foreach($produits as $produit)
                                            <option value="{{$produit->id_produit}}" > {{$produit->reference}} -- {{$produit->designation}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label>T.V.A</label>
                                    <input type="number" class="form-control" id="tva0" name="tva" placeholder="TVA" step="0.01" required onchange="calcule(0)" onkeyup="calcule(0)" >
                                </div>
                                <div class="form-group col-lg-6">
                                    <label>Prix Unitaire H.T</label>
                                    <input type="number" class="form-control" id="prix_unitaire_ht0" name="prix_unitaire_ht" onchange="calcule(0)" onkeyup="calcule(0)" placeholder="Prix Unitaire H.T" required step="0.01" >
                                </div>
                            </div>


                            <div class="col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label>Quantité</label>
                                    <input type="number" step="0.01" class="form-control" id="quantite0" name="quantite" placeholder="Quantité" onchange="calcule(0)" onkeyup="calcule(0)" required  >
                                </div>
                                <div class="form-group col-lg-6">
                                    <label>Prix Uniaire T.T.C</label>
                                    <input type="number" class="form-control" id="prix_unitaire_ttc0" name="prix_unitaire_ttc" step="0.01" onchange="calcule(0)" onkeyup="calcule(0)" placeholder="Prix Uniaire TTC" required  >
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label>Totale H.T</label>
                                    <input type="number" class="form-control" id="totale_ht0" name="totale_ht" placeholder="Totale H.T" required readonly >
                                </div>
                                <div class="form-group col-lg-6">
                                    <label>Totale TTC</label>
                                    <input type="number" class="form-control" id="totale_ttc0" name="totale_ttc" placeholder="Totale TTC" required readonly >
                                    <br>
                                </div>
                            </div>
                        </div>

                        <div class="hidden">

                            <input type="text" id="idFournisseur" name="idFournisseur" value="{{Session::get('idFournisseur')}}">
                            <input type="text" id="contactFounisseur" name="contactFounisseur" value="{{Session::get('contactFounisseur')}}">
                            <input type="text" id="adresseFournisseur" name="adresseFournisseur" value="{{Session::get('adresseFournisseur')}}">

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">Valider</button>
                        </div>

                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
        </div>



        @foreach($lignescommande as $ligne)

            <div cl1ass="example-modal" >
                <div class="modal" id="edite{{$ligne->id_ligne_commande_fournisseur}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;">Modifier produit</h4>
                            </div>
                            <div class="modal-body">
                                <div class="col-lg-12">
                                    <div class="col-lg-6">
                                        <label>Produit </label>
                                        <select id="idSelecReference" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="produit" required="required">
                                            <option value="">Sélectionner le produit</option>
                                            @foreach($produits as $produit)
                                                <option value="{{$produit->id_produit}}" @if($produit->id_produit == $ligne->id_produit) selected @endif> {{$produit->reference}} -- {{$produit->designation}} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-6">
                                        <label>T.V.A</label>
                                        <input type="number" class="form-control" id="tva{{$ligne->id_ligne_commande_fournisseur}}" name="tva" placeholder="TVA" step="1" value="{{$ligne->tva}}" required onchange="calcule({{$ligne->id_ligne_commande_fournisseur}})" onkeyup="calcule({{$ligne->id_ligne_commande_fournisseur}})" >
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label>Prix Unitaire H.T</label>
                                        <input type="number" class="form-control" id="prix_unitaire_ht{{$ligne->id_ligne_commande_fournisseur}}" name="prix_unitaire_ht" value="{{$ligne->prix_ht}}" onchange="calcule({{$ligne->id_ligne_commande_fournisseur}})" onkeyup="calcule({{$ligne->id_ligne_commande_fournisseur}})" placeholder="Prix Unitaire H.T" required  >
                                    </div>
                                </div>


                                <div class="col-lg-12">
                                    <div class="form-group col-lg-6">
                                        <label>Quantité</label>
                                        <input type="number" class="form-control" id="quantite{{$ligne->id_ligne_commande_fournisseur}}" name="quantite" placeholder="Quantité" value="{{$ligne->quantite_commander}}" onchange="calcule({{$ligne->id_ligne_commande_fournisseur}})" onkeyup="calcule({{$ligne->id_ligne_commande_fournisseur}})" required  >
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label>Prix Uniaire T.T.C</label>
                                        <input type="number" class="form-control" id="prix_unitaire_ttc{{$ligne->id_ligne_commande_fournisseur}}" name="prix_unitaire_ttc" step="0.01" value="{{$ligne->prix_ttc}}" onchange="calcule({{$ligne->id_ligne_commande_fournisseur}})" onkeyup="calcule({{$ligne->id_ligne_commande_fournisseur}})" placeholder="Prix Uniaire TTC" required  >
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group col-lg-6">
                                        <label>Totale H.T</label>
                                        <input type="number" class="form-control" id="totale_ht{{$ligne->id_ligne_commande_fournisseur}}" name="totale_ht"  value="{{$ligne->total_prix_ht}}" placeholder="Totale H.T" required readonly >
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label>Totale TTC</label>
                                        <input type="number" class="form-control" id="totale_ttc{{$ligne->id_ligne_commande_fournisseur}}" name="totale_ttc" value="{{$ligne->total_prix_ttc}}" placeholder="Totale TTC" required readonly >
                                        <br>
                                    </div>
                                </div>
                            </div>

                            <div class="hidden">

                                <input type="text" id="idFournisseur{{$ligne->id_ligne_commande_fournisseur}}" name="idFournisseur" value="{{Session::get('idFournisseur')}}">
                                <input type="text" id="contactFounisseur{{$ligne->id_ligne_commande_fournisseur}}" name="contactFounisseur"  value="{{Session::get('contactFounisseur')}}">
                                <input type="text" id="adresseFournisseur{{$ligne->id_ligne_commande_fournisseur}}" name="adresseFournisseur"  value="{{Session::get('adresseFournisseur')}}">

                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>

                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>


            <div class="example-modal">
                <div class="modal" id="DeleteModal{{$ligne->id_ligne_commande_fournisseur}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                            </div>
                            <div class="modal-body">
                                <p>Voulez-vous vraiment supprimer ce produit de la commande ?</p>
                            </div>

                            <div class="modal-footer">
                                <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>

        @endforeach




</section><!-- /.content -->






<script>
    function getFournisseur(id_fournisseur){

        var nom = document.getElementById("idSelecFournisseur");
        $.get("{{url('commande_fournisseur/fournisseur?ID=')}}"+id_fournisseur, function(res,stat){
            var contact = document.getElementById("contact_Fournisseur");
            var adresse = document.getElementById("adresse_Fournisseur");

            contact.value = res[0].contact;
            adresse.value = res[0].adresse_complet;

            document.getElementById("adresseFournisseur").value = adresse.value;
            document.getElementById("contactFounisseur").value =  contact.value;
            document.getElementById("idFournisseur").value = id_fournisseur;

            @foreach($lignescommande as $ligne)

                    document.getElementById("adresseFournisseur{{$ligne->id_ligne_commande_fournisseur}}").value = adresse.value;
            document.getElementById("contactFounisseur{{$ligne->id_ligne_commande_fournisseur}}").value =  contact.value;
            document.getElementById("idFournisseur{{$ligne->id_ligne_commande_fournisseur}}").value = id_fournisseur;

            @endforeach

        });
    }

</script>


<script>
    function calcule(id){


        var tva = document.getElementById("tva"+id).value;
        var quantite = document.getElementById("quantite"+id).value;
        var prix_unitaire_ht = document.getElementById("prix_unitaire_ht"+id).value;
        var prix_unitaire_ttc = document.getElementById("prix_unitaire_ttc"+id).value;
        var totale_ht = document.getElementById("totale_ht"+id);
        var totale_ttc = document.getElementById("totale_ttc"+id);

        document.getElementById("prix_unitaire_ttc"+id).value = prix_unitaire_ht * (1+(tva/100));
        document.getElementById("totale_ht"+id).value = prix_unitaire_ht * quantite;
        document.getElementById("totale_ttc"+id).value = prix_unitaire_ttc * quantite;
        document.getElementById("prix_unitaire_ht"+id).value = document.getElementById("prix_unitaire_ttc"+id).value/(1+(tva/100));




    }

</script>



@endsection
