@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Modifier la commande client
    </h1>

</section>






<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::get('erreur'))
            <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{{ Session::get('erreur') }}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'PUT','action' => ['CommandeClientController@postFormEdit', $commande_client->idCommande]]) !!}
                <div class="form-group">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° Commande client : </label>
                            <input type="text" class="form-control" name="numCommande"  required value="{{$commande_client->numCommande}}" readonly>
                        </div>
                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Fournisseur : </label>
                            <select id="idSelecClient" class="form-control" onchange="getClient(this.value)" name="client" required="required">
                                <option selected disabled value="" style="background-color: white">Sélectionner le client ...</option>
                                @foreach($clients as $client)
                                    <option value="{{$client->idClient}}" @if($client->idClient == Session::get('idClient')) selected @endif> {{$client->raisonSociale}} </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Contact client :</label>
                            <input type="text" class="form-control" id="contact_Client" name="contact_Client" placeholder="Contact client" value ="{{Session::get('contactClient')}}" required readonly >
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Adresse : </label>
                            <input type="text" class="form-control" id="adresse_Client" name="adresse_Client" placeholder="Adresse" value="{{Session::get('adresseClient')}}" required readonly >
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Date de création : </label>
                            <input type="date" class="form-control" id="date_creation" name="date_creation" value="{{Session::get('dateCreation')}}" onchange="saveDate()" required >

                        </div>


                    </div>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div  style="float: right" >
                        <a href="#ajouterLigneCommandeFournisseur" data-toggle="modal" class="btn btn-block btn-primary" style="margin-bottom: 2%">
                            <span class="glyphicon glyphicon-plus" ></span>
                            Ajout produit
                        </a>
                    </div>
                    <br>
                    <br>
                    <br>

                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
					<div class="table-responsive">
						<table id="example1" class="table table-bordered table-striped dataTable">
							<thead>
							<tr role="row">
								<th class="text-center sorting_asc">Référence produit</th>
								<th class="text-center sorting_asc">Désignation</th>
								<th class="text-center sorting_asc">Quantité</th>
								<th class="text-center sorting_asc">TVA (%)</th>
								<th class="text-center sorting_asc">Prix Unitaire H.T</th>
								<th class="text-center sorting_asc">Prix Unitaire T.T.C</th>
								<th class="text-center sorting_asc">Totale H.T</th>
								<th class="text-center sorting_asc">Totale T.T.C</th>
								<th class="text-center sorting_asc">Modifier</th>
								<th class="text-center sorting_asc">Annuler</th>
							</tr>
							</thead>

							<tbody>


							<?php

							$total_ht = 0;
							$total_ttc = 0;

							?>

							@foreach( $lignescommande as $ligne)
								<tr role="row" class="odd">
									<td class="text-center sorting_1">{!!$ligne->produit->reference!!}</td>
									<td class="text-center sorting_1">{!!$ligne->produit->designation!!}</td>
									<td class="text-center sorting_1">{!!(float)$ligne->quantiteCommande!!}</td>									
                                    <td class="text-center sorting_1">{!!$ligne->tva!!}</td>
									<td class="text-center sorting_1">{!!number_format($ligne->prixHT,2)!!}</td>
									<td class="text-center sorting_1">{!!number_format($ligne->prixTTC,2)!!}</td>
                                    <td class="text-center sorting_1">{!!number_format($ligne->totalPrixHT,2)!!}</td>
									<td class="text-center sorting_1">{!!number_format($ligne->totalPrixTTC,2)!!}</td>
									<td class="text-center sorting_asc">
										<a href="#edite{{$ligne->idLigneCommandeProduit}}" class="glyphicon glyphicon-edit"  data-toggle="modal">


										</a>
									</td >
									<td class="text-center sorting_asc">
										<a href="#DeleteModal{{$ligne->idLigneCommandeProduit}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

										</a>
									</td>
								</tr>

								<?php

								$total_ttc +=  $ligne->totalPrixTTC;
								$total_ht +=   $ligne->totalPrixHT;

								?>
							@endforeach

							</tbody>
						</table>
					</div>

                    <div class="col-lg-12" >

                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >

                            <label> Total TTC </label>
                            <input type="text" class="form-control col-lg-1" readonly  value="{!!number_format($total_ttc,2)!!}">
                            <input type="text" readonly class="hidden" name="total_ttc" value="{!!$total_ttc!!}">
                        </div>

                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >
                            <label> TVA </label>
                            <input type="text" class="form-control col-lg-1" readonly name="total_tva" value="{!!number_format(($total_ttc-$total_ht),2)!!}">
                        </div>
                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >
                            <label> Total HT </label>
                            <input type="text" class="form-control col-lg-1" readonly value="{!!number_format($total_ht,2)!!}">
                            <input type="text" class="hidden" readonly name="total_ht" value="{!!$total_ht!!}">

                        </div>




                    </div>




                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">

                        <a href="{{url('commande_client/modifier/annuler/'.$commande_client->idCommande)}}" type="button" class="btn btn-default pull-right" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-primary pull-right">Valider</button>

                    </div>

                </div>
            </div>
            {!! Form::close() !!}
        </div><!-- /.box -->


        <!--  POPUP pour ajout produit  -->
        <div cl1ass="example-modal" >
            <div class="modal" id="ajouterLigneCommandeFournisseur">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" style="font-family:verdana;">Ajout produit</h4>
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['method'=>'POST','action' => ['CommandeClientController@postAddLigneCommandeEdit', $commande_client->idCommande]]) !!}
                            <div class="col-lg-12">
                                <div class="col-lg-6">
                                    <label>Produit </label>
                                    <select id="idSelecReferenceAjouter" class="form-control selectpicker" data-live-search="true" name="produit" onchange="getTVA()">
                                        <option value="" selected disabled style="background-color: white">Sélectionner le produit</option>
                                        @foreach($produits as $produit)
                                            <option value="{{$produit->id_produit}}" > {{$produit->reference}} -- {{$produit->designation}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label>T.V.A</label>
                                    <input type="number" class="form-control" id="tva0" name="tva" placeholder="TVA" step="0.01" required onchange="calcule(0),calculeHT(0)" onkeyup="calcule(0),calculeHT(0)" >
                                </div>
                                <div class="form-group col-lg-6">
                                    <label>Prix Unitaire H.T</label>
                                    <input type="number" class="form-control" id="prix_unitaire_ht0" name="prix_unitaire_ht" onchange="calcule(0)" onkeyup="calcule(0)" placeholder="Prix Unitaire H.T" required  step="0.01">
                                </div>
                            </div>


                            <div class="col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label>Quantité</label>
                                    <input type="number" min="1" step="0.01" class="form-control" id="quantite0" name="quantite" placeholder="Quantité" onchange="calcule(0)" onkeyup="calcule(0)" required  >
                                </div>
                                <div class="form-group col-lg-6">
                                    <label>Prix Uniaire T.T.C</label>
                                    <input type="number" class="form-control" id="prix_unitaire_ttc0" name="prix_unitaire_ttc" step="0.01" onchange="calculeHT(0),calculeTotal(0)" onkeyup="calculeHT(0),calculeTotal(0)" placeholder="Prix Uniaire TTC" required  >
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label>Totale H.T</label>
                                    <input type="number" class="form-control" id="totale_ht0" name="totale_ht" placeholder="Totale H.T" required readonly >
                                </div>
                                <div class="form-group col-lg-6">
                                    <label>Totale TTC</label>
                                    <input type="number" class="form-control" id="totale_ttc0" name="totale_ttc" placeholder="Totale TTC" required readonly >
                                    <br>
                                </div>
                            </div>
                        </div>

                        <div class="hidden">

                            <input type="text" id="idClient" name="idClient" value="{{Session::get('idClient')}}">
                            <input type="text" id="contactClient" name="contactClient" value="{{Session::get('contactClient')}}">
                            <input type="text" id="adresseClient" name="adresseClient" value="{{Session::get('adresseClient')}}">
                            <input type="text" id="dateCreationCommande" name="dateCreationCommande" value="{{Session::get('dateCreation')}}">

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">Valider</button>
                        </div>
                        {!! Form::close() !!}

                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
        </div>



        @foreach($lignescommande as $ligne)

            <div cl1ass="example-modal" >
                <div class="modal" id="edite{{$ligne->idLigneCommandeProduit}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;">Modifier produit</h4>
                            </div>
                            <div class="modal-body">
                                {!! Form::open(['method'=>'PUT','action' => ['CommandeClientController@postEditeLigneCommandeEdit',$ligne->idLigneCommandeProduit,$commande_client->idCommande]]) !!}
                                <div class="col-lg-12">
                                    <div class="col-lg-6">
                                        <label>Produit </label>
                                        <select id="idSelecReferenceModifier" class="form-control selectpicker" data-live-search="true" name="produit" onchange="getTVAmodifier({{ $ligne->idLigneCommandeProduit }})">
                                            <option value="">Sélectionner le produit</option>
                                            @foreach($produits as $produit)
                                                <option value="{{$produit->id_produit}}" @if($produit->id_produit == $ligne->idProduit) selected @endif> {{$produit->reference}} -- {{$produit->designation}} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-6">
                                        <label>T.V.A</label>
                                        <input type="number" min="0"  class="form-control" id="tva{{$ligne->idLigneCommandeProduit}}" name="tva" placeholder="TVA" step="0.01" value="{{(float)$ligne->tva}}" required onchange="calcule({{$ligne->idLigneCommandeProduit}});calculeHT({{$ligne->idLigneCommandeProduit}})" onkeyup="calcule({{$ligne->idLigneCommandeProduit}});calculeHT({{$ligne->idLigneCommandeProduit}})" >
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label>Prix Unitaire H.T</label>
                                        <input type="number" min="0" step="0.01" class="form-control" id="prix_unitaire_ht{{$ligne->idLigneCommandeProduit}}" name="prix_unitaire_ht" value="{{(float)$ligne->prixHT}}" onchange="calcule({{$ligne->idLigneCommandeProduit}})" onkeyup="calcule({{$ligne->idLigneCommandeProduit}})" placeholder="Prix Unitaire H.T" required  >
                                    </div>
                                </div>


                                <div class="col-lg-12">
                                    <div class="form-group col-lg-6">
                                        <label>Quantité</label>
                                        <input type="number" min="1" class="form-control" id="quantite{{$ligne->idLigneCommandeProduit}}" name="quantite" placeholder="Quantité" value="{{(float)$ligne->quantiteCommande}}" onchange="calcule({{$ligne->idLigneCommandeProduit}})" onkeyup="calcule({{$ligne->idLigneCommandeProduit}})" required  >
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label>Prix Uniaire T.T.C</label>
                                        <input type="number" min="0" step="0.01" class="form-control" id="prix_unitaire_ttc{{$ligne->idLigneCommandeProduit}}" name="prix_unitaire_ttc" value="{{(float)$ligne->prixTTC}}" onchange="calculeHT({{$ligne->idLigneCommandeProduit}}),calculeTotal({{$ligne->idLigneCommandeProduit}})" onkeyup="calculeHT({{$ligne->idLigneCommandeProduit}}),calculeTotal({{$ligne->idLigneCommandeProduit}})" placeholder="Prix Uniaire TTC" required  >
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group col-lg-6">
                                        <label>Totale H.T</label>
                                        <input type="number" step="0.01" class="form-control" id="totale_ht{{$ligne->idLigneCommandeProduit}}" name="totale_ht"  value="{{(float)$ligne->totalPrixHT}}" placeholder="Totale H.T" required readonly >
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label>Totale TTC</label>
                                        <input type="number" step="0.01" class="form-control" id="totale_ttc{{$ligne->idLigneCommandeProduit}}" name="totale_ttc" value="{{(float)$ligne->totalPrixTTC}}" placeholder="Totale TTC" required readonly >
                                        <br>
                                    </div>
                                </div>
                            </div>

                            <div class="hide">

                                <input type="text" id="idClient{{$ligne->idLigneCommandeProduit}}" name="idClient" value="{{Session::get('idClient')}}">
                                <input type="text" id="contactClient{{$ligne->idLigneCommandeProduit}}" name="contactClient"  value="{{Session::get('contactClient')}}">
                                <input type="text" id="adresseClient{{$ligne->idLigneCommandeProduit}}" name="adresseClient"  value="{{Session::get('adresseClient')}}">
                                <input type="text" id="etatCommande{{$ligne->idLigneCommandeProduit}}" name="etatCommande"  value="{{Session::get('etatCommande')}}">
                                <input type="text" id="dateCreationCommande{{$ligne->idLigneCommandeProduit}}" name="dateCreationCommande"  value="{{Session::get('dateCreation')}}">

                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>
                            {!! Form::close() !!}

                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>


            <div class="example-modal">
                <div class="modal" id="DeleteModal{{$ligne->idLigneCommandeProduit}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                            </div>
                            <div class="modal-body">
                                <p>Voulez-vous vraiment supprimer ce produit de la commande ?</p>
                            </div>

                            <div class="modal-footer">
                                {!! Form::open(['method' => 'POST', 'action' => ['CommandeClientController@deleteLigneCommandeClientEdit',$ligne->idLigneCommandeProduit,$commande_client->idCommande]]) !!}
                                <div class="hide">

                                    <input type="text" id="idClientS{{$ligne->idLigneCommandeProduit}}" name="idClient" value="{{Session::get('idClient')}}">
                                    <input type="text" id="contactClientS{{$ligne->idLigneCommandeProduit}}" name="contactClient"  value="{{Session::get('contactClient')}}">
                                    <input type="text" id="adresseClientS{{$ligne->idLigneCommandeProduit}}" name="adresseClient"  value="{{Session::get('adresseClient')}}">
                                    <input type="text" id="dateCreationCommandeS{{$ligne->idLigneCommandeProduit}}" name="dateCreationCommande"  value="{{Session::get('dateCreation')}}">

                                </div>
                                <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                {!! Form::close() !!}
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>

        @endforeach




</section><!-- /.content -->






<script>


    saveDate();

    function getClient(idClient){

        var nom = document.getElementById("idSelecClient");
        $.get("{{url('commande_client/client?ID=')}}"+idClient, function(res,stat){
            var contact = document.getElementById("contact_Client");
            var adresse = document.getElementById("adresse_Client");

            contact.value = res[0].nomClient+" "+res[0].prenomClient;
            adresse.value = res[0].adresseClient;

            document.getElementById("adresseClient").value = adresse.value;
            document.getElementById("contactClient").value =  contact.value;
            document.getElementById("idClient").value = idClient;

            @foreach($lignescommande as $ligne)

                    document.getElementById("adresseClient{{$ligne->idLigneCommandeProduit}}").value = adresse.value;
            document.getElementById("contactClient{{$ligne->idLigneCommandeProduit}}").value =  contact.value;
            document.getElementById("idClient{{$ligne->idLigneCommandeProduit}}").value = idClient;

            @endforeach

        });
    }

    function calcule(id){


        var tva = document.getElementById("tva"+id).value;
        var quantite = document.getElementById("quantite"+id).value;
        var prix_unitaire_ht = document.getElementById("prix_unitaire_ht"+id).value;
        var prix_unitaire_ttc = document.getElementById("prix_unitaire_ttc"+id).value;
        var totale_ht = document.getElementById("totale_ht"+id);
        var totale_ttc = document.getElementById("totale_ttc"+id);
        if(tva==''){
            tva=0;
        }if(prix_unitaire_ht==''){
            prix_unitaire_ht=0;
        }if(prix_unitaire_ttc==''){
            prix_unitaire_ttc=0;
        }if(quantite==''){
            quantite=0;
        }
        document.getElementById("prix_unitaire_ttc"+id).value = (prix_unitaire_ht * (1+(tva/100))).toFixed(2);
        document.getElementById("totale_ht"+id).value = (prix_unitaire_ht * quantite).toFixed(2);
        document.getElementById("totale_ttc"+id).value = (prix_unitaire_ttc * quantite).toFixed(2);


        document.getElementById("prix_unitaire_ht"+id).value = prix_unitaire_ht;




    }

    function getTVA(){
        document.getElementById('tva0').value ='';
        var id_produit = document.getElementById('idSelecReferenceAjouter').value;
        $.ajax({
                    url: "{{url('produit/getproduit')}}/"+id_produit,
                    method : "post",   
                    data: {
                    "_token": "{{ csrf_token() }}"
                    } ,        
                    success: function(data){ 
                        document.getElementById('tva0').value = data.tva;  
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
    }
    
    function getTVAmodifier(id){
        document.getElementById('tva'+id).value ='';
        var id_produit = document.getElementById('idSelecReferenceModifier').value;
        $.ajax({
                    url: "{{url('produit/getproduit')}}/"+id_produit,
                    method : "post",   
                    data: {
                    "_token": "{{ csrf_token() }}"
                    } ,        
                    success: function(data){ 
                        document.getElementById('tva'+id).value = data.tva;  
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
    }

    function calculeTotal(id){

//alert(id);
        var tva = document.getElementById("tva"+id).value;
        var quantite = document.getElementById("quantite"+id).value;
        var prix_unitaire_ht = document.getElementById("prix_unitaire_ht"+id).value;
        var prix_unitaire_ttc = document.getElementById("prix_unitaire_ttc"+id).value;
        var totale_ht = document.getElementById("totale_ht"+id);
        var totale_ttc = document.getElementById("totale_ttc"+id);
        if(tva==''){
            tva=0;
        }if(prix_unitaire_ht==''){
            prix_unitaire_ht=0;
        }if(prix_unitaire_ttc==''){
            prix_unitaire_ttc=0;
        }if(quantite==''){
            quantite=0;
        }

        document.getElementById("totale_ht"+id).value = (prix_unitaire_ht * quantite).toFixed(2);
        document.getElementById("totale_ttc"+id).value = (prix_unitaire_ttc * quantite).toFixed(2);




    }

    function calculeHT(id){


        var tva = document.getElementById("tva"+id).value;

        var quantite = document.getElementById("quantite"+id).value;
        var prix_unitaire_ht = document.getElementById("prix_unitaire_ht"+id).value;
        var prix_unitaire_ttc = document.getElementById("prix_unitaire_ttc"+id).value;
        var totale_ht = document.getElementById("totale_ht"+id);
        var totale_ttc = document.getElementById("totale_ttc"+id);
        if(tva==''){
            tva=0;
        }if(prix_unitaire_ht==''){
            prix_unitaire_ht=0;
        }if(prix_unitaire_ttc==''){
            prix_unitaire_ttc=0;
        }if(quantite==''){
            quantite=0;
        }
        document.getElementById("prix_unitaire_ht"+id).value = (parseFloat(prix_unitaire_ttc)/((parseFloat(tva)/100)+1)).toFixed(2);;




    }



    function saveDate(){

        document.getElementById("dateCreationCommande").value = document.getElementById("date_creation").value;

        @foreach($lignescommande as $ligne)

            document.getElementById("dateCreationCommande{{$ligne->idLigneCommandeProduit}}").value = document.getElementById("date_creation").value;
        document.getElementById("dateCreationCommandeS{{$ligne->idLigneCommandeProduit}}").value = document.getElementById("date_creation").value;

        @endforeach

    }

</script>



@endsection