@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Détail de la commande client
    </h1>

    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>


<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                @if(Session::get('CLIENT_PREPARATION_AJOUTER'))
                @if($hasPreparations->first()==null)
                <div class="box-tools pull-right">
                    <a href="{{url('commande_client/preparation')}}/{{$commande_client->idCommande}}" class="btn btn-block btn-primary">
                        <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
                        Préparer
                    </a>
                </div>
                @else
                        <div class="box-tools pull-right">
                            <a href="{{url('preparation/detail')}}/{{$hasPreparations->first()->idPreparation}}" class="btn btn-block btn-primary">
                                <span  aria-hidden="false"></span>
                                Voir préparation
                            </a>
                        </div>
                @endif
                @endif
                <div class="form-group">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° Commande client : </label>
                            <input type="text" class="form-control" name="num_commande_client"  required value="{{$commande_client->numCommande}}" readonly>
                        </div>
                          <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>Statut commande : </label>
                            <input type="text" class="form-control" name="statut_cmd"  required value="{{$commande_client->statutCommande}}" readonly>
                        </div>



                    </div>  <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Raison sociale : </label>
                            <input type="text" class="form-control" name="raison_sociale"  required value="{{$commande_client->Client->raisonSociale}}" readonly>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Adresse client : </label>
                            <input type="text" class="form-control" name="adresse_client :"  required value="{{$commande_client->Client->adresseClient}}" readonly>
                        </div>
                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Date de création : </label>
                            <input type="text" class="form-control" name="date_commande :"  required value="{{$commande_client->dateCommande}}" readonly>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Email contact :</label>
                            <input type="text" class="form-control" name="email_contact"  value ="{{$commande_client->Client->emailClient}}"  readonly >
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Nom et prénom contact : </label>
                            <input type="text" class="form-control"  name="nom&prenom_contact" value="{{$commande_client->Client->nomClient}} {{$commande_client->Client->prenomClient}}"  readonly >
                        </div>

                    </div>

                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <!--  <div class="col-lg-4 col-md-6 col-sm-6">
                                      <label>Statut : </label>
                        <input type="text" class="form-control" name="statut" value="" readonly>
                            </div>
                        </div> -->
                    <div class="col-lg-12 col-md-12 col-sm-12" style="margin-top: 20px;">
                        <div class="table-responsive">
                            <table id="example1" class="table table-bordered table-striped dataTable">
                                <thead>
                                <tr role="row">
                                    <th class="text-center sorting_asc">Référence</th>
                                    <th class="text-center sorting_asc">Désignation</th>
                                    <th class="text-center sorting_asc">Quantité</th>
                                    <th class="text-center sorting_asc">TVA (%)</th>
                                    <th class="text-center sorting_asc">Prix Unitaire H.T</th>
                                    <th class="text-center sorting_asc">Prix Unitaire T.T.C</th>
                                    <th class="text-center sorting_asc">Total H.T</th>
                                    <th class="text-center sorting_asc">Total T.T.C</th>

                                </tr>
                                </thead>

                                <tbody>


                                <?php

                                $total_ht = 0;
                                $total_ttc = 0;

                                ?>

                                @foreach( $lignescommande as $ligne)
                                    <tr role="row" class="odd">
                                        <td class="text-center sorting_1">{!!$ligne->produit->reference!!}</td>
                                        <td class="text-center sorting_1">{!!$ligne->produit->designation!!}</td>
                                        <td class="text-center sorting_1">{!!(float)$ligne->quantiteCommande!!}</td>
                                        <td class="text-center sorting_1">{!!$ligne->tva!!}</td>
                                        <td class="text-center sorting_1">{!!number_format($ligne->prixHT,2)!!}</td>
                                        <td class="text-center sorting_1">{!!number_format($ligne->prixTTC,2)!!}</td>
                                        <td class="text-center sorting_1">{!!number_format($ligne->totalPrixHT,2)!!}</td>
                                        <td class="text-center sorting_1">{!!number_format($ligne->totalPrixTTC,2)!!}</td>

                                    </tr>

                                    <?php

                                    $total_ttc +=  $ligne->totalPrixTTC;
                                    $total_ht +=   $ligne->totalPrixHT;

                                    ?>
                                @endforeach

                                </tbody>
                            </table>
                        </div>


                        <div class="col-lg-12" >

                            <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >

                                <label> Total TTC </label>
                                <input type="text" class="form-control col-lg-1" readonly  value="{!!number_format($total_ttc,2)!!}">
                                <input type="text" readonly class="hidden" name="total_ttc" value="{!!$total_ttc!!}">
                            </div>

                            <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right" >
                                <label> Total HT </label>
                                <input type="text" class="form-control col-lg-1" readonly value="{!!number_format($total_ht,2)!!}">
                                <input type="text" class="hidden" readonly name="total_ht" value="{!!$total_ht!!}">

                            </div>
                        </div>

                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">
                        <a href="{{url('commande_client/index')}}" class="btn btn-default pull-right" data-dismiss="modal">Retour</a>
                    </div>
                </div>
            </div><!-- /.box -->
                </div>
            </div>     
</section><!-- /.content -->









@endsection
