@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('CLIENT_LIST_AJOUTER'))

    <div class="box-tools pull-right">
        <a href="{{ url('client/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    @endif

    <h1>
        Gestion des clients
    </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDeleteOk'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDeleteOk') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif


        @if(Session::has('msgAddSuccess'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgAddSuccess') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif


    @if(Session::has('msgDeleteNotOk'))
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgDeleteNotOk') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
            @endif
                <!-- Default box -->
        <div class="box">

            <br>
            <form method="get" action="{{ route('recherche_client') }}">

                <div class="table-responsive">
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" @if (isset($mot_a_rechercher))
                        value="{{ $mot_a_rechercher }}"
                    @endif>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
                
            </div><br>
            </form>
           
            <table id="" class="table table-bordered table-striped ">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">Raison sociale</th>
                    <th class="text-center sorting_asc">Contact</th>
                    <th class="text-center sorting_asc">Email</th>
                    <th class="text-center sorting_asc">Téléphone</th>
                    <th class="text-center sorting_asc">Adresse</th>
                    @if(Session::get('CLIENT_LIST_MODIFIER'))

                    <th class="text-center sorting_asc">Modifier</th>
                    @endif
                    @if(Session::get('CLIENT_LIST_SUPPRIMER'))

                    <th class="text-center sorting_asc">Supprimer</th>
                        @endif
                </tr>
                </thead>

                <tbody>
                @foreach( $clients as $client)
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{!!$client->raisonSociale!!}</td>
                        <td class="text-center sorting_1">{!!$client->nomClient!!} {!!$client->prenomClient!!}</td>
                        <td class="text-center sorting_1">{!!$client->emailClient!!}</td>
                        <td class="text-center sorting_1">{!!$client->telephoneClient!!}</td>
                        <td class="text-center sorting_1">{!!$client->adresseClient!!}</td>
                        @if(Session::get('CLIENT_LIST_MODIFIER'))

                        <td class="text-center sorting_asc">
                            <a href="{{url('client/modifier')}}/{{$client->idClient}}" class="glyphicon glyphicon-edit">

                            </a>
                        </td >
                        @endif
                        @if(Session::get('CLIENT_LIST_SUPPRIMER'))

                        <td class="text-center sorting_asc">
                            <a href="#DeleteModal{{$client->idClient}}" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                        </td>
                            @endif
                    </tr>

                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$client->idClient}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce client " {{$client->raisonSociale}} "  ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['ClientController@delete',$client->idClient]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                @endforeach
                </tbody>

            </table>
			<p>Affichage de l'élement {{($clients->currentPage()-1)* $clients->perPage()+($clients->total() ? 1:0)}} à {{($clients->currentPage()-1)*$clients->perPage()+count($clients)}}  sur  {{$clients->total()}} éléments</p>
            
            <span class="pull-right">{{ $clients->links() }}</p>


        </div><!-- /.box -->
</section><!-- /.content -->






@endsection