@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">

    <h1>
        Ajouter un client
    </h1>

    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>



<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAddSuccess'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddSuccess') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif


    @if(Session::has('msgAddExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAddExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
                <!-- fin messages -->

        <!-- Default box -->
        <div class="box">
            <div class="panel-body">
                <div class="col-sm-12">

                    {!! Form::open(['method'=>'POST','action' => ['ClientController@postForm']]) !!}


                    <table>
                        <tbody>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Raison sociale
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="societe" placeholder="Raison sociale" required value="{{old('societe')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                   Nom client
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="nom" placeholder="Nom client" required value="{{old('nom')}}">
                                </div>
                            </td>
                        </tr>

                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                   Prenom client
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="prenom" placeholder="Prénom client" required value="{{old('prenom')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Région
                                </label>
                                <div class="col-sm-6">
                                    <select id="idSelectWilaya" class="form-control" name="region" >
                                        <option selected disabled value="" style="background-color: white">Sélectionner la région ...</option>an
                                        @foreach($wilayas as $wilaya)
                                            <option value="{{$wilaya->id_wilaya}}" >@if($wilaya->id_wilaya < 10 ) 0{{$wilaya->id_wilaya}} @else {{$wilaya->id_wilaya}} @endif - {{$wilaya->nom_wilaya}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </td>
                        </tr>

                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Adresse
                                </label>
                                <div class="col-sm-6">
                                    <input type="text"  class="form-control" name="adresse" placeholder="Adresse" required value="{{old('adresse')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Téléphone
                                </label>
                                <div class="col-sm-6">
                                    <input type="number"  class="form-control" name="telephone" placeholder="Téléphone" required value="{{old('telephone')}}">
                                </div>
                            </td>
                        </tr>
                        <tr style="height:50px">
                            <td class="col-sm-4">
                                <label class="col-sm-4 control-label">
                                    Email
                                </label>
                                <div class="col-sm-6">
                                    <input type="email" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" title="exemple@email.com"   class="form-control" name="email" placeholder="Email" required value="{{old('email')}}">
                                </div>
                            </td>
                        </tr>

                        </tbody>
                    </table>
                    </br>
                    </br>



                    <input class="btn btn-flat btn-primary pull-right" type="submit" value="Valider">
                    <a href="{{url('client/index')}}" class="btn btn-flat btn-danger pull-right">Annuler</a>

                    {!! Form::close() !!}

                </div>
            </div>
        </div><!-- /.box -->
</section><!-- /.content -->


@endsection