@extends('app')
@section('content')

<!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Modifier  chargement
    </h1>

</section>

<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAdd') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgExist'))
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgExist') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    <!-- fin messages -->

    <!-- Default box -->
    <div class="box" id="MYDIV">
        <div class="box-body">
            {!! Form::open(['method'=>'POST','action' => ['ChargementController@postEdit',$chargement->idChargement]]) !!}
            <div class="form-group">
                <div class="col-lg-12 ">
                    <div class="col-lg-3">
                        <label>N° Chargement : </label>
                        <input type="text" class="form-control", id="numChargement" name="numChargement" placeholder="Numéro de chargement" required value="{{$chargement->numChargement}}" readonly >
                    </div>
                    <div class="col-lg-3">
                        <label>Date de chargement : </label>
                        <input type="date" class="form-control" id="dateChargement"  name="dateChargement" value="{{$chargement->dateChargement}}"  required >

                    </div>

                    <div class="col-lg-3">
                        <label>Statut : </label>
                        <select  class="form-control " name="Statut" required="required">

                            @foreach($listeStatut as $liste)
                            <option value="{{$liste->code}}" @if($chargement->statutChargement == $liste->code ) selected  @endif > {{$liste->valeur}} </option>
                            @endforeach
                        </select>
                    </div>

                 @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                    <div class="col-lg-3">
                        <label>Nombre total d'unités d'expédition  : </label>
                        <input type="number" class="form-control" id="totalUE"  name="totalUE" value="{{$chargement->totalUE_chargement}}"  required readonly >
                    </div>
                    @endif



                </div>
                <br>
                <br>
                <br>
                <br>

                <div class="col-lg-12">
                    <div class="col-lg-3">
                        <label>Transporteur : </label>
                        <select id="idSelectTransporteur" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" onchange="getInformations(this.value)" name="idTransporteur" required="required" disabled="disabled">
                            <option selected disabled value="" >Sélectionner le transporteur ...</option>
                            @foreach($transporteurs as $transporteur)
                            <option value="{{$transporteur->idTransporteur}}" @if($idtransporteur!=null && $idtransporteur->idTransporteur == $transporteur->idTransporteur ) selected @elseif($chargement->idTransporteur == $transporteur->idTransporteur ) selected @endif > {{$transporteur->numTransporteur}} </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-3">
                        <label>Véhicule : </label>
                        <select id="idSelectVéhicule" class="form-control"  name="idEmplacement" >
                            <option selected disabled value="">Sélectionner le véhicule ...</option>
                            @foreach($emplacements as $emplacement)
                            <option value="{{$emplacement->id_emplacement}}" @if($idtransporteur!=null && $idtransporteur->idEmplacement == $emplacement->id_emplacement ) selected @elseif($chargement->idEmplacement == $emplacement->id_emplacement ) selected @endif > {{$emplacement->libelle}} </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-lg-3">
                        <label>Nombre total des produits  : </label>
                        <input type="number" class="form-control" id="totalProduits"  name="totalProduits" value="{{$chargement->totalProduits_chargement}}"  required readonly >
                    </div>
                    <div class="col-lg-3">
                        <label>Total poids  : </label>
                        <input type="number" class="form-control" id="totalPoids"  name="totalPoids" value="{{$chargement->totalPoids_chargement}}"  required readonly >
                    </div>

                </div>
                <br>
                <br>
                <br>
            </div>

            <div class="col-lg-12">
                <table id="example1" class="table table-bordered table-striped dataTable">
                    <thead>
                        <tr role="row">

                            <th class="text-center sorting_asc">Sélectionner </th>
                            <th class="text-center sorting_asc">N° préparation</th>
                            <th class="text-center sorting_asc">N° commande</th>
                            <th class="text-center sorting_asc">Raison sociale</th>
                            <th class="text-center sorting_asc">Date prévue</th>
                             @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                            <th class="text-center sorting_asc">Nombre d'UE</th>
                            @endif
                            <th class="text-center sorting_asc">Nombre produits</th>
                            <th class="text-center sorting_asc">Total poids</th>
                            <th class="text-center sorting_asc">Statut</th>

                        </tr>
                    </thead>

                    <tbody>

                        @foreach( $lignes as $ligne)

                        <tr role="row" class="odd">
                            <td class="text-center sorting_1"><label>
                                <input style=" transform: scale(1.5);"  type="checkbox" id="select" name="select{{$ligne->idPreparation}}" onchange="nbrProduit(this,{{$ligne->nombreProduits}}),totalP(this,{{$ligne->totalPoids}}),totalUEs(this,{{$ligne->nombreUE}})"
                                @if( (DB::table('ligne_preparation_chargement')->select('idPreparation')
                                ->where('idPreparation','=',$ligne->idPreparation)->where('idChargement','=',$id)->count()) != 0) checked @endif value="selected">
                            </label></td>
                            <td class="text-center sorting_1">{{$ligne->numPreparation}}</td>
                            @if($ligne->idCommande != 0)
                                <td class="text-center sorting_1">{{$ligne->CommandeClient->numCommande}}</td>
                                @else
                                <td class="text-center sorting_1"></td>
                            @endif
                            <td class="text-center sorting_1">{{$ligne->Client->raisonSociale}}</td>
                            
                            
                               
                            <td class="text-center sorting_1">{{$ligne->datePrevue}}</td>
                             @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                            <td class="text-center sorting_1">{{$ligne->nombreUE}}</td>
                            @endif
                            <td class="text-center sorting_1">{{$ligne->nombreProduits}}</td>
                            <td class="text-center sorting_1">{{(float) $ligne->totalPoids}}</td>
                            <td class="text-center sorting_1">{{$ligne->valeur}}</td>
                        </tr>
                        @endforeach


                    </tbody>
                </table>



                <div style="float: right">

                    <a href="{{url('chargement/index')}}" class="btn btn-default" data-dismiss="modal">Annuler</a>
                    <button type="submit" class="btn btn-primary">Valider</button>

                </div>

            </div>
        </div>
        {!! Form::close() !!}
    </div><!-- /.box -->


</section><!-- /.content -->

<script>

    function getInformations(idTransporteur){

        window.location.href = "{{url('chargement/ajouter')}}/"+idTransporteur

    }

    function nbrProduit(element,nbr)
    {
        if(element.checked) {
            var nombreProduit = (document.getElementById('totalProduits'));

            var n = nombreProduit.value;

            var nb = parseInt(n);
            nb += nbr;
            document.getElementById('totalProduits').value = nb;
        }
        else{
            var nombreProduit = (document.getElementById('totalProduits'));

            var n = nombreProduit.value;

            var nb = parseInt(n);
            nb -= nbr;
            document.getElementById('totalProduits').value = nb;
        }

    }
    function totalP(element,poids)
    {

        if(element.checked) {

            var poidsProduit = (document.getElementById('totalPoids'));

            var n = poidsProduit.value;

            var nb = parseFloat(n);
            nb = nb+poids;
            document.getElementById('totalPoids').value = nb;
        }
        else{
            var poidsProduit = (document.getElementById('totalPoids'));

            var n = poidsProduit.value;

            var nb = parseFloat(n);
            nb = nb-poids;
            document.getElementById('totalPoids').value = nb;
        }
    }

    function totalUEs(element,UEs)
    {

        if(element.checked) {

            var totalUE = (document.getElementById('totalUE'));

            var n = totalUE.value;

            var nb = parseInt(n);
            nb = nb+UEs;
            document.getElementById('totalUE').value = nb;
        }
        else{
            var totalUE = (document.getElementById('totalUE'));

            var n = totalUE.value;

            var nb = parseInt(n);
            nb = nb-UEs;
            document.getElementById('totalUE').value = nb;
        }
    }





</script>








@endsection