﻿@extends('app')
@section('content')

<!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('CLIENT_CHARGEMENT_AJOUTER'))

    <div class="box-tools pull-right">
        <a  class="btn btn-block btn-primary" 
        @if (Session::get('AJOUT_CHARGEMENT_PREPARATION') == "1")
            href="#"
            style="visibility: hidden;" 
        @else
        href="{{ url('chargement/ajouter') }}"
        @endif
        >
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    @endif

    <h1>
       Liste des chargements
   </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDeleteOk'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgDeleteOk') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgDeleteNotOk'))
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgDeleteNotOk') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgAdd'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAdd') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif
    {!! Form::open(['method' => 'GET', 'action' => ['ChargementController@filtre']]) !!}
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-4">
                        <label class="text-center">Filtrer par mode d'affichage : </label>
                        <select name="mode_affichage" id="mode_affichage"  class="form-control" >
                            <option value="0" disabled>Choisir un mode d'affichage</option>
                            <option value="1"
                                @if(isset($mode_affichage))
                                    @if($mode_affichage == 1)
                                        selected
                                    @endif
                                @else
                                    selected
                                @endif>
                                Les chargements qui n'ont pas été livrés
                            </option>
                            <option value="2"
                            @if(isset($mode_affichage))
                                @if($mode_affichage == 2)
                                    selected
                                @endif
                            @endif>
                                Les chargements livrés
                            </option> 
                            <option value="3"
                            @if(isset($mode_affichage))
                                @if($mode_affichage == 3)
                                    selected
                                @endif
                            @endif>
                                Tous les chargements
                            </option> 
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="text-center">Filtrer par statut : </label>
                        <select name="statut" id="statut"  class="form-control" >
                            <option value="-1" disabled>Choisir un statut</option>
                            <option value="10"
                                @if(isset($statut))
                                    @if($statut == 10)
                                        selected
                                    @endif
                                @else
                                    selected
                                @endif>
                                Tous les statuts
                            </option>
                            @foreach($statut_chargement as $v)
                                <option value="{{$v['code']}}"
                                    @if(isset($statut))
                                        @if($statut == $v['code'])
                                            selected
                                        @endif
                                    @endif>
                                        {{$v['valeur']}}
                                </option> 
                            @endforeach
                        </select>
                    </div>
                </div>
                <br>
                <div class="col-md-12">
                    @if(isset($mode_affichage))
                        <div class="box-tools pull-right" style="margin-right: 1%;" id="rechercher">
                            <input type="button" class="btn btn-default" value="Réinitialiser" onclick="window.location.href = '{{ route('index_chargement') }}';">
                        </div>
                    @endif
                    <div class="box-tools pull-right" style="margin-right: 1%;" id="rechercher">
                        <input type="submit" class="btn btn-default" value="Filtrer" >
                    </div>
                </div>
            </div>
        {!! Form::close() !!}
        <br>

    <!-- Default box -->
    <div class="box">
        <div class="box-body">
            {!! Form::open(['method'=>'POST','action' => ['ChargementController@export']]) !!}
                  <div class="col-sm-12">
                    <div class="col-sm-5">
                        <label>Date Début :</label>
                            <input required type="date" class="form-control" id="date_debut" name="date_debut"   >
                    </div>
                    <div class="col-sm-5">
                <label>Date fin :</label>
                            <input required type="date" class="form-control" id="date_fin" name="date_fin" value=""   >

                    </div><div class="col-sm-2">
                        <label></label>
                        <input type="submit" name="" id="button_export" class="btn btn-success form-control" value="Export Excel">
                </div>  </div>
                <input type="hidden" id="btn_count_export" value="0">
            {!! Form::close() !!}
        </div>
        <form method="get" action="{{ route('recherche_chargement') }}">
                <div class="table-responsive">
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" 
                    @if (isset($mot_a_rechercher))
                        value="{{ $mot_a_rechercher }}"
                    @endif>
                    <input type="hidden" name="mode_affichage" class="form-control" 
                    @if (isset($mode_affichage))
                        value="{{ $mode_affichage }}"
                    @endif>
                    <input type="hidden" name="statut" class="form-control" 
                    @if (isset($statut))
                        value="{{ $statut }}"
                    @endif>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
            </div><br>
        </form>
            <br>

        <table id="" class="table table-bordered table-striped">
            <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N° chargement</th>
                    <th class="text-center sorting_asc">Transporteur</th>
                    <th class="text-center sorting_asc">Véhicule</th>
                    <th class="text-center sorting_asc">Date chargement</th>
                   
                        <th class="text-center sorting_asc">Nombre d'UE</th>
                    
                    
                    <th class="text-center sorting_asc">Nombre produits</th>
                    <th class="text-center sorting_asc">Total poids</th>
                    <th class="text-center sorting_asc">Bon de livraison</th>
                    <th class="text-center sorting_asc">Statut</th>
                    @if(Session::get('CLIENT_CHARGEMENT_DETAIL'))
                    <th class="text-center sorting_asc">Détail</th>
                    @endif
                    @if(Session::get('CLIENT_CHARGEMENT_MODIFIER'))
                        
                        <th class="text-center sorting_asc">Modifier</th>
                    @endif
                    @if(Session::get('CLIENT_CHARGEMENT_SUPPRIMER'))

                    <th class="text-center sorting_asc">Supprimer</th>
                    @endif
                </tr>
            </thead>

            <tbody>
                @foreach( $chargements as $chargement)
                <tr role="row" class="odd">
                    <td class="text-center sorting_1">{!!$chargement->numChargement!!}</td>
                    
                    <td class="text-center sorting_1">
                        {!!$chargement->numTransporteur!!}--{!!$chargement->nomTransporteur!!} {!!$chargement->prenomTransporteur!!}
                    </td>
                    
                   
                    <td class="text-center sorting_1">
                        {!!$chargement->libelle!!}
                    </td>
                    

                    <td class="text-center sorting_1">{!!$chargement->dateChargement!!}</td>
                    
                    <td class="text-center sorting_1">{!!$chargement->totalUE_chargement!!}</td>
                    
                    <td class="text-center sorting_1">{!!$chargement->totalProduits_chargement!!}</td>
                    <td class="text-center sorting_1">{!!$chargement->totalPoids_chargement!!}</td>
                    <td class="text-center sorting_1">
                        
                        <a href="{{url('./livraison/detail/')}}/{{ $chargement->id_bon_livraison }}" target="_blank">{!!$chargement->num_bl!!}</a>
                    </td>
                    <td class="text-center sorting_1">{!!$chargement->valeur!!}</td>
                    @if(Session::get('CLIENT_CHARGEMENT_DETAIL'))
                    <td class="text-center sorting_1">
                        <a href="{{url('chargement/detail')}}/{{$chargement->idChargement}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">
                        </a>
                    </td>
                    @endif
                    @if(Session::get('CLIENT_CHARGEMENT_MODIFIER'))
                    
                    <td class="text-center sorting_asc">
                        @if (Session::get('AJOUT_CHARGEMENT_PREPARATION') != "1")
                        @if($chargement->valeur == "Non chargé")
                        <a href="{{url('chargement/modifier')}}/{{$chargement->idChargement}}" class="glyphicon glyphicon-edit">

                        </a>
                        @endif
                        @endif
                    </td >

                    
                    
                    @endif
                    @if(Session::get('CLIENT_CHARGEMENT_SUPPRIMER'))

                    <td class="text-center sorting_asc">
                        @if($chargement->valeur == "Non chargé")
                        <a href="#DeleteModal{{$chargement->idChargement}}" class="open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">
                        </a>
                        @endif
                    </td>

                    
                    @endif
                </tr>
                    <!--

                    <tr role="row" class="odd">
                        <td class="sorting_1">Gecko</td>
                        <td>Firefox 1.0</td>
                        <td>Win 98+ / OSX.2+</td>
                        <td>1.7</td>
                        <td>A</td>
                        <td>A</td>
                        <td>A</td>
                    </tr>
                -->

                <div class="example-modal">
                    <div class="modal" id="DeleteModal{{$chargement->idChargement}}">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce chargement ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['ChargementController@delete',$chargement->idChargement]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>


                    @endforeach
                </tbody>

            </table>

            <p>Affichage de l'élement {{($chargements->currentPage()-1)* $chargements->perPage()+($chargements->total() ? 1:0)}} à {{($chargements->currentPage()-1)*$chargements->perPage()+count($chargements)}}  sur  {{$chargements->total()}} éléments</p>
            
            <span class="pull-right">{{ $chargements->links() }}</span>
            


        </div><!-- /.box -->
    </section><!-- /.content -->






    @endsection