@extends('app')
@section('content')
        <!-- jspdf -->
{!! Html::script('assets/js/jsPDF/jspdf.js') !!}
        <!--<script src="../../assets/js/jspdf/jspdf.js"></script>-->
{!! Html::script('assets/js/jsPDF/dist/jspdf.min.js') !!}
        <!--<script src="../../assets/js/jspdf/dist/jspdf.min.js"></script>-->
{!! Html::script('assets/js/jsPDF/jsPDF-AutoTable/dist/jspdf.plugin.autotable.js') !!}
        <!--<script src="../../assets/js/jspdf/jspdf-autotable/dist/jspdf.plugin.autotable.js"></script>-->
<!-- Content Header (Page header) -->


<!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Détail d'un chargement
    </h1>

</section>

<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgAdd') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgExist'))
    <div class="box box-warning box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgExist') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif


    <!-- fin messages -->

    <!-- Default box -->
    <div class="box" id="MYDIV">
        <div class="box-body">
            <div class="form-group">
                {!! Form::open(['method'=>'POST','id' => 'formulaire','action' => ['ChargementController@show',$chargement->idChargement]]) !!}
                <div >
                    <button type="button" id="btn-export"  class="btn btn-flat btn-danger pull-right" onclick="genPDF()">Export PDF</button>
                </div>
                <br>
                <br>

                <div class="col-lg-12 ">
                    <div class="col-lg-3">
                        <label>N° Chargement : </label>
                        <input type="text" class="form-control", id="numChargement" name="numChargement" placeholder="Numéro de chargement"  value="{{$chargement->numChargement}}" readonly>
                    </div>
                    <div class="col-lg-3">
                        <label>Date de chargement : </label>
                        <input type="date" class="form-control" id="dateChargement"  name="dateChargement" value="{{$chargement->dateChargement}}"   readonly>

                    </div>
                    <div class="col-lg-3">
                        <label>Statut : </label>
                        <input type="text" class="form-control" id="statut" name="statut" value="{{$chargement->valeur}}"   readonly >
                    </div>
                      @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                        <div class="col-lg-3">
                            <label>Nombre total d'unités d'expédition  : </label>
                            <input type="number" class="form-control" id="totalUE"  name="totalUE" value="{{$chargement->totalUE_chargement}}"   readonly >
                        </div>
                        @endif
                       



                </div>
                <br>
                <br>
                <br>
                <br>

                <div class="col-lg-12">
                    <div class="col-lg-3">
                        <label>Transporteur : </label>
                        <input type="text" class="form-control" id="Transporteur" name="Transporteur" value="{{$chargement->Transporteur->numTransporteur}}--{{$chargement->Transporteur->nomTransporteur}} {{$chargement->Transporteur->prenomTransporteur}}"   readonly >
                    </div>
                    <div class="col-lg-3">
                        <label>Véhicule : </label>
                        <input type="text" class="form-control" name="Emplacement" id="Emplacement"
                        @if ($chargement->Emplacement !=0)
                             value="{{$chargement->Emplacement->libelle}}"
                        @else
                            value=""
                        @endif    readonly >
                    </div>

                    <div class="col-lg-3">
                        <label>Nombre total des produits  : </label>
                        <input type="number" class="form-control" id="totalProduits"  name="totalProduits" value="{{$chargement->totalProduits_chargement}}"  required readonly >
                    </div>
                    <div class="col-lg-3">
                        <label>Total poids  : </label>
                        <input type="number" class="form-control" id="totalPoids"  name="totalPoids" value="{{$chargement->totalPoids_chargement}}"  required readonly >
                    </div>

                </div>
                <br>
                <br>

            </div>
            <br>
            <br>
            <h3> Les préparations :</h3>

            <?php
            $i=0;
            ?>
            @foreach($lignes as $ligne)
                <?php
                $i++;
                ?>
            <div style="margin-bottom: 2%;margin-top: 2%" >
                <div class="col-lg-3">
                    <label>N° préparation  : </label>
                    <input type="text" class="form-control"  name="numPreparation" id="numPreparation{{$i}}" value="{{$ligne->numPreparation}}"  required readonly >
                </div>

                <div class="col-lg-3">
                    <label>Statut  : </label>
                    <input type="text" class="form-control"  name="statut" id="statut{{$i}}" value="{{$ligne->valeur}}"  required readonly >
                </div>

                @if($ligne->idCommande)
                    <div class="col-lg-3">
                        <label>N° commande  : </label>
                        <input type="text" class="form-control"  name="numCommande" id="numCommande{{$i}}" value="{{$ligne->CommandeClient->numCommande}}"  required readonly >
                    </div>
@endif
                    <div class="col-lg-3">
                        <label>Raison sociale  : </label>
                        <input type="text" class="form-control"  name="raisonSociale" id="raisonSociale{{$i}}" value="{{$ligne->Client->raisonSociale}}"  required readonly >
                    </div>
                

            </div>
            <br>
            <br>

            <div style="margin-bottom: 2%;margin-top: 5%" >
                <table id="{{$i}}table" class="table table-bordered table-striped ">
                    <thead>
                    <tr role="row">
                        <th class="text-center sorting_asc">N° UE</th>
                        <th class="text-center sorting_asc">Référence</th>
                        <th class="text-center sorting_asc">Désignation</th>
                        <th class="text-center sorting_asc">Code produit</th>
                        @if (Session::get('N_LOT'))
                            <th class="text-center sorting_asc">Numéro de lot</th>
                        @endif
                        
                        <th class="text-center sorting_asc">Emplacement</th>
                        <th class="text-center sorting_asc">Quantité</th>
                        <th class="text-center sorting_asc">Reste a préparé</th>
                        <th class="text-center sorting_asc">Quantité préparée</th>
                        <th class="text-center sorting_asc">Opérateur</th>
                        <th class="text-center sorting_asc">Poids</th>
                        @if (Session::get('NUMERO_SERIE'))
                            <th class="text-center sorting_asc">N° de série</th>
                        @endif
                        <th class="text-center sorting_asc">Statut</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($LigneProduits as $LigneProduit)
                    @if($ligne->idPreparation == $LigneProduit->idPreparation)
                    
                    <tr role="row">
                        @if (Session::get('STOCK_ENTITE') == 1 || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == 1)
                                <td class="text-center sorting_1">{!!$LigneProduit->stockProduit->num_ue !!}</td>
                            @else
                            @if($LigneProduit->UniteExpedition != null)
                            <td class="text-center sorting_1">{!!$LigneProduit->UniteExpedition->SSCC !!}</td>
                            @else
                            <td class="text-center sorting_1"></td>
                            @endif
                            @endif
                        <td class="text-center sorting_1">{!!$LigneProduit->Produit->reference!!}</td>
                        <td class="text-center sorting_1">{!!$LigneProduit->Produit->designation!!}</td>
                        <td class="text-center sorting_1">{!!$LigneProduit->Produit->code_identification!!}</td>
                        @if (Session::get('N_LOT'))
                        <td class="text-center sorting_1">{!!$LigneProduit->StockProduit->numero_lot!!}</td>
                        @endif
                        <td class="text-center sorting_1">{!!$LigneProduit->StockProduit->Emplacement->libelle!!}</td>
                        <td class="text-center sorting_1">
                            @if ($LigneProduit->num_serie != null && $LigneProduit->num_serie != '')
                                1
                            @else
                                {!!(float)$LigneProduit->quantite_a_preparer!!}
                            @endif
                            
                        </td>
                        <td class="text-center sorting_1">{!!(float)$LigneProduit->quantite_restante!!}</td>
                        <td class="text-center sorting_1">{!!(float)$LigneProduit->quantite_preparer!!}</td>

                        <td class="text-center sorting_1">{!!$LigneProduit->User->nom!!} {!!$LigneProduit->User->prenom!!}</td>
                        <td class="text-center sorting_1">{!!(float)$LigneProduit->total_poids!!}</td>
                        @if (Session::get('NUMERO_SERIE'))
                            <th class="text-center sorting_asc">
                                @if ($LigneProduit->num_serie != '')
                                    {{ $LigneProduit->num_serie }}
                                @else
                                    N/A
                                @endif
                                
                            </th>
                        @endif
                        @if($LigneProduit->UniteExpedition != null)
                                @if($LigneProduit->UniteExpedition->statut == 1)
                                    <td class="text-center sorting_1">Chargée</td>
                                @else
                                    <td class="text-center sorting_1">Non chargée</td>
                                @endif
                            @else
                                @if($LigneProduit->statut == 3)
                                    <td class="text-center sorting_1">Chargée</td>
                                @else
                                    <td class="text-center sorting_1">Non chargée</td>
                                @endif
                            @endif

                    </tr>
                    @endif
                    @endforeach
                    </tbody>

                </table>

            </div>


            @endforeach



            <div style="float: right">

                <a href="{{url('chargement/index')}}" class="btn btn-default" data-dismiss="modal">Retour</a>


                <div class="hidden">
                    <input type="text"   id="i" value={{$i}}>

                    <input type="text"   id="header" @if($configuration != null) value="{{$configuration->header}}" @else value="" @endif >
                <input type="text"   id="footer"  @if($configuration != null)  value="{{$configuration->footer}}" @else value="" @endif>
                <img  id="logo" @if($configuration != null) src="{{ asset('/dist/img/'.$configuration->image) }}" @else src="" @endif width="15%" height="15%" alt="User Image">



                </div>
            </div>

            <!------- pdf ------------>
            <div class="hidden">
                <input type="text" name="exportPdf" id="exportPdf" value="0">
            </div>
            <!---------pdf ------------>
            {!! Form::close() !!}
        </div>
    </div>
    </div><!-- /.box -->


</section><!-- /.content -->
<script>

    function genPDF() {
            var imgData =  document.getElementById('logo');
            var header = document.getElementById('header').value;
            var footer = document.getElementById('footer').value;

            var doc = new jsPDF('p', 'pt');
            var input = document.getElementById('numChargement');
            var input1 = document.getElementById('dateChargement');
            var input2 = document.getElementById('statut');
            var input3 = document.getElementById('Transporteur');
            var input4 = document.getElementById('Emplacement');
            var input5 = document.getElementById('totalProduits');
            var input6 = document.getElementById('totalUE');
            var input7 = document.getElementById('totalPoids');


            var x = document.getElementById('i').value;

            doc.setFontSize(12);
            doc.text('N° chargement : ' + input.value, 40, 180);
            doc.text('Date chargement : ' + input1.value, 320, 180);
            //doc.text('Statut : ' + input2.value, 40, 180);
            doc.text('Transporteur : ' + input3.value, 40, 200);
            doc.text('Véhicule : ' + input4.value, 40, 220);
            


            doc.setFontSize(14);
            
            var titre="Rapport détaillé d'un chargement";
        var width_titre = doc.getTextWidth(titre);
        var space_titre=doc.internal.pageSize.width-width_titre;
        space_titre=space_titre/2;
        doc.text(titre, space_titre, 120, {
            startY: doc.autoTable.previous.finalY + 15,
            margin: {horizontal: 7},
            columnStyles: {text: {columnWidth: 'auto'}}

        });
            var step = 280;
            var startTable = 330;

            for (var i = 1; i <= x; i++) {
                
                var input8 = document.getElementById('numPreparation' + i);
                var input9 = document.getElementById('statut' + i);
                var input10 = document.getElementById('numCommande' + i);
                var input11 = document.getElementById('raisonSociale' + i);
                doc.setFontSize(9);
                
                doc.text("N° préparation : " + input8.value, 40, step);
                doc.text("Statut : " + input9.value, 300, step);
                doc.text("Raison sociale : " + input11.value, 40, step+20);
                if (input10 != null) {
                    doc.text("N° commande : " + input10.value, 300, step+20);
                }
                    

                var elem = document.getElementById(i + "table");
                var res = doc.autoTableHtmlToJson(elem);

                @if (Session::get('NUMERO_SERIE'))
                doc.autoTable(res.columns, res.data, {
                    tableWidth: 'auto',
                    fontSize : 6,
                    startY: startTable,
                    //margin: {horizontal: 7},
                    styles: {overflow: 'linebreak', columnWidth: 'wrap', cellPadding: 5, halign: 'center'},
                     columnStyles: {
            text: {
                columnWidth: 'wrap'
            },
            0: {
                columnWidth: 30         
            },
            1: {
                columnWidth: 55
            },
            2: {
                columnWidth: 105
            },
            3: {
                columnWidth: 45
            },
            4: {
                columnWidth: 68
            },
            5: {
                columnWidth: 35
            },
            6: {
                columnWidth: 40
            },
            7: {
                columnWidth: 40
            },
            8: {
                columnWidth: 38
            },
            9: {
                columnWidth: 30
            },
            10: {
                columnWidth: 40
            },
            11: {
                columnWidth: 40
            }

        },
                    addPageContent: function (data) {
                        //doc.setTextColor(8);
                        //doc.setFontStyle('arial');
                        doc.setFontSize(9);
                        var splitTitle;
                        var space;
                        var space1;
                        var width = doc.getTextWidth(footer);
                        if(width>350){
                            splitTitle  = doc.splitTextToSize(footer, 350);
                            space=doc.internal.pageSize.width-350;
                        }else{
                            splitTitle=footer;
                            space=doc.internal.pageSize.width-width;
                        }
                        space1=space/2;
                        doc.text(splitTitle, space1, doc.internal.pageSize.height - 40);
                        doc.setFontSize(10);
                        splitTitle = doc.splitTextToSize(header, 250);
                        doc.text(splitTitle,320, 40);
                        var image = new Image();
                        var img = document.getElementById('logo');
                        image = img ;
                        image.src=img.src ;
                        image.width = 200;
                        image.height = 70;
                        doc.addImage(img, 'PNG',40,20);
                    },
                     margin: {top: 100, left:10,right:10,bottom:50},
                });
                @else  
                    doc.autoTable(res.columns, res.data, {
                    tableWidth: 'auto',
                    fontSize : 8,
                    startY: startTable,
                    //margin: {horizontal: 7},
                    styles: {overflow: 'linebreak', columnWidth: 'wrap', cellPadding: 5, halign: 'center'},
                     columnStyles: {
            text: {
                columnWidth: 'wrap'
            },
            0: {
                columnWidth: 40         
            },
            1: {
                columnWidth: 65
            },
            2: {
                columnWidth: 68
            },
            3: {
                columnWidth: 55
            },
            4: {
                columnWidth: 78
            },
            5: {
                columnWidth: 45
            },
            6: {
                columnWidth: 50
            },
            7: {
                columnWidth: 50
            },
            8: {
                columnWidth: 48
            },
            9: {
                columnWidth: 35
            },
            10: {
                columnWidth: 40
            }
        },
                    addPageContent: function (data) {
                        doc.setTextColor(8);
                        doc.setFontStyle('arial');
                        doc.setFontSize(8);
                        var splitTitle;
                        var space;
                        var space1;
                        var width = doc.getTextWidth(footer);
                        if(width>350){
                            splitTitle  = doc.splitTextToSize(footer, 350);
                            space=doc.internal.pageSize.width-350;
                        }else{
                            splitTitle=footer;
                            space=doc.internal.pageSize.width-width;
                        }
                        space1=space/2;
                        doc.text(splitTitle, space1, doc.internal.pageSize.height - 40);
                        doc.setFontSize(10);
                        splitTitle = doc.splitTextToSize(header, 250);
                        doc.text(splitTitle,320, 40);
                        var image = new Image();
                        var img = document.getElementById('logo');
                        image = img ;
                        image.src=img.src ;
                        image.width = 200;
                        image.height = 70;
                        doc.addImage(img, 'PNG',40,20);
                    },
                     margin: {top: 100, left:10,right:10,bottom:50},
                });
                @endif


                
               
                step = doc.autoTable.previous.finalY + 50;
                startTable = step + 30;
                
            }
            doc.setFontSize(11);
            doc.text('Nombre total des produits : ' + input5.value,350,doc.autoTable.previous.finalY + 80);
             @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
            doc.text("Nombre total d'unités d'expédition : " + input6.value,350,doc.autoTable.previous.finalY + 60);
            @endif

            doc.text("Total poids : " + input7.value, 350,doc.autoTable.previous.finalY + 100);


            doc.save("Rapport chargement.pdf");
            returnToPage();
    }

    function returnToPage()
    {
        document.getElementById('exportPdf').value = '0';

        document.getElementById("formulaire").submit();
    }

    window.onload = genPDF();

</script>
@endsection
