@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Ajouter un chargement
    </h1>

</section>


<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'POST','action' => ['ChargementController@postForm',$idtransporteur]]) !!}
                <div class="form-group">
                    <div class="col-lg-12 ">
                        <div class="col-lg-3">
                            <label>N° Chargement : </label>
                            <input type="text" class="form-control", id="numChargement" name="numChargement" placeholder="Numéro de chargement" required readonly value="{{$NumChargement}}" onchange="sessionChargement(this)" >
                        </div>
                        <div class="col-lg-3">
                            <label>Date de chargement : </label>
                            <input type="date" class="form-control" id="dateChargement"  name="dateChargement" @if(Session::has('dateChargement')) value="{{Session::get('dateChargement')}}" @else value="<?php echo date("Y-m-d");?>" @endif required  onchange="sessionDate(this)" >

                        </div>
                    @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                        <div class="col-lg-3">
                            <label>Nombre total d'unités d'expédition  : </label>
                            <input type="number" class="form-control" id="totalUE"  name="totalUE" value="0"  required readonly >
                        </div>
                    @endif
                    </div>
                    <br>
                    <br>
                    <br>
                    <br>

                    <div class="col-lg-12">
                        <div class="col-lg-3">
                            <label>Transporteur : </label>
                            <select id="idSelectTransporteur" class="form-control"  onchange="getInformations(this.value)" name="idTransporteur" required="required">
                                <option selected disabled value="">Sélectionner le transporteur ...</option>
                                @foreach($transporteurs as $transporteur)
                                    <option value="{{$transporteur->idTransporteur}}" @if($idtransporteur!=null && $idtransporteur->idTransporteur == $transporteur->idTransporteur ) selected @endif  > {{$transporteur->numTransporteur}}--{{$transporteur->nomTransporteur}} {{$transporteur->prenomTransporteur}} </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-3">
                            <label>Véhicule : </label>
                            <select id="idSelectVéhicule" class="form-control" name="idEmplacement" >
                                <option selected disabled value="">Sélectionner le véhicule ...</option>
                                @foreach($emplacements as $emplacement)
                                    <option value="{{$emplacement->id_emplacement}}" @if($idtransporteur!=null && $idtransporteur->idEmplacement == $emplacement->id_emplacement ) selected @endif > {{$emplacement->libelle}} </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-3">
                            <label>Nombre total des produits  : </label>
                            <input type="number" class="form-control" id="totalProduits"  name="totalProduits" value="0"  required readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Total poids  : </label>
                            <input type="number" class="form-control" id="totalPoids"  name="totalPoids" value="0"  required readonly >
                        </div>

                    </div>
                    <br>
                    <br>
                    <br>
                </div>

                <div class="col-lg-12">
                    <table id="example1" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr role="row">

                            <th class="text-center sorting_asc">Sélectionner </th>
                            <th class="text-center sorting_asc">N° préparation</th>
                            <th class="text-center sorting_asc">N° commande</th>
                            <th class="text-center sorting_asc">Raison sociale</th>
                            <th class="text-center sorting_asc">Date prévue</th>
                            @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                            <th class="text-center sorting_asc">Nombre d'UE</th>
                            @endif
                            <th class="text-center sorting_asc">Nombre produits</th>
                            <th class="text-center sorting_asc">Total poids</th>
                            <th class="text-center sorting_asc">Statut</th>

                        </tr>
                        </thead>

                        <tbody>

                        @foreach( $lignes as $ligne)
                            <tr role="row" class="odd">
                                <td class="text-center sorting_1"><label>
                                        <input style=" transform: scale(1.5);"  type="checkbox" id="select" name="select{{$ligne->idPreparation}}" onchange="nbrProduit(this,{{$ligne->nombreProduits}}),totalP(this,{{$ligne->totalPoids}}),totalUEs(this,{{$ligne->nombreUE}})"  value="selected">
                                    </label></td>
                                <td class="text-center sorting_1">{{$ligne->numPreparation}}</td>
                                @if($ligne->idCommande != 0 )
                                    <td class="text-center sorting_1">{{$ligne->CommandeClient->numCommande}}</td>
                                    <td class="text-center sorting_1">{{$ligne->CommandeClient->Client->raisonSociale}}</td>
                                @else
                                    <td class="text-center sorting_1">--</td>
                                    @if ($ligne->Client != null)
                                        <td class="text-center sorting_1">{{$ligne->Client->raisonSociale}}</td>
                                    @else
                                        <td class="text-center sorting_1">--</td>
                                    @endif
                                    
                                @endif
                                <td class="text-center sorting_1">{{$ligne->datePrevue}}</td>
                                @if (Session::get('STOCK_ENTITE') == "0" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == "0")
                                <td class="text-center sorting_1">{{$ligne->nombreUE}}</td>
                                @endif
                                <td class="text-center sorting_1">{{$ligne->nombreProduits}}</td>
                                <td class="text-center sorting_1">{{(float)$ligne->totalPoids}}</td>
                                <td class="text-center sorting_1">{{$ligne->valeur}}</td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>



                    <div style="float: right">

                        <a href="{{url('chargement/index')}}" class="btn btn-default" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-primary">Valider</button>

                    </div>

                </div>
            </div>
            {!! Form::close() !!}
        </div><!-- /.box -->


</section><!-- /.content -->

<script>



    function getInformations(idTransporteur){

        window.location.href = "{{url('chargement/ajouter')}}/"+idTransporteur

    }

    function nbrProduit(element,nbr)
    {
        if(element.checked) {
            var nombreProduit = (document.getElementById('totalProduits'));

            var n = nombreProduit.value;

            var nb = parseInt(n);
            nb += nbr;
            document.getElementById('totalProduits').value = nb;
        }
        else{
            var nombreProduit = (document.getElementById('totalProduits'));

            var n = nombreProduit.value;

            var nb = parseInt(n);
            nb -= nbr;
            document.getElementById('totalProduits').value = nb;
        }

    }
    function totalP(element,poids)
    {

        if(element.checked) {

            var poidsProduit = (document.getElementById('totalPoids'));

            var n = poidsProduit.value;

            var nb = parseFloat(n);
            nb = nb+poids;
            document.getElementById('totalPoids').value = nb;
        }
        else{
            var poidsProduit = (document.getElementById('totalPoids'));

            var n = poidsProduit.value;

            var nb = parseFloat(n);
            nb = nb-poids;
            document.getElementById('totalPoids').value = nb;
        }
    }

    function totalUEs(element,UEs)
    {

        if(element.checked) {

            var totalUE = (document.getElementById('totalUE'));

            var n = totalUE.value;

            var nb = parseFloat(n);
            nb = nb+UEs;
            document.getElementById('totalUE').value = nb;
        }
        else{
            var totalUE = (document.getElementById('totalUE'));

            var n = totalUE.value;

            var nb = parseFloat(n);
            nb = nb-UEs;
            document.getElementById('totalUE').value = nb;
        }
    }



    function sessionChargement(name)
    {

        var valeur = document.getElementById('numChargement').value;

        $.get("{{url('chargement/sessionChargement?ID=')}}"+valeur,function(res,stat){})
    }

    function sessionDate(name)
    {

        var valeur = document.getElementById('dateChargement').value;

        $.get("{{url('chargement/sessionDate?ID=')}}"+valeur,function(res,stat){})
    }



</script>








@endsection