@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html">

    <h1>
        Modifier bon de réception de la production
    </h1>

    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>






<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'POST','action' => ['BonReceptionProductionControlleur@postFormEdit', $bonReception->id_bon_reception]]) !!}
                <div class="form-group">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° Bon réception de la production : </label>
                            <input type="text" class="form-control" name="num_bon_reception" placeholder="N° Bon réception de la production " required value="{{$bonReception->id_bon_reception}}" readonly>
                        </div>
                    </div>
                    <br>
                    <br>
                    <br>
                    <br>

                    <div class="col-lg-12 col-md-12 col-sm-12">

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Date de création : </label>
                            <input type="date" class="form-control" id="date_creation"  name="date_creation" value="{{Session::get('dateCreation')}}" onchange="saveDate()" required >

                        </div>

                    </div>
                </div>
                <div class="col-lg-12">
                    <div  style="float: right" >
                        <a href="#ajouterLigneBonReceptionProduction" data-toggle="modal" class="btn btn-block btn-primary" style="margin-bottom: 2%" >
                            <span class="glyphicon glyphicon-plus" ></span>
                            Ajout produit
                        </a>
                    </div>

                    <br>
                    <br>
                    <br>

                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="table-responsive">
                        <table id="example1" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">Référence produit</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Qantité réceptionner</th>
                                <th class="text-center sorting_asc">Modifier</th>
                                <th class="text-center sorting_asc">Annuler</th>
                            </tr>
                            </thead>

                            <tbody>



                            @foreach( $lignes as $ligne)
                                <tr role="row" class="odd">
                                    <td class="text-center sorting_1">{!!$ligne->stockProduit->produit->reference!!}</td>
                                    <td class="text-center sorting_1">{!!$ligne->stockProduit->produit->designation!!}</td>
                                    <td class="text-center sorting_1">{!!$ligne->quantite_receptionner!!}</td>
                                    <td class="text-center sorting_asc">
                                        <a href="#edite{{$ligne->id_ligne_bon_reception}}" class="glyphicon glyphicon-edit"  data-toggle="modal">

                                        </a>
                                    </td >
                                    <td class="text-center sorting_asc">
                                        <a href="#DeleteModal{{$ligne->id_ligne_bon_reception}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                                        </a>
                                    </td>

                                </tr>


                            @endforeach

                            </tbody>
                        </table>
                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">

                        <a href="{{url('receptions/reception_production/modifier/annuler', $bonReception->id_bon_reception)}}" class="btn btn-default pull-right" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-primary pull-right">Valider</button>

                    </div>

                </div>
            </div>
            {!! Form::close() !!}
        </div><!-- /.box -->


        <!--  POPUP pour ajout produit  -->

        <div cl1ass="example-modal" >
            <div class="modal" id="ajouterLigneBonReceptionProduction">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" style="font-family:verdana;">Ajout produit </h4>
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['method'=>'POST','action' => ['BonReceptionProductionControlleur@postAddLigneBonReceptionProductionEdit', $bonReception->id_bon_reception]]) !!}
                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Produit </label>
                                    <select id="idSelecReference" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="produit" required="required">
                                        <option value="">Sélectionner le produit</option>
                                        @foreach($produits as $produit)
                                            <option value="{{$produit->id_produit}}" > {{$produit->reference}} -- {{$produit->designation}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Quantité réceptionnée </label>
                                    <input type="number" class="form-control" id="quantiteReceptionnee" name="quantiteReceptionnee" placeholder="Quantité réceptionnée" required  >
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Numéro de lot </label>
                                    <input type="number" class="form-control" id="numeroLot" name="numeroLot" placeholder="Numéro de lot" required  >
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Date de fabrication</label>
                                    <input type="date" class="form-control" id="dateFabrication" name="dateFabrication" placeholder="Date de fabrication" required >
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Date de péremption</label>
                                    <input type="date" class="form-control" id="datePeremption" name="datePeremption" placeholder="Date de péremption" required >
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Zone de stockage</label>
                                    <select id="idSelectZone" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" onchange="getEmplacementV1(this.value)" name="zone" required="required">
                                        <option selected disabled>Séléctionner la zone de stockage...</option>
                                        @foreach($zones as $zone)
                                            <option value="{{$zone->id_zone}}" >{{$zone->libelle}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Emplacement du nouveau stock du produit</label>
                                    <select id="idSelectEmplacement" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="emplacement" required="required">
                                        <option selected disabled>Séléctionner l'emplacement de ce nouveau stock ...</option>
                                    </select>
                                </div>
                            </div>


                        </div>

                        <div class="hidden">

                            <input type="text" id="dateCreationBonReception" name="dateCreationBonReception" value="{{Session::get('dateCreation')}}">
                            <input type="text" id="dateEntree" name="dateEntree" value="<?php echo date("Y-m-d");?>">

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">Valider</button>
                        </div>
                        {!! Form::close() !!}

                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
        </div>



    @foreach($lignes as $ligne)

            <div cl1ass="example-modal" >
                <div class="modal" id="edite{{$ligne->id_ligne_bon_reception}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;">Modifier produit</h4>
                            </div>
                            <div class="modal-body">
                                {!! Form::open(['method'=>'PUT','action' => ['BonReceptionProductionControlleur@postEditeLigneBonReceptionProductionEdit',$ligne->id_ligne_bon_reception,$bonReception->id_bon_reception]]) !!}

                                <div class="col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label>Produit </label>
                                        <select id="idSelecReference" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="produit" required="required">
                                            @foreach($produits as $produit)
                                                <option value="{{$produit->id_produit}}" @if($produit->id_produit == $ligne->stockProduit->id_produit) selected @endif  > {{$produit->reference}} -- {{$produit->designation}} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label>Quantité réceptionnée </label>
                                        <input type="number" class="form-control" id="quantiteReceptionnee{{$ligne->id_ligne_bon_reception}}" name="quantiteReceptionnee" placeholder="Quantité réceptionnée" value="{{$ligne->quantite_receptionner}}" required  >
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label>Numéro de lot </label>
                                        <input type="number" class="form-control" id="numeroLot{{$ligne->id_ligne_bon_reception}}" name="numeroLot" placeholder="Numéro de lot" value="{{$ligne->stockProduit->numero_lot}}" required  >
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label>Date de fabrication</label>
                                        <input type="date" class="form-control" id="dateFabrication{{$ligne->id_ligne_bon_reception}}" name="dateFabrication" placeholder="Date de fabrication" value="{{$ligne->stockProduit->date_fabrication}}" required  >
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label>Date de péremption</label>
                                        <input type="date" class="form-control" id="datePeremption{{$ligne->id_ligne_bon_reception}}" name="datePeremption" placeholder="Date de péremption" value="{{$ligne->stockProduit->date_peremption}}" required >
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label>Zone de stockage</label>
                                        <select id="idSelectZone" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" onchange="getEmplacementV2(this.value, {{$ligne->stockProduit->date_peremption}})" name="zone" required="required" >
                                            <option selected disabled>Séléctionner la zone de stockage...</option>
                                            @foreach($zones as $zone)
                                                <option value="{{$zone->id_zone}}" @if(($ligne->stockProduit->emplacement->id_zone != null) &&($ligne->stockProduit->emplacement->id_zone == $zone->id_zone)) selected @endif >{{$zone->libelle}} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label>Emplacement du nouveau stock du produit</label>
                                        <select id="idSelectEmplacement{{$ligne->id_ligne_bon_reception}}" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="emplacement" required="required" >
                                            <option selected disabled>Séléctionner l'emplacement de ce nouveau stock ...</option>
                                            @foreach($emplacements as $emplacement)
                                                @if($emplacement->id_zone == $ligne->stockProduit->emplacement->id_zone)
                                                    <option value="{{$emplacement->id_emplacement}}" @if($emplacement->id_emplacement == $ligne->stockProduit->id_emplacement) selected @endif>
                                                        {{$emplacement->libelle}}
                                                    </option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="hidden">

                                <input type="text" id="dateCreationBonReception{{$ligne->id_ligne_bon_reception}}" name="dateCreationBonReception"  value="{{Session::get('dateCreation')}}">

                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>
                            {!! Form::close() !!}

                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>

            <div class="example-modal">
                <div class="modal" id="DeleteModal{{$ligne->id_ligne_bon_reception}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                            </div>
                            <div class="modal-body">
                                <p>Voulez-vous vraiment supprimer ce produit de ce bon de réception production ?</p>
                            </div>

                            <div class="modal-footer">
                                {!! Form::open(['method' => 'POST', 'action' => ['BonReceptionProductionControlleur@deleteLigneBonReceptionEdit',$ligne->id_ligne_bon_reception,$bonReception->id_bon_reception]]) !!}
                                <div class="hide">
                                    <input type="text" id="dateCreationBonReceptionS{{$ligne->id_ligne_bon_reception}}" name="dateCreationBonReception" value="{{Session::get('dateCreation')}}">
                                </div>
                                <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                {!! Form::close() !!}
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>



        @endforeach




</section><!-- /.content -->






<script>

    saveDate();


    function saveDate(){

        document.getElementById("dateCreationBonReception").value = document.getElementById("date_creation").value;

        @foreach($lignes as $ligne)

            document.getElementById("dateCreationBonReception{{$ligne->id_ligne_bon_reception}}").value = document.getElementById("date_creation").value;
        document.getElementById("dateCreationBonReceptionS{{$ligne->id_ligne_bon_reception}}").value = document.getElementById("date_creation").value;

        @endforeach

    }


    function getEmplacementV1(id_zone){

        //alert(id_zone);

        $.get("{{url('stock_produit/emplacements?ID=')}}"+id_zone, function(res,stat){
            var select1 = document.getElementById("idSelectEmplacement");
            // var nom= document.getElementById("input3");

            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value=''>Séléctionner l'emplacement de ce nouveau stock ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_emplacement+"'> "+res[i].libelle+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }


        });
    }

    function getEmplacementV2(id_zone, idLigne){

        //alert(id_zone);

        $.get("{{url('stock_produit/emplacements?ID=')}}"+id_zone, function(res,stat){
            var select1 = document.getElementById("idSelectEmplacement"+idLigne);
            // var nom= document.getElementById("input3");

            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value=''>Séléctionner l'emplacement de ce nouveau stock ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_emplacement+"'> "+res[i].libelle+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }


        });
    }

</script>





@endsection