@extends('app')
@section('content')

        <!-- Content Header (Page header) -->



<section class="content-header">
    <div class="box-tools pull-right">
        <a href="{{ url('receptions/reception_production/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>

    <h1>
        Gestion des réceptions de la production
    </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDelete'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgDelete') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif


    @if(Session::has('msgSupprimer'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgSupprimer') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgAjouter'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAjouter') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
                <!-- Default box -->
        <div class="box">

            <table id="example1" class="table table-bordered table-striped dataTable">
                <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N° Bon de réception</th>
                    <th class="text-center sorting_asc">Date de création</th>
                    <th class="text-center sorting_asc">Détail</th>
                    <th class="text-center sorting_asc">Modifier</th>
                    <th class="text-center sorting_asc">Supprimer</th>
                </tr>
                </thead>

                <tbody>
                @foreach( $bons_receptions as $bon_reception)
                    <tr role="row" class="odd">
                        <td class="text-center sorting_1">{!!$bon_reception->id_bon_reception!!}</td>
                        <td class="text-center sorting_1">{!!$bon_reception->date_creation!!}</td>
                        <td class="text-center sorting_1">
                            <a href="{{url('receptions/reception_production/detail')}}/{{$bon_reception->id_bon_reception}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                            </a>
                        </td>
                        <td class="text-center sorting_asc">
                            <a href="{{url('receptions/reception_production/modifier')}}/{{$bon_reception->id_bon_reception}}" class="glyphicon glyphicon-edit">

                            </a>
                        </td >
                        <td class="text-center sorting_asc">
                            <a href="#DeleteModal{{$bon_reception->id_bon_reception}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                            </a>
                        </td>
                    </tr>


                    <div class="example-modal">
                        <div class="modal" id="DeleteModal{{$bon_reception->id_bon_reception}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce bon de réception ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['BonReceptionProductionControlleur@delete',$bon_reception->id_bon_reception]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>



                @endforeach
                </tbody>

            </table>


        </div><!-- /.box -->
</section><!-- /.content -->






@endsection