@extends('app')
@section('content')
    <!-- Content Header (Page header) -->
    {!! Html::script('assets/js/jsPDF/jspdf.js') !!}
    <!--<script src="../../assets/js/jspdf/jspdf.js"></script>-->
    {!! Html::script('assets/js/jsPDF/dist/jspdf.min.js') !!}
    <!--<script src="../../assets/js/jspdf/dist/jspdf.min.js"></script>-->
    {!! Html::script('assets/js/jsPDF/jsPDF-AutoTable/dist/jspdf.plugin.autotable.js') !!}
    <section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">
        <h1>
            Modification du bon de réception
        </h1>

    </section>
    <!-- Main content -->
    <section class="content">
        <!-- Messages -->

        @if(Session::has('msgAdd'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgAdd') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif

        @if(Session::has('msgExist'))
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgExist') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
    @endif
    @if(Session::has('msgAjouter'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>
                    {!! session('msgAjouter') !!}
                </em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif
    <!-- fin messages -->
        <!-- Default box -->
        <div class="box" id="MYDIV">
            {!! Form::open(['method'=>'POST','action' => ['BonReceptionFournisseurControlleur@postFormEditUE',$bonReception->id_bon_reception]]) !!}
            <div class="box-body">
                <div class="box-tools pull-right">


                            <input type="submit" value="Modifier" class="btn btn-block btn-primary" >


                </div>
                <div class="form-group">
                    <div class="col-lg-12">
                        <div class="col-lg-3">

                            <label>N° Commande fournisseur : </label>
                            <input type="text" class="form-control" id="num_commande" name="num_commande" placeholder=""   @if($bonReception->id_commande > 0) value="{{$bonReception->commandeFounisseur->num_commande_fournisseur}}" @endif>
                        </div>

                        <div class="col-lg-3">
                            <label>Fournisseur : </label>
                            <select  class="form-control " name="fournisseur" >
                                <option selected disabled value="">Sélectionner le fournisseur ...</option>
                                @foreach($fournisseurs as $fournisseur)
                                    <option value="{{$fournisseur->id_fournisseur}}" @if($bonReception->id_commande > 0)@if($commande->id_fournisseur == $fournisseur->id_fournisseur ) selected  @endif @endif > {{$fournisseur->societe}} </option>
                                @endforeach
                            </select>


                        </div>

                        <div class="col-lg-3">
                            <label>Contrat : </label>
                            <input type="text" class="form-control" id="contrat" name="contrat" placeholder=""  value="{{$bonReception->contrat}}">
                        </div>

                        <div class="col-lg-3">
                            <label>Facture : </label>
                            <input type="text" class="form-control" id="facture" name="facture" placeholder=""  value="{{$bonReception->facture}}">
                        </div>

                    </div>
                    <div class="col-lg-12 ">
                        <div class="col-lg-3">
                            <label>N° Bon réception : </label>
                            <input type="text" class="form-control" id="num_bon_reception" name="num_bon_reception" placeholder="" required value="{{$bonReception->num_bon_reception}}" readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Date bon de réception :</label>
                            <input type="date" class="form-control" id="date_creation"  name="date_creation" value="{{$bonReception->date_creation}}"  required readonly >

                        </div>
                        @if (Session::get('STOCK_ENTITE')=='1')
                            <div class="col-lg-6">
                                <label>Entité : </label>
                                <input id="entitee"type="text" class="form-control"
                                       @if ($bonReception->entite != null)
                                       @if ($bonReception->entite->libelle_entite != null)
                                       value="{{ $bonReception->entite->type_entite }} / {{ $bonReception->entite->num_entite }} / {{ $bonReception->entite->libelle_entite  }}"
                                       @else
                                       value="{{ $bonReception->entite->type_entite }} / {{ $bonReception->entite->num_entite }} "
                                       @endif
                                       @endif

                                       readonly >

                            </div>
                        @endif

                        <div class="col-lg-3">
                            <label>N° de document : </label>
                            <input type="text" class="form-control" id="num_document"
                                   @if (Session::get('TYPE_NUMERO_DOCUMENT') == "1")
                                   value="PACKING LIST / {{ $bonReception->num_document }}"
                                   @else
                                   value="{{ $bonReception->num_document }}"
                                   @endif

                                   readonly >

                        </div>
                        <div class="col-lg-3">
                            <label>Statut : </label>
                            <input type="text" class="form-control" id="statut"  name="date_creation" @if($bonReception->statut==0 ) value="En attente réception"  @elseif($bonReception->statut==2 || $bonReception->statut == 1)value="En attente validation"
                                   @elseif($bonReception->statut==3)
                                   value="Validé"
                                   @endif  required readonly >

                        </div>


                        @if(Session::get('USE_UE')=='1')
                            @if ($bonReception->unite_expedition == "1")
                                <div class="col-lg-3">
                                    <br>
                                    <input type="checkbox" name="ue" id="unite_expedition" disabled
                                           checked >
                                    <label>Avec unité d'expédition</label>
                                </div>
                                <br>
                                <br>
                            @endif
                        @endif
                        <br>

                    </div>
                    <br>
                    <br>
                    <br>



                </div>



                <div class="col-lg-12">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <br>
                        <table id="example1" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr role="row">
                                @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                                    <th class="text-center sorting_asc">N°UE</th>
                                @endif


                                <th class="text-center sorting_asc">Référence produit</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Emplacement</th>
                                <th class="text-center sorting_asc">Quantité</th>
                                <th class="text-center sorting_asc">Reste à recevoir</th>
                                <th class="text-center sorting_asc">Quantité réceptionnée(prévisionnelle)</th>
                                <th class="text-center sorting_asc">Quantité réceptionnée(réelle)</th>
                                <th class="text-center sorting_asc">Opérateur</th>
                                <th class="text-center sorting_asc">N° de série</th>
                                @if ($bonReception->statut!=3)
                                    @if(Session::get('FOURNISSEURS_RECEPTION_SIMULER_FO')=='1')
                                        <th class="text-center sorting_asc">
                                            Simuler saisie FO
                                        </th>
                                    @endif
                                @endif
                            </tr>
                            </thead>
                            <tbody>
                            @foreach( $collection as $ligneBonReception)
                                <tr role="row" class="odd">
                                    @if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                                        <td class="text-center sorting_1">{{$ligneBonReception->sscc}}</td>

                                    @endif

                                    <td class="text-center sorting_1">{{$ligneBonReception->produit->reference}}</td>

                                    <td class="text-center sorting_1">{{$ligneBonReception->produit->designation}}</td>

                                    <td class="text-center sorting_1">{{$ligneBonReception->Emplacement->libelle}}</td>

                                    <td class="text-center sorting_1">
                                        {{ (float)$ligneBonReception->quantite_commander}}
                                    </td>

                                    <td class="text-center sorting_1">
                                        {{ (float)$ligneBonReception->quantite_reste_receptionnee}}
                                    </td>

                                    <td class="text-center sorting_1">{{ (float)$ligneBonReception->quantite_receptionner}}</td>
                                    <td class="text-center sorting_1">
                                        {{ (float)$ligneBonReception->qteReceptionnerFO }}
                                    </td>
                                    @if($ligneBonReception->operateur == 0)
                                        <td class="text-center sorting_1"></td>
                                    @else
                                        <td class="text-center sorting_1">{{$ligneBonReception->Operateur->nom}}  {{$ligneBonReception->Operateur->prenom}}</td>
                                    @endif
                                    <td class="text-center sorting_1">
                                        <a class="glyphicon glyphicon-eye-open" style="cursor: pointer;" onclick="numSerie({{ $ligneBonReception->id_ligne_bon_reception}}, {{ $ligneBonReception->produit}})"></a>
                                    </td>
                                    @if ($bonReception->statut!=3)
                                        @if(Session::get('FOURNISSEURS_RECEPTION_SIMULER_FO')=='1')

                                            <td class="text-center sorting_1">
                                                <a class="glyphicon glyphicon-edit" style="cursor: pointer;" onclick="simule_saisie_fo({{$ligneBonReception->quantite_receptionner}} , {{$bonReception->id_bon_reception  }}, {{ $ligneBonReception->id_ligne_bon_reception }}, {{$ligneBonReception->qteReceptionnerFO}},{{ $ligneBonReception->produit }});">
                                                </a>
                                            </td>

                                        @endif
                                    @endif
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div style="float: right">

                        <a href="{{url('receptions/reception_fournisseur/index')}}" class="btn btn-default" data-dismiss="modal">Retour</a>

                    </div>

                </div>
            </div>
        </div><!-- /.box -->
        {!! Form::close() !!}

    </section><!-- /.content -->


    <div class="modal fade" id="modal-quantite-reelle">
        <div class="modal-dialog">
            <form method="post" action="{{ route('simule_saisie_fo_ue') }}">
                {{ csrf_field() }}
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Quantité réceptionnée(réelle) </h4>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="bon_reception" id="bon_reception">
                        <input type="hidden" name="ligne_bon_reception" id="ligne_bon_reception">
                        <div class="form-group">
                            <label>Opérateur</label>
                            <input type="text" id="" class="form-control" disabled value="{{Session::get('nom')." ".Session::get('prenom')}}" style="text-align: center">
                        </div>
                        <div class="form-group">
                            <label>Produit</label>
                            <textarea class="form-control" rows="3" id="produit" readonly style="text-align: center"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Quantité réceptionnée(prévisionnelle)</label>
                            <input type="text" id="quantite_RP" min="1" class="form-control" disabled style="text-align: center">
                        </div>
                        <div class="col-sm-12">
                            <br>
                            <div class="form-group">
                                <label>Quantité réceptionnée(réelle)</label>
                                <input type="number" step="0.01" min="0" id="quantite_RR" required name="quantite_RR" class="form-control" style="text-align: center">
                            </div>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Annuler</button>
                        <input type="submit" class="btn btn-primary" value="Valider">

                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <input type="hidden" id="loool" value="lol">
    <!-- /.modal -->

    <div class="modal" id="valider_reception_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                </div>
                <div class="modal-body">
                    <p>Voulez-vous vraiment valider la réception ?</p>
                </div>

                <div class="modal-footer">

                    <a href="{{url('/receptions/reception_fournisseur_ue/valider')}}/{{$bonReception->id_bon_reception}}" class="btn btn-flat btn-primary pull-right">
                        Valider
                    </a>
                    <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>

                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

    <div class="box" hidden>

        @if (isset($collection))
            <table id="table" class="table table-bordered table-striped">
                <thead>
                <tr role="row">
                    @if(Session::get('CONTENEUR') == '1')
                        <th>N° CONTENEUR</th>
                    @endif
                    <th>N°UE</th>
                    <th>CODE PRODUIT</th>
                    <th>QUANTITÉ</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($collection as $key => $ligneBonReception)
                    <tr role="row">
                        @if(Session::get('CONTENEUR') == '1')
                            <td>{{ $ligneBonReception->n_conteneur }}</td>
                        @endif
                        <td>{{ $ligneBonReception->sscc }}</td>
                        <td>{{ $ligneBonReception->produit->code_identification }}</td>
                        <td>{{ (float) $ligneBonReception->qteReceptionnerFO }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            <br><br>
            <div class="hidden">
                <input type="text"   id="header" @if($configuration != null) value="{{$configuration->header}}" @else value="" @endif >
                <input type="text"   id="footer"  @if($configuration != null)  value="{{$configuration->footer}}" @else value="" @endif>
                <img  id="logo" @if($configuration != null) src="{{ asset('/dist/img/'.$configuration->image) }}" @else src="" @endif width="20%" height="20%" alt="User Image">
            </div>
        @endif

    </div>

    <div class="modal fade" id="modal-detail_num_serie">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Liste des N° de série </h4>
                </div>
                {!! Form::open(['method'=>'POST','action' => ['BonReceptionFournisseurControlleur@postFormEditSN',$bonReception->id_bon_reception]]) !!}


                <div class="modal-body">
                    <b id="desi_produit"></b><br>
                    <b id="ref_produit"></b><br>


                    <main id="tebleau">
                        <br>
                        <table id="example8" class="table table-bordered table-striped" style="text-align: center">
                            <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">N° de série</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </main>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" >Valider</button>

                    <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                </div>
                {!! Form::close() !!}
               
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

    <script>

        function numSerie(ligneReception,produit){
            //alert(ligneReception);
            $.ajax({

                url: "{{url('receptions/reception_fournisseur_ue/num_serie')}}/"+ligneReception,
                method : "post",
                data: {
                    "_token": "{{ csrf_token() }}"
                } ,
                success: function(data){
                    document.getElementById("desi_produit").innerHTML = "Désignation Produit : "+produit.designation;
                    document.getElementById("ref_produit").innerHTML = "Référence Produit : "+produit.reference;

                    var t = $('#example8').DataTable();
                    t.clear().draw();

                    var myModal = $('#modal-detail_num_serie');

                    var vals = Object.keys(data).map(function(key) {
                        t.row.add( [
                            '<input class="form-control" style="text-align: center "type="text" name="num_serie[]" value="'+data[key].num_serie+'"> <input type="hidden" name="id_num_serie[]" value="'+data[key].id_num_serie+'"><input type="hidden" name="id_ligne_reception[]" value="'+data[key].id_ligne_reception+'">',

                        ] ).draw( false );
                    });

                    myModal.modal({ show: true });
                },
                error: function(data){
                    alert('oops erreur de serveur !!');
                }
            });
        }



        function get_ue_from_produit(designation,id_ligne_bon_reception,id_produit,emplacement,reference){
            $.ajax({
                url: "{{url('receptions/reception_fournisseur/detail/ue')}}/"+id_ligne_bon_reception,
                method : "post",
                data: {
                    "_token": "{{ csrf_token() }}"
                } ,
                success: function(data){
                    var t = $('#example7').DataTable();
                    t.clear().draw();

                    var myModal = $('#modal-detail_ue');

                    document.getElementById('id_produit').value = id_produit;
                    document.getElementById('ligne').value = id_ligne_bon_reception;
                    document.getElementById("reference_produit_ue").innerHTML = "Référence Produit : "+reference;
                    document.getElementById("designation_produit_ue").innerHTML = "Désignation Produit : "+designation;
                    document.getElementById("emplacement_produit_ue").innerHTML = "Emplacement du produit : "+emplacement;
                    //document.getElementById("emplacement_produit_ue").innerHTML = "Emplacement Produit : "+emplacement;


                    document.getElementById('liste_ue').hidden =true;

                    var vals = Object.keys(data).map(function(key) {
                        t.row.add( [
                            '<b>'+data[key].sscc+'</b>'
                        ] ).draw( false );
                    });
                    document.getElementById('ssccPdf').disabled = false;

                    myModal.modal({ show: true });
                },
                error: function(data){
                    alert('oops erreur de serveur !!');
                }
            });
        }


        function simule_saisie_fo(quantite_receptionner_previsionnelle,bon_reception,ligne_bon_reception,quantite_receptionner_reelle,objetProduit) {
            var myModal = $('#modal-quantite-reelle');
            document.getElementById('produit').value = objetProduit.reference +", "+objetProduit.designation;
            document.getElementById('quantite_RP').value = quantite_receptionner_previsionnelle ;
            document.getElementById('quantite_RR').value = quantite_receptionner_reelle ;
            document.getElementById('bon_reception').value = bon_reception;
            document.getElementById('ligne_bon_reception').value = ligne_bon_reception;

            myModal.modal({ show: true });
        }




        function genPDF1() {
            var imgData =  document.getElementById('logo');
            var header = document.getElementById('header').value;
            var footer = document.getElementById('footer').value;

            var doc = new jsPDF('p', 'pt');
            doc.setFontSize(14);
            var titre="Rapport détaillé d'un bon de réception";
            //doc.text(titre, 250, 100);

            doc.setFontSize(14);

            var width_titre = doc.getTextWidth(titre);
            var space_titre=doc.internal.pageSize.width-width_titre;
            space_titre=space_titre/2;
            doc.text(titre, space_titre, 100, {
                startY: doc.autoTable.previous.finalY + 15,
                margin: {horizontal: 7},
                columnStyles: {text: {columnWidth: 'auto'}}

            });
            doc.setFontSize(12);
            /*var width_titre = doc.getTextWidth(titre);
            var space_titre=doc.internal.pageSize.width-width_titre;
            space_titre=space_titre/2;
            doc.text(titre, space_titre, 100, {
                startY: doc.autoTable.previous.finalY + 15,
                margin: {horizontal: 7},

            });*/

            doc.text('N° Bon réception : ' +document.getElementById("num_bon_reception").value, 60, 140);

            doc.text('N° de document : ' +document.getElementById("num_document").value, 60, 160);

            doc.text('Date bon de réception : ' +document.getElementById("date_creation").value, 340, 140);
            //doc.text('Statut : '+ document.getElementById("statut").value, 340, 120);
            @if (Session::get('STOCK_ENTITE') == "1")
            doc.text('Entité : ' +document.getElementById("entitee").value, 60, 180);
                    @endif

            var step = 300;
            var startTable = 200;
            var elem = document.getElementById("table");
            var res = doc.autoTableHtmlToJson(elem);
            doc.autoTable(res.columns, res.data, {
                tableWidth: 'auto',
                startY: startTable,
                margin: {horizontal: 7},
                styles: {overflow: 'linebreak', columnWidth: 'auto',cellPadding: 6, fontSize: 10,halign: 'center'},
                columnStyles: {text: {columnWidth: 'auto'}},
                addPageContent: function (data) {
                    doc.setTextColor(10);
                    doc.setFontStyle('arial');
                    doc.setFontSize(10);
                    var splitTitle;
                    var space;
                    var space1;
                    var width = doc.getTextWidth(footer);
                    if(width>350){
                        splitTitle  = doc.splitTextToSize(footer, 350);
                        space=doc.internal.pageSize.width-350;
                    }else{
                        splitTitle=footer;
                        space=doc.internal.pageSize.width-width;
                    }
                    space1=space/2;
                    doc.text(splitTitle, space1, doc.internal.pageSize.height - 40);
                    doc.setFontSize(10);
                    splitTitle = doc.splitTextToSize(header, 250);
                    doc.text(splitTitle,320, 40);
                    var image = new Image();
                    var img = document.getElementById('logo');
                    image = img ;
                    image.src=img.src ;
                    image.width = 200;
                    image.height = 70;
                    doc.addImage(img, 'PNG',40,20);
                },
                margin: {top: 100, left:10,right:10,bottom:50},

            });
            step = doc.autoTable.previous.finalY + 50;
            startTable = step + 10;


            doc.save("Bon de réception.pdf");
        }

        function supprimer(id) {
            if(confirm("Voulez?"))
            {
                $.ajax({
                    url:"delete.php",
                    method:"POST",
                    data:{id:id},
                    success:function(data){
                        $('#alert_message').html('<div class="alert alert-success">'+data+'</div>');
                        $('#example8').DataTable().destroy();
                        fetch_data();
                    }
                });
                setInterval(function(){
                    $('#alert_message').html('');
                }, 5000);
            }

        }


    </script>

@endsection

