@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Modifier le bon de réception
    </h1>

</section>




<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('ajouter'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('ajouter') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

     @if(Session::has('erreur'))
        <div class="box box-danger box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('erreur') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgAjouter'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAjouter') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif
                <!-- fin messages -->
        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'PUT','action' => ['BonReceptionFournisseurControlleur@postFormEdit', $bonReception->id_bon_reception]]) !!}
                <div class="form-group">
                    <div class="col-lg-12 ">
                        <div class="col-lg-3">
                            <label>N° Bon réceprion : </label>
                            <input type="text" class="form-control" name="num_bon_reception" placeholder="" required value="{{$bonReception->num_bon_reception}}" readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Date bon de réception : </label>
                            <input type="date" class="form-control" id="date_creation"  name="date_creation" value="{{$bonReception->date_creation}}"  required readonly >
                        </div>
                        @if(Session::get('AVEC_UE')=='1')
                            @if ($bonReception->unite_expedition == "1")
                                <div class="col-lg-3">
                                    <br>
                                    <input type="checkbox" name="ue" id="unite_expedition" disabled
                                     checked >
                                    <label>Avec unité d'expédition</label>
                                 </div>
                            @endif
                        @endif

                    </div>
                    <br>
                    <br>
                    <br>
                    <br>

                    <div class="col-lg-12">
                        <div class="col-lg-3">
                            <label>Commande fournisseur : </label>
                            <input type="text" class="form-control" id="idCommandeFounisseur"  name="idCommandeFounisseur" value="{{$commandeFournisseur->num_commande_fournisseur}}"  required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Le Fournisseur :</label>
                            <input type="text" class="form-control" id="fournisseur" name="fournisseur" placeholder="Fournisseur" value ="{{$commandeFournisseur->fournisseur->societe}}" required readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Le Contact : </label>
                            <input type="text" class="form-control" id="contactFournisseur" name="contactFournisseur" placeholder="Contact" value="{{$commandeFournisseur->fournisseur->contact}}" required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Date commande fournisseur : </label>
                            <input type="date" class="form-control" id="dateCreationCommandeFournisseur"  name="dateCreationCommandeFournisseur"  value="{{$commandeFournisseur->date_creation}}" required readonly>
                        </div>

                    </div>
                    <br>
                    <br>
                    <br>
                </div>
                
                    <br> 
                    <a data-toggle="modal" data-target="#ajouter_produit_modal" class="btn btn-primary" style="float: right;margin-right:1.5%;" >
                            Ajouter produit non commandé
                </a>
                <br><br><br>
                <div class="col-lg-12">
                    <table id="example1" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr role="row">
                            <th class="text-center sorting_asc">Produit commandé</th>
                            <th class="text-center sorting_asc">Référence produit</th>
                            <th class="text-center sorting_asc">Désignation</th>
                            <th class="text-center sorting_asc">Quantité commandée</th>
                            <th class="text-center sorting_asc">Reste à recevoir</th>
                            <th class="text-center sorting_asc">Qantité réceptionnée</th>
                            <th class="text-center sorting_asc">Modifier la quantité à réceptioner</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach( $lignesBonReception as $ligneBonReception)
                            <tr role="row" class="odd">
                                 <td class="text-center sorting_1">
                                    @if ($ligneBonReception->id_ligne_commande_fournisseur == 0)
                                        <small class="label bg-red">Non</small>
                                    @else
                                        <small class="label bg-green">Oui</small>
                                    @endif    
                                </td>
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <td class="text-center sorting_1">{{$ligneBonReception->ligneCommandeFournisseur->produit->reference}}</td>
                                @else
                                    <td class="text-center sorting_1">{{$ligneBonReception->produit->reference}}</td>
                                @endif
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <td class="text-center sorting_1">{{$ligneBonReception->ligneCommandeFournisseur->produit->designation}}</td>
                                @else
                                    <td class="text-center sorting_1">{{$ligneBonReception->produit->designation}}</td>
                                @endif

                                <td class="text-center sorting_1">{{(float) $ligneBonReception->quantite_commander}}</td>
                                
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <td class="text-center sorting_1">
                                    {{ (float) $ligneBonReception->ligneCommandeFournisseur->quantite_commander- $ligneBonReception->ligneCommandeFournisseur->quantite_receptionner }}</td>
                                @else
                                    <td class="text-center sorting_1">{{ (float) $ligneBonReception->quantite_reste_receptionnee}}</td>
                                @endif
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <td class="text-center sorting_1">{{ (float) $ligneBonReception->quantite_receptionner}}</td>
                                @else
                                    <td class="text-center sorting_1">{{ (float) $ligneBonReception->qteReceptionnerFO}}</td>
                                @endif
                                
                                @if ($ligneBonReception->id_ligne_commande_fournisseur == 0 ||
                                ($ligneBonReception->id_ligne_commande_fournisseur != 0 && 
                                    $ligneBonReception->qteReceptionnerFO == 0) )
                                    <td class="text-center sorting_1">
                                        <a href="#edit{{$ligneBonReception->id_ligne_bon_reception}}" class="glyphicon glyphicon-edit"  data-toggle="modal">
                                        </a>
                                    </td>
                                @else
                                    <td class="text-center sorting_1"></td>
                                @endif
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                    <div class="modal-footer">
                        <a href="{{url('receptions/reception_fournisseur/modifier/annuler/'.$bonReception->id_bon_reception)}}" type="button" class="btn btn-default" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-primary">Valider</button>
                    </div>

                </div>
            </div>
            {!! Form::close() !!}
        </div><!-- /.box -->



        @foreach( $lignesBonReception as $ligneBonReception)

                <!--  POPUP pour ajout produit  -->

        <div cl1ass="example-modal" >
            <div class="modal" id="edit{{$ligneBonReception->id_ligne_bon_reception}}">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <h4 class="modal-title" style="font-family:verdana;">Modifier la quantité à réceptionner du produit <br>
                                [{{ $ligneBonReception->ligneCommandeFournisseur->produit->reference }}, {{ $ligneBonReception->ligneCommandeFournisseur->produit->designation }}]</h4>
                                @else
                                    <h4 class="modal-title" style="font-family:verdana;"> Modifier la quantité à réceptionner du produit <br>
                                [{{ $ligneBonReception->produit->reference }}, {{ $ligneBonReception->produit->designation }}]</h4>
                                @endif
                            
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['method'=>'PUT','action' => ['BonReceptionFournisseurControlleur@postEditeLigneBonReceptionEdit', $ligneBonReception->id_ligne_bon_reception, $bonReception->id_bon_reception]]) !!}

                            <div class="col-lg-12">
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <div class="form-group col-lg-12">
                                        <label>Quantité commandée</label>
                                        <input type="number" step="0.01" class="form-control" id="quantiteCommandee0" name="quantiteCommandee" placeholder="Quantité commandée" step="1" required  value="{{ (float) $ligneBonReception->quantite_commander}}" readonly >
                                    </div>
                                @endif
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <div class="form-group col-lg-12">
                                        <label>Reste à recevoir</label>
                                        <input type="number"  step="0.01"class="form-control" id="quantiteReste0" name="quantiteReste" placeholder="" step="1" required  value="{{ (float) $ligneBonReception->ligneCommandeFournisseur->quantite_commander- $ligneBonReception->ligneCommandeFournisseur->quantite_receptionner
                                        }}" readonly >
                                    </div>
                                @endif
                                <div class="form-group col-lg-12">
                                    <label>Quantité réceptionnée</label>
                                    <input type="number" step="0.01" class="form-control" id="quantiteReceptionnee0" name="quantiteReceptionnee" placeholder="Quantité réceptionnée" min="1" 
                                    @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                        max="{{$ligneBonReception->quantite_commander}}" 
                                    @endif
                                    required
                                     @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                     value="{{ (float) $ligneBonReception->quantite_receptionner}}" 
                                    @else
                                     value="{{ (float) $ligneBonReception->qteReceptionnerFO}}" 
                                    @endif>
                                </div>
                                @if(Session::get('N_LOT')=='1')
                                    <div class="form-group col-lg-12">
                                        <label>Numéro de lot</label>
                                        <input type="text" class="form-control" id="numeroLot" name="numeroLot" placeholder="Numéro de lot" required value="{{$ligneBonReception->numLot}}">
                                    </div>
                                @endif
                                @if(Session::get('DATE_PEREMPTION')=='1')
                                <div class="form-group col-lg-12">
                                    <label>Date de fabrication</label>
                                    <input type="date" class="form-control" id="dateFabrication" name="dateFabrication" placeholder="Date de fabrication" required value="{{$ligneBonReception->date_fabrication}}">
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Date de péremption</label>
                                    <input type="date" class="form-control" id="datePeremption" name="datePeremption" placeholder="Date de péremption" required value="{{$ligneBonReception->date_peremption}}">
                                </div>
                                @endif
                                <div class="form-group col-lg-12">
                                    <label>Zone de stockage</label>
                                    <select id="idSelectZone" class="form-control" name="zone" onchange="getEmplacement(this.value,{{$ligneBonReception->id_ligne_bon_reception}})" required="required">
                                        <option selected disabled>Séléctionner la zone de stockage...</option>
                                        @foreach($zones as $zone)
                                            <option value="{{$zone->id_zone}}" @if(($ligneBonReception->Emplacement->id_zone != null) &&($ligneBonReception->Emplacement->id_zone == $zone->id_zone)) selected @endif >{{$zone->libelle}} </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Emplacement du nouveau stock du produit</label>
                                    <select id="idSelectEmplacement{{$ligneBonReception->id_ligne_bon_reception}}" class="form-control " name="emplacement" required="required">
                                        @if ($ligneBonReception->idEmplacement != null || $ligneBonReception->idEmplacement != '')
                                        @foreach($emplacements as $emplacement)
                                            @if($emplacement->id_zone == $ligneBonReception->emplacement->zone->id_zone)
                                                <option value="{{$emplacement->id_emplacement}}" @if($emplacement->id_emplacement == $ligneBonReception->idEmplacement) selected @endif>
                                                    {{$emplacement->libelle}}
                                                </option>
                                            @endif
                                        @endforeach
                                            
                                        @else
                                        <option selected value="" disabled>Séléctionner l'emplacement de ce nouveau stock ...</option>
                                        @endif
                                    </select>
                                </div>

                            </div>

                            <div class="hidden">
                                <input type="date" id="dateEntreeEnStock" name="dateEntreeEnStock" value="<?php echo date("Y-m-d");?>">

                            </div>


                            <div class="hide">

                                <input type="text" id="idBonReception{{$ligneBonReception->id_ligne_bon_reception}}" name="idBonReception" value="{{Session::get('idBonReception')}}">
                                <input type="text" id="dateCreationBonReception{{$ligneBonReception->id_ligne_bon_reception}}" name="dateCreationBonReception" value="{{Session::get('dateCreationBonReception')}}">
                                <input type="text" id="fournisseur{{$ligneBonReception->id_ligne_bon_reception}}" name="fournisseur" value="{{Session::get('fournisseur')}}">
                                <input type="text" id="contactFounisseur{{$ligneBonReception->id_ligne_bon_reception}}" name="contactFounisseur" value="{{Session::get('contactFounisseur')}}">
                                <input type="text" id="idLigneCommande{{$ligneBonReception->id_ligne_bon_reception}}" name="contactFounisseur" value="{{Session::get('contactFounisseur')}}">


                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>
                            {!! Form::close() !!}

                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>
        </div>

        <div class="example-modal">
            <div class="modal" id="DeleteModal{{$ligneBonReception->id_ligne_bon_reception}}">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                        </div>
                        <div class="modal-body">
                            <p>Voulez-vous annuler la réception de ce produit ?</p>

                        </div>

                        <div class="modal-footer">
                            {!! Form::open(['method' => 'POST', 'action' => ['BonReceptionFournisseurControlleur@deleteLigneBonReception',$ligneBonReception->id_ligne_bon_reception]]) !!}

                            <div class="hidden">
                                <input type="text" id="idCommande{{$ligneBonReception->id_ligne_bon_reception}}" name="idCommande" value="{{$commandeFournisseur->id_commande_fournisseur}}">
                            </div>

                            <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                            <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                            {!! Form::close() !!}
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
        </div>

        @endforeach

<div class="modal fade" id="ajouter_produit_modal">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Ajouter produit non commandé</h4>
              </div>
               <form method="post" action="{{ route('produitNonCommandeModifier') }}">
                     {{ csrf_field() }}
                     <input type="hidden" name="bonReception" value="{{ $bonReception->id_bon_reception }}">
              <div class="modal-body">
                    <div class="col-sm-12"><br>
                        <div class="form-group">
                            <label>Produit :</label>
                            <select class="form-control selectpicker" data-live-search="true" id="produit" name="produit">
                                <option selected disabled style="background-color: white"> Sélectionner le produit ...</option>
                               @foreach ($produits as $produit)
                                   <option value="{{ $produit->id_produit }}"> {{ $produit->reference}}</option>
                               @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Quantité :</label>
                            <input type="number" step="0.01" min="0" class="form-control" id="quantitee" name="quantitee" required>
                        </div>
                        @if (Session::get('N_LOT') == '1')
                            <div class="form-group">
                                <label>Numéro de lot :</label>
                                <input type="text" class="form-control" id="lot" name="lot" required>
                            </div>
                        @endif
                        @if (Session::get('DATE_PEREMPTION') == '1')
                            <div class="form-group">
                                <label>Date de fabrication :</label>
                                <input type="date" class="form-control" id="dateFabrication" name="dateFabrication" required>
                            </div>
                            <div class="form-group">
                                <label>Date de péremption :</label>
                                <input type="date"  class="form-control" id="datePeremption" name="datePeremption" required>
                            </div>
                        @endif

                        <div class="form-group">
                            <label>La zone de stockage :</label>
                            <select class="form-control" id="zonee" name="zonee" onchange="selectionneZone()" required="required">
                                
                                <option selected disabled value=""> Sélectionner la zone ...</option>
                                @foreach ($zones as $zone)
                                    <option value="{{ $zone->id_zone }}">{{ $zone->libelle }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Emplacement :</label>
                            <select class="form-control" id="emplacement" name="emplacement" required="required">
                                <option selected disabled> Sélectionner l'emplacement ...</option>
                            </select>
                        </div> <br> 

                    </div>
              </div>
          
              <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Annuler</button>
                <input type="submit" class="btn btn-primary" value="Valider" />
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->



</section><!-- /.content -->



<script>
    function getEmplacement(id_zone,idLigne){

        //alert(id_zone);

        $.get("{{url('stock_produit/emplacements?ID=')}}"+id_zone, function(res,stat){
            var select1 = document.getElementById("idSelectEmplacement"+idLigne);
            // var nom= document.getElementById("input3");

            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value=''>Séléctionner l'emplacement de ce nouveau stock ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_emplacement+"'> "+res[i].libelle+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }


        });
    }

    function selectionneZone(){
        var zone = document.getElementById("zonee").value;
          $.ajax({
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},  
                url: "{{url('inventaire/getEmplacement')}}/"+zone,
                method : "POST",
               
                success: function(data) {
                   if (data == 0) {
                        $('#emplacement').attr('disabled', true);
                        alert('oops pas demplacement trouvé pour cette zone! ');
                    }
                    else{
                        $('#emplacement').attr('disabled', false);
                        $("#emplacement").empty();
                         $("#emplacement").append("<option selected disabled value=''>Sélectionner l'emplacement ...</option>");
                        data.forEach(function(d) {
                              $("#emplacement").append("<option value="+d.id_emplacement+">"+d.libelle+"</option>");
                          });
                    }
                },
                error: function(data){
                          alert('oops erreur de serveur! ');
                }

              });
    }
</script>


@endsection