@extends('app')
@section('content')

<!-- Content Header (Page header) -->



<section class="content-header">
    @if(Session::get('FOURNISSEURS_RECEPTION_AJOUTER'))
    <div class="box-tools pull-right">
        <a href="{{ url('receptions/reception_fournisseur/ajouter') }}" class="btn btn-block btn-primary">
            <span class="glyphicon glyphicon-plus" aria-hidden="false"></span>
            Ajouter
        </a>
    </div>
    

    <div class="box-tools pull-right" style="margin-right: 1%">
        <a href="#importer" class="btn btn-block btn-success" data-toggle="modal">
            <span class="glyphicon glyphicon-download-alt" aria-hidden="false"></span>
                Importer
        </a>
    </div>
    @endif
    <h1>
        Gestion des réceptions des commandes fournisseur
    </h1>

</section>



<!-- Main content -->
<section class="content">
    @if(Session::has('msgDelete'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgDelete') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif
    @if(Session::has('msgErreurReception'))
    <div class="box box-danger box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgErreurReception') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif


    @if(Session::has('msgSupprimer'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! session('msgSupprimer') !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('msgAjouter'))
    <div class="box box-success box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>
                    {!! session('msgAjouter') !!}
                </em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif
    @if(Session::has('msgAjouterAnnuler'))
    <div class="box box-danger box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                    Échec de l'importation.<br>
                <em>
                    <ul>
                        @foreach (session('msgAjouterAnnuler')[0] as $key => $erreur)
                        <li>
                            Ligne {{ $key }} : {{ $erreur }}.
                        </li>
                        @endforeach
                    </ul>
                    
                </em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif
    @if(Session::has('msgAjouterErreur'))
    <div class="box box-danger box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                    Échec de l'importation.<br>
                <em>
                    @if (session('msgAjouterErreur')[0]->count() != 0)
                    <ul>
                        @foreach (session('msgAjouterErreur')[0] as $key =>$warning)
                        <li>
                        Ligne {{ $key }} : {{ $warning }}.
                        </li>
                        @endforeach
                    </ul>
                    @endif

                    @if (session('msgAjouterErreur')[1]->count() != 0)
                    <ul>
                        @foreach (session('msgAjouterErreur')[1] as $key => $erreur)
                        <li>
                            Ligne {{ $key }} : {{ $erreur }}.
                        </li>
                        @endforeach
                    </ul>
                    @endif
                </em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if($errors->any())
    <div class="box box-danger box-solid">
        <div class="box-header with-border">
            <div class="box-title">
                <span> <i class="fa fa-check"></i></span>
                <em>{!! $errors->first() !!}</em>
            </div>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="remove">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        </div>
    </div>
    @endif

<div class="box-body">
            {!! Form::open(['method'=>'POST','action' => ['BonReceptionFournisseurControlleur@export']]) !!}
                  <div class="col-sm-12">
                    <div class="col-sm-5">
                        <label>Date Début :</label>
                            <input required type="date" class="form-control" id="date_debut" name="date_debut"   >
                    </div>
                    <div class="col-sm-5">
                <label>Date fin :</label>
                            <input required type="date" class="form-control" id="date_fin" name="date_fin" value=""   >

                    </div><div class="col-sm-2">
                        <label></label>
                        <input type="submit" name="" id="button_export" class="btn btn-success form-control" value="Export Excel">
                </div>  </div>
                <input type="hidden" id="btn_count_export" value="0">
            {!! Form::close() !!}
</div>
 {!! Form::open(['method'=>'POST','action' => ['BonReceptionFournisseurControlleur@recherche']]) !!}

<br>
            <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Filtrer par N° série" name="numSerie" class="form-control">
                    <input type="submit" class="btn btn-default form-inline" value="Filtrer" >
                
            </div>
        <br>
        <br>
        <br>
        
        {!! Form::close() !!}
    <!-- Default box -->

    
    <div class="box">
<br>
        <form method="get" action="{{ route('recherche_reception') }}">

                <div class="table-responsive">
                    <div class="box-tools pull-right form-inline" style="margin-right: 1%;" id="rechercher">
              
                    <input type="text" placeholder="Recherche"name="recherche" class="form-control" @if (isset($mot_a_rechercher))
                        value="{{ $mot_a_rechercher }}"
                    @endif>
                    <input type="submit" class="btn btn-default form-inline" value="Rechercher" ><br><br>
                
            </div><br>
            </form>

        

        <table id="" class="table table-bordered table-striped">
            <thead>
                <tr role="row">
                    <th class="text-center sorting_asc">N° de bon de réception</th>
                    <th class="text-center sorting_asc">N° de commande</th>
                    <th class="text-center sorting_asc">Fournisseur</th>
                    @if(Session::get('STOCK_ENTITE') == "1")
                    <th class="text-center sorting_asc">N° de document</th>
                    <th class="text-center sorting_asc">Entité</th>
                    @endif
                    <th class="text-center sorting_asc">Contrat</th>
                    <th class="text-center sorting_asc">Facture</th>
                    <th class="text-center sorting_asc">Date bon de réception</th>
                    <th class="text-center sorting_asc">Statut</th>
                    @if(Session::get('FOURNISSEURS_RECEPTION_DETAIL'))
                    <th class="text-center sorting_asc">Détail</th>
                    @endif

                    @if(Session::get('FOURNISSEURS_RECEPTION_MODIFIER'))
                    <th class="text-center sorting_asc">Modifier</th>
                    @endif

                    @if(Session::get('FOURNISSEURS_RECEPTION_SUPPRIMER'))

                    <th class="text-center sorting_asc">Supprimer</th>
                    @endif
                </tr>
            </thead>

            <tbody>
                @foreach( $bons_receptions as $bon_reception)

                <tr role="row" class="odd">
                    <td class="text-center sorting_1">{!!$bon_reception->num_bon_reception!!}</td>
                    @if ($bon_reception->commandeFounisseur != null ||$bon_reception->commandeFounisseur != '' )
                    <td class="text-center sorting_1">
                        {!!$bon_reception->commandeFounisseur->num_commande_fournisseur!!}
                    </td>
                    @else
                    <td class="text-center sorting_1"></td>
                    @endif
                    @if ($bon_reception->commandeFounisseur != null ||$bon_reception->commandeFounisseur != '')
                        @if ($bon_reception->commandeFounisseur->fournisseur != null ||$bon_reception->commandeFounisseur->fournisseur != '')
                    <td class="text-center sorting_1">
                        {!!$bon_reception->commandeFounisseur->fournisseur->societe!!}
                    </td>
                            @else
                            <td class="text-center sorting_1"></td>
                        @endif
                    @else
                    <td class="text-center sorting_1"></td>
                    @endif
                    @if(Session::get('STOCK_ENTITE') == "1")
                        <td class="text-center sorting_1">
                            {!!$bon_reception->num_document!!}
                        </td>
                        <td class="text-center sorting_1">
                            {!!$bon_reception->entite->type_entite!!}/{!!$bon_reception->entite->num_entite!!}/{!!$bon_reception->entite->libelle_entite!!}
                        </td>
                    @endif
                    <td class="text-center sorting_1">{!!$bon_reception['contrat']!!}</td>
                    <td class="text-center sorting_1">{!!$bon_reception['facture']!!}</td>
                    <td class="text-center sorting_1">{!!$bon_reception->date_creation!!}</td>
                    @if($bon_reception->statut==0 )
                    <td class="text-center sorting_1">En attente réception</td>
                    @elseif($bon_reception->statut==2 || $bon_reception->statut == 1)
                    <td class="text-center sorting_1">En attente validation</td>
                    @elseif($bon_reception->statut==3)
                    <td class="text-center sorting_1">Validé</td>
                    @endif

                    @if(Session::get('FOURNISSEURS_RECEPTION_DETAIL'))
                    @if (($bon_reception->commandeFounisseur != null ||$bon_reception->commandeFounisseur != '')&& (Session::get('STOCK_ENTITE') == "0"))
                    <td class="text-center sorting_1">
                        <a href="{{url('receptions/reception_fournisseur/detail')}}/{{$bon_reception->id_bon_reception}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                        </a>
                    </td>
                    @else
                    <td class="text-center sorting_1">
                        <a href="{{url('receptions/reception_fournisseur_ue/detail')}}/{{$bon_reception->id_bon_reception}}" data-toggle="modal" class="glyphicon glyphicon-eye-open">

                        </a>
                    </td>
                    @endif
                    @endif
                    @if (($bon_reception->commandeFounisseur != null ||$bon_reception->commandeFounisseur != '') && Session::get('STOCK_ENTITE') == "0")
                    @if(Session::get('FOURNISSEURS_RECEPTION_MODIFIER'))
                    @if ($bon_reception->statut == 0)
                    <td class="text-center sorting_asc">
                        <a href="{{url('receptions/reception_fournisseur/modifier')}}/{{$bon_reception->id_bon_reception}}" class="glyphicon glyphicon-edit">
                        </a>
                    </td>
                    @else
                    <td class="text-center sorting_asc"></td>
                    @endif

                    @endif
                    @else
                        @if(Session::get('FOURNISSEURS_RECEPTION_MODIFIER'))
                            @if ($bon_reception->statut == 0)
                                <td class="text-center sorting_asc">
                                    <a href="{{url('receptions/reception_fournisseur_ue/modifier')}}/{{$bon_reception->id_bon_reception}}" class="glyphicon glyphicon-edit">
                                    </a>
                                </td>
                            @else
                                <td class="text-center sorting_asc"></td>
                            @endif
                            @endif
                    @endif
                    @if(Session::get('FOURNISSEURS_RECEPTION_SUPPRIMER'))
                    @if ($bon_reception->statut == 0)
                    <td class="text-center sorting_asc">
                        <a href="#DeleteModal{{$bon_reception->id_bon_reception}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">
                        </a>
                    </td>
                    @else
                    <td></td>
                    @endif
                    @endif
                </tr>


                <div class="example-modal">
                    <div class="modal" id="DeleteModal{{$bon_reception->id_bon_reception}}">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Voulez-vous vraiment supprimer ce bon de réception ?</p>
                                    </div>

                                    <div class="modal-footer">
                                        {!! Form::open(['method' => 'POST', 'action' => ['BonReceptionFournisseurControlleur@delete',$bon_reception->id_bon_reception]]) !!}
                                        <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                        <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    </div>
                    @endforeach
                </tbody>

            </table>

            <p>Affichage de l'élement {{($bons_receptions->currentPage()-1)* $bons_receptions->perPage()+($bons_receptions->total() ? 1:0)}} à {{($bons_receptions->currentPage()-1)*$bons_receptions->perPage()+count($bons_receptions)}}  sur  {{$bons_receptions->total()}} éléments</p>
            
            <span class="pull-right">{{ $bons_receptions->links() }}</span>


        </div><!-- /.box -->
    </section><!-- /.content -->


    <div class="example-modal">
        <div class="modal" id="importer">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h3 class="modal-title" style="font-family:verdana;">Importer les réceptions </h3>
                        </div>
                        <div class="modal-body">
                            <p>Importer les réceptions par UE depuis un fichier xls ou xlsx. Télécharger le modèle et ouvrir Excel  pour voir le format avec tous les champs acceptés.
                            </p>

                            {!! Form::open(['method'=>'POST','action' => ['BonReceptionFournisseurControlleur@downloadModele']]) !!}
                            <div class="col-sm-7">
                                <label class="control-label">Télécharger le fichier modèle</label>

                            </div>

                            <input id="btnDwnld" class="btn btn-success col-sm-4" type="submit"  value="Télécharger le modèle" name="dwnld">
                            <br>
                            <br>
                            {!! Form::close() !!}
                            @if (Session::get('AVEC_UE_RECEPTION'))
                                @if (Session::get('CONTROLE_UE'))
                                    @if (Session::get('STOCK_ENTITE'))
                                        {!! Form::open(['url'=>'reception/upload_entite', 'files' => true,'enctype'=>'multipart/form-data']) !!}
                                        <div class="col-sm-7">
                                            <input type="file" id="file" name="file"  class="form-control" onchange="verifInput(this.id, 'btnSubmit');" accept=".xls,.xlsx,.csv" required>
                                        </div>
                                        <input id="btnSubmit" class="btn btn-success col-sm-4" type="submit" value="Importer le fichier" disabled="disabled" name="submit" onClick="toggle_visibility('tips');">

                                        {!! Form::close() !!}
                                    @else
                                        {!! Form::open(['url'=>'reception/upload', 'files' => true,'enctype'=>'multipart/form-data']) !!}
                                        <div class="col-sm-7">
                                            <input type="file" id="file" name="file"  class="form-control" onchange="verifInput(this.id, 'btnSubmit');" accept=".xls,.xlsx,.csv" required>
                                        </div>
                                        <input id="btnSubmit" class="btn btn-success col-sm-4" type="submit" value="Importer le fichier" disabled="disabled" name="submit" onClick="toggle_visibility('tips');">

                                        {!! Form::close() !!}
                                    @endif
                                @endif
                            @else
                                {!! Form::open(['url'=>'reception/upload_normal', 'files' => true,'enctype'=>'multipart/form-data']) !!}
                                        <div class="col-sm-7">
                                            <input type="file" id="file" name="file"  class="form-control" onchange="verifInput(this.id, 'btnSubmit');" accept=".xls,.xlsx,.csv" required>
                                        </div>
                                        <input id="btnSubmit" class="btn btn-success col-sm-4" type="submit" value="Importer le fichier" disabled="disabled" name="submit" onClick="toggle_visibility('tips');">

                                        {!! Form::close() !!}
                            @endif
                            



                            <div class="modal-footer">



                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>
        </div>
        <script type="text/javascript">
            function verifInput(id, idSubmit) {
                if(document.getElementById(id).value != ""){
                    document.getElementById(idSubmit).disabled = false;
                }
            }
        </script>


        @endsection