@extends('app')
@section('content')
        <!-- Content Header (Page header) -->
{!! Html::script('assets/js/jsPDF/jspdf.js') !!}
        <!--<script src="../../assets/js/jspdf/jspdf.js"></script>-->
{!! Html::script('assets/js/jsPDF/dist/jspdf.min.js') !!}
        <!--<script src="../../assets/js/jspdf/dist/jspdf.min.js"></script>-->
{!! Html::script('assets/js/jsPDF/jsPDF-AutoTable/dist/jspdf.plugin.autotable.js') !!}
<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">
    <h1>
        Le détail du bon de réception
    </h1>
    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>
<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif
            <!-- fin messages -->
        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                <div class="box-tools pull-right">
                    @if($bonReception->statut == 2 || $bonReception->statut==1 )
                        <a data-toggle="modal" data-target="#valider_reception_modal" class="btn btn-block btn-primary">
                            Valider la réception
                        </a>

                    @endif
                </div>
                <div class="form-group">
                    <div class="col-lg-12 ">
                        <div class="col-lg-3">
                            <label>N° Bon réception : </label>
                            <input type="text" class="form-control" name="num_bon_reception" placeholder="" required value="{{$bonReception->num_bon_reception}}" readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Date bon de réception:</label>
                            <input type="date" class="form-control" id="date_creation"  name="date_creation" value="{{$bonReception->date_creation}}"  required readonly >

                        </div>
                        

                        <div class="col-lg-3">
                            <label>Statut: </label>
                            <input type="text" class="form-control" id="date_creation"  name="date_creation" @if($bonReception->statut==0 ) value="En attente réception"  @elseif($bonReception->statut==2 || $bonReception->statut == 1)value="En attente validation"
                            @elseif($bonReception->statut==3)
                                value="Validé"
                            @endif  required readonly >

                        </div>
                        @if(Session::get('USE_UE')=='1')
                            @if ($bonReception->unite_expedition == "1")
                                <div class="col-lg-3">
                                    <br>
                                    <input type="checkbox" name="ue" id="unite_expedition" disabled
                                     checked >
                                    <label>Avec unité d'expédition</label>
                                 </div>
                            @endif
                        @endif
                        
                    </div>
                    <br>
                    <br>
                    <br>
                    <br>

                    <div class="col-lg-12">
                        <div class="col-lg-3">
                            <label>Commande fournisseur : </label>
                            <input type="text" class="form-control" id="idCommandeFounisseur"  name="idCommandeFounisseur" value="{{$commandeFournisseur->num_commande_fournisseur}}"  required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Le Fournisseur :</label>
                            <input type="text" class="form-control" id="fournisseur" name="fournisseur" placeholder="Fournisseur" value ="{{$commandeFournisseur->fournisseur->societe}}" required readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Le Contact : </label>
                            <input type="text" class="form-control" id="contactFournisseur" name="contactFournisseur" placeholder="Contact" value="{{$commandeFournisseur->fournisseur->contact}}" required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Date commande fournisseur : </label>
                            <input type="date" class="form-control" id="dateCreationCommandeFournisseur"  name="dateCreationCommandeFournisseur"  value="{{$commandeFournisseur->date_creation}}" required readonly>
                        </div>

                    </div>
                    <br>
                    <br>
                    <br>
                </div>
                @if(Session::get('USE_UE')=='1')
                    @if ($bonReception->unite_expedition == "1")
                        @if($bonReception->statut == 2 || $bonReception->statut==1 )
                            <br>
                        @endif
                        <button type="button" id="btn-export"  class="btn btn-flat btn-danger" 
                        @if (Session::get('CONTENEUR')=='0')
                            onclick="genPDF1()"
                        @else
                            onclick="genPDF2({{ $Nconteneur }},{{ $Nconteneur->count() }},{{ Session::get('CONTENEUR_OBLIGATOIRE') }},{{ $resultat_avec_conteneur_null }})" 
                        @endif
                    
                        style="float: right;margin-right: 1.5%;">Export PDF</button>
                        <br><br><br>
                    @endif
                @endif

                <div class="col-lg-12">
                    <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-striped dataTable">
                        <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">Produit commandé</th>
                                <th class="text-center sorting_asc">Référence produit</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Emplacement</th>
                                <th class="text-center sorting_asc">Quantité commandée</th>
                                <th class="text-center sorting_asc">Reste à recevoir</th>
                                <th class="text-center sorting_asc">Quantité réceptionnée(prévisionnelle)</th>
                                <th class="text-center sorting_asc">Quantité réceptionnée(réelle)</th>
                                <th class="text-center sorting_asc">Opérateur</th>
                                @if(Session::get('USE_UE')=='1')
                                    @if ($bonReception->unite_expedition == "1")
                                        <th class="text-center sorting_asc">N°UE</th>
                                    @endif
                                @endif
                                @if ($bonReception->statut!=3)
                                    @if(Session::get('FOURNISSEURS_RECEPTION_SIMULER_FO')=='1')
                                        <th class="text-center sorting_asc">
                                           Simuler saisie FO
                                        </th>
                                    @endif
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                        @foreach( $lignesBonReception as $ligneBonReception)
                            <tr role="row" class="odd">
                                <td class="text-center sorting_1">
                                    @if ($ligneBonReception->id_ligne_commande_fournisseur == 0)
                                        <small class="label bg-red">Non</small>
                                    @else
                                        <small class="label bg-green">Oui</small>
                                    @endif    
                                </td>
                                @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                     <td class="text-center sorting_1">{{$ligneBonReception->ligneCommandeFournisseur->produit->reference}}</td>
                                @else
                                     <td class="text-center sorting_1">{{$ligneBonReception->produit->reference}}</td>
                                @endif
                                @if($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <td class="text-center sorting_1">{{$ligneBonReception->ligneCommandeFournisseur->produit->designation}}</td>
                                @else
                                    <td class="text-center sorting_1">{{$ligneBonReception->produit->designation}}</td>
                                @endif
                                <td class="text-center sorting_1">{{$ligneBonReception->Emplacement->libelle}}</td>
                                <td class="text-center sorting_1">{{(float) $ligneBonReception->quantite_commander}}</td>
                                @if($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                    <td class="text-center sorting_1">
                                    {{(float) $ligneBonReception->ligneCommandeFournisseur->quantite_commander- $ligneBonReception->ligneCommandeFournisseur->quantite_receptionner }}</td>
                                @else
                                    <td class="text-center sorting_1">{{ (float) $ligneBonReception->quantite_reste_receptionnee}}</td>
                                @endif
                                <td class="text-center sorting_1">{{ (float) $ligneBonReception->quantite_receptionner}}</td>
                                <td class="text-center sorting_1">{{ (float)$ligneBonReception->qteReceptionnerFO}}</td>
                                @if($ligneBonReception->operateur == 0)
                                    <td class="text-center sorting_1"></td>
                                @else
                                    <td class="text-center sorting_1">{{$ligneBonReception->Operateur->nom}}  {{$ligneBonReception->Operateur->prenom}}</td>
                                @endif
                                @if(Session::get('USE_UE')=='1')
                                    @if($bonReception->unite_expedition == "1")
                                            @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                        <td class="text-center sorting_1">
                                        <a onclick="get_ue_from_produit('{{$ligneBonReception->ligneCommandeFournisseur->produit->designation}}',{{$ligneBonReception->id_ligne_bon_reception}},{{$ligneBonReception->ligneCommandeFournisseur->produit->id_produit }},'{{ $ligneBonReception->emplacement->libelle}}','{{$ligneBonReception->ligneCommandeFournisseur->produit->reference}}')" class="glyphicon glyphicon-eye-open" style="cursor: pointer;">
                                        </a>
                                    </td>
                                        @else
                                         <td class="text-center sorting_1"></td>
                                        @endif
                                    @endif
                                @endif
                                @if ($bonReception->statut!=3)
                                    @if(Session::get('FOURNISSEURS_RECEPTION_SIMULER_FO')=='1')
                                        @if ($ligneBonReception->id_ligne_commande_fournisseur != 0)
                                            <td class="text-center sorting_1">
                                                <a class="glyphicon glyphicon-edit" style="cursor: pointer;" onclick="simule_saisie_fo({{$ligneBonReception->quantite_receptionner}},{{$bonReception->id_bon_reception}},{{$ligneBonReception->id_ligne_bon_reception }},{{(float)$ligneBonReception->qteReceptionnerFO}},{{$ligneBonReception->ligneCommandeFournisseur->produit }});">
                                                </a>
                                            </td>
                                        @else
                                            <td class="text-center sorting_1"></td>
                                        @endif
                                    @endif
                                @endif
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>

                    <div style="float: right">

                        <a href="{{url('receptions/reception_fournisseur/index')}}" class="btn btn-default" data-dismiss="modal">Retour</a>

                    </div>

                </div>
            </div>
        </div><!-- /.box -->
    </section><!-- /.content -->
<div class="modal fade" id="modal-detail_ue">
          <div class="modal-dialog ">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Liste des unités d'expédition</h4>
              </div>
              <div class="modal-body">
                <input type="hidden" id="id_produit">
                <input type="hidden" id="ligne">
                
                <b id="reference_produit_ue"></b><br>
                <b id="designation_produit_ue"></b><br>
                <b id="emplacement_produit_ue"></b>
                <br><br>
                <main id="tebleau">
                    <table id="example7" class="table table-bordered table-striped" style="text-align: center">
                        <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">N°UE</th>   
                            </tr>
                        </thead>
                        <tbody>        
                        </tbody>
                    </table>
                </main>
             
                <div id="liste_ue" style="text-align: center"></div>    
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-danger" id="ssccPdf" onclick="exportPdfListeUe()">Export PDF</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

        <div class="modal fade" id="modal-quantite-reelle">
          <div class="modal-dialog">
            <form method="post" action="{{ route('simule_saisie_fo') }}">
                     {{ csrf_field() }}
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Quantité réceptionnée(réelle) </h4>
              </div>
              <div class="modal-body">
                <input type="hidden" name="bon_reception" id="bon_reception">
                <input type="hidden" name="ligne_bon_reception" id="ligne_bon_reception">
                        <div class="form-group">
                            <label>Opérateur</label>
                            <input type="text" id="" class="form-control" disabled value="{{Session::get('nom')." ".Session::get('prenom')}}" style="text-align: center">
                        </div>
                        <div class="form-group">
                            <label>Produit</label>
                            
                            <textarea id="produit" class="form-control" disabled style="text-align: center" rows="3"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Quantité réceptionnée(prévisionnelle)</label>
                            <input type="text" id="quantite_RP" min="1" class="form-control" disabled style="text-align: center">
                        </div>
                    <div class="col-sm-12">
                        <br>
                        <div class="form-group">
                            <label>Quantité réceptionnée(réelle)</label>
                            <input type="number" step="0.01" min="0" id="quantite_RR" required name="quantite_RR" class="form-control" style="text-align: center">
                        </div>
                    </div>

              </div>
              
              <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Annuler</button>
               <input type="submit" class="btn btn-primary" value="Valider">
                
              </div>
            </div>
            </form>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <input type="hidden" id="loool" value="lol">
        <!-- /.modal -->

        <div class="modal" id="valider_reception_modal">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                                </div>
                                <div class="modal-body">
                                    <p>Voulez-vous vraiment valider la réception ?</p>
                                </div>

                                <div class="modal-footer">

                                    <a href="{{url('/receptions/reception_fournisseur/valider')}}/{{$bonReception->id_bon_reception}}" class="btn btn-flat btn-primary pull-right">
                                        Valider
                                    </a>
                                    <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>

                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->

                    <div class="box" hidden>
                        
                        @if(Session::get('CONTENEUR')=='0')
                            @if (isset($resultat))
                                <table id="table" class="table table-bordered table-striped">
                                    <thead>
                                    <tr role="row">
                                        <th>CODE PRODUIT</th>
                                        <th>N°UE</th>
                                        <th>QUANTITÉ</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($resultat as $key => $res)
                                        @foreach ($res as $r)
                                            <tr role="row">
                                                <td>{{ $key }}</td>
                                                <td>{{ $r->sscc }}</td>
                                                <td>1</td> 
                                            </tr>
                                        @endforeach
                                    @endforeach
                                    </tbody>
                                </table>

                                <div class="hidden">                           
                                    <input type="text"   id="header" @if($configuration != null) value="{{$configuration->header}}" @else value="" @endif >
                                    <input type="text"   id="footer"  @if($configuration != null)  value="{{$configuration->footer}}" @else value="" @endif>
                                    <img  id="logo" @if($configuration != null) src="{{ asset('/dist/img/'.$configuration->image) }}" @else src="" @endif width="20%" height="20%" alt="User Image">
                                </div>
                            @endif
                        @else
                            @if (isset($Nconteneur))
                            @php
                                $i = 0;    
                            @endphp 
                                @foreach ($Nconteneur as $key => $value)
                                    <label> Numéro de conteneur : {{ $key }}</label><br>
                                    <input type="hidden" id="{{$i}}numeroConteneur" value="{{ $key }}">
                                    <table id="{{$i}}table" class="table table-bordered table-striped">
                                        <thead>
                                        <tr role="row">
                                            <th>CODE PRODUIT</th>
                                            <th>N°UE</th>
                                            <th>QUANTITÉ</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($value as $key1 => $v)
                                            <tr role="row">
                                                <td>{{ $v->ligneBonReception->produit->code_identification }}</td>
                                                <td>{{ $v->sscc }}</td>
                                                <td>1</td> 
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                <br><br>
                                <div class="hidden">
                                    <input type="text"   id="header" @if($configuration != null) value="{{$configuration->header}}" @else value="" @endif >
                                    <input type="text"   id="footer"  @if($configuration != null)  value="{{$configuration->footer}}" @else value="" @endif>
                                    <img  id="logo" @if($configuration != null) src="{{ asset('/dist/img/'.$configuration->image) }}" @else src="" @endif width="20%" height="20%" alt="User Image">
                                </div>
                                    @php
                                        $i++;    
                                    @endphp
                                @endforeach
                            @endif
                            @if (isset($resultat_avec_conteneur_null))   
                                    <table id="table2" class="table table-bordered table-striped">
                                        <thead>
                                        <tr role="row">
                                            <th>CODE PRODUIT</th>
                                            <th>N°UE</th>
                                            <th>QUANTITÉ</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($resultat_avec_conteneur_null as $key => $value)
                                            <tr role="row">
                                                <td>{{ $value->ligneBonReception->produit->code_identification }}</td>
                                                <td>{{ $value->sscc }}</td>
                                                <td>1</td> 
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                <br><br>
                                <div class="hidden">
                                    <input type="text"   id="header" @if($configuration != null) value="{{$configuration->header}}" @else value="" @endif >
                                    <input type="text"   id="footer"  @if($configuration != null)  value="{{$configuration->footer}}" @else value="" @endif>
                                    <img  id="logo" @if($configuration != null) src="{{ asset('/dist/img/'.$configuration->image) }}" @else src="" @endif width="20%" height="20%" alt="User Image">
                                </div>
                                @endif
                        @endif
                    </div>

<script>
    
     function get_ue_from_produit(designation,id_ligne_bon_reception,id_produit,emplacement,reference){
        $.ajax({
                    url: "{{url('receptions/reception_fournisseur/detail/ue')}}/"+id_ligne_bon_reception,
                    method : "post",   
                    data: {
                    "_token": "{{ csrf_token() }}"
                    } ,        
                    success: function(data){ 
                        var t = $('#example7').DataTable();
                        t.clear().draw();
                        
                        var myModal = $('#modal-detail_ue');

                        document.getElementById('id_produit').value = id_produit;
                        document.getElementById('ligne').value = id_ligne_bon_reception;
                        document.getElementById("reference_produit_ue").innerHTML = "Référence Produit : "+reference;
                        document.getElementById("designation_produit_ue").innerHTML = "Désignation Produit : "+designation;
                        document.getElementById("emplacement_produit_ue").innerHTML = "Emplacement du produit : "+emplacement;
                        //document.getElementById("emplacement_produit_ue").innerHTML = "Emplacement Produit : "+emplacement;
                            
                        
                            document.getElementById('liste_ue').hidden =true;

                            var vals = Object.keys(data).map(function(key) {
                            t.row.add( [
                                       '<b>'+data[key].sscc+'</b>'
                                    ] ).draw( false );
                            });
                            document.getElementById('ssccPdf').disabled = false; 
                        
                        myModal.modal({ show: true });                                   
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  }); 
      }

      function exportPdfListeUe() {
        var ligne = document.getElementById('ligne').value;
        window.location.href = "{{url('/receptions/reception_fournisseur/detail/ue/downloadPDF')}}/"+ligne ;
      }

       function simule_saisie_fo(quantite_receptionner_previsionnelle,bon_reception,ligne_bon_reception,quantite_receptionner_reelle,objetProduit) {    
        var myModal = $('#modal-quantite-reelle');
        document.getElementById('produit').value = objetProduit.reference +", "+objetProduit.designation;
        document.getElementById('quantite_RP').value = quantite_receptionner_previsionnelle;
        document.getElementById('quantite_RR').value = quantite_receptionner_reelle;
        document.getElementById('bon_reception').value = bon_reception;
        document.getElementById('ligne_bon_reception').value = ligne_bon_reception;
        
        myModal.modal({ show: true });
      }
      

      function genPDF2(conteneur, count,obligatoire,conteneur_null) {

        var imgData =  document.getElementById('logo');
        var header = document.getElementById('header').value;
        var footer = document.getElementById('footer').value;
        var tete = 0;
        var doc = new jsPDF('p', 'pt');

        doc.setFontSize(14);
        var titre="Liste des unités d'expédition";

        var width_titre = doc.getTextWidth(titre);
        var space_titre=doc.internal.pageSize.width-width_titre;
        space_titre=space_titre/2;
        doc.text(titre, space_titre, 120, {
            startY: doc.autoTable.previous.finalY + 15,
            margin: {horizontal: 7},
            columnStyles: {text: {columnWidth: 'auto'}}
        });
        var step = 180;
        var startTable = 190;

        if(count != 0){
            tete= 1;
            for(var i=0; i < count; i++){
                var input1 = document.getElementById(i+'numeroConteneur').value;
                doc.setFontSize(11);
                doc.text('Numéro de conteneur : '+input1,40,step);
                var elem = document.getElementById(i+"table");
                var res = doc.autoTableHtmlToJson(elem);
                if(tete == 1){

                doc.autoTable(res.columns, res.data, {
                    tableWidth: 'auto',
                    startY: startTable,
                    margin: {horizontal: 7},
                    styles: {overflow: 'linebreak', columnWidth: 'auto',cellPadding: 6, fontSize: 10,halign: 'center'},
                    columnStyles: {text: {columnWidth: 'auto'}},
                    addPageContent: function (data) {
                        doc.setTextColor(10);
                        doc.setFontStyle('arial');
                        doc.setFontSize(10);
                        var splitTitle;
                        var space;
                        var space1;
                        var width = doc.getTextWidth(footer);
                        if(width>350){
                            splitTitle  = doc.splitTextToSize(footer, 350);
                            space=doc.internal.pageSize.width-350;
                        }else{
                            splitTitle=footer;
                            space=doc.internal.pageSize.width-width;
                        }
                        space1=space/2;
                        
                        doc.text(splitTitle, space1, doc.internal.pageSize.height - 40);
                    
                        //doc.setFontSize(10);
                        splitTitle = doc.splitTextToSize(header, 250);
                        
                        doc.text(splitTitle,320, 40);
                    
                        var image = new Image();
                        var img = document.getElementById('logo');
                        image = img ;
                        image.src=img.src ;
                        image.width = 200;
                        image.height = 70;
                        doc.addImage(img, 'PNG',40,20);    
                    },
                    margin: {top: 100, left:10,right:10,bottom:50},
                });
            }
            else{
                doc.autoTable(res.columns, res.data, {
                    tableWidth: 'auto',
                    startY: startTable,
                    margin: {horizontal: 7},
                    styles: {overflow: 'linebreak', columnWidth: 'auto',cellPadding: 6, fontSize: 10,halign: 'center'},
                    columnStyles: {text: {columnWidth: 'auto'}},
                });

            }

                step = doc.autoTable.previous.finalY + 50;
                startTable = step + 10;
            }
        }

        if(conteneur_null != '' ){
            var elem2 = document.getElementById("table2");
            var res2 = doc.autoTableHtmlToJson(elem2);
            if(count != 0){
                doc.text('Pas de numéro de conteneur associer',40,doc.autoTable.previous.finalY + 40);
            }else{
                doc.text('Pas de numéro de conteneur associer',40,step);
            }
            if(count != 0){
                doc.autoTable(res2.columns, res2.data, {
                    tableWidth: 'auto',
                    startY: doc.autoTable.previous.finalY + 50,
                    margin: {horizontal: 7},
                    styles: {overflow: 'linebreak', columnWidth: 'auto',cellPadding: 6, fontSize: 10,halign: 'center'},
                    columnStyles: {text: {columnWidth: 'auto'}},
                    addPageContent: function (data) {
                    }
                });
            }else{
                doc.autoTable(res2.columns, res2.data, {
                    tableWidth: 'auto',
                    startY: startTable,
                    margin: {horizontal: 7},
                    styles: {overflow: 'linebreak', columnWidth: 'auto',cellPadding: 6, fontSize: 10,halign: 'center'},
                    columnStyles: {text: {columnWidth: 'auto'}},
                    addPageContent: function (data) {
                        if(tete == 0 ){
                        doc.setTextColor(10);
                        doc.setFontStyle('arial');
                        doc.setFontSize(10);
                        var splitTitle;
                        var space;
                        var space1;
                        var width = doc.getTextWidth(footer);
                        if(width>350){
                            splitTitle  = doc.splitTextToSize(footer, 350);
                            space=doc.internal.pageSize.width-350;
                        }else{
                            splitTitle=footer;
                            space=doc.internal.pageSize.width-width;
                        }
                         space1=space/2;
                        
                            doc.text(splitTitle, space1, doc.internal.pageSize.height - 40);
                        
                            doc.setFontSize(10);
                        splitTitle = doc.splitTextToSize(header, 250);
                        
                            doc.text(splitTitle,320, 40);
                        
                        var image = new Image();
                        var img = document.getElementById('logo');
                        image = img ;
                        image.src=img.src ;
                        image.width = 200;
                        image.height = 70;
                        doc.addImage(img, 'PNG',40,20);
                        }
                    },
                    margin: {top: 100, left:10,right:10,bottom:50},
                });
            }    
        }
        tete = 0;

        doc.save("Liste des unités d'expédition.pdf");
    }

    function genPDF1() {
        var imgData =  document.getElementById('logo');
        var header = document.getElementById('header').value;
        var footer = document.getElementById('footer').value;

        var doc = new jsPDF('p', 'pt');
        doc.setFontSize(14);
        var titre="Liste des unités d'expédition";
        var width_titre = doc.getTextWidth(titre);
        var space_titre=doc.internal.pageSize.width-width_titre;
        space_titre=space_titre/2;
        doc.text(titre, space_titre, 120, {
            startY: doc.autoTable.previous.finalY + 15,
            margin: {horizontal: 7},
            columnStyles: {text: {columnWidth: 'auto'}}
        });
        var step = 280;
        var startTable = 150;
        var elem = document.getElementById("table");
        var res = doc.autoTableHtmlToJson(elem);
        doc.autoTable(res.columns, res.data, {
            tableWidth: 'auto',
            startY: startTable,
            margin: {horizontal: 7},
            styles: {overflow: 'linebreak', columnWidth: 'auto',cellPadding: 6, fontSize: 10,halign: 'center'},
            columnStyles: {text: {columnWidth: 'auto'}},
            addPageContent: function (data) {
                doc.setTextColor(10);
                doc.setFontStyle('arial');
                doc.setFontSize(10);
                var splitTitle;
                var space;
                var space1;
                var width = doc.getTextWidth(footer);
                if(width>350){
                    splitTitle  = doc.splitTextToSize(footer, 350);
                    space=doc.internal.pageSize.width-350;
                }else{
                    splitTitle=footer;
                    space=doc.internal.pageSize.width-width;
                }
                space1=space/2;
                doc.text(splitTitle, space1, doc.internal.pageSize.height - 40);
                doc.setFontSize(10);
                splitTitle = doc.splitTextToSize(header, 250);
                doc.text(splitTitle,320, 40);
                var image = new Image();
                var img = document.getElementById('logo');
                image = img ;
                image.src=img.src ;
                image.width = 200;
                image.height = 70;
                doc.addImage(img, 'PNG',40,20);
            },
            margin: {top: 100, left:10,right:10,bottom:50},

        });
        step = doc.autoTable.previous.finalY + 50;
        startTable = step + 10;
        
       
        doc.save("Liste des unités d'expédition.pdf");
    }
</script>

@endsection

