@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Ajouter un bon de réception
    </h1>

</section>


<!-- Main content -->
<section class="content">
    <!-- Messages -->

       @if(Session::has('erreur'))
        <div class="box box-danger box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('erreur') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

     @if(Session::has('ajouter'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('ajouter') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

    @if(Session::has('msgErreurReception'))
        <div class="box box-danger box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgErreurReception') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgErreurCommandeNonValide'))
        <div class="box box-danger box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgErreurCommandeNonValide') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'POST','action' => ['BonReceptionFournisseurControlleur@postForm']]) !!}
                <div class="form-group">
                    <div class="col-lg-12 ">
                        <div class="col-lg-3">
                            <label>N° de bon réception : </label>
                            <input type="text" class="form-control", id="numBonReceptionFournisseur" name="num_bon_reception" placeholder="" required value="{{$NumBonReception}}" readonly>
                        </div>
                        <div class="col-lg-3">
                            <label>Date bon de réception : </label>
                            <input type="date" class="form-control" id="date_creation"  name="date_creation" value="<?php echo date("Y-m-d");?>"  required >

                        </div>
                        @if(Session::get('USE_UE')=='1')
                            <div class="col-lg-3">
                                <br>
                                <input type="checkbox" name="ue" id="avec_uee" onchange="changeEtat(this)"@if (Session::get('avec_ueee') == 1)
                                    checked
                                @endif>
                                <label>Avec unité d'expédition</label>
                            </div>
                        @endif
                    </div>
                    <br>
                    <br>
                    <br>
                    <br>

                    <div class="col-lg-12">
                        <div class="col-lg-3">
                            <label>Commande fournisseur : </label>
                            <select id="idSelectCommandeFournisseur" class="form-control" onchange="getInformations(this.value)" name="idCommandeFournisseur" required="required">
                                <option selected disabled value="" style="background-color: white">Sélectionner la commande fournisseur ...</option>
                                @foreach($commandes as $commandeIndex)
                                    <option value="{{$commandeIndex->id_commande_fournisseur}}" @if(($commande != null) && ($commandeIndex->id_commande_fournisseur == $commande->id_commande_fournisseur)) selected @endif> {{$commandeIndex->num_commande_fournisseur}} </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-3">
                            <label>Fournisseur :</label>
                            <input type="text" class="form-control" id="fournisseur" name="fournisseur" placeholder="Fournisseur" value ="{{Session::get('societe')}}" required readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Contact : </label>
                            <input type="text" class="form-control" id="contactFournisseur" name="contactFournisseur" placeholder="Contact" value="{{Session::get('contact')}}" required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Date commande fournisseur : </label>
                            <input type="date" class="form-control" id="dateCreationCommandeFournisseur"  name="dateCreationCommandeFournisseur"  value="{{Session::get('date')}}" required readonly>
                        </div>

                    </div>

                </div>
                @if ($ajouterProduitNonCommande)
                    <br>
                    <br>
                    <br> 
                    <a data-toggle="modal" data-target="#ajouter_produit_modal" class="btn btn-primary" style="float: right;margin-right:1.5%;" >
                            Ajouter produit non commandé
                </a>
                @endif
                <br><br><br>
                <div class="col-lg-12">
                    <table id="example1" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr role="row">
                            <th class="text-center sorting_asc">Produit commandé</th>
                            <th class="text-center sorting_asc">Référence produit</th>
                            <th class="text-center sorting_asc">Désignation</th>
                            <th class="text-center sorting_asc">Quantité commandée</th>
                            <th class="text-center sorting_asc">Reste à recevoir</th>
                            <th class="text-center sorting_asc">Quantité réceptionnée</th>
                            <th class="text-center sorting_asc">Réceptionner</th>
                            <th class="text-center sorting_asc">Supprimer</th>
                        </tr>
                        </thead>

                        <tbody>

                        @foreach( $lignes as $ligne)
                            <tr role="row" class="odd">
                                <td class="text-center sorting_1">
                                    @if ($ligne->id_ligne_commande_fournisseur == 0)
                                        <small class="label bg-red">Non</small>
                                    @else
                                        <small class="label bg-green">Oui</small>
                                    @endif    
                                </td>
                                <td class="text-center sorting_1">
                                    @if ($ligne->id_ligne_commande_fournisseur != 0)
                                        {{$ligne->ligneCommandeFournisseur->produit->reference}}
                                    @else
                                        {{$ligne->produit->reference}}
                                    @endif
                                </td>
                                <td class="text-center sorting_1">
                                    @if ($ligne->id_ligne_commande_fournisseur != 0)
                                        {{$ligne->ligneCommandeFournisseur->produit->designation}}
                                    @else
                                        {{$ligne->produit->designation}}
                                    @endif
                                </td>
                                <td class="text-center sorting_1">{{(float) $ligne->quantite_commander}}</td>
                                <td class="text-center sorting_1">
                                   @if ($ligne->id_ligne_commande_fournisseur != 0)
                                        {{ (float) $ligne->ligneCommandeFournisseur->quantite_commander - $ligne->ligneCommandeFournisseur->quantite_receptionner  }}
                                    @else
                                        {{ (float) $ligne->quantite_reste_receptionnee}}
                                    @endif
                                    
                                </td>
                                <td class="text-center sorting_1">{{ (float) $ligne->quantite_receptionner}}</td>
                                <td class="text-center sorting_asc">
                                    <a href="#ReceptionModal{{$ligne->id_ligne_bon_reception}}" class="glyphicon glyphicon-edit"  data-toggle="modal">
                                    </a>
                                </td >
                                <td class="text-center sorting_asc">
                                    <a href="#DeleteModal{{$ligne->id_ligne_bon_reception}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                                    </a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>




                    <div style="float: right">

                        <a href="{{url('receptions/reception_fournisseur/index')}}" class="btn btn-default" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-primary">Valider</button>

                    </div>

                </div>
            </div>
            {!! Form::close() !!}
        </div><!-- /.box -->


        @foreach( $lignes as $ligne)

        <!--  POPUP pour ajout produit  -->

        <div cl1ass="example-modal" >
            <div class="modal" id="ReceptionModal{{$ligne->id_ligne_bon_reception}}">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" style="font-family:verdana;">Réception quantite produit <br> 
                            @if($ligne->id_ligne_commande_fournisseur != 0)
                                [{{ $ligne->ligneCommandeFournisseur->produit->reference }}, {{ $ligne->ligneCommandeFournisseur->produit->designation }}]</h4>
                            @else
                                [{{ $ligne->produit->reference }}, {{ $ligne->produit->designation }}]</h4>
                            @endif
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['method'=>'PUT','action' => ['BonReceptionFournisseurControlleur@postAddQuantiteReceptionnee', $ligne->id_ligne_bon_reception]]) !!}

                            <input type="hidden" name="commande_id" value="{{$ligne->id_ligne_commande_fournisseur}}">

                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    @if($ligne->id_ligne_commande_fournisseur != 0)
                                        <label>Quantité commandée</label>
                                        <input type="number" step="0.01" class="form-control" id="quantiteCommandee0" name="quantiteCommandee" placeholder="Quantité commandée" step="1" required  value="{{ (float)$ligne->quantite_commander}}" readonly >
                                    @endif
                                    
                                </div>
                                @if($ligne->id_ligne_commande_fournisseur != 0)
                                    <div class="form-group col-lg-12">
                                        <label>Reste à recevoir</label>
                                        <input type="number" step="0.01" class="form-control" id="quantiteReste0" name="quantiteReste" placeholder="" step="1" required  value="{{(float) $ligne->ligneCommandeFournisseur->quantite_commander - $ligne->ligneCommandeFournisseur->quantite_receptionner  }}" readonly >
                                    </div>
                                @endif
                                <div class="form-group col-lg-12">
                                    <label>Quantité réceptionnée</label>
                                    <input type="number" step="0.01" class="form-control" id="quantiteReceptionnee0" name="quantiteReceptionnee" placeholder="Quantité réceptionnée"  min="1" 
                                    @if($ligne->id_ligne_commande_fournisseur != 0)
                                    max="{{$ligne->ligneCommandeFournisseur->quantite_commander - $ligne->ligneCommandeFournisseur->quantite_receptionner  }}" 
                                    
                                    @endif
                                    value="{{ (float) $ligne->quantite_receptionner }}" 
                                    required  >
                                </div>
                                @if(Session::get('N_LOT')=='1')
                                    <div class="form-group col-lg-12">
                                        <label>Numéro de lot</label>
                                        <input type="text" class="form-control" id="numeroLot" name="numeroLot" placeholder="Numéro de lot" required 
                                        value="{{ $ligne->numLot }}"    
                                        >
                                    </div>
                                @endif
                                @if(Session::get('DATE_PEREMPTION')=='1')
                                    <div class="form-group col-lg-12">
                                        <label>Date de fabrication</label>
                                        <input type="date" class="form-control" id="dateFabrication" name="dateFabrication" placeholder="Date de fabrication" required 
                                            value="{{ $ligne->date_fabrication }}"    
                                        >
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label>Date de péremption</label>
                                        <input type="date" class="form-control" id="datePeremption" name="datePeremption" placeholder="Date de péremption" required
                                            value="{{ $ligne->date_peremption }}"    
                                         >
                                    </div>
                                @endif
                                <div class="form-group col-lg-12">
                                    <label>Zone de stockage</label>
                                    <select id="idSelectZone" class="form-control" name="zone" onchange="getEmplacement(this.value,{{$ligne->id_ligne_bon_reception}})" required="required">
                                        @if ($ligne->idEmplacement == null || $ligne->idEmplacement == '')
                                            <option selected value="" disabled style="background-color: white">Séléctionner la zone de stockage...</option>
                                        @endif
                                        @foreach($zones as $zone)
                                            <option value="{{$zone->id_zone}}"
                                                @if ($ligne->idEmplacement != null || $ligne->idEmplacement != '')
                                                   @if ($zone->id_zone == $ligne->emplacement->zone->id_zone)
                                                        selected
                                                   @endif
                                                @endif>
                                                {{$zone->libelle}} 
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Emplacement du nouveau stock du produit</label>
                                    <select id="idSelectEmplacement{{$ligne->id_ligne_bon_reception}}" class="form-control " name="emplacement" required="required">

                                        @if ($ligne->idEmplacement != null || $ligne->idEmplacement != '')
                                        @foreach($emplacements as $emplacement)
                                            @if($emplacement->id_zone == $ligne->emplacement->zone->id_zone)
                                                <option value="{{$emplacement->id_emplacement}}" @if($emplacement->id_emplacement == $ligne->idEmplacement) selected @endif>
                                                    {{$emplacement->libelle}}
                                                </option>
                                            @endif
                                        @endforeach
                                            
                                        @else
                                        <option selected value="" disabled>Séléctionner l'emplacement de ce nouveau stock ...</option>
                                        @endif
                                        
                                    </select>
                                </div>
                            </div>



                            <div class="hidden">
                                <input type="text" id="idCommande{{$ligne->id_ligne_bon_reception}}" name="idCommande" value="{{$commande->id_commande_fournisseur}}">

                            </div>

                            <div class="hidden">
                                <input type="date" id="dateEntreeEnStock" name="dateEntreeEnStock" value="<?php echo date("Y-m-d");?>">

                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>
                            {!! Form::close() !!}

                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>
        </div>

            <div class="example-modal">
                <div class="modal" id="DeleteModal{{$ligne->id_ligne_bon_reception}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                            </div>
                            <div class="modal-body">
                                <p>Voulez-vous annuler la réception de ce produit ?</p>

                            </div>

                            <div class="modal-footer">
                                {!! Form::open(['method' => 'POST', 'action' => ['BonReceptionFournisseurControlleur@deleteLigneBonReception',$ligne->id_ligne_bon_reception]]) !!}

                                <div class="hidden">

                                    <input type="text" id="idCommande{{$ligne->id_ligne_bon_reception}}" name="idCommande" value="{{$commande->id_commande_fournisseur}}">

                                </div>

                                <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                {!! Form::close() !!}
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>

        @endforeach

        <div class="modal fade" id="ajouter_produit_modal">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Ajouter produit non commandé</h4>
              </div>
               <form method="post" action="{{ route('ajouterProduitNonCommande') }}">
                     {{ csrf_field() }}
                    <input type="hidden" name="id_commande" value="{{ $commande->id_commande_fournisseur }}">
              <div class="modal-body">
                    <div class="col-sm-12"><br>
                        <div class="form-group">
                            <label>Produit :</label>
                            <select class="form-control selectpicker" data-live-search="true" id="produit" name="produit">
                                <option selected disabled value='' style="background-color: white"> Sélectionner le produit ...</option>
                               @foreach ($produits as $produit)
                                   <option value="{{ $produit->id_produit }}"> {{ $produit->reference}}</option>
                               @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Quantité :</label>
                            <input type="number" step="0.01" min="0" class="form-control" id="quantitee" name="quantitee" required>
                        </div>
                        @if (Session::get('N_LOT') == '1')
                            <div class="form-group">
                                <label>Numéro de lot :</label>
                                <input type="text" class="form-control" id="lot" name="lot" required>
                            </div>
                        @endif
                        @if (Session::get('DATE_PEREMPTION') == '1')
                            <div class="form-group">
                                <label>Date de fabrication :</label>
                                <input type="date" class="form-control" id="dateFabrication" name="dateFabrication" required>
                            </div>
                            <div class="form-group">
                                <label>Date de péremption :</label>
                                <input type="date"  class="form-control" id="datePeremption" name="datePeremption" required>
                            </div>
                        @endif

                        <div class="form-group">
                            <label>La zone de stockage :</label>
                            <select class="form-control" id="zonee" name="zonee" onchange="selectionneZone()" required>
                                
                                <option selected disabled value=""> Sélectionner la zone ...</option>
                                @foreach ($zones as $zone)
                                    <option value="{{ $zone->id_zone }}">{{ $zone->libelle }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Emplacement :</label>
                            <select class="form-control" id="emplacement" name="emplacement" required="required">
                                <option selected disabled value=""> Sélectionner l'emplacement ...</option>
                            </select>
                        </div> <br> 

                    </div>
              </div>
          
              <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Annuler</button>
                <input type="submit" class="btn btn-primary" value="Valider" />
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

</section><!-- /.content -->

<script>

    function getInformations(idCommande){

        window.location.href = "{{url('receptions/reception_fournisseur/ajouter')}}/"+idCommande

    }


    function getEmplacement(id_zone,idLigne){

        //alert(id_zone);

        $.get("{{url('stock_produit/emplacements?ID=')}}"+id_zone, function(res,stat){
            var select1 = document.getElementById("idSelectEmplacement"+idLigne);
            // var nom= document.getElementById("input3");

            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value = ''>Séléctionner l'emplacement de ce nouveau stock ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_emplacement+"'> "+res[i].libelle+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }
        });
    }

    function changeEtat(element){
        if($(element).is(":checked")){

            $.ajax({
                    url: "{{url('receptions/reception_fournisseur/detail/ue/checked')}}/"+1,
                    method : "post",   
                    data: {
                    "_token": "{{ csrf_token() }}"
                    } ,        
                    success: function(data){ 
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  });         
        }else{
            $.ajax({
                    url: "{{url('receptions/reception_fournisseur/detail/ue/checked')}}/"+0,
                    method : "post",   
                    data: {
                    "_token": "{{ csrf_token() }}"
                    } ,        
                    success: function(data){                                  
                    },
                    error: function(data){
                        alert('oops erreur de serveur !!');
                      }
                  });    
        }   
    }

    /*function selectionneProduit(){
        document.getElementById("quantitee").disabled = false;
    }

    function changeQuantite(){
        document.getElementById("lot").disabled = false;
    }
    
    function changeLot(){
        document.getElementById("dateFabrication").disabled = false;
    }

    function changeDateFabrication(){
        document.getElementById("datePeremption").disabled = false;
    }*/


    function selectionneZone(){
        var zone = document.getElementById("zonee").value;
          $.ajax({
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},  
                url: "{{url('inventaire/getEmplacement')}}/"+zone,
                method : "POST",
               
                success: function(data) {
                   if (data == 0) {
                        $('#emplacement').attr('disabled', true);
                        alert('oops pas demplacement trouvé pour cette zone! ');
                    }
                    else{
                        $('#emplacement').attr('disabled', false);
                        $("#emplacement").empty();
                         $("#emplacement").append("<option selected disabled value=''>Sélectionner l'emplacement ...</option>");
                        data.forEach(function(d) {
                              $("#emplacement").append("<option value="+d.id_emplacement+">"+d.libelle+"</option>");
                          });
                    }
                },
                error: function(data){
                          alert('oops erreur de serveur! ');
                }

              });
    }

</script>








@endsection