@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Le détail du bon de réception
    </h1>

    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>






<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif
            <!-- fin messages -->
        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">


                <div class="form-group">
                    <div class="col-lg-12 ">
                        <div class="col-lg-3">
                            <label>N° Bon réceprion : </label>
                            <input type="text" class="form-control" name="num_bon_reception" placeholder="" required value="{{$bonReception->id_bon_reception}}" readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Date bon de réception : </label>
                            <input type="date" class="form-control" id="date_creation"  name="date_creation" value="{{$bonReception->date_creation}}"  required readonly >

                        </div>
                    </div>
                    <br>
                    <br>
                    <br>
                    <br>

                    <div class="col-lg-12">
                        <div class="col-lg-3">
                            <label>Commande fournisseur : </label>
                            <input type="number" class="form-control" id="idCommandeFounisseur"  name="idCommandeFounisseur" value="{{$bonReception->id_commande}}"  required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Le Fournisseur :</label>
                            <input type="text" class="form-control" id="fournisseur" name="fournisseur" placeholder="Fournisseur" value ="{{$commandeFournisseur->fournisseur->societe}}" required readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Le Contact : </label>
                            <input type="text" class="form-control" id="contactFournisseur" name="contactFournisseur" placeholder="Contact" value="{{$commandeFournisseur->fournisseur->contact}}" required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Date commande fournisseur : </label>
                            <input type="date" class="form-control" id="dateCreationCommandeFournisseur"  name="dateCreationCommandeFournisseur"  value="{{$commandeFournisseur->date_creation}}" required readonly>
                        </div>

                    </div>
                    <br>
                    <br>
                    <br>
                </div>

                <div class="col-lg-12">
                    <table id="example1" class="table table-bordered table-striped dataTable">
                        <thead>
                            <tr role="row">
                                <th class="text-center sorting_asc">Référence produit</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Quantité commandée</th>
                                <th class="text-center sorting_asc">Reste à recevoir</th>
                                <th class="text-center sorting_asc">Qantité réceptionner</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach( $lignesBonReception as $ligneBonReception)
                            <tr role="row" class="odd">
                                <td class="text-center sorting_1">{{$ligneBonReception->ligneCommandeFournisseur->produit->reference}}</td>
                                <td class="text-center sorting_1">{{$ligneBonReception->ligneCommandeFournisseur->produit->designation}}</td>
                                <td class="text-center sorting_1">{{$ligneBonReception->quantite_commander}}</td>
                                <td class="text-center sorting_1">{{$ligneBonReception->quantite_reste_receptionnee - $ligneBonReception->quantite_receptionner}}</td>
                                <td class="text-center sorting_1">{{$ligneBonReception->quantite_receptionner}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                    <div style="float: right">

                        <a href="{{url('bon_reception/index')}}" class="btn btn-default" data-dismiss="modal">Retour</a>

                    </div>

                </div>
            </div>
        </div><!-- /.box -->
    </section><!-- /.content -->



@endsection