@extends('app')
@section('content')

        <!-- Content Header (Page header) -->


<section class="content-header" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">

    <h1>
        Ajouter un bon de réception
    </h1>

    <!--
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#">Examples</a></li>
      <li class="active">Blank page</li>
    </ol>
    -->
</section>






<!-- Main content -->
<section class="content">
    <!-- Messages -->

    @if(Session::has('msgAdd'))
        <div class="box box-success box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgAdd') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if(Session::has('msgExist'))
        <div class="box box-warning box-solid">
            <div class="box-header with-border">
                <div class="box-title">
                    <span> <i class="fa fa-check"></i></span>
                    <em>{!! session('msgExist') !!}</em>
                </div>
                <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        @endif

                <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">
                {!! Form::open(['method'=>'POST','action' => ['BonReceptionControlleur@postForm']]) !!}
                <div class="form-group">
                    <div class="col-lg-12 ">
                        <div class="col-lg-3">
                            <label>N° Bon réceprion : </label>
                            <input type="text" class="form-control" name="num_bon_reception" placeholder="" required value="{{$num_bon_receptionr}}" readonly>
                        </div>
                        <div class="col-lg-3">
                            <label>Date bon de réception : </label>
                            <input type="date" class="form-control" id="date_creation"  name="date_creation" value="<?php echo date("Y-m-d");?>"  required >

                        </div>
                    </div>
                    <br>
                    <br>
                    <br>
                    <br>

                    <div class="col-lg-12">
                        <div class="col-lg-3">
                            <label>Commande fournisseur : </label>
                            <select id="idSelectCommandeFournisseur" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" onchange="getInformations(this.value)" name="idCommandeFournisseur" required="required">
                                <option selected disabled value="">Sélectionner la commande fournisseur ...</option>
                                @foreach($commandes as $commandeIndex)
                                    <option value="{{$commandeIndex->id_commande_fournisseur}}" @if(($commande != null) && ($commandeIndex->id_commande_fournisseur == $commande->id_commande_fournisseur)) selected @endif> {{$commandeIndex->id_commande_fournisseur}} </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-3">
                            <label>Le Fournisseur :</label>
                            <input type="text" class="form-control" id="fournisseur" name="fournisseur" placeholder="Fournisseur" value ="{{Session::get('societe')}}" required readonly >
                        </div>
                        <div class="col-lg-3">
                            <label>Le Contact : </label>
                            <input type="text" class="form-control" id="contactFournisseur" name="contactFournisseur" placeholder="Contact" value="{{Session::get('contact')}}" required readonly >
                        </div>

                        <div class="col-lg-3">
                            <label>Date commande fournisseur : </label>
                            <input type="date" class="form-control" id="dateCreationCommandeFournisseur"  name="dateCreationCommandeFournisseur"  value="{{Session::get('date')}}" required readonly>
                        </div>

                    </div>
                    <br>
                    <br>
                    <br>
                </div>

                <div class="col-lg-12">
                    <table id="example1" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr role="row">
                            <th class="text-center sorting_asc">Référence produit</th>
                            <th class="text-center sorting_asc">Désignation</th>
                            <th class="text-center sorting_asc">Quantité commandée</th>
                            <th class="text-center sorting_asc">Reste à recevoir</th>
                            <th class="text-center sorting_asc">Qantité réceptionner</th>
                            <th class="text-center sorting_asc">Réceptionner</th>
                            <th class="text-center sorting_asc">Supprimer</th>
                        </tr>
                        </thead>

                        <tbody>

                        @foreach( $lignes as $ligne)
                            <tr role="row" class="odd">
                                <td class="text-center sorting_1">{{$ligne->ligneCommandeFournisseur->produit->reference}}</td>
                                <td class="text-center sorting_1">{{$ligne->ligneCommandeFournisseur->produit->designation}}</td>
                                <td class="text-center sorting_1">{{$ligne->quantite_commander}}</td>
                                <td class="text-center sorting_1">{{$ligne->quantite_reste_receptionnee - $ligne->quantite_receptionner}}</td>
                                <td class="text-center sorting_1">{{$ligne->quantite_receptionner}}</td>
                                <td class="text-center sorting_asc">
                                    <a href="#ReceptionModal{{$ligne->id_ligne_bon_reception}}" class="glyphicon glyphicon-edit"  data-toggle="modal">

                                    </a>
                                </td >
                                <td class="text-center sorting_asc">
                                    <a href="#DeleteModal{{$ligne->id_ligne_bon_reception}}" class=" open-AddBookDialog glyphicon glyphicon-trash" data-toggle="modal">

                                    </a>
                                </td>
                            </tr>



                        @endforeach

                        </tbody>
                    </table>




                    <div style="float: right">

                        <a href="{{url('bon_reception/index')}}" class="btn btn-default" data-dismiss="modal">Annuler</a>
                        <button type="submit" class="btn btn-primary">Valider</button>

                    </div>

                </div>
            </div>
            {!! Form::close() !!}
        </div><!-- /.box -->


        @foreach( $lignes as $ligne)

        <!--  POPUP pour ajout produit  -->

        <div cl1ass="example-modal" >
            <div class="modal" id="ReceptionModal{{$ligne->id_ligne_bon_reception}}">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" style="font-family:verdana;">Réception quantite produit</h4>
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['method'=>'PUT','action' => ['BonReceptionControlleur@postAddQuantiteReceptionnee', $ligne->id_ligne_bon_reception]]) !!}

                            <div class="col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label>Quantité commandée</label>
                                    <input type="number" class="form-control" id="quantiteCommandee0" name="quantiteCommandee" placeholder="Quantité commandée" step="1" required  value="{{$ligne->quantite_commander}}" readonly >
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Reste à recevoir</label>
                                    <input type="number" class="form-control" id="quantiteReste0" name="quantiteReste" placeholder="" step="1" required  value="{{$ligne->quantite_reste_receptionnee}}" readonly >
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Quantité réceptionnée</label>
                                    <input type="number" class="form-control" id="quantiteReceptionnee0" name="quantiteReceptionnee" placeholder="Quantité réceptionnée" step="1" min="1" max="{{$ligne->quantite_reste_receptionnee}}" required  >
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Numéro de lot</label>
                                    <input type="text" class="form-control" id="numeroLot" name="numeroLot" placeholder="Numéro de lot" required >
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Date de fabrication</label>
                                    <input type="date" class="form-control" id="dateFabrication" name="dateFabrication" placeholder="Date de fabrication" required >
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Date de péremption</label>
                                    <input type="date" class="form-control" id="datePeremption" name="datePeremption" placeholder="Date de péremption" required >
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Zone de stockage</label>
                                    <select id="idSelectZone" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="zone" onchange="getEmplacement(this.value,{{$ligne->id_ligne_bon_reception}})" required="required">
                                        <option selected disabled>Séléctionner la zone de stockage...</option>
                                        @foreach($zones as $zone)
                                            <option value="{{$zone->id_zone}}" >{{$zone->libelle}} </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>Emplacement du nouveau stock du produit</label>
                                    <select id="idSelectEmplacement{{$ligne->id_ligne_bon_reception}}" class="form-control selectpicker" data-selected-text-format="count > 3" data-live-search="true" name="emplacement" required="required">
                                        <option selected disabled>Séléctionner l'emplacement de ce nouveau stock ...</option>
                                    </select>
                                </div>
                            </div>



                            <div class="hidden">
                                <input type="text" id="idCommande{{$ligne->id_ligne_bon_reception}}" name="idCommande" value="{{$commande->id_commande_fournisseur}}">

                            </div>

                            <div class="hidden">
                                <input type="date" id="dateEntreeEnStock" name="dateEntreeEnStock" value="<?php echo date("Y-m-d");?>">

                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>
                            {!! Form::close() !!}

                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>
        </div>

            <div class="example-modal">
                <div class="modal" id="DeleteModal{{$ligne->id_ligne_bon_reception}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" style="font-family:verdana;"> Confirmation </h4>
                            </div>
                            <div class="modal-body">
                                <p>Voulez-vous annuler la réception de ce produit ?</p>

                            </div>

                            <div class="modal-footer">
                                {!! Form::open(['method' => 'POST', 'action' => ['BonReceptionControlleur@deleteLigneBonReception',$ligne->id_ligne_bon_reception]]) !!}

                                <div class="hidden">

                                    <input type="text" id="idCommande{{$ligne->id_ligne_bon_reception}}" name="idCommande" value="{{$commande->id_commande_fournisseur}}">

                                </div>

                                <input type="submit" class="btn btn-flat btn-primary pull-right" value="Valider">
                                <button type="button" class="btn btn-flat btn-danger pull-right " data-dismiss="modal">Annuler</button>
                                {!! Form::close() !!}
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            </div>

        @endforeach

</section><!-- /.content -->

<script>

    function getInformations(idCommande){

        window.location.href = "{{url('bon_reception/ajouter')}}/"+idCommande

    }


    function getEmplacement(id_zone,idLigne){

        //alert(id_zone);

        $.get("{{url('stock_produit/emplacements?ID=')}}"+id_zone, function(res,stat){
            var select1 = document.getElementById("idSelectEmplacement"+idLigne);
            // var nom= document.getElementById("input3");

            // alert("Listcommune"+adresse);
            select1.innerHTML = "<option selected disabled value=''>Séléctionner l'emplacement de ce nouveau stock ...</option>";

            for(var i=0;i<res.length;i++)
            {
                var option = "<option value='"+res[i].id_emplacement+"'> "+res[i].libelle+"</option>";
                select1.innerHTML = select1.innerHTML + option;
            }


        });
    }




</script>








@endsection