@extends('app')
@section('content')

    <section class="content-header" xmlns="http://www.w3.org/1999/html">
        <h1>Détail bon de livraison</h1>

    </section>
    <!-- Main content -->
    <section class="content">
        <!-- Messages -->

        @if(Session::has('msgAdd'))
            <div class="box box-success box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgAdd') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        @endif

        @if(Session::has('msgExist'))
            <div class="box box-warning box-solid">
                <div class="box-header with-border">
                    <div class="box-title">
                        <span> <i class="fa fa-check"></i></span>
                        <em>{!! session('msgExist') !!}</em>
                    </div>
                    <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="remove">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
    @endif

    <!-- fin messages -->

        <!-- Default box -->
        <div class="box" id="MYDIV">
            <div class="box-body">

                {!! Form::open(['method'=>'POST','id' => 'formulaire','action' => ['BonLivraisonController@show',$bonLivraison->id_bon_livraison]]) !!}
                <div >
                    <button type="button" id="btn-export"  class="btn btn-flat btn-danger pull-right" onclick="genPDF({{ Session::get('COMPOSE_PACK') }})">Export PDF</button>
                </div>
                <div class="form-group">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° de bon de livraison : </label>
                            <input type="text" class="form-control" name="num_bl" id="num_bl"   value="{{$bonLivraison->num_bl}}" readonly>
                        </div>

                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° de préparation : </label>
                            <input type="text" class="form-control" name="num_commande_fournisseur"  required value="{{$bonLivraison->preparation->numPreparation}}" readonly>
                        </div>
                    </div>
                    @if (Session::get('STOCK_ENTITE'))
                            <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Entité : </label>
                            <input type="text" class="form-control" style="font-size:24px" name="" id="entite" value="Entité : {{$bonLivraison->preparation->entite->type_entite}} / {{$bonLivraison->preparation->entite->num_entite}} / {{$bonLivraison->preparation->entite->libelle_entite}}" required readonly>
                            <br>
                        </div>
                        @endif


                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <label>N° Commande client: </label>
                            <input type="text" class="form-control" name="num_commande_client" id="num_commande_client" required @if($bonLivraison->id_commande != 0) value="{{$bonLivraison->commandeClient->numCommande}}" @endif readonly>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Raison sociale :</label>
                            <input type="text" class="form-control"  name="raison sociale" id="raison_sociale"   @if($bonLivraison->id_commande != 0) 
                            value ="{{$bonLivraison->commandeClient->Client->raisonSociale}}" 
                            @else
                            @if ($bonLivraison->preparation->Client != null)
                                 value ="{{$bonLivraison->preparation->Client->raisonSociale}}"
                            @endif
                           
                            @endif required readonly >
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Adresse client :</label>

                            <input type="text" class="form-control"  name="adresse_client" id="adresse_client"  
                             @if($bonLivraison->id_commande != 0) 
                            value ="{{$bonLivraison->commandeClient->Client->adresseClient}}"
                            @else
                            @if ($bonLivraison->preparation->Client != null)
                                 value ="{{$bonLivraison->preparation->Client->adresseClient}}"
                            @endif
                             @endif  
                             required readonly >
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Transporteur :</label>

                            <input type="text" class="form-control"  name="transporteur_nom" id="transporteur_nom"  @if($bonLivraison->preparation->idTransporteur != NULL) value ="{{$bonLivraison->preparation->Transporteur->nomTransporteur}} {{$bonLivraison->preparation->Transporteur->prenomTransporteur}}" @endif required readonly >
                            <input type="text" class="form-control"  name="transporteur_tel" id="transporteur_tel"  @if($bonLivraison->preparation->idTransporteur != NULL) value ="{{$bonLivraison->preparation->Transporteur->telephoneTransporteur}}" @endif required readonly >
                            <input type="text" class="form-control"  name="transporteur_num" id="transporteur_num"  @if($bonLivraison->preparation->idTransporteur != NULL) value ="{{$bonLivraison->preparation->Transporteur->numTransporteur}}" @endif required readonly >
                        </div>
                    </div>


                    <div class="col-lg-12 col-md-12 col-sm-12">


                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Nombre de produit : </label>
                            <input type="text" class="form-control" name="date_creation" id="nbr_produit" value="{{$bonLivraison->nbr_produit}}" required readonly>
                            <br>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <label>Date de création : </label>
                            <input type="text" class="form-control" name="date_creation" id="date_creation" value="{{$bonLivraison->date_creation}}" required readonly>
                            <br>
                        </div>

                    </div>


                </div>
                 

                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="table-responsive">
                          <table id="table" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr role="row">
                                @if (Session::get('STOCK_ENTITE') == '1' || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                                    <th class="text-center sorting_asc">N°Document</th>
                                    <th class="text-center sorting_asc">N°UE</th>
                                @endif
                                <th class="text-center  sorting_asc">Référence</th>
                                <th class="text-center sorting_asc">Désignation</th>
                                <th class="text-center sorting_asc">Code produit</th>
                                <th class="text-center sorting_asc">Emp</th>
                                <th class="text-center sorting_asc">Qte</th>
                                @if (Session::get('COMPOSE_PACK')=='1')
                                <th class="text-center sorting_asc">Produit<br>composé pack</th>
                                <th class="text-center sorting_asc">Désignation <br>(Produit <br>composé pack)</th>
                                <th class="text-center sorting_asc">Qte <br>(Produit composé pack)</th>
                                @endif
                                @if (Session::get('NUMERO_SERIE'))
                                    <th class="text-center sorting_asc">N° de série</th>
                                @endif
                                @if (Session::get('STOCK_ENTITE') != "1" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1" )
                                    <th style="">Observation</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach( $ligneBonLivraison as $ligne)
                                @if (Session::get('NUMERO_SERIE') == '1')
                                                            
                                @if ($ligne->ligneProduit->NumeroSerie != null && $ligne->ligneProduit->NumeroSerie != '' && $ligne->ligneProduit->NumeroSerie->isEmpty() == false)
                                    @foreach ($ligne->ligneProduit->NumeroSerie as $element)
                                        <tr role="row" class="odd">
                                    @if (Session::get('STOCK_ENTITE') == '1' || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">@if ($ligne->ligneProduit)
                                        @if ($ligne->ligneProduit->StockProduit)
                                            @if (!$ligne->ligneProduit->StockProduit->ligneBonReceptionUe->isEmpty())
                                            @if ($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception)
                                            @if ($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception)
                                        

                                            {!!$ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception->num_document!!}
                                        @endif
                                        @endif
                                        @endif
                                        @endif
                                        @endif</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->ligneProduit->stockProduit->num_ue!!}</td>
                                    @endif
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->produit->reference!!}</td>
                                    <td class="text-center sorting_1">{!!$ligne->produit->designation!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->produit->code_identification!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->ligneProduit->StockProduit->Emplacement->libelle!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">1</td>
                                    @if (Session::get('COMPOSE_PACK')=='1')
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{{ $ligne->produit->compose_pack }}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">
                                        @if ($produitComposeCollect->get($ligne->id_bl_produit) != null )
                                            <ul>
                                                @foreach ($produitComposeCollect->get($ligne->id_bl_produit) as $produit)
                                                    <li >{{ $produit->produitEnfant->designation }}</li><br>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">
                                        @if ($produitComposeCollect->get($ligne->id_bl_produit) != null )
                                            <ul>
                                                @foreach ($produitComposeCollect->get($ligne->id_bl_produit) as $produit)
                                                    <li >{{ (float) $produit->quantite }}</li><br><br>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </td>
                                    @endif
                                    @if (Session::get('NUMERO_SERIE'))
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">
                                        {{ $element->num_serie}}
                                    </td>
                                 @endif
                                    @if (Session::get('STOCK_ENTITE') != "1" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1" )
                                        <td class="text-center sorting_1"></td> 
                                    @endif

                                </tr>
                                    @endforeach
                                @else

                                <tr role="row" class="odd">
                                    @if (Session::get('STOCK_ENTITE') == '1' || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">@if ($ligne->ligneProduit)
                                        @if ($ligne->ligneProduit->StockProduit)
                                            @if (!$ligne->ligneProduit->StockProduit->ligneBonReceptionUe->isEmpty())
                                            @if ($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception)
                                            @if ($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception)
                                        

                                            {!!$ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception->num_document!!}
                                        @endif
                                        @endif
                                        @endif
                                        @endif
                                        @endif</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->ligneProduit->stockProduit->num_ue!!}</td>
                                    @endif
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->produit->reference!!}</td>
                                    <td class="text-center sorting_1">{!!$ligne->produit->designation!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->produit->code_identification!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->ligneProduit->StockProduit->Emplacement->libelle!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!! (float) $ligne->qnt!!}</td>
                                    @if (Session::get('COMPOSE_PACK')=='1')
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{{ $ligne->produit->compose_pack }}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">
                                        @if ($produitComposeCollect->get($ligne->id_bl_produit) != null )
                                            <ul>
                                                @foreach ($produitComposeCollect->get($ligne->id_bl_produit) as $produit)
                                                    <li >{{ $produit->produitEnfant->designation }}</li><br>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">
                                        @if ($produitComposeCollect->get($ligne->id_bl_produit) != null )
                                            <ul>
                                                @foreach ($produitComposeCollect->get($ligne->id_bl_produit) as $produit)
                                                    <li >{{ (float) $produit->quantite }}</li><br><br>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </td>
                                    @endif
                                    @if (Session::get('NUMERO_SERIE'))
                                    <td class="text-center sorting_1">
                                        
                                        
                                    </td>
                                 @endif
                                    @if (Session::get('STOCK_ENTITE') != "1" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1" )
                                        <td class="text-center sorting_1"></td> 
                                    @endif

                                </tr>
                                @endif
                                @else
                                <tr role="row" class="odd">
                                    @if (Session::get('STOCK_ENTITE') == '1' || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1')
                                    <td class="text-center sorting_1" style="text-align: center">@if ($ligne->ligneProduit)
                                        @if ($ligne->ligneProduit->StockProduit)
                                            @if (!$ligne->ligneProduit->StockProduit->ligneBonReceptionUe->isEmpty())
                                            @if ($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception)
                                            @if ($ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception)
                                        

                                            {!!$ligne->ligneProduit->StockProduit->ligneBonReceptionUe[0]->ligneBonReception->bonReception->num_document!!}
                                        @endif
                                        @endif
                                        @endif
                                        @endif
                                        @endif</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->ligneProduit->stockProduit->num_ue!!}</td>
                                    @endif
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->produit->reference!!}</td>
                                    <td class="text-center sorting_1">{!!$ligne->produit->designation!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->produit->code_identification!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!!$ligne->ligneProduit->StockProduit->Emplacement->libelle!!}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{!! (float) $ligne->qnt!!}</td>
                                    @if (Session::get('COMPOSE_PACK')=='1')
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">{{ $ligne->produit->compose_pack }}</td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">
                                        @if ($produitComposeCollect->get($ligne->id_bl_produit) != null )
                                            <ul>
                                                @foreach ($produitComposeCollect->get($ligne->id_bl_produit) as $produit)
                                                    <li >{{ $produit->produitEnfant->designation }}</li><br>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </td>
                                    <td class="text-center sorting_1" style="text-align: center;vertical-align: middle">
                                        @if ($produitComposeCollect->get($ligne->id_bl_produit) != null )
                                            <ul>
                                                @foreach ($produitComposeCollect->get($ligne->id_bl_produit) as $produit)
                                                    <li >{{ (float) $produit->quantite }}</li><br><br>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </td>
                                    @endif
                                    @if (Session::get('NUMERO_SERIE'))
                                    <td class="text-center sorting_1">
                                        
                                        
                                    </td>
                                 @endif
                                    @if (Session::get('STOCK_ENTITE') != "1" || Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1" )
                                        <td class="text-center sorting_1"></td> 
                                    @endif

                                </tr>
                                @endif
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    <table id="signature">
                    <tr><td colspan="8"><b>DESTINATION</b></td></tr>
                    <tr><td>RAISON SOCIALE</td><td style="vertical-align: middle" colspan="7">  
                        {{$bonLivraison->preparation->Client->raisonSociale}}   
                        </td></tr>
                    <tr><td>ADRESSE CLIENT</td> <td style="vertical-align: middle" colspan="7">{{$bonLivraison->preparation->Client->adresseClient}}</td></tr>
                </table>
                <div id="sig">
                <table style="font-size:24px;text-align: center">
                    <colgroup>
                        <col width="150" style="vertical-align:middle;" />
                        <col style="width:200px;" />
                    </colgroup>
                    
                    <tr>
                        <th colspan="3">Signature rail-logistic</th>
                        <th colspan="3">Signature transporteur</th>
                        <th colspan="3">Signature client</th>
                    </tr>
                     <tr>
                        <th colspan="3">nom & prenom</th>
                        <th colspan="3"></th>
                        <th colspan="3">nom & prenom</th>
                    </tr>

                </table>

                </div>

                 <div id="sig2">
                <table border="1px" style="font-size:24px;text-align: center;vertical-align: middle">
                    <tr bgcolor="#DFDFDF"><td colspan="8"><b>SIGNATURE</b></td></tr>
                    <tr>
                        <th>MAGASIN RAIL-LOGISTIC :</th>
                        <td colspan="3" style="text-align: center">{{ $prefixe }}</td>
                        <th>RECEPTIONNAIRE</th>
                        <td colspan="3"></td>
                    </tr>

                    <tr>
                        <th>NOM & PRENOM :</th>
                        <td colspan="3"></td>
                        <th>NOM & PRENOM : </th>
                        <td colspan="3"></td>
                    </tr>

                    <tr>
                        <th>MOB :</th>
                        <td colspan="3"></td>
                        <th>MOB :</th>
                        <td colspan="3"></td>
                    </tr>

                    <tr>
                        <th>MAT:</th>
                        <th colspan="3"></th>
                        <th>MAT:</th>
                        <td colspan="3"></td>
                    </tr>

                    <tr>
                        <th>SIGNATURE :</th>
                        <td colspan="3"></td>
                        <th>SIGNATURE :</th>
                        <td colspan="3"></td>
                    </tr>
                    <tr>
                        <th></th>
                        <td colspan="3"></td>
                        <th>DATE DE RECEPTION :</th>
                        <td colspan="3"></td>
                    </tr>

                </table>

                </div>


                <table id="TRANSPORTEUR">
                    <tr><td colspan="8"><b>TRANSPORTEUR</b></td></tr>
                    <tr><td>N° Transporteur</td><td colspan="7" style="text-align: left">  
                        @if($bonLivraison->preparation->idTransporteur != NULL) {{$bonLivraison->preparation->Transporteur->numTransporteur}} @endif   
                        </td></tr>
                    <tr><td>Nom et prénom</td> <td colspan="7" style="text-align: left"> @if($bonLivraison->preparation->idTransporteur != NULL) {{$bonLivraison->preparation->Transporteur->nomTransporteur}} {{$bonLivraison->preparation->Transporteur->prenomTransporteur}} @endif</td></tr>
                    <tr><td>Nom et prénom (Chauffeur)</td> <td colspan="7" style="text-align: left"> </td></tr>
                    <tr><td>imm</td> <td colspan="7" style="text-align: left"> </td></tr>
                    <tr><td>Téléphone</td> <td colspan="7" style="text-align: left">@if($bonLivraison->preparation->idTransporteur != NULL) {{$bonLivraison->preparation->Transporteur->telephoneTransporteur}} @endif</td></tr>
                </table>
                    <div class="col-lg-12" >
                        @if(Session::get('COMPOSE_PACK'))
                        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12" style="float: right" >
                            <label> Total quantité avec produit composé : </label>
                            <input type="text" class="form-control col-lg-1" readonly name="total_qnt" id="total_qnt" value="{{$total_qnt_cmp}}">
                        </div>
                        @endif
                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12" style="float: right; margin-right: 10%" >

                            <label> Total quantité :</label>
                            <input type="text" class="form-control col-lg-1" readonly id="total_qnt_cmp"  value="{{ $total_qnt }}">
                            <input type="text" readonly class="hidden" name="total_ttc" value="{{ $total_qnt }}">
                        </div>
                    </div>

                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 2%">
                    <a @if(Session::get('pageSource')=='preparation') href="{{url('preparation/detail')}}/{{Session::get('idBL')}}" @endif href="{{url('livraison/index')}}" class="btn btn-default pull-right">Retour</a>
                </div>

                <div class="hidden">
                    <input type="text" name="exportPdf" id="exportPdf" value="0">
                </div>


                <div class="hidden" id="logo">
                    <table>
                        <tr>

                            <td>@if($configuration != null) @if($configuration->image != "" && $configuration->image != null )<img  @if($configuration != null) src="{{ asset('/dist/img/'.$configuration->image) }}" @else src="" @endif width="25%" height="25%" alt="User Image"> @endif @endif</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>@if($configuration != null) @if($configuration->image2 != "" && $configuration->image2 != null ) <img  @if($configuration != null) src="{{ asset('/dist/img/'.$configuration->image2) }}" @else src="" @endif width="25%" height="25%" alt="User Image">@endif @endif</td>
                        </tr>
                    </table>
                </div>
                <div class="hidden">
                    <input type="text" id="header"  @if($configuration != null) value="{{$configuration->header}}" @else value="" @endif >
                    <input type="text"   id="footer"  @if($configuration != null)  value="{{$configuration->footer}}" @else value="" @endif>

                </div>

                <!---------pdf ------------>
                {!! Form::close() !!}
            </div>
        </div><!-- /.box -->

    </section><!-- /.content -->
    <script type="text/javascript" src="https://oss.sheetjs.com/sheetjs/xlsx.full.min.js"></script>
<script>

    function fnExcelReport(){

        var header ='<h2 style="text-align: center">'+document.getElementById('header').value+'</h2>';
        var logo=document.getElementById('logo').outerHTML;


        var titre ="<p style='text-align: center;font-size:50px'> <b>BON DE LIVRAISON</b></p>";
        

        titre += "<p style='text-align: center;font-size:90px'>"+document.getElementById('num_bl').value+"</p>";

        @if (Session::get('STOCK_ENTITE') == "1")

          var  entite =document.getElementById('entite').value;
                @endif

        var footer = '<h2 style="text-align: center">'+document.getElementById('footer').value+'</h2>';
        var nbr_produit = 'Nombre de produit : '+document.getElementById('nbr_produit').value;
        var total_qnt_cmp ='Total quantité : '+document.getElementById('total_qnt_cmp').value+'</p>';
        var date ='Date de création : '+document.getElementById('date_creation').value+'</h6>';

        var sociale = 'Raison sociale : '+ document.getElementById('raison_sociale').value+'<br>';
        var adresse = 'Adresse client : '+ document.getElementById('adresse_client').value+'<br>';
        var num = 'N° Transporteur  : '+ document.getElementById('transporteur_num').value+'<br>';
        var nom = 'Nom et prénom : '+ document.getElementById('transporteur_nom').value+'<br>';
        var tel = 'téléphone : '+ document.getElementById('transporteur_tel').value+'<br>';

        var tab_text = '<table border="1px" style="font-size:24px;text-align: center " >';
        var textRange;
        var j = 0;
        var tab = document.getElementById('table'); // id of table
        var lines = tab.rows.length;
        // the first headline of the table
        if (lines > 0) {
            tab_text = tab_text + '<tr bgcolor="#DFDFDF">' + tab.rows[0].innerHTML + '</tr>';
        }
        // table data lines, loop starting from 1
        for (j = 1 ; j < lines; j++) {
            tab_text = tab_text + "<tr>" + tab.rows[j].innerHTML + "</tr>";
        }
        tab_text = tab_text + "</table>";

        //tab_text = tab_text.replace(/<A[^>]*>|<\/A>/g, "");             //remove if u want links in your table
       // tab_text = tab_text.replace(/<img[^>]*>/gi,"");
        //tab_text = tab_text.replace(0,"jjj");
                        // remove if u want images in your table
        //tab_text = tab_text.replace(/<input[^>]*>|<\/input>/gi, "");// reomves input params
       // var sig = '<table border="1px" style="font-size:24px;text-align: center " >';
        var j = 0;
        var sig =document.getElementById('sig').outerHTML;

        var sig2 =document.getElementById('sig2').outerHTML;
      /*  var table_sig = document.getElementById('sig'); // id of table
        var line_sig = table_sig.rows.length;
        // the first headline of the table
        if (line_sig > 0) {
            sig = sig + '<tr bgcolor="#DFDFDF">' + table_sig.rows[0].innerHTML + '</tr>';
        }
        // table data lines, loop starting from 1
        for (j = 1 ; j < line_sig; j++) {
            sig = sig + "<tr>" + table_sig.rows[j].innerHTML + "</tr>";
        }
        sig = sig + "</table>";*/

        var tran = '<table border="1px" style="font-size:24px;text-align: center " >';
        var j = 0;
        var transporteur = document.getElementById('TRANSPORTEUR'); // id of table
        var linesss = transporteur.rows.length;
        // the first headline of the table
        if (linesss > 0) {
            tran = tran + '<tr bgcolor="#DFDFDF">' + transporteur.rows[0].innerHTML + '</tr>';
        }
        // table data lines, loop starting from 1
        for (j = 1 ; j < linesss; j++) {
            tran = tran + "<tr>" + transporteur.rows[j].innerHTML + "</tr>";
        }
        tran = tran + "</table>";
        var tabg = "<table border='1px' style='font-size:24px;text-align: center'>";
        var j = 0;
        var tabb = document.getElementById('signature'); // id of table
        var liness = tabb.rows.length;
        // the first headline of the table
        if (liness > 0) {
            tabg = tabg + "<tr bgcolor='#DFDFDF'>" + tabb.rows[0].innerHTML + "</tr>";
        }
        // table data lines, loop starting from 1
        for (j = 1 ; j < liness; j++) {
            tabg = tabg + "<tr>" + tabb.rows[j].innerHTML + "</tr bgcolor='#DFDFDF'>";
        }
        tabg = tabg + "</table>";
        tab_text2='<br>'+logo+'<br><br><br><br>'+header+'<br>'+titre+'<p style="font-size:24px">'+entite+'<br>'+date+'</p><br>'+tabg+'<br>'+tran+'<br>'+tab_text+'<br>'+'<p style="font-size:24px">'+nbr_produit+'<br>'+total_qnt_cmp+'</p><br>'+sig2+'<br>'+sig+'<br><br><br><br>'+footer+'</p>';
        var ua = window.navigator.userAgent;
        var msie = ua.indexOf("MSIE ");
        // if Internet Explorer
        if (msie > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./)) {
            //alert("if");
            txtArea1.document.open("txt/html","replace");
            txtArea1.document.write(tab_text2);
            txtArea1.document.close();
            txtArea1.focus();
            sa = txtArea1.document.execCommand("SaveAs", true, "DataTableExport.xls");
        }
        else{
            returnToPage();
            //alert("if");
            // other browser not tested on IE 11
             var a = document.createElement('a');
//getting data from our div that contains the HTML table
var data_type = "data:application/vnd.ms-excel;UTF-8,";
a.href = data_type + ', ' + escape(tab_text2);
//setting the file name
a.download = document.getElementById('num_bl').value+'.xls';
//triggering the function
a.click();
//just in case, prevent default behaviour
e.preventDefault();

return (a);
             /*ar result = "data:application/vnd.ms-excel;UTF-8,"+ escape(tab_text2);
        this.href = result;
        this.download = "my-custom-filename.xls";
        returnToPage();
        return true;*/
            /*sa= window.open('data:application/vnd.ms-excel;UTF-8,'+ escape(tab_text2));
            returnToPage();
            return (sa);*/
        }
    }

    function returnToPage()
    {

        document.getElementById('exportPdf').value = '0';

        document.getElementById("formulaire").submit();
    }


    window.onload = fnExcelReport();

</script>
@endsection
