<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model
{
    protected $table='user';
    protected $primaryKey='id_user';
    protected $fillable=['nom','prenom','email','telephone','login','password','idProfilDroit'];
    public $timestamps = false;
    public function  getPrimaryKey(){
        return $this->primaryKey;
    }

    public function LigneProduit()
    {
        return $this->hasMany('App\LigneProduit','id_user','idUser');
    }

    public function LigneInventaire()
    {
        return $this->hasMany('App\LigneInventaire','id_user','idOperateur');
    }
    public function profil_acces_backoffice(){
        return $this->belongsTo('App\ProfilBackoffice','idProfilDroit', 'id');
    }
    public function profil_acces_mobile(){
        return $this->belongsTo('App\ProfileMobile','idProfilDroit', 'id');
    }

    public function productions(){
        return $this->hasMany('App\Production','id_user');
    }

     public function tracabilites(){
        return $this->hasMany('App\Tracabilite','id_user');
    }
}

