<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Ue extends Model
{
    protected $table='ue';
    protected $primaryKey='num_ue';
    
    protected $casts = ['num_entite' => 'string'];
    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable=['nbr_produi','etat_ue','volume_ue','poids_ue'];
    public $timestamps = false;

    public function  getPrimaryKey(){
        return $this->primaryKey;
    }

    public function stockProduit(){
        return $this->hasMany('App\StockProduit','num_ue','num_ue');
    }
    public function emplacement(){
        return $this->belongsTo('App\Emplacement','id_emplacement','id_emplacement');
    }

}