<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 07/06/2017
 * Time: 12:34
 */

namespace App;


use Illuminate\Database\Eloquent\Model;

class Transporteur extends Model
{

    protected $table='transporteur';
    protected $primaryKey='idTransporteur';
    protected $fillable=['idEmplacement','numTransporteur', 'nomTransporteur', 'prenomTransporteur', 'telephoneTransporteur'];
    public $timestamps = false;
    public function  getPrimaryKey(){
        return $this->primaryKey;
    }

    public function emplacement(){

        return $this->belongsTo('App\Emplacement','idEmplacement','id_emplacement');
    }


    public function preparation(){
        return $this->hasMany('App\Preparation','idTransporteur','idTransporteur');
    }

    public function chargement(){
        return $this->hasMany('App\Chargement','idTransporteur','idTransporteur');
    }



}